/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.executor;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.common.creation.EngineCreationContext;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.computation.executor.rs.RsOutputStream;
import org.apache.linkis.engineconn.core.executor.ExecutorManager$;
import org.apache.linkis.engineconn.launch.EngineConnServer$;
import org.apache.linkis.engineplugin.spark.Interpreter.PythonInterpreter$;
import org.apache.linkis.engineplugin.spark.common.Kind;
import org.apache.linkis.engineplugin.spark.common.PySpark;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.entity.SparkEngineSession;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.linkis.engineplugin.spark.exception.ExecuteError;
import org.apache.linkis.engineplugin.spark.executor.PythonInterpretRequest;
import org.apache.linkis.engineplugin.spark.executor.SQLSession$;
import org.apache.linkis.engineplugin.spark.executor.SecureRandomStringUtils;
import org.apache.linkis.engineplugin.spark.executor.SparkEngineConnExecutor;
import org.apache.linkis.engineplugin.spark.imexport.CsvRelation$;
import org.apache.linkis.engineplugin.spark.utils.EngineUtils$;
import org.apache.linkis.governance.common.paser.CodeParser;
import org.apache.linkis.governance.common.paser.PythonCodeParser;
import org.apache.linkis.governance.common.utils.GovernanceUtils$;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import org.apache.linkis.storage.resultset.ResultSetWriter$;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.csv.UDF$;
import py4j.GatewayServer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\u0005c\u0001\u0002%J\u0001YC\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0001\u0018\u0005\tG\u0002\u0011\t\u0011)A\u0005;\"AA\r\u0001BC\u0002\u0013\u0005Q\r\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003g\u0011\u0015i\u0007\u0001\"\u0001o\u0011%\u0011\b\u00011AA\u0002\u0013%1\u000fC\u0005{\u0001\u0001\u0007\t\u0019!C\u0005w\"Q\u00111\u0001\u0001A\u0002\u0003\u0005\u000b\u0015\u0002;\t\u0017\u0005\u0015\u0001\u00011AA\u0002\u0013%\u0011q\u0001\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0002C\u0006\u0002 \u0001\u0001\r\u0011!Q!\n\u0005%\u0001\"CA\u0011\u0001\u0001\u0007I\u0011BA\u0012\u0011%\t\t\u0005\u0001a\u0001\n\u0013\t\u0019\u0005\u0003\u0005\u0002H\u0001\u0001\u000b\u0015BA\u0013\u0011-\tI\u0005\u0001a\u0001\u0002\u0004%I!a\u0013\t\u0017\u00055\u0003\u00011AA\u0002\u0013%\u0011q\n\u0005\f\u0003'\u0002\u0001\u0019!A!B\u0013\tY\u0003C\u0005\u0002V\u0001\u0011\r\u0011\"\u0003\u0002X!A\u0011Q\r\u0001!\u0002\u0013\tI\u0006C\u0006\u0002h\u0001\u0001\r\u00111A\u0005\n\u0005-\u0003bCA5\u0001\u0001\u0007\t\u0019!C\u0005\u0003WB1\"a\u001c\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002,!I\u0011\u0011\u000f\u0001A\u0002\u0013%\u00111\u000f\u0005\n\u0003w\u0002\u0001\u0019!C\u0005\u0003{B\u0001\"!!\u0001A\u0003&\u0011Q\u000f\u0005\f\u0003\u0007\u0003\u0001\u0019!A!B\u0013\t)\t\u0003\u0005K\u0001\t\u0007I1BAI\u0011!\tI\n\u0001Q\u0001\n\u0005M\u0005\"CAN\u0001\u0001\u0007I1AAO\u0011%\ti\u000b\u0001a\u0001\n\u0003\ty\u000b\u0003\u0005\u00024\u0002\u0001\u000b\u0015BAP\u00111\t)\f\u0001a\u0001\u0002\u0004%\taSA\\\u00111\ty\r\u0001a\u0001\u0002\u0004%\taSAi\u0011-\t)\u000e\u0001a\u0001\u0002\u0003\u0006K!!/\t\u0013\u0005]\u0007A1A\u0005\n\u0005e\u0007\u0002CAv\u0001\u0001\u0006I!a7\t\u0013\u00055\bA1A\u0005\n\u0005=\b\u0002CA\u007f\u0001\u0001\u0006I!!=\t\u0013\u0005}\bA1A\u0005\u0002\t\u0005\u0001\u0002\u0003B\u0005\u0001\u0001\u0006IAa\u0001\t\u0013\t-\u0001A1A\u0005\u0002\t5\u0001\u0002\u0003B\n\u0001\u0001\u0006IAa\u0004\t\u0015\tU\u0001\u0001#b\u0001\n\u0013\tY\u0005\u0003\u0006\u0003\u0018\u0001A)\u0019!C\u0005\u00053AqA!\f\u0001\t\u0003\u0011y\u0003C\u0004\u0003:\u0001!\tAa\u000f\t\u000f\t-\u0003\u0001\"\u0001\u0003N!9!Q\u000b\u0001\u0005B\t]\u0003b\u0002B-\u0001\u0011\u0005#1\f\u0005\b\u0005C\u0002A\u0011\tB,\u0011\u001d\u0011\u0019\u0007\u0001C!\u0005KBqA!\u001d\u0001\t\u0013\u0011\u0019\bC\u0004\u0003v\u0001!\tFa\u001e\t\u000f\tM\u0005\u0001\"\u0001\u0003X!9!Q\u0013\u0001\u0005\u0002\t]\u0005b\u0002BN\u0001\u0011\u0005!Q\u0014\u0005\b\u0005C\u0003A\u0011\u0001BR\u0011\u001d\u0011Y\u000b\u0001C\u0001\u0005[CqA!0\u0001\t\u0003\u0011y\fC\u0004\u0003F\u0002!\tAa2\t\u000f\t-\u0007\u0001\"\u0001\u0003N\"9!Q\u001b\u0001\u0005\u0002\t]\u0007b\u0002Bq\u0001\u0011\u0005!1\u001d\u0005\b\u0005W\u0004A\u0011\u0001Bw\u0011%\u0019i\u0001AI\u0001\n\u0003\u0019y\u0001C\u0005\u0004&\u0001\t\n\u0011\"\u0001\u0004\u0010!I1q\u0005\u0001\u0012\u0002\u0013\u00051\u0011\u0006\u0005\b\u0007[\u0001A\u0011\u0001B,\u0011\u001d\u0019y\u0003\u0001C\u0001\u0007cAqaa\u000e\u0001\t#\nY\u0005C\u0004\u0004:\u0001!\taa\u000f\u0003'M\u0003\u0018M]6QsRDwN\\#yK\u000e,Ho\u001c:\u000b\u0005)[\u0015\u0001C3yK\u000e,Ho\u001c:\u000b\u00051k\u0015!B:qCJ\\'B\u0001(P\u00031)gnZ5oKBdWoZ5o\u0015\t\u0001\u0016+\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003%N\u000ba!\u00199bG\",'\"\u0001+\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00019\u0006C\u0001-Z\u001b\u0005I\u0015B\u0001.J\u0005]\u0019\u0006/\u0019:l\u000b:<\u0017N\\3D_:tW\t_3dkR|'/\u0001\nta\u0006\u00148.\u00128hS:,7+Z:tS>tW#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\\\u0015AB3oi&$\u00180\u0003\u0002c?\n\u00112\u000b]1sW\u0016sw-\u001b8f'\u0016\u001c8/[8o\u0003M\u0019\b/\u0019:l\u000b:<\u0017N\\3TKN\u001c\u0018n\u001c8!\u0003\tIG-F\u0001g!\t9'.D\u0001i\u0015\u0005I\u0017!B:dC2\f\u0017BA6i\u0005\rIe\u000e^\u0001\u0004S\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0002paF\u0004\"\u0001\u0017\u0001\t\u000bm+\u0001\u0019A/\t\u000b\u0011,\u0001\u0019\u00014\u0002\u001b\u001d\fG/Z<bsN+'O^3s+\u0005!\bCA;y\u001b\u00051(\"A<\u0002\tALHG[\u0005\u0003sZ\u0014QbR1uK^\f\u0017pU3sm\u0016\u0014\u0018!E4bi\u0016<\u0018-_*feZ,'o\u0018\u0013fcR\u0011Ap \t\u0003OvL!A 5\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u00039\u0011\u0011!a\u0001i\u0006\u0019\u0001\u0010J\u0019\u0002\u001d\u001d\fG/Z<bsN+'O^3sA\u00059\u0001O]8dKN\u001cXCAA\u0005!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\tA\u0001\\1oO*\u0011\u00111C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0018\u00055!a\u0002)s_\u000e,7o]\u0001\faJ|7-Z:t?\u0012*\u0017\u000fF\u0002}\u0003;A\u0011\"!\u0001\u000b\u0003\u0003\u0005\r!!\u0003\u0002\u0011A\u0014xnY3tg\u0002\n1\u0001]5e+\t\t)\u0003E\u0003h\u0003O\tY#C\u0002\u0002*!\u0014aa\u00149uS>t\u0007\u0003BA\u0017\u0003wqA!a\f\u00028A\u0019\u0011\u0011\u00075\u000e\u0005\u0005M\"bAA\u001b+\u00061AH]8pizJ1!!\u000fi\u0003\u0019\u0001&/\u001a3fM&!\u0011QHA \u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\b5\u0002\u000fALGm\u0018\u0013fcR\u0019A0!\u0012\t\u0013\u0005\u0005Q\"!AA\u0002\u0005\u0015\u0012\u0001\u00029jI\u0002\n\u0001B[8c\u000fJ|W\u000f]\u000b\u0003\u0003W\tAB[8c\u000fJ|W\u000f]0%KF$2\u0001`A)\u0011%\t\t\u0001EA\u0001\u0002\u0004\tY#A\u0005k_\n<%o\\;qA\u0005I\u0011/^3ss2{7m[\u000b\u0003\u00033\u0002RaZA.\u0003?J1!!\u0018i\u0005\u0015\t%O]1z!\r9\u0017\u0011M\u0005\u0004\u0003GB'\u0001\u0002\"zi\u0016\f!\"];fefdunY6!\u0003\u0011\u0019w\u000eZ3\u0002\u0011\r|G-Z0%KF$2\u0001`A7\u0011%\t\t!FA\u0001\u0002\u0004\tY#A\u0003d_\u0012,\u0007%A\fqsRDwN\\*de&\u0004H/\u00138ji&\fG.\u001b>fIV\u0011\u0011Q\u000f\t\u0004O\u0006]\u0014bAA=Q\n9!i\\8mK\u0006t\u0017a\u00079zi\"|gnU2sSB$\u0018J\\5uS\u0006d\u0017N_3e?\u0012*\u0017\u000fF\u0002}\u0003\u007fB\u0011\"!\u0001\u0019\u0003\u0003\u0005\r!!\u001e\u00021ALH\u000f[8o'\u000e\u0014\u0018\u000e\u001d;J]&$\u0018.\u00197ju\u0016$\u0007%A\u0004qe>l\u0017n]3\u0011\r\u0005\u001d\u0015QRA\u0016\u001b\t\tIIC\u0002\u0002\f\"\f!bY8oGV\u0014(/\u001a8u\u0013\u0011\ty)!#\u0003\u000fA\u0013x.\\5tKV\u0011\u00111\u0013\t\u0005\u0003\u000f\u000b)*\u0003\u0003\u0002\u0018\u0006%%\u0001G#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;pe\u0006IQ\r_3dkR|'\u000fI\u0001\rgB\f'o[*fgNLwN\\\u000b\u0003\u0003?\u0003B!!)\u0002*6\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+A\u0002tc2T!\u0001T)\n\t\u0005-\u00161\u0015\u0002\r'B\f'o[*fgNLwN\\\u0001\u0011gB\f'o[*fgNLwN\\0%KF$2\u0001`AY\u0011%\t\tAHA\u0001\u0002\u0004\ty*A\u0007ta\u0006\u00148nU3tg&|g\u000eI\u0001\u0017K:<\u0017N\\3Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiV\u0011\u0011\u0011\u0018\t\u0005\u0003w\u000bY-\u0004\u0002\u0002>*!\u0011qXAa\u0003\u001d)\u00070Z2vi\u0016T1ASAb\u0015\u0011\t)-a2\u0002\u0017\r|W\u000e];uCRLwN\u001c\u0006\u0004\u0003\u0013|\u0015AC3oO&tWmY8o]&!\u0011QZA_\u0005Y)enZ5oK\u0016CXmY;uS>t7i\u001c8uKb$\u0018AG3oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;`I\u0015\fHc\u0001?\u0002T\"I\u0011\u0011A\u0011\u0002\u0002\u0003\u0007\u0011\u0011X\u0001\u0018K:<\u0017N\\3Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002\nQ#\u001a8hS:,7I]3bi&|gnQ8oi\u0016DH/\u0006\u0002\u0002\\B!\u0011Q\\At\u001b\t\tyN\u0003\u0003\u0002b\u0006\r\u0018\u0001C2sK\u0006$\u0018n\u001c8\u000b\t\u0005\u0015\u0018qY\u0001\u0007G>lWn\u001c8\n\t\u0005%\u0018q\u001c\u0002\u0016\u000b:<\u0017N\\3De\u0016\fG/[8o\u0007>tG/\u001a=u\u0003Y)gnZ5oK\u000e\u0013X-\u0019;j_:\u001cuN\u001c;fqR\u0004\u0013\u0001\u00057j]\u0016|U\u000f\u001e9viN#(/Z1n+\t\t\t\u0010\u0005\u0003\u0002t\u0006eXBAA{\u0015\u0011\t90!1\u0002\u0005I\u001c\u0018\u0002BA~\u0003k\u0014aBU:PkR\u0004X\u000f^*ue\u0016\fW.A\tmS:,w*\u001e;qkR\u001cFO]3b[\u0002\n!b]9m\u0007>tG/\u001a=u+\t\u0011\u0019\u0001\u0005\u0003\u0002\"\n\u0015\u0011\u0002\u0002B\u0004\u0003G\u0013!bU)M\u0007>tG/\u001a=u\u0003-\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\u0011\u0002\u000fM+6iQ#T'V\u0011!q\u0002\t\u0005\u0003\u0017\u0011\t\"\u0003\u0003\u0002>\u00055\u0011\u0001C*V\u0007\u000e+5k\u0015\u0011\u0002\u0013ALHG\u001b+pW\u0016t\u0017!C4x\u0005VLG\u000eZ3s+\t\u0011Y\u0002\u0005\u0003\u0003\u001e\t\u001db\u0002\u0002B\u0010\u0005GqA!!\r\u0003\"%\tq/C\u0002\u0003&Y\fQbR1uK^\f\u0017pU3sm\u0016\u0014\u0018\u0002\u0002B\u0015\u0005W\u0011AcR1uK^\f\u0017pU3sm\u0016\u0014()^5mI\u0016\u0014(b\u0001B\u0013m\u0006aq-\u001a;Ta\u0006\u00148nQ8oMV\u0011!\u0011\u0007\t\u0005\u0005g\u0011)$\u0004\u0002\u0002(&!!qGAT\u0005%\u0019\u0006/\u0019:l\u0007>tg-A\nhKRT\u0015M^1Ta\u0006\u00148nQ8oi\u0016DH/\u0006\u0002\u0003>A!!q\bB$\u001b\t\u0011\tE\u0003\u0003\u0002\u0014\t\r#\u0002\u0002B#\u0003O\u000b1!\u00199j\u0013\u0011\u0011IE!\u0011\u0003!)\u000bg/Y*qCJ\\7i\u001c8uKb$\u0018aD4fiN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0016\u0005\t=\u0003\u0003BA\u0006\u0005#JAAa\u0015\u0002\u000e\t1qJ\u00196fGR\fA!\u001b8jiR\tA0\u0001\u0005lS2dG+Y:l)\ra(Q\f\u0005\b\u0005?\n\u0004\u0019AA\u0016\u0003\u0019!\u0018m]6J\t\u0006)1\r\\8tK\u00069q-\u001a;LS:$WC\u0001B4!\u0011\u0011IG!\u001c\u000e\u0005\t-$bAAs\u0017&!!q\u000eB6\u0005\u0011Y\u0015N\u001c3\u0002\u0017%t\u0017\u000e^$bi\u0016<\u0018-_\u000b\u0002y\u00069!/\u001e8D_\u0012,GC\u0003B=\u0005\u0013\u0013iIa$\u0003\u0012B!!1\u0010BC\u001b\t\u0011iH\u0003\u0003\u0003\u0000\t\u0005\u0015\u0001C3yK\u000e,H/\u001a:\u000b\u0007\t\ru*A\u0005tG\",G-\u001e7fe&!!q\u0011B?\u0005=)\u00050Z2vi\u0016\u0014Vm\u001d9p]N,\u0007B\u0002BFk\u0001\u0007q+A\nta\u0006\u00148.\u00128hS:,W\t_3dkR|'\u000fC\u0004\u0002hU\u0002\r!a\u000b\t\u000f\u0005UV\u00071\u0001\u0002:\"9\u0011\u0011J\u001bA\u0002\u0005-\u0012a\u00047bufLe.\u001b;HCR,w/Y=\u0002\u0017\u0015DXmY;uK2Kg.\u001a\u000b\u0005\u0005s\u0012I\nC\u0004\u0002h]\u0002\r!a\u000b\u00023=t\u0007+\u001f;i_:\u001c6M]5qi&s\u0017\u000e^5bY&TX\r\u001a\u000b\u0004y\n}\u0005BBA\u0011q\u0001\u0007a-A\u0007hKR\u001cF/\u0019;f[\u0016tGo]\u000b\u0003\u0005K\u00032\u0001\u0017BT\u0013\r\u0011I+\u0013\u0002\u0017!f$\bn\u001c8J]R,'\u000f\u001d:fiJ+\u0017/^3ti\u0006)2/\u001a;Ti\u0006$X-\\3oiN4\u0015N\\5tQ\u0016$GC\u0002BX\u0005k\u0013I\fE\u0002h\u0005cK1Aa-i\u0005\r\te.\u001f\u0005\b\u0005oS\u0004\u0019AA\u0016\u0003\ryW\u000f\u001e\u0005\b\u0005wS\u0004\u0019AA;\u0003\u0015)'O]8s\u00031\t\u0007\u000f]3oI>+H\u000f];u)\ra(\u0011\u0019\u0005\b\u0005\u0007\\\u0004\u0019AA\u0016\u0003\u001diWm]:bO\u0016\f\u0011#\u00199qK:$WI\u001d:pe>+H\u000f];u)\ra(\u0011\u001a\u0005\b\u0005\u0007d\u0004\u0019AA\u0016\u0003\u0019\u0019\bn\\<E\rR)APa4\u0003R\"9\u0011\u0011J\u001fA\u0002\u0005-\u0002b\u0002Bj{\u0001\u0007!qV\u0001\u0003I\u001a\f1b\u001d5po\u0006c\u0017.Y:E\rR9AP!7\u0003\\\nu\u0007bBA%}\u0001\u0007\u00111\u0006\u0005\b\u0005't\u0004\u0019\u0001BX\u0011\u001d\u0011yN\u0010a\u0001\u0003W\tQ!\u00197jCN\f\u0001b\u001d5po\"#V\n\u0014\u000b\u0006y\n\u0015(q\u001d\u0005\b\u0003\u0013z\u0004\u0019AA\u0016\u0011\u001d\u0011Io\u0010a\u0001\u0005_\u000b1\u0002\u001b;nY\u000e{g\u000e^3oi\u0006Y1/\u0019<f\t\u001a#vnQ:w)1\t)Ha<\u0003r\nU(\u0011 B\u007f\u0011\u001d\u0011\u0019\u000e\u0011a\u0001\u0005_CqAa=A\u0001\u0004\tY#\u0001\u0003qCRD\u0007\"\u0003B|\u0001B\u0005\t\u0019AA;\u0003%A\u0017m\u001d%fC\u0012,'\u000fC\u0005\u0003|\u0002\u0003\n\u00111\u0001\u0002v\u0005Y\u0011n](wKJ<(/\u001b;f\u0011%\u0011y\u0010\u0011I\u0001\u0002\u0004\u0019\t!\u0001\u0004paRLwN\u001c\t\t\u0007\u0007\u0019I!a\u000b\u000306\u00111Q\u0001\u0006\u0005\u0007\u000f\t\t\"\u0001\u0003vi&d\u0017\u0002BB\u0006\u0007\u000b\u00111!T1q\u0003U\u0019\u0018M^3E\rR{7i\u001d<%I\u00164\u0017-\u001e7uIM*\"a!\u0005+\t\u0005U41C\u0016\u0003\u0007+\u0001Baa\u0006\u0004\"5\u00111\u0011\u0004\u0006\u0005\u00077\u0019i\"A\u0005v]\u000eDWmY6fI*\u00191q\u00045\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004$\re!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)2/\u0019<f\t\u001a#vnQ:wI\u0011,g-Y;mi\u0012\"\u0014!F:bm\u0016$e\tV8DgZ$C-\u001a4bk2$H%N\u000b\u0003\u0007WQCa!\u0001\u0004\u0014\u0005AA.[:u+\u001235/A\u0005fq&\u001cHo]+E\rR!\u0011QOB\u001a\u0011\u001d\u0019)$\u0012a\u0001\u0003W\tAA\\1nK\u0006\u0019r-\u001a;Fq\u0016\u001cW\u000f^8s\u0013\u0012\u0004&/\u001a$jq\u0006A\u0001O]5oi2{w\rF\u0002}\u0007{Aqaa\u0010H\u0001\u0004\u0011y+A\u0002m_\u001e\u0004")
public class SparkPythonExecutor
extends SparkEngineConnExecutor {
    private String py4jToken;
    private GatewayServer.GatewayServerBuilder gwBuilder;
    private final SparkEngineSession sparkEngineSession;
    private final int id;
    private GatewayServer gatewayServer;
    private Process process;
    private Option<String> pid;
    private String jobGroup;
    private final byte[] queryLock;
    private String code;
    private boolean pythonScriptInitialized;
    private Promise<String> promise;
    private final ExecutionContextExecutor executor;
    private SparkSession sparkSession;
    private EngineExecutionContext engineExecutionContext;
    private final EngineCreationContext engineCreationContext;
    private final RsOutputStream lineOutputStream;
    private final SQLContext sqlContext;
    private final String SUCCESS;
    private volatile byte bitmap$0;

    public SparkEngineSession sparkEngineSession() {
        return this.sparkEngineSession;
    }

    public int id() {
        return this.id;
    }

    private GatewayServer gatewayServer() {
        return this.gatewayServer;
    }

    private void gatewayServer_$eq(GatewayServer x$1) {
        this.gatewayServer = x$1;
    }

    private Process process() {
        return this.process;
    }

    private void process_$eq(Process x$1) {
        this.process = x$1;
    }

    private Option<String> pid() {
        return this.pid;
    }

    private void pid_$eq(Option<String> x$1) {
        this.pid = x$1;
    }

    private String jobGroup() {
        return this.jobGroup;
    }

    private void jobGroup_$eq(String x$1) {
        this.jobGroup = x$1;
    }

    private byte[] queryLock() {
        return this.queryLock;
    }

    private String code() {
        return this.code;
    }

    private void code_$eq(String x$1) {
        this.code = x$1;
    }

    private boolean pythonScriptInitialized() {
        return this.pythonScriptInitialized;
    }

    private void pythonScriptInitialized_$eq(boolean x$1) {
        this.pythonScriptInitialized = x$1;
    }

    private ExecutionContextExecutor executor() {
        return this.executor;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public void sparkSession_$eq(SparkSession x$1) {
        this.sparkSession = x$1;
    }

    public EngineExecutionContext engineExecutionContext() {
        return this.engineExecutionContext;
    }

    public void engineExecutionContext_$eq(EngineExecutionContext x$1) {
        this.engineExecutionContext = x$1;
    }

    private EngineCreationContext engineCreationContext() {
        return this.engineCreationContext;
    }

    private RsOutputStream lineOutputStream() {
        return this.lineOutputStream;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public String SUCCESS() {
        return this.SUCCESS;
    }

    private String py4jToken$lzycompute() {
        SparkPythonExecutor sparkPythonExecutor = this;
        synchronized (sparkPythonExecutor) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.py4jToken = SparkConfiguration$.MODULE$.LINKIS_PYSPARK_USE_SECURE_RANDOM() ? SecureRandomStringUtils.randomAlphanumeric(256) : Integer.toString(SecureRandom.getInstance("SHA1PRNG").nextInt(100000));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.py4jToken;
    }

    private String py4jToken() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.py4jToken$lzycompute();
        }
        return this.py4jToken;
    }

    private GatewayServer.GatewayServerBuilder gwBuilder$lzycompute() {
        SparkPythonExecutor sparkPythonExecutor = this;
        synchronized (sparkPythonExecutor) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                GatewayServer.GatewayServerBuilder builder = new GatewayServer.GatewayServerBuilder().javaPort(0).callbackClient(0, InetAddress.getByName("127.0.0.1")).connectTimeout(0).readTimeout(0).customCommands(null);
                this.gwBuilder = this.liftedTree1$1(builder);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.gwBuilder;
    }

    private GatewayServer.GatewayServerBuilder gwBuilder() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.gwBuilder$lzycompute();
        }
        return this.gwBuilder;
    }

    public SparkConf getSparkConf() {
        return this.sc().getConf();
    }

    public JavaSparkContext getJavaSparkContext() {
        return new JavaSparkContext(this.sc());
    }

    public Object getSparkSession() {
        if (this.sparkSession() != null) {
            return this.sparkSession();
        }
        return (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalAccessException("not supported keyword spark in spark1.x versions");
        };
    }

    @Override
    public void init() {
        this.setCodeParser((CodeParser)new PythonCodeParser());
        super.init();
        this.logger().info("spark python executor start");
    }

    @Override
    public void killTask(String taskID) {
        this.logger().info(new java.lang.StringBuilder(26).append("Start to kill python task ").append(taskID).toString());
        super.killTask(taskID);
        this.logger().info(new java.lang.StringBuilder(25).append("To close python cli task ").append(taskID).toString());
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.close(), this.logger());
    }

    @Override
    public void close() {
        Object object;
        this.logger().info("To remove pyspark executor");
        Utils$.MODULE$.tryAndError((Function0 & Serializable & scala.Serializable)() -> ExecutorManager$.MODULE$.getInstance().removeExecutor((Label[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.getExecutorLabels()).asScala()).toArray(ClassTag$.MODULE$.apply(Label.class))), this.logger());
        this.logger().info("Finished remove pyspark executor");
        this.logger().info("To kill pyspark process");
        if (this.process() != null) {
            if (this.gatewayServer() != null) {
                Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.gatewayServer().shutdown(), this.logger());
                this.gatewayServer_$eq(null);
            }
            IOUtils.closeQuietly((OutputStream)this.lineOutputStream());
            object = Utils$.MODULE$.tryAndErrorMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.pid().foreach((Function1 & Serializable & scala.Serializable)p -> {
                    SparkPythonExecutor.$anonfun$close$4(this, p);
                    return BoxedUnit.UNIT;
                });
                Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.process().destroy());
                this.process_$eq(null);
                this.logger().info("Finished kill pyspark process");
            }, "process close failed", this.logger());
        } else {
            object = BoxedUnit.UNIT;
        }
        this.logger().info("python executor finished to close");
    }

    @Override
    public Kind getKind() {
        return new PySpark();
    }

    private void initGateway() {
        Object object;
        CommandLine commandLine;
        this.logger().info(new java.lang.StringBuilder(24).append("spark.python.version => ").append(this.engineCreationContext().getOptions().get("spark.python.version")).toString());
        String userDefinePythonVersion = this.engineCreationContext().getOptions().getOrDefault("spark.python.version", "python").toLowerCase();
        String sparkPythonVersion = StringUtils.isNotBlank((CharSequence)userDefinePythonVersion) && userDefinePythonVersion.equals("python3") ? (String)SparkConfiguration$.MODULE$.PYSPARK_PYTHON3_PATH().getValue() : userDefinePythonVersion;
        String pythonExec = (String)CommonVars$.MODULE$.apply("PYSPARK_DRIVER_PYTHON", (Object)sparkPythonVersion).getValue();
        String pythonScriptPath = (String)CommonVars$.MODULE$.apply("python.script.path", (Object)"python/mix_pyspark.py").getValue();
        int port = EngineUtils$.MODULE$.findAvailPort();
        this.gatewayServer_$eq(this.gwBuilder().entryPoint((Object)this).javaPort(port).build());
        this.gatewayServer().start();
        this.logger().info(new java.lang.StringBuilder(30).append("Pyspark process file path is: ").append(this.getClass().getClassLoader().getResource(pythonScriptPath).toURI()).toString());
        StringBuilder pythonClasspath = new StringBuilder(PythonInterpreter$.MODULE$.pythonPath());
        String files = this.sc().getConf().get("spark.files", "");
        this.logger().info(new java.lang.StringBuilder(19).append("output spark files ").append(files).toString());
        Object object2 = StringUtils.isNotEmpty((CharSequence)files) ? pythonClasspath.$plus$plus$eq(File.pathSeparator).$plus$plus$eq(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files.split(","))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.endsWith(".zip"))))).mkString(File.pathSeparator)) : BoxedUnit.UNIT;
        String pyFiles = this.sc().getConf().get("spark.submit.pyFiles", "");
        this.logger().info(new java.lang.StringBuilder(24).append("spark.submit.pyFiles => ").append(pyFiles).toString());
        String classPath = (String)CommonVars$.MODULE$.apply("java.class.path", (Object)"").getValue();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classPath.split(";"))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.endsWith(".zip"))))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> pythonClasspath.$plus$plus$eq(File.pathSeparator).$plus$plus$eq(x$3));
        CommandLine cmd = CommandLine.parse((String)pythonExec);
        if (BoxesRunTime.unboxToBoolean((Object)SparkConfiguration$.MODULE$.SPARK_PYTHON_TEST_MODE_ENABLE().getValue())) {
            String path = (String)SparkConfiguration$.MODULE$.SPARK_PYTHON_TEST_MODE_MIX__PYSHELL_PATH().getValue();
            this.logger().info(new java.lang.StringBuilder(20).append(SparkConfiguration$.MODULE$.SPARK_PYTHON_TEST_MODE_ENABLE().key()).append(" => true, will use ").append(SparkConfiguration$.MODULE$.SPARK_PYTHON_TEST_MODE_MIX__PYSHELL_PATH().key()).append(":").append(path).toString());
            commandLine = cmd.addArgument(path, false);
        } else {
            commandLine = cmd.addArgument(PythonInterpreter$.MODULE$.createFakeShell(pythonScriptPath, PythonInterpreter$.MODULE$.createFakeShell$default$2()).getAbsolutePath(), false);
        }
        cmd.addArgument(Integer.toString(port), false);
        cmd.addArgument(EngineUtils$.MODULE$.sparkSubmitVersion().replaceAll("\\.", ""), false);
        cmd.addArgument(this.py4jToken(), false);
        cmd.addArgument(pythonClasspath.toString(), false);
        cmd.addArgument(pyFiles, false);
        ProcessBuilder builder = new ProcessBuilder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd.toStrings())).toSeq().toList()).asJava());
        Map<String, String> env = builder.environment();
        if (StringUtils.isBlank((CharSequence)this.sc().getConf().get("spark.pyspark.python", ""))) {
            this.logger().info("spark.pyspark.python is null");
            if (userDefinePythonVersion.equals("python3")) {
                this.logger().info(new java.lang.StringBuilder(57).append("userDefinePythonVersion is ").append(pythonExec).append(" will be set to PYSPARK_PYTHON").toString());
                object = env.put("PYSPARK_PYTHON", pythonExec);
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            String executorPython = this.sc().getConf().get("spark.pyspark.python");
            this.logger().info(new java.lang.StringBuilder(43).append("set PYSPARK_PYTHON spark.pyspark.python is ").append(executorPython).toString());
            object = env.put("PYSPARK_PYTHON", executorPython);
        }
        env.put("PYTHONPATH", pythonClasspath.toString());
        env.put("PYTHONUNBUFFERED", "YES");
        env.put("PYSPARK_GATEWAY_PORT", String.valueOf(BoxesRunTime.boxToInteger((int)port)));
        env.put("SPARK_HOME", (String)SparkConfiguration$.MODULE$.SPARK_HOME().getValue());
        this.logger().info(new java.lang.StringBuilder(24).append("pyspark builder command:").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(builder.command()).asScala()).mkString(" ")).toString());
        builder.redirectErrorStream(true);
        builder.redirectInput(ProcessBuilder.Redirect.PIPE);
        this.process_$eq(builder.start());
        Utils$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.close());
        Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int exitCode = this.process().waitFor();
            this.pythonScriptInitialized_$eq(false);
            this.logger().info(new java.lang.StringBuilder(43).append("Pyspark process has stopped with exit code ").append(exitCode).toString());
            return Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> {
                if ($this.promise != null && !$this.promise.isCompleted()) {
                    return $this.promise.failure((Throwable)((Object)new ExecuteError(SparkErrorCodeSummary.PYSPARK_STOPPED.getErrorCode(), SparkErrorCodeSummary.PYSPARK_STOPPED.getErrorDesc())));
                }
                return BoxedUnit.UNIT;
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.close());
        }, (ExecutionContext)this.executor());
        Utils$.MODULE$.waitUntil((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.pythonScriptInitialized(), (Duration)((TimeType)SparkConfiguration$.MODULE$.SPARK_LANGUAGE_REPL_INIT_TIME().getValue()).toDuration());
    }

    @Override
    public ExecuteResponse runCode(SparkEngineConnExecutor sparkEngineExecutor, String code, EngineExecutionContext engineExecutionContext, String jobGroup) {
        EngineExecutionContext engineExecutionContext2 = engineExecutionContext;
        EngineExecutionContext engineExecutionContext3 = this.engineExecutionContext();
        if (engineExecutionContext2 == null ? engineExecutionContext3 != null : !engineExecutionContext2.equals(engineExecutionContext3)) {
            this.engineExecutionContext_$eq(engineExecutionContext);
            this.lineOutputStream().reset(engineExecutionContext);
            this.lineOutputStream().ready();
        }
        this.lazyInitGateway();
        this.jobGroup_$eq(jobGroup);
        return this.executeLine(code);
    }

    public void lazyInitGateway() {
        if (this.process() == null) {
            Utils$.MODULE$.tryThrow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.initGateway(), (Function1 & Serializable & scala.Serializable)t -> {
                this.logger().error("initialize python executor failed, please ask administrator for help!", t);
                Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.close(), this.logger());
                throw t;
            });
            return;
        }
    }

    public ExecuteResponse executeLine(String code) {
        if (this.sc().isStopped()) {
            throw new IllegalStateException("Application has been stopped, please relogin to try it.");
        }
        if (!this.pythonScriptInitialized()) {
            throw new IllegalStateException("Pyspark process cannot be initialized, please ask administrator for help.");
        }
        this.promise = Promise$.MODULE$.apply();
        this.code_$eq(code);
        this.engineExecutionContext().appendStdout(new java.lang.StringBuilder(4).append(EngineUtils$.MODULE$.getName()).append(" >> ").append(code).toString());
        byte[] byArray = this.queryLock();
        synchronized (byArray) {
            this.queryLock().notify();
        }
        Await$.MODULE$.result((Awaitable)this.promise.future(), (Duration)Duration$.MODULE$.Inf());
        this.lineOutputStream().flush();
        String outStr = this.lineOutputStream().toString();
        if (new StringOps(Predef$.MODULE$.augmentString(outStr)).nonEmpty()) {
            String res;
            Record[] output = (Record[])Utils$.MODULE$.tryQuietly((Function0 & Serializable & scala.Serializable)() -> ResultSetWriter$.MODULE$.getRecordByRes(outStr, (long)BoxesRunTime.unboxToInt((Object)SparkConfiguration$.MODULE$.SPARK_CONSOLE_OUTPUT_NUM().getValue())));
            String string = res = output != null ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output)).map((Function1 & Serializable & scala.Serializable)x -> x.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList().mkString("\n") : "";
            if (new StringOps(Predef$.MODULE$.augmentString(res)).nonEmpty()) {
                this.engineExecutionContext().appendStdout(new java.lang.StringBuilder(10).append("result is ").append(res).toString());
            }
        }
        return new SuccessExecuteResponse();
    }

    public void onPythonScriptInitialized(int pid) {
        this.pid_$eq((Option<String>)new Some((Object)Integer.toString(pid)));
        this.pythonScriptInitialized_$eq(true);
        this.logger().info(new java.lang.StringBuilder(44).append("Pyspark process has been initialized.pid is ").append(pid).toString());
    }

    public PythonInterpretRequest getStatements() {
        byte[] byArray = this.queryLock();
        synchronized (byArray) {
            while (this.code() == null || !this.pythonScriptInitialized()) {
                this.queryLock().wait();
            }
        }
        this.logger().info(new java.lang.StringBuilder(35).append("Prepare to deal python code, code: ").append(this.code().substring(0, this.code().indexOf("\n") > 0 ? this.code().indexOf("\n") : this.code().length())).toString());
        PythonInterpretRequest request = new PythonInterpretRequest(this.code(), this.jobGroup());
        this.code_$eq(null);
        return request;
    }

    public Object setStatementsFinished(String out, boolean error) {
        this.logger().info(new java.lang.StringBuilder(52).append("A python code finished, has some errors happened?  ").append(error).append(".").toString());
        Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep(10L));
        if (!error) {
            return this.promise.success((Object)this.SUCCESS());
        }
        if (this.promise.isCompleted()) {
            this.logger().info("promise is completed and should start another python gateway");
            this.close();
            return BoxedUnit.UNIT;
        }
        return this.promise.failure((Throwable)((Object)new ExecuteError(SparkErrorCodeSummary.OUT_ID.getErrorCode(), out)));
    }

    public void appendOutput(String message) {
        if (!this.pythonScriptInitialized()) {
            this.logger().info(message);
            return;
        }
        if (BoxesRunTime.unboxToBoolean((Object)SparkConfiguration$.MODULE$.SPARK_PYTHON_TEST_MODE_ENABLE().getValue())) {
            this.logger().info(message);
        }
        this.lineOutputStream().write(message.getBytes("utf-8"));
    }

    public void appendErrorOutput(String message) {
        if (!this.pythonScriptInitialized()) {
            this.logger().info(message);
            return;
        }
        this.logger().error(message);
        this.engineExecutionContext().appendStdout(new java.lang.StringBuilder(16).append("errorMessage is ").append(message).toString());
    }

    public void showDF(String jobGroup, Object df) {
        SQLSession$.MODULE$.showDF(this.sc(), jobGroup, (Dataset<Row>)((Dataset)df), null, 5000, this.engineExecutionContext());
        this.logger().info("Pyspark showDF execute success!");
    }

    public void showAliasDF(String jobGroup, Object df, String alias) {
        SQLSession$.MODULE$.showDF(this.sc(), jobGroup, (Dataset<Row>)((Dataset)df), alias, 5000, this.engineExecutionContext());
        this.logger().info("Pyspark showAliasDF execute success!");
    }

    public void showHTML(String jobGroup, Object htmlContent) {
        SQLSession$.MODULE$.showHTML(this.sc(), jobGroup, htmlContent, this.engineExecutionContext());
        this.logger().info("Pyspark showHTML execute success!");
    }

    public boolean saveDFToCsv(Object df, String path, boolean hasHeader, boolean isOverwrite, Map<String, Object> option) {
        return CsvRelation$.MODULE$.saveDFToCsv(this.sparkSession(), (Dataset<Row>)((Dataset)df), path, hasHeader, isOverwrite, (scala.collection.immutable.Map<String, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(option).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    public boolean saveDFToCsv$default$3() {
        return true;
    }

    public boolean saveDFToCsv$default$4() {
        return false;
    }

    public Map<String, Object> saveDFToCsv$default$5() {
        return new HashMap<String, Object>();
    }

    public void listUDFs() {
        UDF$.MODULE$.listUDFs(this.sparkSession());
    }

    public boolean existsUDF(String name) {
        return UDF$.MODULE$.existsUDF(name, this.sparkSession());
    }

    @Override
    public String getExecutorIdPreFix() {
        return "SparkPythonExecutor_";
    }

    public void printLog(Object log) {
        this.logger().info(log.toString());
        if (this.engineExecutionContext() != null) {
            this.engineExecutionContext().appendStdout(new java.lang.StringBuilder(32).append("+++++++++++++++\n").append(log.toString()).append("\n+++++++++++++++").toString());
            return;
        }
        this.logger().warn("engine context is null can not send log");
    }

    private final /* synthetic */ GatewayServer.GatewayServerBuilder liftedTree1$1(GatewayServer.GatewayServerBuilder builder$1) {
        GatewayServer.GatewayServerBuilder gatewayServerBuilder;
        try {
            gatewayServerBuilder = builder$1.authToken(this.py4jToken());
        }
        catch (Throwable err) {
            gatewayServerBuilder = builder$1;
        }
        return gatewayServerBuilder;
    }

    public static final /* synthetic */ void $anonfun$close$4(SparkPythonExecutor $this, String p) {
        $this.logger().info(new java.lang.StringBuilder(45).append("Try to kill pyspark process with: [kill -15 ").append(p).append("]").toString());
        GovernanceUtils$.MODULE$.killProcess(String.valueOf(p), new java.lang.StringBuilder(26).append("kill pyspark process,pid: ").append($this.pid()).toString(), false);
    }

    public SparkPythonExecutor(SparkEngineSession sparkEngineSession, int id) {
        this.sparkEngineSession = sparkEngineSession;
        this.id = id;
        super(sparkEngineSession.sparkContext(), id);
        this.pid = None$.MODULE$;
        this.queryLock = new byte[0];
        this.pythonScriptInitialized = false;
        this.executor = ExecutionContext$.MODULE$.global();
        this.sparkSession = sparkEngineSession.sparkSession();
        this.engineCreationContext = EngineConnServer$.MODULE$.getEngineCreationContext();
        this.lineOutputStream = new RsOutputStream();
        this.sqlContext = sparkEngineSession.sqlContext();
        this.SUCCESS = "success";
    }
}

