/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.UserModifiable;
import org.apache.linkis.manager.label.entity.annon.ValueSerialNum;
import org.apache.linkis.manager.label.exception.LabelRuntimeException;
import org.apache.linkis.protocol.util.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelUtils {
    private static Set<String> modifiableLabelKeyList;
    public static final String COMMON_VALUE = "*";
    public static final String UNIVERSAL_LABEL_SEPARATOR = "-";
    public static Logger logger;

    public static boolean isBasicType(Class<?> clz) {
        if (clz == null) {
            return false;
        }
        return clz.equals(String.class) || clz.equals(Enum.class) || ClassUtils.isPrimitiveOrWrapper(clz);
    }

    public static List<String> getOrderedValueNameInLabelClass(Class<?> clazz, String[] namePrefixes) {
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<MethodWrapper> methodWrappers = new ArrayList<MethodWrapper>();
        block0: for (Method method : methods) {
            String methodName = method.getName();
            if (!method.isAnnotationPresent(ValueSerialNum.class)) continue;
            ValueSerialNum position = method.getAnnotation(ValueSerialNum.class);
            if (null == namePrefixes || namePrefixes.length == 0) {
                methodWrappers.add(new MethodWrapper(methodName, position.value()));
                continue;
            }
            for (String prefix : namePrefixes) {
                if (!methodName.startsWith(prefix) || (methodName = methodName.substring(prefix.length())).length() <= 0) continue;
                methodWrappers.add(new MethodWrapper(methodName.substring(0, 1).toLowerCase() + methodName.substring(1), position.value()));
                continue block0;
            }
        }
        Collections.sort(methodWrappers);
        return methodWrappers.stream().distinct().map(methodWrapper -> methodWrapper.methodName).collect(Collectors.toList());
    }

    public static List<Label<?>> distinctLabel(List<Label<?>> labelListA, List<Label<?>> labelListB) {
        if (CollectionUtils.isEmpty(labelListA)) {
            return labelListB;
        }
        if (CollectionUtils.isEmpty(labelListB)) {
            return labelListA;
        }
        ArrayList resList = new ArrayList();
        HashSet<String> labelAKeys = new HashSet<String>();
        for (Label<?> label : labelListA) {
            if (labelAKeys.contains(label.getLabelKey())) continue;
            labelAKeys.add(label.getLabelKey());
            resList.add(label);
        }
        for (Label<?> label : labelListB) {
            if (labelAKeys.contains(label.getLabelKey())) continue;
            resList.add(label);
        }
        return resList;
    }

    public static Map<String, Object> labelsToMap(List<Label<?>> labelList) throws LabelRuntimeException {
        if (CollectionUtils.isEmpty(labelList)) {
            return null;
        }
        HashMap<String, Object> labelMap = new HashMap<String, Object>();
        for (Label<?> label : labelList) {
            if (labelMap.containsKey(label.getLabelKey())) continue;
            labelMap.put(label.getLabelKey(), label.getStringValue());
        }
        return labelMap;
    }

    public static List<ImmutablePair<String, String>> labelsToPairList(List<Label<?>> labelList) {
        if (CollectionUtils.isEmpty(labelList)) {
            return null;
        }
        ArrayList<ImmutablePair<String, String>> rsList = new ArrayList<ImmutablePair<String, String>>(labelList.size());
        for (Label<?> label : labelList) {
            if (null != label) {
                rsList.add((ImmutablePair<String, String>)new ImmutablePair((Object)label.getLabelKey(), (Object)label.getStringValue()));
                continue;
            }
            logger.warn("LabelList contans empty label.");
        }
        return rsList;
    }

    public static Set<String> listAllUserModifiableLabel() {
        if (modifiableLabelKeyList != null) {
            return modifiableLabelKeyList;
        }
        Set labelSet = org.apache.linkis.common.utils.ClassUtils.reflections().getSubTypesOf(Label.class);
        HashSet<String> result = new HashSet<String>();
        labelSet.stream().forEach(label -> {
            try {
                Label instanceLabel;
                if (!org.apache.linkis.common.utils.ClassUtils.isInterfaceOrAbstract((Class)label) && (instanceLabel = (Label)label.newInstance()) instanceof UserModifiable) {
                    result.add(instanceLabel.getLabelKey());
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.info("Failed to instantiation", (Throwable)e);
            }
        });
        modifiableLabelKeyList = result;
        return modifiableLabelKeyList;
    }

    static {
        logger = LoggerFactory.getLogger(LabelUtils.class);
    }

    public static class Jackson {
        public static final String PREFIX = "[";
        public static final String SUFFIX = "]";
        private static final ObjectMapper mapper = new ObjectMapper();

        public static String toJson(Object simpleObj, Class<?> viewModel) {
            ObjectWriter writer = mapper.writer();
            if (null != simpleObj) {
                try {
                    if (null != viewModel) {
                        writer = writer.withView(viewModel);
                    }
                    return writer.writeValueAsString(simpleObj);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Fail to process method 'toJson(" + simpleObj + ": " + simpleObj.getClass() + ", " + (viewModel != null ? viewModel.getSimpleName() : null) + ")'", e);
                }
            }
            return null;
        }

        public static <T> T fromJson(String json, Class<?> tClass, Class<?> ... parameters) {
            if (StringUtils.isNotBlank((CharSequence)json)) {
                try {
                    if (parameters.length > 0) {
                        return (T)mapper.readValue(json, mapper.getTypeFactory().constructParametricType(tClass, (Class[])parameters));
                    }
                    return (T)mapper.readValue(json, tClass);
                }
                catch (Exception e) {
                    logger.warn("Fail to process method 'fromJson(" + (json.length() > 5 ? json.substring(0, 5) + "..." : json) + ": " + json.getClass() + ", " + tClass.getSimpleName() + ": " + Class.class + ", ...: " + Class.class + ")", (Throwable)e);
                    return null;
                }
            }
            return null;
        }

        public static <T> T fromJson(String json, JavaType javaType) {
            if (StringUtils.isNotBlank((CharSequence)json)) {
                try {
                    return (T)mapper.readValue(json, javaType);
                }
                catch (Exception e) {
                    throw new RuntimeException("Fail to process method 'fromJson(" + (json.length() > 5 ? json.substring(0, 5) + "..." : json) + ": " + json.getClass() + ", " + javaType.getTypeName() + ": " + JavaType.class + ")", e);
                }
            }
            return null;
        }

        public static <T> T convert(Object simpleObj, Class<?> tClass, Class<?> ... parameters) {
            try {
                if (parameters.length > 0) {
                    return (T)mapper.convertValue(simpleObj, mapper.getTypeFactory().constructParametricType(tClass, (Class[])parameters));
                }
                return (T)mapper.convertValue(simpleObj, tClass);
            }
            catch (Exception e) {
                throw new RuntimeException("Fail to process method 'convert(" + simpleObj + ": " + simpleObj.getClass().getSimpleName() + ", " + tClass.getSimpleName() + ": " + Class.class + ", ...: " + Class.class + ")", e);
            }
        }

        public static <T> T convert(Object simpleObj, JavaType javaType) {
            try {
                return (T)mapper.convertValue(simpleObj, javaType);
            }
            catch (Exception e) {
                throw new RuntimeException("Fail to process method 'convert(" + simpleObj + ": " + simpleObj.getClass().getSimpleName() + ", " + javaType.getTypeName() + ": " + JavaType.class + ")", e);
            }
        }

        static {
            mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            mapper.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true);
            mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
            mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
    }

    private static class MethodWrapper
    implements Comparable<MethodWrapper> {
        String methodName;
        int order;

        MethodWrapper(String methodName, int order) {
            this.methodName = methodName;
            this.order = order;
        }

        @Override
        public int compareTo(MethodWrapper o) {
            return this.order - o.order;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodWrapper) {
                return this.methodName.equals(((MethodWrapper)obj).methodName);
            }
            return super.equals(obj);
        }

        public String toString() {
            return this.methodName;
        }
    }
}

