/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.rm.utils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.linkis.common.conf.ByteType;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.protocol.conf.RequestQueryEngineConfigWithGlobalConfig;
import org.apache.linkis.governance.common.protocol.conf.RequestQueryEngineConfigWithGlobalConfig$;
import org.apache.linkis.governance.common.protocol.conf.RequestQueryGlobalConfig;
import org.apache.linkis.governance.common.protocol.conf.ResponseQueryConfig;
import org.apache.linkis.manager.common.conf.RMConfiguration;
import org.apache.linkis.manager.common.entity.resource.CPUResource;
import org.apache.linkis.manager.common.entity.resource.DriverAndYarnResource;
import org.apache.linkis.manager.common.entity.resource.InstanceResource;
import org.apache.linkis.manager.common.entity.resource.LoadInstanceResource;
import org.apache.linkis.manager.common.entity.resource.LoadResource;
import org.apache.linkis.manager.common.entity.resource.MemoryResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.entity.resource.ResourceType;
import org.apache.linkis.manager.common.entity.resource.SpecialResource;
import org.apache.linkis.manager.common.entity.resource.YarnResource;
import org.apache.linkis.manager.common.errorcode.ManagerCommonErrorCodeSummary;
import org.apache.linkis.manager.common.exception.RMWarnException;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.utils.EngineTypeLabelCreator;
import org.apache.linkis.protocol.CacheableProtocol;
import org.apache.linkis.rpc.RPCMapCache;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;

public final class UserConfiguration$
implements Logging {
    public static UserConfiguration$ MODULE$;
    private final LabelBuilderFactory labelFactory;
    private final RPCMapCache<String, String, String> globalMapCache;
    private final RPCMapCache<Tuple2<UserCreatorLabel, EngineTypeLabel>, String, String> engineMapCache;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new UserConfiguration$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        UserConfiguration$ userConfiguration$ = this;
        synchronized (userConfiguration$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private LabelBuilderFactory labelFactory() {
        return this.labelFactory;
    }

    public RPCMapCache<String, String, String> globalMapCache() {
        return this.globalMapCache;
    }

    public RPCMapCache<Tuple2<UserCreatorLabel, EngineTypeLabel>, String, String> engineMapCache() {
        return this.engineMapCache;
    }

    public Map<String, String> getGlobalConfig(String user) {
        return this.globalMapCache().getCacheMap((Object)user);
    }

    public int getUserGlobalInstanceLimit(String user) {
        return Predef$.MODULE$.Integer2int((Integer)RMConfiguration.USER_AVAILABLE_INSTANCE.getValue(this.getGlobalConfig(user)));
    }

    private Tuple2<UserCreatorLabel, EngineTypeLabel> buildRequestLabel(String user, String creator, String engineType) {
        UserCreatorLabel userCreateLabel = (UserCreatorLabel)this.labelFactory().createLabel(UserCreatorLabel.class);
        userCreateLabel.setUser(user);
        userCreateLabel.setCreator("*");
        EngineTypeLabel engineType2 = EngineTypeLabelCreator.createEngineTypeLabel((String)"*");
        return new Tuple2((Object)userCreateLabel, (Object)engineType2);
    }

    private String buildRequestLabel$default$2() {
        return "*";
    }

    private String buildRequestLabel$default$3() {
        return "*";
    }

    public Resource getUserConfiguredResource(ResourceType resourceType, UserCreatorLabel userCreatorLabel, EngineTypeLabel engineTypeLabel) {
        return (Resource)Utils$.MODULE$.tryAndWarn((Function0 & Serializable & scala.Serializable)() -> {
            Resource userCreatorAvailableResource = MODULE$.generateResource(resourceType, MODULE$.engineMapCache().getCacheMap((Object)new Tuple2((Object)userCreatorLabel, (Object)engineTypeLabel)));
            MODULE$.logger().info(new StringBuilder(40).append(userCreatorLabel.getUser()).append(" on creator ").append(userCreatorLabel.getCreator()).append(" available engine ").append(engineTypeLabel.getEngineType()).append(" resource:").append(userCreatorAvailableResource).toString());
            return userCreatorAvailableResource;
        }, this.logger());
    }

    public Resource getUserConfiguredResource(ResourceType resourceType, String engineType, String user, String creator) {
        return (Resource)Utils$.MODULE$.tryAndWarn((Function0 & Serializable & scala.Serializable)() -> {
            Resource userCreatorAvailableResource = MODULE$.generateResource(resourceType, MODULE$.engineMapCache().getCacheMap(MODULE$.buildRequestLabel(user, creator, engineType)));
            MODULE$.logger().info(new StringBuilder(31).append(user).append(" on creator available resource:").append(userCreatorAvailableResource).toString());
            return userCreatorAvailableResource;
        }, this.logger());
    }

    public Resource generateResource(ResourceType policy, Map<String, String> userConfiguration) {
        ResourceType resourceType = policy;
        if (ResourceType.CPU.equals(resourceType)) {
            return new CPUResource(Predef$.MODULE$.Integer2int((Integer)RMConfiguration.USER_AVAILABLE_CPU.getValue(userConfiguration)));
        }
        if (ResourceType.Memory.equals(resourceType)) {
            return new MemoryResource(((ByteType)RMConfiguration.USER_AVAILABLE_MEMORY.getValue(userConfiguration)).toLong());
        }
        if (ResourceType.Load.equals(resourceType)) {
            return new LoadResource(((ByteType)RMConfiguration.USER_AVAILABLE_MEMORY.getValue(userConfiguration)).toLong(), Predef$.MODULE$.Integer2int((Integer)RMConfiguration.USER_AVAILABLE_CPU.getValue(userConfiguration)));
        }
        if (ResourceType.Instance.equals(resourceType)) {
            return new InstanceResource(Predef$.MODULE$.Integer2int((Integer)RMConfiguration.USER_AVAILABLE_INSTANCE.getValue(userConfiguration)));
        }
        if (ResourceType.LoadInstance.equals(resourceType)) {
            return new LoadInstanceResource(((ByteType)RMConfiguration.USER_AVAILABLE_MEMORY.getValue(userConfiguration)).toLong(), Predef$.MODULE$.Integer2int((Integer)RMConfiguration.USER_AVAILABLE_CPU.getValue(userConfiguration)), Predef$.MODULE$.Integer2int((Integer)RMConfiguration.USER_AVAILABLE_INSTANCE.getValue(userConfiguration)));
        }
        if (ResourceType.Yarn.equals(resourceType)) {
            return new YarnResource(((ByteType)RMConfiguration.USER_AVAILABLE_YARN_INSTANCE_MEMORY.getValue(userConfiguration)).toLong(), Predef$.MODULE$.Integer2int((Integer)RMConfiguration.USER_AVAILABLE_YARN_INSTANCE_CPU.getValue(userConfiguration)), Predef$.MODULE$.Integer2int((Integer)RMConfiguration.USER_AVAILABLE_YARN_INSTANCE.getValue(userConfiguration)), (String)RMConfiguration.USER_AVAILABLE_YARN_QUEUE_NAME.getValue(userConfiguration));
        }
        if (ResourceType.DriverAndYarn.equals(resourceType)) {
            return new DriverAndYarnResource(new LoadInstanceResource(((ByteType)RMConfiguration.USER_AVAILABLE_MEMORY.getValue(userConfiguration)).toLong(), Predef$.MODULE$.Integer2int((Integer)RMConfiguration.USER_AVAILABLE_CPU.getValue(userConfiguration)), Predef$.MODULE$.Integer2int((Integer)RMConfiguration.USER_AVAILABLE_INSTANCE.getValue(userConfiguration))), new YarnResource(((ByteType)RMConfiguration.USER_AVAILABLE_YARN_INSTANCE_MEMORY.getValue(userConfiguration)).toLong(), Predef$.MODULE$.Integer2int((Integer)RMConfiguration.USER_AVAILABLE_YARN_INSTANCE_CPU.getValue(userConfiguration)), Predef$.MODULE$.Integer2int((Integer)RMConfiguration.USER_AVAILABLE_YARN_INSTANCE.getValue(userConfiguration)), (String)RMConfiguration.USER_AVAILABLE_YARN_QUEUE_NAME.getValue(userConfiguration)));
        }
        if (ResourceType.Special.equals(resourceType)) {
            return new SpecialResource(new HashMap());
        }
        throw new RMWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_RESULT_TYPE.getErrorCode(), ManagerCommonErrorCodeSummary.NOT_RESOURCE_RESULT_TYPE.getErrorDesc());
    }

    private UserConfiguration$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.labelFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
        this.globalMapCache = new RPCMapCache<String, String, String>(){

            public CacheableProtocol createRequest(String user) {
                return new RequestQueryGlobalConfig(user);
            }

            public Map<String, String> createMap(Object any) {
                Object object = any;
                if (object instanceof ResponseQueryConfig) {
                    ResponseQueryConfig responseQueryConfig = (ResponseQueryConfig)object;
                    return responseQueryConfig.getKeyAndValue();
                }
                throw new MatchError(object);
            }
        };
        this.engineMapCache = new RPCMapCache<Tuple2<UserCreatorLabel, EngineTypeLabel>, String, String>(){

            public CacheableProtocol createRequest(Tuple2<UserCreatorLabel, EngineTypeLabel> labelTuple) {
                return new RequestQueryEngineConfigWithGlobalConfig((UserCreatorLabel)labelTuple._1(), (EngineTypeLabel)labelTuple._2(), RequestQueryEngineConfigWithGlobalConfig$.MODULE$.apply$default$3());
            }

            public Map<String, String> createMap(Object any) {
                Object object = any;
                if (object instanceof ResponseQueryConfig) {
                    ResponseQueryConfig responseQueryConfig = (ResponseQueryConfig)object;
                    return responseQueryConfig.getKeyAndValue();
                }
                throw new MatchError(object);
            }
        };
    }
}

