/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.rm.external.yarn;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.entity.resource.ResourceType;
import org.apache.linkis.manager.common.entity.resource.YarnResource;
import org.apache.linkis.manager.common.errorcode.ManagerCommonErrorCodeSummary;
import org.apache.linkis.manager.common.exception.RMErrorException;
import org.apache.linkis.manager.common.exception.RMWarnException;
import org.apache.linkis.manager.rm.external.domain.ExternalAppInfo;
import org.apache.linkis.manager.rm.external.domain.ExternalResourceIdentifier;
import org.apache.linkis.manager.rm.external.domain.ExternalResourceProvider;
import org.apache.linkis.manager.rm.external.request.ExternalResourceRequester;
import org.apache.linkis.manager.rm.external.yarn.YarnAppInfo;
import org.apache.linkis.manager.rm.external.yarn.YarnQueueInfo;
import org.apache.linkis.manager.rm.external.yarn.YarnResourceIdentifier;
import org.apache.linkis.manager.rm.utils.RequestKerberosUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnResourceRequester
implements ExternalResourceRequester {
    private static final Logger logger = LoggerFactory.getLogger(YarnResourceRequester.class);
    private final String HASTATE_ACTIVE = "active";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, String> rmAddressMap = new ConcurrentHashMap<String, String>();
    private static final HttpClient httpClient = HttpClients.createDefault();

    private String getAuthorizationStr(ExternalResourceProvider provider) {
        String user = (String)provider.getConfigMap().getOrDefault("user", "");
        String pwd = (String)provider.getConfigMap().getOrDefault("pwd", "");
        String authKey = user + ":" + pwd;
        return Base64.getMimeEncoder().encodeToString(authKey.getBytes());
    }

    @Override
    public NodeResource requestResourceInfo(ExternalResourceIdentifier identifier, ExternalResourceProvider provider) {
        String rmWebAddress = this.getAndUpdateActiveRmWebAddress(provider);
        logger.info("rmWebAddress: " + rmWebAddress);
        String queueName = ((YarnResourceIdentifier)identifier).getQueueName();
        String realQueueName = "root." + queueName;
        try {
            YarnQueueInfo resources = this.getResources(rmWebAddress, realQueueName, queueName, provider);
            CommonNodeResource nodeResource = new CommonNodeResource();
            nodeResource.setMaxResource((Resource)resources.getMaxResource());
            nodeResource.setUsedResource((Resource)resources.getUsedResource());
            nodeResource.setMaxApps(Integer.valueOf(resources.getMaxApps()));
            nodeResource.setNumPendingApps(Integer.valueOf(resources.getNumPendingApps()));
            nodeResource.setNumActiveApps(Integer.valueOf(resources.getNumActiveApps()));
            return nodeResource;
        }
        catch (Exception e) {
            throw new RMErrorException(ManagerCommonErrorCodeSummary.YARN_QUEUE_EXCEPTION.getErrorCode(), ManagerCommonErrorCodeSummary.YARN_QUEUE_EXCEPTION.getErrorDesc(), (Throwable)e);
        }
    }

    public Optional<YarnResource> maxEffectiveHandle(Optional<JsonNode> queueValue, String rmWebAddress, String queueName, ExternalResourceProvider provider) {
        try {
            JsonNode metrics = this.getResponseByUrl("metrics", rmWebAddress, provider);
            JsonNode clusterMetrics = metrics.path("clusterMetrics");
            long totalMemory = clusterMetrics.path("totalMB").asLong();
            long totalCores = clusterMetrics.path("totalVirtualCores").asLong();
            if (queueValue.isPresent()) {
                JsonNode jsonNode = queueValue.get();
                double absoluteCapacity = jsonNode.path("absoluteCapacity").asDouble();
                YarnResource yarnResource = new YarnResource((long)Math.floor(absoluteCapacity * (double)totalMemory * 1024.0 * 1024.0 / 100.0), (int)Math.floor(absoluteCapacity * (double)totalCores / 100.0), 0, queueName, "");
                return Optional.of(yarnResource);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            logger.warn("maxEffectiveHandle parse failed", (Throwable)e);
            return Optional.empty();
        }
    }

    public static Optional getQueue(JsonNode queues, String realQueueName) {
        if (queues instanceof ArrayNode) {
            for (JsonNode q : (ArrayNode)queues) {
                Optional childQueue;
                String yarnQueueName = q.get("queueName").asText();
                if (yarnQueueName.equals(realQueueName)) {
                    return Optional.of(q);
                }
                if (!realQueueName.startsWith(yarnQueueName + ".") || !(childQueue = YarnResourceRequester.getQueue(YarnResourceRequester.getChildQueues(q), realQueueName)).isPresent()) continue;
                return childQueue;
            }
            return Optional.empty();
        }
        if (queues instanceof ObjectNode) {
            ObjectNode queueObj = (ObjectNode)queues;
            JsonNode queueName = queueObj.get("queueName");
            if (queueName != null && queueName.asText().equals(realQueueName)) {
                return Optional.of(queueObj);
            }
            JsonNode childQueues = queueObj.get("childQueues");
            if (childQueues == null) {
                return Optional.empty();
            }
            return YarnResourceRequester.getQueue(childQueues, realQueueName);
        }
        return Optional.empty();
    }

    public static JsonNode getChildQueues(JsonNode resp) {
        JsonNode queues = resp.get("childQueues").get("queue");
        if (queues != null && !queues.isNull() && !queues.isMissingNode() && queues.isArray() && queues.size() > 0) {
            return queues;
        }
        return resp.get("childQueues");
    }

    public Optional<JsonNode> getQueueOfCapacity(JsonNode queues, String realQueueName) {
        if (queues.isArray()) {
            for (JsonNode q : queues) {
                Optional<JsonNode> matchQueue;
                String yarnQueueName = q.get("queueName").asText();
                if (yarnQueueName.equals(realQueueName)) {
                    return Optional.of(q);
                }
                if (!q.has("queues") || !(matchQueue = this.getQueueOfCapacity(q.get("queues"), realQueueName)).isPresent()) continue;
                return matchQueue;
            }
            return Optional.empty();
        }
        if (queues.isObject()) {
            Optional<JsonNode> matchQueue;
            if (queues.has("queueName") && queues.get("queueName").asText().equals(realQueueName)) {
                return Optional.of(queues);
            }
            if (queues.has("queues") && (matchQueue = this.getQueueOfCapacity(queues.get("queues"), realQueueName)).isPresent()) {
                return matchQueue;
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    static JsonNode getChildQueuesOfCapacity(JsonNode resp) {
        return resp.path("queues").path("queue");
    }

    public YarnQueueInfo getResources(String rmWebAddress, String realQueueName, String queueName, ExternalResourceProvider provider) {
        JsonNode resp = this.getResponseByUrl("scheduler", rmWebAddress, provider);
        JsonNode schedulerInfo = resp.path("scheduler").path("schedulerInfo");
        String schedulerType = schedulerInfo.path("type").asText();
        if ("capacityScheduler".equals(schedulerType)) {
            realQueueName = queueName;
            JsonNode childQueues = YarnResourceRequester.getChildQueuesOfCapacity(schedulerInfo);
            Optional<JsonNode> queue = this.getQueueOfCapacity(childQueues, realQueueName);
            if (queue == null || !queue.isPresent()) {
                logger.debug("cannot find any information about queue " + queueName + ", response: " + resp);
                throw new RMWarnException(ManagerCommonErrorCodeSummary.YARN_NOT_EXISTS_QUEUE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.YARN_NOT_EXISTS_QUEUE.getErrorDesc(), queueName));
            }
            JsonNode queueInfo = queue.get();
            return new YarnQueueInfo(this.maxEffectiveHandle(queue, rmWebAddress, queueName, provider).get(), YarnResourceRequester.getYarnResource(queue.map(node -> node.path("resourcesUsed")), queueName).get(), queueInfo.path("maxApps").asInt(), queueInfo.path("numPendingApps").asInt(), queueInfo.path("numActiveApps").asInt());
        }
        if ("fairScheduler".equals(schedulerType)) {
            Optional queue;
            if ("root".equals(queueName)) {
                queue = Optional.of(schedulerInfo.path("rootQueue"));
            } else {
                JsonNode childQueues = YarnResourceRequester.getChildQueues(schedulerInfo.path("rootQueue"));
                queue = YarnResourceRequester.getQueue(childQueues, realQueueName);
            }
            if (queue == null || !queue.isPresent()) {
                logger.debug("cannot find any information about queue " + queueName + ", response: " + resp);
                throw new RMWarnException(ManagerCommonErrorCodeSummary.YARN_NOT_EXISTS_QUEUE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.YARN_NOT_EXISTS_QUEUE.getErrorDesc(), queueName));
            }
            Optional<JsonNode> maxResources = queue.map(node -> node.path("maxResources"));
            Optional<JsonNode> usedResources = queue.map(node -> node.path("usedResources"));
            JsonNode queueInfo = (JsonNode)queue.get();
            int numPendingApps = 0;
            int numActiveApps = 0;
            if (!"root".equals(queueName)) {
                numPendingApps = queueInfo.path("numPendingApps").asInt();
                numActiveApps = queueInfo.path("numActiveApps").asInt();
            }
            return new YarnQueueInfo(YarnResourceRequester.getYarnResource(maxResources, queueName).get(), YarnResourceRequester.getYarnResource(usedResources, queueName).get(), queueInfo.path("maxApps").asInt(), numPendingApps, numActiveApps);
        }
        logger.debug("only support fairScheduler or capacityScheduler, schedulerType: " + schedulerType + ", response: " + resp);
        throw new RMWarnException(ManagerCommonErrorCodeSummary.ONLY_SUPPORT_FAIRORCAPA.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.ONLY_SUPPORT_FAIRORCAPA.getErrorDesc(), schedulerType));
    }

    public static Optional<YarnResource> getYarnResource(Optional<JsonNode> jsonNode, String queueName) {
        if (jsonNode.isPresent()) {
            JsonNode r = jsonNode.get();
            return Optional.of(new YarnResource(r.get("memory").asLong() * 1024L * 1024L, r.get("vCores").asInt(), 0, queueName, ""));
        }
        return Optional.empty();
    }

    public static Optional<YarnResource> getAllocatedYarnResource(Optional<JsonNode> jsonNode, String queueName) {
        if (jsonNode.isPresent()) {
            JsonNode r = jsonNode.get();
            return Optional.of(new YarnResource(r.get("allocatedMB").asLong() * 1024L * 1024L, r.get("allocatedVCores").asInt(), 0, queueName, ""));
        }
        return Optional.empty();
    }

    @Override
    public List<ExternalAppInfo> requestAppInfo(ExternalResourceIdentifier identifier, ExternalResourceProvider provider) {
        String rmWebAddress = this.getAndUpdateActiveRmWebAddress(provider);
        String queueName = ((YarnResourceIdentifier)identifier).getQueueName();
        String realQueueName = "root." + queueName;
        JsonNode resp = this.getResponseByUrl("apps", rmWebAddress, provider).path("apps").path("app");
        if (resp.isMissingNode()) {
            return new ArrayList<ExternalAppInfo>();
        }
        ArrayNode appArray = (ArrayNode)resp;
        ArrayList<ExternalAppInfo> appInfoList = new ArrayList<ExternalAppInfo>();
        Iterator iterator = appArray.elements();
        while (iterator.hasNext()) {
            JsonNode app = (JsonNode)iterator.next();
            String yarnQueueName = app.get("queue").asText();
            String state = app.get("state").asText();
            if (!yarnQueueName.equals(realQueueName) || !state.equals("RUNNING") && !state.equals("ACCEPTED")) continue;
            String id = app.get("id").asText();
            String user = app.get("user").asText();
            String applicationType = app.get("applicationType").asText();
            Optional<YarnResource> yarnResource = YarnResourceRequester.getAllocatedYarnResource(Optional.ofNullable(app), queueName);
            if (!yarnResource.isPresent()) continue;
            YarnAppInfo appInfo = new YarnAppInfo(id, user, state, applicationType, yarnResource.get());
            appInfoList.add(appInfo);
        }
        return appInfoList;
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Yarn;
    }

    private JsonNode getResponseByUrl(String url, String rmWebAddress, ExternalResourceProvider provider) {
        Object kerberosEnable;
        HttpGet httpGet = new HttpGet(rmWebAddress + "/ws/v1/cluster/" + url);
        httpGet.addHeader("Accept", "application/json");
        Object authorEnable = provider.getConfigMap().get("authorEnable");
        HttpResponse httpResponse = null;
        if (authorEnable instanceof Boolean && ((Boolean)authorEnable).booleanValue()) {
            httpGet.addHeader("Authorization", "Basic " + this.getAuthorizationStr(provider));
        }
        if ((kerberosEnable = provider.getConfigMap().get("kerberosEnable")) instanceof Boolean) {
            if (((Boolean)kerberosEnable).booleanValue()) {
                HttpResponse response;
                String principalName = (String)provider.getConfigMap().get("principalName");
                String keytabPath = (String)provider.getConfigMap().get("keytabPath");
                String krb5Path = (String)provider.getConfigMap().get("krb5Path");
                if (StringUtils.isNotBlank((CharSequence)krb5Path)) {
                    logger.warn("krb5Path: {} has been specified, but not allow to be set to avoid conflict", (Object)krb5Path);
                }
                RequestKerberosUrlUtils requestKuu = new RequestKerberosUrlUtils(principalName, keytabPath, false);
                httpResponse = response = requestKuu.callRestUrl(rmWebAddress + "/ws/v1/cluster/" + url, principalName);
            } else {
                try {
                    httpResponse = httpClient.execute((HttpUriRequest)httpGet);
                }
                catch (IOException e) {
                    logger.warn("getResponseByUrl failed", (Throwable)e);
                    throw new RMErrorException(ManagerCommonErrorCodeSummary.YARN_QUEUE_EXCEPTION.getErrorCode(), ManagerCommonErrorCodeSummary.YARN_QUEUE_EXCEPTION.getErrorDesc(), (Throwable)e);
                }
            }
        } else {
            try {
                httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            }
            catch (IOException e) {
                logger.warn("getResponseByUrl failed", (Throwable)e);
                throw new RMErrorException(ManagerCommonErrorCodeSummary.YARN_QUEUE_EXCEPTION.getErrorCode(), ManagerCommonErrorCodeSummary.YARN_QUEUE_EXCEPTION.getErrorDesc(), (Throwable)e);
            }
        }
        String entityString = "";
        try {
            entityString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException e) {
            logger.warn("getResponseByUrl failed", (Throwable)e);
            throw new RMErrorException(ManagerCommonErrorCodeSummary.YARN_QUEUE_EXCEPTION.getErrorCode(), ManagerCommonErrorCodeSummary.YARN_QUEUE_EXCEPTION.getErrorDesc(), (Throwable)e);
        }
        JsonNode jsonNode = null;
        try {
            jsonNode = objectMapper.readTree(entityString);
        }
        catch (Exception e) {
            logger.warn("getResponseByUrl failed", (Throwable)e);
            throw new RMErrorException(ManagerCommonErrorCodeSummary.YARN_QUEUE_EXCEPTION.getErrorCode(), ManagerCommonErrorCodeSummary.YARN_QUEUE_EXCEPTION.getErrorDesc(), (Throwable)e);
        }
        return jsonNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAndUpdateActiveRmWebAddress(ExternalResourceProvider provider) {
        String haAddress = (String)provider.getConfigMap().get("rmWebAddress");
        String activeAddress = this.rmAddressMap.get(haAddress);
        if (StringUtils.isBlank((CharSequence)activeAddress)) {
            String string = haAddress.intern();
            synchronized (string) {
                if (StringUtils.isBlank((CharSequence)activeAddress)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Cannot find value of haAddress : " + haAddress + " in cacheMap with size " + this.rmAddressMap.size());
                    }
                    if (StringUtils.isNotBlank((CharSequence)haAddress)) {
                        String[] addresses;
                        for (String address : addresses = haAddress.split(";")) {
                            try {
                                JsonNode response = this.getResponseByUrl("info", address, provider);
                                JsonNode haStateValue = response.path("clusterInfo").path("haState");
                                if (haStateValue.isMissingNode() || !haStateValue.isTextual()) continue;
                                String haState = haStateValue.asText();
                                if ("active".equalsIgnoreCase(haState)) {
                                    activeAddress = address;
                                    continue;
                                }
                                logger.warn("Resourcemanager : " + address + " haState : " + haState);
                            }
                            catch (Exception e) {
                                logger.error("Get Yarn resourcemanager info error, " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)activeAddress)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Put (" + haAddress + ", " + activeAddress + ") to cacheMap.");
                        }
                        this.rmAddressMap.put(haAddress, activeAddress);
                    } else {
                        throw new RMErrorException(ManagerCommonErrorCodeSummary.GET_YARN_EXCEPTION.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.GET_YARN_EXCEPTION.getErrorDesc(), haAddress));
                    }
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Get active rm address : " + activeAddress + " from haAddress : " + haAddress);
        }
        return activeAddress;
    }

    @Override
    public Boolean reloadExternalResourceAddress(ExternalResourceProvider provider) {
        if (null != provider) {
            String rmWebHaAddress = (String)provider.getConfigMap().get("rmWebAddress");
            this.rmAddressMap.remove(rmWebHaAddress);
            this.getAndUpdateActiveRmWebAddress(provider);
        }
        return true;
    }
}

