/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.am.restful.EMRestfulApi;
import org.apache.linkis.manager.am.service.ECResourceInfoService;
import org.apache.linkis.manager.am.service.em.EMInfoService;
import org.apache.linkis.manager.am.util.ECResourceInfoUtils;
import org.apache.linkis.manager.am.utils.AMUtils;
import org.apache.linkis.manager.am.vo.EMNodeVo;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.persistence.ECResourceInfoRecord;
import org.apache.linkis.manager.common.entity.persistence.PersistenceNode;
import org.apache.linkis.manager.common.entity.persistence.PersistencerEcNodeInfo;
import org.apache.linkis.manager.dao.ECResourceRecordMapper;
import org.apache.linkis.manager.dao.LabelManagerMapper;
import org.apache.linkis.manager.dao.NodeManagerMapper;
import org.apache.linkis.manager.label.service.NodeLabelService;
import org.apache.linkis.manager.persistence.LabelManagerPersistence;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ECResourceInfoServiceImpl
implements ECResourceInfoService {
    private static final Logger logger = LoggerFactory.getLogger(EMRestfulApi.class);
    private ObjectMapper json = new ObjectMapper().setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    @Autowired
    private ECResourceRecordMapper ecResourceRecordMapper;
    @Autowired
    private NodeManagerMapper nodeManagerMapper;
    @Autowired
    private LabelManagerMapper labelManagerMapper;
    @Autowired
    private LabelManagerPersistence labelManagerPersistence;
    @Autowired
    private NodeLabelService nodeLabelService;
    @Autowired
    private EMInfoService emInfoService;

    @Override
    public ECResourceInfoRecord getECResourceInfoRecord(String ticketId) {
        if (StringUtils.isNotBlank((CharSequence)ticketId)) {
            return this.ecResourceRecordMapper.getECResourceInfoRecord(ticketId);
        }
        return null;
    }

    @Override
    public ECResourceInfoRecord getECResourceInfoRecordByInstance(String instance) {
        if (StringUtils.isNotBlank((CharSequence)instance)) {
            return this.ecResourceRecordMapper.getECResourceInfoRecordByInstance(instance);
        }
        return null;
    }

    @Override
    public void deleteECResourceInfoRecordByTicketId(String ticketId) {
        if (StringUtils.isNotBlank((CharSequence)ticketId)) {
            logger.info("Start to delete ec\uff1a{} info ", (Object)ticketId);
            this.ecResourceRecordMapper.deleteECResourceInfoRecordByTicketId(ticketId);
        }
    }

    @Override
    public void deleteECResourceInfoRecord(Integer id) {
        logger.info("Start to delete ec id\uff1a{} info ", (Object)id);
        this.ecResourceRecordMapper.deleteECResourceInfoRecord(id);
    }

    @Override
    public List<ECResourceInfoRecord> getECResourceInfoRecordList(String instance, Date endDate, Date startDate, String username, String engineType, String status) {
        return this.ecResourceRecordMapper.getECResourceInfoHistory(username, instance, endDate, startDate, engineType, status);
    }

    @Override
    public List<Map<String, Object>> getECResourceInfoList(List<String> creatorUserList, List<String> engineTypeList, List<String> statusStrList, String queueName, List<String> ecInstancesList, Boolean isCrossCluster) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        ArrayList<Integer> statusIntList = new ArrayList<Integer>();
        for (String status : statusStrList) {
            statusIntList.add(NodeStatus.valueOf((String)status).ordinal());
        }
        List ecNodesInfo = this.nodeManagerMapper.getEMNodeInfoList(creatorUserList, statusIntList, ecInstancesList);
        Map<String, PersistencerEcNodeInfo> persistencerEcNodeInfoMap = ecNodesInfo.stream().collect(Collectors.toMap(PersistenceNode::getInstance, item -> item));
        List instanceList = ecNodesInfo.stream().map(e -> e.getInstance()).collect(Collectors.toList());
        if (instanceList.size() == 0) {
            return resultList;
        }
        List ecResourceInfoRecords = this.ecResourceRecordMapper.getECResourceInfoList(instanceList, engineTypeList);
        ecResourceInfoRecords.forEach(latestRecord -> {
            PersistencerEcNodeInfo ecNodeinfo = (PersistencerEcNodeInfo)persistencerEcNodeInfoMap.get(latestRecord.getServiceInstance());
            if (ecNodeinfo == null) {
                logger.info("Can not get any ec node info of ec:{}", (Object)ecNodeinfo.getInstance());
            } else {
                try {
                    Map item = (Map)this.json.readValue(this.json.writeValueAsString((Object)ecNodeinfo), (TypeReference)new TypeReference<Map<String, Object>>(){});
                    Integer instanceStatus = ecNodeinfo.getInstanceStatus();
                    item.put("instanceStatus", NodeStatus.values()[instanceStatus].name());
                    String usedResourceStr = latestRecord.getUsedResource();
                    long lastUnlockTimestamp = 0L;
                    if (NodeStatus.values()[instanceStatus].name().equals(NodeStatus.Unlock.name())) {
                        String heartbeatMsg = ecNodeinfo.getHeartbeatMsg();
                        Map heartbeatMap = new HashMap();
                        if (StringUtils.isNotBlank((CharSequence)heartbeatMsg)) {
                            heartbeatMap = (Map)BDPJettyServerHelper.gson().fromJson(heartbeatMsg, new HashMap().getClass());
                        }
                        Integer lastUnlockTimestampObject = heartbeatMap.getOrDefault("lastUnlockTimestamp", 0);
                        BigDecimal lastUnlockTimestampBigDecimal = new BigDecimal(String.valueOf(lastUnlockTimestampObject));
                        lastUnlockTimestamp = lastUnlockTimestampBigDecimal.longValue();
                    }
                    item.put("lastUnlockTimestamp", lastUnlockTimestamp);
                    item.put("useResource", ECResourceInfoUtils.getStringToMap(usedResourceStr));
                    item.put("ecmInstance", latestRecord.getEcmInstance());
                    String engineType = latestRecord.getEngineType();
                    item.put("engineType", engineType);
                    if (StringUtils.isNotBlank((CharSequence)queueName)) {
                        Map<String, Object> usedResourceMap = ECResourceInfoUtils.getStringToMap(usedResourceStr);
                        Map yarn = MapUtils.getMap(usedResourceMap, (Object)"yarn", new HashMap());
                        String queueNameStr = String.valueOf(yarn.getOrDefault("queueName", ""));
                        if (StringUtils.isNotBlank((CharSequence)queueNameStr) && queueName.equals(queueNameStr)) {
                            resultList.add(item);
                        }
                    } else {
                        resultList.add(item);
                    }
                }
                catch (JsonProcessingException e) {
                    logger.error("Fail to process the ec node info: [{}]", (Object)ecNodeinfo, (Object)e);
                }
            }
        });
        if (null != isCrossCluster) {
            ArrayList<Map> resultListByCluster = new ArrayList<Map>();
            ArrayList<EMNodeVo> emNodeVos = AMUtils.copyToEMVo(this.emInfoService.getAllEM());
            Map<String, EMNodeVo> clusterMap = emNodeVos.stream().filter(s -> s.getLabels().stream().anyMatch(d -> d.getLabelKey().equals("yarnCluster"))).collect(Collectors.toMap(EMNodeVo::getInstance, item -> item));
            for (Map map : resultList) {
                if (isCrossCluster.booleanValue() && clusterMap.containsKey(map.get("ecmInstance").toString())) {
                    resultListByCluster.add(map);
                    continue;
                }
                if (isCrossCluster.booleanValue() || clusterMap.containsKey(map.get("ecmInstance").toString())) continue;
                resultListByCluster.add(map);
            }
            resultList.clear();
            resultList.addAll(resultListByCluster);
        }
        return resultList;
    }
}

