/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.service.impl;

import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.governance.common.protocol.task.ResponseEngineConnPid;
import org.apache.linkis.manager.am.manager.DefaultEngineNodeManager;
import org.apache.linkis.manager.am.service.EngineConnPidCallbackService;
import org.apache.linkis.manager.am.service.engine.AbstractEngineService;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.label.service.NodeLabelService;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultEngineConnPidCallbackService
extends AbstractEngineService
implements EngineConnPidCallbackService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEngineConnPidCallbackService.class);
    @Autowired
    private DefaultEngineNodeManager defaultEngineNodeManager;
    @Autowired
    private NodeLabelService nodeLabelService;

    @Override
    @Receiver
    public void dealPid(ResponseEngineConnPid protocol) {
        logger.info("DefaultEngineConnPidCallbackService dealPid serviceInstance: [{}] pid: [{}] ticketId: [{}]", new Object[]{protocol.serviceInstance(), protocol.pid(), protocol.ticketId()});
        EngineNode engineNode = this.defaultEngineNodeManager.getEngineNodeInfoByTicketId(protocol.ticketId());
        if (engineNode == null) {
            logger.error("DefaultEngineConnPidCallbackService dealPid failed, engineNode is null, serviceInstance:{}", (Object)protocol.serviceInstance());
            return;
        }
        engineNode.setIdentifier(protocol.pid());
        ServiceInstance oldServiceInstance = engineNode.getServiceInstance();
        if (engineNode.getMark().equals("cluster_process")) {
            ServiceInstance serviceInstance = protocol.serviceInstance();
            engineNode.setServiceInstance(serviceInstance);
            this.getEngineNodeManager().updateEngineNode(oldServiceInstance, engineNode);
            this.nodeLabelService.labelsFromInstanceToNewInstance(oldServiceInstance, serviceInstance);
        }
        this.defaultEngineNodeManager.updateEngine(engineNode);
    }
}

