/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.service.engine;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.manager.am.conf.AMConfiguration;
import org.apache.linkis.manager.am.conf.EngineConnConfigurationService;
import org.apache.linkis.manager.am.service.engine.AbstractEngineService;
import org.apache.linkis.manager.am.service.engine.EngineConnCanKillService;
import org.apache.linkis.manager.common.entity.enumeration.MaintainType;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.protocol.engine.ECCanKillRequest;
import org.apache.linkis.manager.common.protocol.engine.ECCanKillResponse;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.service.NodeLabelService;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001\u0002\b\u0010\u0001yAQA\f\u0001\u0005\u0002=B\u0011\"\r\u0001A\u0002\u0003\u0007I\u0011\u0002\u001a\t\u0013e\u0002\u0001\u0019!a\u0001\n\u0013Q\u0004\"C\"\u0001\u0001\u0004\u0005\t\u0015)\u00034\u0011%\t\u0006\u00011AA\u0002\u0013%!\u000bC\u0005[\u0001\u0001\u0007\t\u0019!C\u00057\"IQ\f\u0001a\u0001\u0002\u0003\u0006Ka\u0015\u0005\u0006?\u0002!\t\u0005\u0019\u0005\u0006q\u0002!I!\u001f\u0005\u0006w\u0002!I\u0001 \u0005\u0006}\u0002!Ia \u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u000b\u0011q\u0004R3gCVdG/\u00128hS:,7i\u001c8o\u0007\u0006t7*\u001b7m'\u0016\u0014h/[2f\u0015\t\u0001\u0012#\u0001\u0004f]\u001eLg.\u001a\u0006\u0003%M\tqa]3sm&\u001cWM\u0003\u0002\u0015+\u0005\u0011\u0011-\u001c\u0006\u0003-]\tq!\\1oC\u001e,'O\u0003\u0002\u00193\u00051A.\u001b8lSNT!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011\u0003\u0002\u0001 G\u0019\u0002\"\u0001I\u0011\u000e\u0003=I!AI\b\u0003+\u0005\u00137\u000f\u001e:bGR,enZ5oKN+'O^5dKB\u0011\u0001\u0005J\u0005\u0003K=\u0011\u0001$\u00128hS:,7i\u001c8o\u0007\u0006t7*\u001b7m'\u0016\u0014h/[2f!\t9C&D\u0001)\u0015\tI#&A\u0003vi&d7O\u0003\u0002,/\u000511m\\7n_:L!!\f\u0015\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\r\t\u0003A\u0001\ta$\u001a8hS:,7i\u001c8o\u0007>tg-[4ve\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0016\u0003M\u0002\"\u0001N\u001c\u000e\u0003UR!AN\n\u0002\t\r|gNZ\u0005\u0003qU\u0012a$\u00128hS:,7i\u001c8o\u0007>tg-[4ve\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002E\u0015tw-\u001b8f\u0007>tgnQ8oM&<WO]1uS>t7+\u001a:wS\u000e,w\fJ3r)\tY\u0014\t\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0003V]&$\bb\u0002\"\u0004\u0003\u0003\u0005\raM\u0001\u0004q\u0012\n\u0014aH3oO&tWmQ8o]\u000e{gNZ5hkJ\fG/[8o'\u0016\u0014h/[2fA!\u0012A!\u0012\t\u0003\r>k\u0011a\u0012\u0006\u0003\u0011&\u000b!\"\u00198o_R\fG/[8o\u0015\tQ5*A\u0004gC\u000e$xN]=\u000b\u00051k\u0015!\u00022fC:\u001c(B\u0001(\u001c\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\\u0017B\u0001)H\u0005%\tU\u000f^8xSJ,G-\u0001\u0007mC\n,GnU3sm&\u001cW-F\u0001T!\t!\u0006,D\u0001V\u0015\t\u0011bK\u0003\u0002X+\u0005)A.\u00192fY&\u0011\u0011,\u0016\u0002\u0011\u001d>$W\rT1cK2\u001cVM\u001d<jG\u0016\f\u0001\u0003\\1cK2\u001cVM\u001d<jG\u0016|F%Z9\u0015\u0005mb\u0006b\u0002\"\u0007\u0003\u0003\u0005\raU\u0001\u000eY\u0006\u0014W\r\\*feZL7-\u001a\u0011)\u0005\u001d)\u0015!E2b].KG\u000e\\#oO&tWmQ8o]R\u0011\u0011-\u001b\t\u0003E\u001el\u0011a\u0019\u0006\u0003!\u0011T!!\u001a4\u0002\u0011A\u0014x\u000e^8d_2T!aK\u000b\n\u0005!\u001c'!E#D\u0007\u0006t7*\u001b7m%\u0016\u001c\bo\u001c8tK\")!\u000e\u0003a\u0001W\u0006\u0001RmY\"b].KG\u000e\u001c*fcV,7\u000f\u001e\t\u0003E2L!!\\2\u0003!\u0015\u001b5)\u00198LS2d'+Z9vKN$\bF\u0001\u0005p!\t\u0001h/D\u0001r\u0015\tA%O\u0003\u0002ti\u00069Q.Z:tC\u001e,'BA;\u0018\u0003\r\u0011\boY\u0005\u0003oF\u0014\u0001BU3dK&4XM]\u0001\u0012G\u0006t7*\u001b7m\u0013:<vN]6US6,GCA1{\u0011\u0015Q\u0017\u00021\u0001l\u0003\u001d\u0019\u0017M\\&jY2$\"!Y?\t\u000b)T\u0001\u0019A6\u0002!\r\fgnS5mY&swk\u001c:l\t\u0006LHcA1\u0002\u0002!)!n\u0003a\u0001W\u0006I\u0011n],fK.,g\u000e\u001a\u000b\u0003\u0003\u000f\u00012\u0001PA\u0005\u0013\r\tY!\u0010\u0002\b\u0005>|G.Z1o\u00031I7/\u00138X_J\\G+[7fQ\r\u0001\u0011\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011qC'\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002\u001c\u0005U!aB*feZL7-\u001a")
public class DefaultEngineConnCanKillService
extends AbstractEngineService
implements EngineConnCanKillService,
Logging {
    @Autowired
    private EngineConnConfigurationService engineConnConfigurationService;
    @Autowired
    private NodeLabelService labelService;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DefaultEngineConnCanKillService defaultEngineConnCanKillService = this;
        synchronized (defaultEngineConnCanKillService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private EngineConnConfigurationService engineConnConfigurationService() {
        return this.engineConnConfigurationService;
    }

    private void engineConnConfigurationService_$eq(EngineConnConfigurationService x$1) {
        this.engineConnConfigurationService = x$1;
    }

    private NodeLabelService labelService() {
        return this.labelService;
    }

    private void labelService_$eq(NodeLabelService x$1) {
        this.labelService = x$1;
    }

    @Override
    @Receiver
    public ECCanKillResponse canKillEngineConn(ECCanKillRequest ecCanKillRequest) {
        MaintainType maintainType;
        ECCanKillResponse ecCanKillResponse = new ECCanKillResponse();
        if (ecCanKillRequest == null || StringUtils.isBlank((CharSequence)ecCanKillRequest.getUser()) || ecCanKillRequest.getEngineTypeLabel() == null) {
            ecCanKillResponse.setFlag(Predef$.MODULE$.boolean2Boolean(true));
            return ecCanKillResponse;
        }
        ArrayList<Object> labels = new ArrayList<Object>();
        labels.add(ecCanKillRequest.getEngineTypeLabel());
        labels.add(ecCanKillRequest.getUserCreatorLabel());
        MaintainType maintainType2 = maintainType = (MaintainType)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            Map<String, String> configProps = this.engineConnConfigurationService().getConsoleConfiguration(labels);
            String string = (String)AMConfiguration.EC_MAINTAIN_TIME_STR.getValue(configProps);
            if ("\u5468\u4e00\u5230\u5468\u4e94\u5de5\u4f5c\u65f6\u95f4\u4fdd\u6301\u4e00\u4e2a\u5f15\u64ce".equals(string)) {
                return MaintainType.day;
            }
            if ("\u5468\u4e00\u5230\u5468\u4e94\u4fdd\u6301\u4e00\u4e2a\u5f15\u64ce".equals(string)) {
                return MaintainType.week;
            }
            return MaintainType.Default;
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                this.logger().warn("failed to get engine maintain time from publicservice", (Throwable)exception);
                return MaintainType.Default;
            }
            throw new MatchError((Object)throwable);
        });
        if (MaintainType.day.equals(maintainType2)) {
            return this.canKillInWorkTime(ecCanKillRequest);
        }
        if (MaintainType.week.equals(maintainType2)) {
            return this.canKillInWorkDay(ecCanKillRequest);
        }
        ecCanKillResponse.setFlag(Predef$.MODULE$.boolean2Boolean(true));
        ecCanKillResponse.setReason("default MaintainType");
        return ecCanKillResponse;
    }

    private ECCanKillResponse canKillInWorkTime(ECCanKillRequest ecCanKillRequest) {
        if (this.isInWorkTime()) {
            return this.canKill(ecCanKillRequest);
        }
        ECCanKillResponse ecCanKillResponse = new ECCanKillResponse();
        ecCanKillResponse.setFlag(Predef$.MODULE$.boolean2Boolean(true));
        ecCanKillResponse.setReason("not workTime");
        return ecCanKillResponse;
    }

    private ECCanKillResponse canKill(ECCanKillRequest ecCanKillRequest) {
        ECCanKillResponse ecCanKillResponse = new ECCanKillResponse();
        Buffer ecNodes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getEngineNodeManager().listEngines(ecCanKillRequest.getUser())).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineConnCanKillService.$anonfun$canKill$1(ecCanKillRequest, x$1)));
        if (ecNodes == null || ecNodes.isEmpty()) {
            ecCanKillResponse.setFlag(Predef$.MODULE$.boolean2Boolean(false));
            this.logger().info(new StringBuilder(46).append("There are no other engines, ").append(ecCanKillRequest).append(" can not be killed").toString());
            ecCanKillResponse.setReason("There are no other engines");
            return ecCanKillResponse;
        }
        Buffer engineConnNodes = (Buffer)ecNodes.filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(NodeStatus.isAvailable((NodeStatus)node.getNodeStatus()))));
        if (engineConnNodes.isEmpty()) {
            ecCanKillResponse.setFlag(Predef$.MODULE$.boolean2Boolean(false));
            this.logger().info(new StringBuilder(56).append("There are no other engines available, ").append(ecCanKillRequest).append(" can not be killed").toString());
            ecCanKillResponse.setReason("There are no other engines available");
            return ecCanKillResponse;
        }
        Buffer ecWithLabels = (Buffer)engineConnNodes.filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineConnCanKillService.$anonfun$canKill$3(this, ecCanKillRequest, node)));
        if (ecWithLabels.nonEmpty()) {
            ecCanKillResponse.setFlag(Predef$.MODULE$.boolean2Boolean(true));
            this.logger().info(new StringBuilder(43).append("There are engines available, ").append(ecCanKillRequest).append(" can be killed").toString());
            ecCanKillResponse.setReason("There are  engines available");
        } else {
            ecCanKillResponse.setFlag(Predef$.MODULE$.boolean2Boolean(false));
            this.logger().info(new StringBuilder(62).append("There are no label equal engines available, ").append(ecCanKillRequest).append(" can not be killed").toString());
            ecCanKillResponse.setReason("There are no label equal engines available");
        }
        return ecCanKillResponse;
    }

    private ECCanKillResponse canKillInWorkDay(ECCanKillRequest ecCanKillRequest) {
        if (this.isWeekend()) {
            ECCanKillResponse ecCanKillResponse = new ECCanKillResponse();
            ecCanKillResponse.setFlag(Predef$.MODULE$.boolean2Boolean(true));
            ecCanKillResponse.setReason("is weekend");
            return ecCanKillResponse;
        }
        return this.canKill(ecCanKillRequest);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isWeekend() {
        DayOfWeek dayOfWeek;
        if (BoxesRunTime.unboxToBoolean((Object)Configuration$.MODULE$.IS_TEST_MODE().getValue())) {
            return true;
        }
        LocalDateTime date = LocalDateTime.now();
        DayOfWeek dayOfWeek2 = dayOfWeek = date.getDayOfWeek();
        DayOfWeek dayOfWeek3 = DayOfWeek.SUNDAY;
        if (dayOfWeek2 == null) {
            if (dayOfWeek3 == null) return true;
        } else if (dayOfWeek2.equals(dayOfWeek3)) return true;
        DayOfWeek dayOfWeek4 = dayOfWeek;
        DayOfWeek dayOfWeek5 = DayOfWeek.SATURDAY;
        if (dayOfWeek4 != null) {
            if (!dayOfWeek4.equals(dayOfWeek5)) return false;
            return true;
        }
        if (dayOfWeek5 == null) return true;
        return false;
    }

    private boolean isInWorkTime() {
        if (this.isWeekend()) {
            return false;
        }
        LocalDateTime date = LocalDateTime.now();
        return date.getHour() > AMConfiguration.EC_MAINTAIN_WORK_START_TIME && date.getHour() < AMConfiguration.EC_MAINTAIN_WORK_END_TIME;
    }

    public static final /* synthetic */ boolean $anonfun$canKill$1(ECCanKillRequest ecCanKillRequest$1, EngineNode x$1) {
        return !x$1.getServiceInstance().equals((Object)ecCanKillRequest$1.getEngineConnInstance());
    }

    public static final /* synthetic */ boolean $anonfun$canKill$3(DefaultEngineConnCanKillService $this, ECCanKillRequest ecCanKillRequest$1, EngineNode node) {
        List<Label<?>> labels = $this.labelService().getNodeLabels(node.getServiceInstance());
        UserCreatorLabel userCreatorLabel = LabelUtil$.MODULE$.getUserCreatorLabel(labels);
        EngineTypeLabel engineTypeLabel = LabelUtil$.MODULE$.getEngineTypeLabel(labels);
        return ecCanKillRequest$1.getUserCreatorLabel().getStringValue().equals(userCreatorLabel.getStringValue()) && ecCanKillRequest$1.getEngineTypeLabel().getStringValue().equals(engineTypeLabel.getStringValue());
    }

    public DefaultEngineConnCanKillService() {
        Logging.$init$((Logging)this);
    }
}

