/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.am.converter.MetricsConverter;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.metrics.NodeHealthyInfo;
import org.apache.linkis.manager.common.entity.metrics.NodeMetrics;
import org.apache.linkis.manager.common.entity.metrics.NodeOverLoadInfo;
import org.apache.linkis.manager.common.entity.metrics.NodeTaskInfo;
import org.apache.linkis.manager.common.entity.node.AMNode;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultMetricsConverter
implements MetricsConverter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMetricsConverter.class);

    @Override
    public NodeTaskInfo parseTaskInfo(NodeMetrics nodeMetrics) {
        String msg = nodeMetrics.getHeartBeatMsg();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            try {
                JsonNode jsonNode = BDPJettyServerHelper.jacksonJson().readTree(msg);
                if (jsonNode != null && jsonNode.has("taskInfo")) {
                    NodeTaskInfo taskInfo = (NodeTaskInfo)BDPJettyServerHelper.jacksonJson().readValue(jsonNode.get("taskInfo").asText(), NodeTaskInfo.class);
                    return taskInfo;
                }
            }
            catch (IOException e) {
                logger.warn("parse task info failed", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public NodeHealthyInfo parseHealthyInfo(NodeMetrics nodeMetrics) {
        String healthyInfo = nodeMetrics.getHealthy();
        if (StringUtils.isNotBlank((CharSequence)healthyInfo)) {
            try {
                return (NodeHealthyInfo)BDPJettyServerHelper.jacksonJson().readValue(healthyInfo, NodeHealthyInfo.class);
            }
            catch (IOException e) {
                logger.warn("parse healthy info failed", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public NodeOverLoadInfo parseOverLoadInfo(NodeMetrics nodeMetrics) {
        String overLoad = nodeMetrics.getOverLoad();
        if (StringUtils.isNotBlank((CharSequence)overLoad)) {
            try {
                return (NodeOverLoadInfo)BDPJettyServerHelper.jacksonJson().readValue(overLoad, NodeOverLoadInfo.class);
            }
            catch (IOException e) {
                logger.warn("parse over load info failed", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public NodeStatus parseStatus(NodeMetrics nodeMetrics) {
        return NodeStatus.values()[nodeMetrics.getStatus()];
    }

    @Override
    public String convertTaskInfo(NodeTaskInfo nodeTaskInfo) {
        try {
            return BDPJettyServerHelper.jacksonJson().writeValueAsString((Object)nodeTaskInfo);
        }
        catch (JsonProcessingException e) {
            logger.warn("convert task info failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public String convertHealthyInfo(NodeHealthyInfo nodeHealthyInfo) {
        try {
            return BDPJettyServerHelper.jacksonJson().writeValueAsString((Object)nodeHealthyInfo);
        }
        catch (JsonProcessingException e) {
            logger.warn("convert healthy info failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public String convertOverLoadInfo(NodeOverLoadInfo nodeOverLoadInfo) {
        try {
            return BDPJettyServerHelper.jacksonJson().writeValueAsString((Object)nodeOverLoadInfo);
        }
        catch (JsonProcessingException e) {
            logger.warn("convert over load info failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public int convertStatus(NodeStatus nodeStatus) {
        return nodeStatus.ordinal();
    }

    @Override
    public AMNode fillMetricsToNode(AMNode amNode, NodeMetrics metrics) {
        if (metrics == null) {
            return amNode;
        }
        amNode.setNodeStatus(this.parseStatus(metrics));
        amNode.setNodeTaskInfo(this.parseTaskInfo(metrics));
        amNode.setNodeHealthyInfo(this.parseHealthyInfo(metrics));
        amNode.setNodeOverLoadInfo(this.parseOverLoadInfo(metrics));
        amNode.setUpdateTime(metrics.getUpdateTime());
        return amNode;
    }
}

