/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.conf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.linkis.common.utils.LinkisUtils;
import org.apache.linkis.manager.am.conf.ConfigurationMapCache;
import org.apache.linkis.manager.am.conf.EngineConnConfigurationService;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import scala.Tuple2;

@Component
class DefaultEngineConnConfigurationService
implements EngineConnConfigurationService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEngineConnConfigurationService.class);

    DefaultEngineConnConfigurationService() {
    }

    @Override
    public Map<String, String> getConsoleConfiguration(List<? extends Label<?>> labelList) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Optional<UserCreatorLabel> userCreatorLabelOption = labelList.stream().filter(l -> l instanceof UserCreatorLabel).map(l -> (UserCreatorLabel)l).findFirst();
        Optional<EngineTypeLabel> engineTypeLabelOption = labelList.stream().filter(l -> l instanceof EngineTypeLabel).map(l -> (EngineTypeLabel)l).findFirst();
        userCreatorLabelOption.ifPresent(userCreatorLabel -> engineTypeLabelOption.ifPresent(engineTypeLabel -> {
            Map engineConfig = (Map)LinkisUtils.tryAndWarn(() -> ConfigurationMapCache.engineMapCache.getCacheMap((Object)new Tuple2(userCreatorLabel, engineTypeLabel)), (Logger)logger);
            if (engineConfig != null) {
                properties.putAll(engineConfig);
            }
        }));
        return properties;
    }
}

