/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.server.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.linkis.bml.client.BmlClient;
import org.apache.linkis.bml.client.BmlClientFactory;
import org.apache.linkis.bml.protocol.BmlResourceVersionsResponse;
import org.apache.linkis.bml.protocol.Version;
import org.apache.linkis.common.utils.ZipUtils;
import org.apache.linkis.engineplugin.server.dao.EngineConnBmlResourceDao;
import org.apache.linkis.engineplugin.server.entity.EngineConnBmlResource;
import org.apache.linkis.engineplugin.server.localize.DefaultEngineConnBmlResourceGenerator;
import org.apache.linkis.engineplugin.server.restful.EnginePluginRestful;
import org.apache.linkis.engineplugin.server.service.EnginePluginAdminService;
import org.apache.linkis.engineplugin.vo.EnginePluginBMLVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class EnginePluginAdminServiceImpl
implements EnginePluginAdminService {
    private static final Logger log = LoggerFactory.getLogger(EnginePluginRestful.class);
    @Autowired
    private EngineConnBmlResourceDao engineConnBmlResourceDao;
    private DefaultEngineConnBmlResourceGenerator defaultEngineConnBmlResourceGenerator = new DefaultEngineConnBmlResourceGenerator();
    private BmlClient bmlClient = BmlClientFactory.createBmlClient();

    @Override
    public void rollBackEnginePlugin(EngineConnBmlResource engineConnBmlResource) {
        this.engineConnBmlResourceDao.update(engineConnBmlResource);
    }

    @Override
    public List<String> getTypeVersionList(String type) {
        return this.engineConnBmlResourceDao.getTypeVersionList(type);
    }

    @Override
    public List<Version> getVersionList(String userName, String bmlResourceId) {
        BmlResourceVersionsResponse versions = this.bmlClient.getVersions(userName, bmlResourceId);
        List versions1 = versions.resourceVersions().versions();
        return versions1;
    }

    @Override
    public List<String> getTypeList() {
        return this.engineConnBmlResourceDao.getTypeList();
    }

    @Override
    public void deleteEnginePluginBML(String ecType, String version, String username) {
        List<EngineConnBmlResource> allEngineConnBmlResource = null;
        try {
            allEngineConnBmlResource = this.engineConnBmlResourceDao.getAllEngineConnBmlResource(ecType, version);
            allEngineConnBmlResource.forEach(engineConnBmlResource -> this.engineConnBmlResourceDao.delete((EngineConnBmlResource)engineConnBmlResource));
            String engineConnsHome = this.defaultEngineConnBmlResourceGenerator.getEngineConnsHome();
            File file = new File(engineConnsHome + "/" + ecType);
            if (file.exists()) {
                EnginePluginAdminServiceImpl.deleteDir(file);
                log.info("file {} delete success", (Object)ecType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageInfo<EngineConnBmlResource> queryDataSourceInfoPage(EnginePluginBMLVo enginePluginBMLVo) {
        PageHelper.startPage((int)enginePluginBMLVo.getCurrentPage(), (int)enginePluginBMLVo.getPageSize());
        try {
            List<EngineConnBmlResource> queryList = this.engineConnBmlResourceDao.selectByPageVo(enginePluginBMLVo);
            PageInfo pageInfo = new PageInfo(queryList);
            return pageInfo;
        }
        finally {
            PageHelper.clearPage();
        }
    }

    @Override
    public void uploadToECHome(MultipartFile mfile) {
        String engineConnsHome = this.defaultEngineConnBmlResourceGenerator.getEngineConnsHome();
        try {
            InputStream in = mfile.getInputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            File file = new File(engineConnsHome);
            if (!file.exists()) {
                log.info("engineplugin's home doesn\u2019t exist");
            }
            FileOutputStream out = new FileOutputStream(engineConnsHome + "/" + mfile.getOriginalFilename());
            while ((len = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            log.info("file {} upload fail", (Object)mfile.getOriginalFilename());
        }
        ZipUtils.fileToUnzip((String)(engineConnsHome + "/" + mfile.getOriginalFilename()), (String)engineConnsHome);
        File file = new File(engineConnsHome + "/" + mfile.getOriginalFilename());
        if (file.exists()) {
            file.delete();
            log.info("file {} delete success", (Object)mfile.getOriginalFilename());
        }
    }

    public static void deleteDir(File directory) {
        File[] files;
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                EnginePluginAdminServiceImpl.deleteDir(file);
                continue;
            }
            file.delete();
        }
        directory.delete();
    }
}

