/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.cache.refresh;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.linkis.engineplugin.cache.config.EngineConnPluginCacheConfig;
import org.apache.linkis.engineplugin.cache.refresh.PluginCacheRefresher;
import org.apache.linkis.engineplugin.cache.refresh.RefreshPluginCacheContainer;
import org.apache.linkis.engineplugin.cache.refresh.RefreshPluginCacheOperation;
import org.apache.linkis.engineplugin.cache.refresh.RefreshableEngineConnPluginCache;
import org.apache.linkis.manager.engineplugin.common.loader.entity.EngineConnPluginInfo;
import org.apache.linkis.manager.engineplugin.common.loader.entity.EngineConnPluginInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRefreshPluginCacheContainer
implements RefreshPluginCacheContainer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRefreshPluginCacheContainer.class);
    private static final String REFRESH_SCHEDULE_THREAD = "Refresh-plugin-cache-scheduler-";
    private static final String REFRESH_WORKER_THREAD = "Refresh-plugin-cache-worker-";
    private ConcurrentHashMap<String, RefreshPluginCacheOperation> pluginRefreshOps = new ConcurrentHashMap();
    private List<RefreshableEngineConnPluginCache.RefreshListener> refreshListeners = new ArrayList<RefreshableEngineConnPluginCache.RefreshListener>();
    private DelayQueue<RefreshPluginCacheOperation> refreshDelayQueue = new DelayQueue();
    private PluginCacheRefresher refresher;
    private volatile boolean isRunning = false;
    private ExecutorService scheduleService;
    private ExecutorService workService;
    private RefreshableEngineConnPluginCache pluginCache;

    public DefaultRefreshPluginCacheContainer(RefreshableEngineConnPluginCache pluginCache) {
        this.pluginCache = pluginCache;
    }

    @Override
    public synchronized void start(PluginCacheRefresher refresher) {
        if (!this.isRunning) {
            LOG.info("Starting container of refreshing plugin cache...");
            this.checkRefresher(refresher);
            this.refresher = refresher;
            this.startExecutors();
            this.isRunning = true;
            this.startConsumer();
        } else {
            LOG.trace("This container has been started");
        }
    }

    @Override
    public synchronized void stop() {
        LOG.info("Stopping container of refreshing plugin cache...");
        this.stopExecutors();
        this.isRunning = false;
        LOG.info("Success to stop container of refreshing plugin cache");
    }

    @Override
    public void addRefreshOperation(EngineConnPluginInfo cacheKey, RefreshPluginCacheOperation operation) {
        if (null != this.refresher) {
            operation.setTimeUnit(this.refresher.timeUnit());
            operation.setDuration(this.refresher.interval());
            operation.setPluginInfo(cacheKey);
            operation.nextTime();
            this.pluginRefreshOps.computeIfAbsent(cacheKey.toString(), key -> {
                this.refreshDelayQueue.put(operation);
                return operation;
            });
        }
    }

    @Override
    public void removeRefreshOperation(EngineConnPluginInfo cacheKey) {
        RefreshPluginCacheOperation operation = this.pluginRefreshOps.remove(cacheKey.toString());
        if (null != operation) {
            LOG.trace("Remove refresh-cache operation in queue for plugin:[ " + cacheKey + " ]");
            this.refreshDelayQueue.remove(operation);
        }
    }

    @Override
    public void addRefreshListener(RefreshableEngineConnPluginCache.RefreshListener refreshListener) {
        this.refreshListeners.add(refreshListener);
    }

    private void startExecutors() {
        LOG.info("Start executors: [ schedule, worker ] in container");
        this.scheduleService = Executors.newSingleThreadExecutor(new RefreshThreadFactory(REFRESH_SCHEDULE_THREAD));
        this.workService = Executors.newFixedThreadPool((Integer)EngineConnPluginCacheConfig.PLUGIN_CACHE_REFRESH_WORKERS.getValue(), new RefreshThreadFactory(REFRESH_WORKER_THREAD));
    }

    private void stopExecutors() {
        LOG.info("Stop executors: [ schedule, worker ] in container");
        if (null != this.scheduleService) {
            this.scheduleService.shutdownNow();
            this.scheduleService = null;
        }
        if (null != this.workService) {
            this.workService.shutdownNow();
            this.workService = null;
        }
    }

    private void onRefresh(EngineConnPluginInfo pluginInfo) {
        this.refreshListeners.forEach(refreshListener -> refreshListener.onRefresh(pluginInfo));
    }

    private void checkRefresher(PluginCacheRefresher refresher) {
        long interval = refresher.interval();
        if (interval <= 0L) {
            throw new IllegalArgumentException("interval value [" + interval + "]of refresher cannot be <= 0 ");
        }
    }

    private void startConsumer() {
        this.scheduleService.submit(() -> {
            while (this.isRunning) {
                try {
                    String cacheKey;
                    RefreshPluginCacheOperation operation = (RefreshPluginCacheOperation)this.refreshDelayQueue.take();
                    if (operation != this.pluginRefreshOps.get(cacheKey = operation.cacheStringKey())) continue;
                    try {
                        try {
                            Future<EngineConnPluginInstance> future = this.workService.submit(() -> operation.getOperation().apply(operation.pluginInfo()));
                            EngineConnPluginInstance newPluginInstance = future.get(12L, TimeUnit.HOURS);
                            if (null == newPluginInstance) continue;
                            this.pluginCache.refresh(newPluginInstance.info(), newPluginInstance);
                            operation.setPluginInfo(newPluginInstance.info());
                            this.onRefresh(newPluginInstance.info());
                        }
                        catch (Exception e) {
                            LOG.info("Unable to refresh plugin: [ " + this.pluginCache.toString() + " ]", (Throwable)e);
                        }
                    }
                    finally {
                        operation.nextTime();
                        operation.setDuration(this.refresher.interval());
                        operation.setTimeUnit(this.refresher.timeUnit());
                        this.refreshDelayQueue.add(operation);
                    }
                }
                catch (InterruptedException e) {
                    LOG.info("Error in consuming delay queue of refresh-plugin-cache operation, message:[" + e.getMessage() + "]", (Throwable)e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
    }

    static class RefreshThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        RefreshThreadFactory(String namePrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

