/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.server.conf;

import java.io.File;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.utils.DESUtil;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.errorcode.LinkisModuleErrorCodeSummary;
import org.apache.linkis.server.exception.BDPInitServerException;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class ServerConfiguration$
implements Logging {
    public static ServerConfiguration$ MODULE$;
    private final CommonVars<String> BDP_SERVER_EXCLUDE_PACKAGES;
    private final CommonVars<String> BDP_SERVER_EXCLUDE_CLASSES;
    private final CommonVars<String> BDP_SERVER_EXCLUDE_ANNOTATION;
    private final CommonVars<String> BDP_SERVER_SPRING_APPLICATION_LISTENERS;
    private final String BDP_SERVER_VERSION;
    private final String cryptKey;
    private final String ticketHeader;
    private final CommonVars<String> BDP_TEST_USER;
    private final CommonVars<String> BDP_SERVER_HOME;
    private final CommonVars<Boolean> BDP_SERVER_DISTINCT_MODE;
    private final CommonVars<Boolean> BDP_SERVER_SOCKET_MODE;
    private final CommonVars<String> BDP_SERVER_IDENT_STRING;
    private final CommonVars<String> BDP_SERVER_SERVER_JETTY_NAME;
    private final CommonVars<String> BDP_SERVER_ADDRESS;
    private final CommonVars<Object> BDP_SERVER_PORT;
    private final CommonVars<String> BDP_SERVER_SECURITY_FILTER;
    private final CommonVars<Object> BDP_SERVER_SECURITY_REFERER_VALIDATE;
    private final CommonVars<Object> BDP_SERVER_SECURITY_SSL;
    private final CommonVars<String> BDP_SERVER_SECURITY_SSL_EXCLUDE_PROTOCOLS;
    private final CommonVars<String> BDP_SERVER_SECURITY_SSL_KEYSTORE_PATH;
    private final CommonVars<String> BDP_SERVER_SECURITY_SSL_KEYSTORE_TYPE;
    private final CommonVars<String> BDP_SERVER_SECURITY_SSL_KEYSTORE_PASSWORD;
    private final CommonVars<String> BDP_SERVER_SECURITY_SSL_KEY_MANAGER_PASSWORD;
    private final CommonVars<String> BDP_SERVER_SECURITY_SSL_CIPHER_SUITES;
    private final CommonVars<String> BDP_SERVER_SERVER_CONTEXT_PATH;
    private final CommonVars<String> BDP_SERVER_RESTFUL_URI;
    private final CommonVars<String> BDP_SERVER_USER_URI;
    private final CommonVars<String> BDP_SERVER_RESTFUL_LOGIN_URI;
    private final String[] BDP_SERVER_RESTFUL_PASS_AUTH_REQUEST_URI;
    private final CommonVars<String> BDP_SERVER_SECURITY_SSL_URI;
    private final CommonVars<String> BDP_SERVER_SOCKET_URI;
    private final CommonVars<String> BDP_SERVER_SOCKET_LOGIN_URI;
    private final CommonVars<String> BDP_SERVER_WAR;
    private final CommonVars<String> BDP_SERVER_WAR_TEMPDIR;
    private final CommonVars<String> BDP_SERVER_SERVER_DEFAULT_DIR_ALLOWED;
    private final CommonVars<TimeType> BDP_SERVER_WEB_SESSION_TIMEOUT;
    private final CommonVars<Object> BDP_SERVER_EVENT_QUEUE_SIZE;
    private final CommonVars<Object> BDP_SERVER_EVENT_CONSUMER_THREAD_SIZE;
    private final CommonVars<TimeType> BDP_SERVER_EVENT_CONSUMER_THREAD_FREE_MAX;
    private final CommonVars<Object> BDP_SERVER_SOCKET_QUEUE_SIZE;
    private final CommonVars<String> BDP_SERVER_SOCKET_TEXT_MESSAGE_SIZE_MAX;
    private final CommonVars<String> BDP_SERVER_ENCODING;
    private final CommonVars<String> BDP_SERVER_RESTFUL_SCAN_PACKAGES;
    private final CommonVars<String> BDP_SERVER_RESTFUL_REGISTER_CLASSES;
    private final CommonVars<String> IS_GATEWAY;
    private final CommonVars<String> BDP_SERVER_WEB_ALLOW_ORIGIN;
    private final CommonVars<String> BDP_SERVER_WEB_ALLOW_METHOD;
    private final boolean LINKIE_USERNAME_SUFFIX_ENABLE;
    private final String LINKIE_USERNAME_SUFFIX_NAME;
    private final CommonVars<String> LINKIS_SERVER_SESSION_TICKETID_KEY;
    private final CommonVars<String> LINKIS_SERVER_SESSION_PROXY_TICKETID_KEY;
    private final CommonVars<String> LINKIS_SERVER_ENTRANCE_HEADER_KEY;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ServerConfiguration$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ServerConfiguration$ serverConfiguration$ = this;
        synchronized (serverConfiguration$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public CommonVars<String> BDP_SERVER_EXCLUDE_PACKAGES() {
        return this.BDP_SERVER_EXCLUDE_PACKAGES;
    }

    public CommonVars<String> BDP_SERVER_EXCLUDE_CLASSES() {
        return this.BDP_SERVER_EXCLUDE_CLASSES;
    }

    public CommonVars<String> BDP_SERVER_EXCLUDE_ANNOTATION() {
        return this.BDP_SERVER_EXCLUDE_ANNOTATION;
    }

    public CommonVars<String> BDP_SERVER_SPRING_APPLICATION_LISTENERS() {
        return this.BDP_SERVER_SPRING_APPLICATION_LISTENERS;
    }

    public String BDP_SERVER_VERSION() {
        return this.BDP_SERVER_VERSION;
    }

    public String cryptKey() {
        return this.cryptKey;
    }

    private String ticketHeader() {
        return this.ticketHeader;
    }

    public Option<String> getUsernameByTicket(String ticketId) {
        if (StringUtils.isEmpty((CharSequence)ticketId)) {
            return None$.MODULE$;
        }
        String userName = DESUtil.decrypt((String)ticketId, (String)this.cryptKey());
        if (userName.startsWith(this.ticketHeader())) {
            return new Some((Object)userName.substring(this.ticketHeader().length()));
        }
        return None$.MODULE$;
    }

    public Option<String> getUsernameByTicket(Object ticketId) {
        if (ticketId == null) {
            return None$.MODULE$;
        }
        return this.getUsernameByTicket(ticketId.toString());
    }

    public String getTicketByUsername(String userName) {
        if (this.LINKIE_USERNAME_SUFFIX_ENABLE()) {
            String username = userName.split(",")[0];
            String time = userName.split(",")[1];
            String proxyUser = new StringBuilder(0).append(username).append(this.LINKIE_USERNAME_SUFFIX_NAME()).toString();
            this.logger().info(new StringBuilder(20).append(username).append(" will be proxied as ").append(proxyUser).toString());
            return DESUtil.encrypt((String)new StringBuilder(1).append(this.ticketHeader()).append(proxyUser).append(",").append(time).toString(), (String)this.cryptKey());
        }
        return DESUtil.encrypt((String)new StringBuilder(0).append(this.ticketHeader()).append(userName).toString(), (String)this.cryptKey());
    }

    public CommonVars<String> BDP_TEST_USER() {
        return this.BDP_TEST_USER;
    }

    public CommonVars<String> BDP_SERVER_HOME() {
        return this.BDP_SERVER_HOME;
    }

    public CommonVars<Boolean> BDP_SERVER_DISTINCT_MODE() {
        return this.BDP_SERVER_DISTINCT_MODE;
    }

    public CommonVars<Boolean> BDP_SERVER_SOCKET_MODE() {
        return this.BDP_SERVER_SOCKET_MODE;
    }

    public CommonVars<String> BDP_SERVER_IDENT_STRING() {
        return this.BDP_SERVER_IDENT_STRING;
    }

    public CommonVars<String> BDP_SERVER_SERVER_JETTY_NAME() {
        return this.BDP_SERVER_SERVER_JETTY_NAME;
    }

    public CommonVars<String> BDP_SERVER_ADDRESS() {
        return this.BDP_SERVER_ADDRESS;
    }

    public CommonVars<Object> BDP_SERVER_PORT() {
        return this.BDP_SERVER_PORT;
    }

    public CommonVars<String> BDP_SERVER_SECURITY_FILTER() {
        return this.BDP_SERVER_SECURITY_FILTER;
    }

    public CommonVars<Object> BDP_SERVER_SECURITY_REFERER_VALIDATE() {
        return this.BDP_SERVER_SECURITY_REFERER_VALIDATE;
    }

    public CommonVars<Object> BDP_SERVER_SECURITY_SSL() {
        return this.BDP_SERVER_SECURITY_SSL;
    }

    public CommonVars<String> BDP_SERVER_SECURITY_SSL_EXCLUDE_PROTOCOLS() {
        return this.BDP_SERVER_SECURITY_SSL_EXCLUDE_PROTOCOLS;
    }

    public CommonVars<String> BDP_SERVER_SECURITY_SSL_KEYSTORE_PATH() {
        return this.BDP_SERVER_SECURITY_SSL_KEYSTORE_PATH;
    }

    public CommonVars<String> BDP_SERVER_SECURITY_SSL_KEYSTORE_TYPE() {
        return this.BDP_SERVER_SECURITY_SSL_KEYSTORE_TYPE;
    }

    public CommonVars<String> BDP_SERVER_SECURITY_SSL_KEYSTORE_PASSWORD() {
        return this.BDP_SERVER_SECURITY_SSL_KEYSTORE_PASSWORD;
    }

    public CommonVars<String> BDP_SERVER_SECURITY_SSL_KEY_MANAGER_PASSWORD() {
        return this.BDP_SERVER_SECURITY_SSL_KEY_MANAGER_PASSWORD;
    }

    public CommonVars<String> BDP_SERVER_SECURITY_SSL_CIPHER_SUITES() {
        return this.BDP_SERVER_SECURITY_SSL_CIPHER_SUITES;
    }

    public CommonVars<String> BDP_SERVER_SERVER_CONTEXT_PATH() {
        return this.BDP_SERVER_SERVER_CONTEXT_PATH;
    }

    public CommonVars<String> BDP_SERVER_RESTFUL_URI() {
        return this.BDP_SERVER_RESTFUL_URI;
    }

    public CommonVars<String> BDP_SERVER_USER_URI() {
        return this.BDP_SERVER_USER_URI;
    }

    public CommonVars<String> BDP_SERVER_RESTFUL_LOGIN_URI() {
        return this.BDP_SERVER_RESTFUL_LOGIN_URI;
    }

    public String[] BDP_SERVER_RESTFUL_PASS_AUTH_REQUEST_URI() {
        return this.BDP_SERVER_RESTFUL_PASS_AUTH_REQUEST_URI;
    }

    public CommonVars<String> BDP_SERVER_SECURITY_SSL_URI() {
        return this.BDP_SERVER_SECURITY_SSL_URI;
    }

    public CommonVars<String> BDP_SERVER_SOCKET_URI() {
        return this.BDP_SERVER_SOCKET_URI;
    }

    public CommonVars<String> BDP_SERVER_SOCKET_LOGIN_URI() {
        return this.BDP_SERVER_SOCKET_LOGIN_URI;
    }

    public CommonVars<String> BDP_SERVER_WAR() {
        return this.BDP_SERVER_WAR;
    }

    public CommonVars<String> BDP_SERVER_WAR_TEMPDIR() {
        return this.BDP_SERVER_WAR_TEMPDIR;
    }

    public CommonVars<String> BDP_SERVER_SERVER_DEFAULT_DIR_ALLOWED() {
        return this.BDP_SERVER_SERVER_DEFAULT_DIR_ALLOWED;
    }

    public CommonVars<TimeType> BDP_SERVER_WEB_SESSION_TIMEOUT() {
        return this.BDP_SERVER_WEB_SESSION_TIMEOUT;
    }

    public CommonVars<Object> BDP_SERVER_EVENT_QUEUE_SIZE() {
        return this.BDP_SERVER_EVENT_QUEUE_SIZE;
    }

    public CommonVars<Object> BDP_SERVER_EVENT_CONSUMER_THREAD_SIZE() {
        return this.BDP_SERVER_EVENT_CONSUMER_THREAD_SIZE;
    }

    public CommonVars<TimeType> BDP_SERVER_EVENT_CONSUMER_THREAD_FREE_MAX() {
        return this.BDP_SERVER_EVENT_CONSUMER_THREAD_FREE_MAX;
    }

    public CommonVars<Object> BDP_SERVER_SOCKET_QUEUE_SIZE() {
        return this.BDP_SERVER_SOCKET_QUEUE_SIZE;
    }

    public CommonVars<String> BDP_SERVER_SOCKET_TEXT_MESSAGE_SIZE_MAX() {
        return this.BDP_SERVER_SOCKET_TEXT_MESSAGE_SIZE_MAX;
    }

    public CommonVars<String> BDP_SERVER_ENCODING() {
        return this.BDP_SERVER_ENCODING;
    }

    public CommonVars<String> BDP_SERVER_RESTFUL_SCAN_PACKAGES() {
        return this.BDP_SERVER_RESTFUL_SCAN_PACKAGES;
    }

    public CommonVars<String> BDP_SERVER_RESTFUL_REGISTER_CLASSES() {
        return this.BDP_SERVER_RESTFUL_REGISTER_CLASSES;
    }

    public CommonVars<String> IS_GATEWAY() {
        return this.IS_GATEWAY;
    }

    public CommonVars<String> BDP_SERVER_WEB_ALLOW_ORIGIN() {
        return this.BDP_SERVER_WEB_ALLOW_ORIGIN;
    }

    public CommonVars<String> BDP_SERVER_WEB_ALLOW_METHOD() {
        return this.BDP_SERVER_WEB_ALLOW_METHOD;
    }

    public boolean LINKIE_USERNAME_SUFFIX_ENABLE() {
        return this.LINKIE_USERNAME_SUFFIX_ENABLE;
    }

    public String LINKIE_USERNAME_SUFFIX_NAME() {
        return this.LINKIE_USERNAME_SUFFIX_NAME;
    }

    public CommonVars<String> LINKIS_SERVER_SESSION_TICKETID_KEY() {
        return this.LINKIS_SERVER_SESSION_TICKETID_KEY;
    }

    public CommonVars<String> LINKIS_SERVER_SESSION_PROXY_TICKETID_KEY() {
        return this.LINKIS_SERVER_SESSION_PROXY_TICKETID_KEY;
    }

    public CommonVars<String> LINKIS_SERVER_ENTRANCE_HEADER_KEY() {
        return this.LINKIS_SERVER_ENTRANCE_HEADER_KEY;
    }

    private ServerConfiguration$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.BDP_SERVER_EXCLUDE_PACKAGES = CommonVars$.MODULE$.apply("wds.linkis.server.component.exclude.packages", (Object)"");
        this.BDP_SERVER_EXCLUDE_CLASSES = CommonVars$.MODULE$.apply("wds.linkis.server.component.exclude.classes", (Object)"");
        this.BDP_SERVER_EXCLUDE_ANNOTATION = CommonVars$.MODULE$.apply("wds.linkis.server.component.exclude.annotation", (Object)"");
        this.BDP_SERVER_SPRING_APPLICATION_LISTENERS = CommonVars$.MODULE$.apply("wds.linkis.server.spring.application.listeners", (Object)"");
        this.BDP_SERVER_VERSION = (String)CommonVars$.MODULE$.apply("wds.linkis.server.version", (Object)"v1").getValue();
        if (StringUtils.isBlank((CharSequence)this.BDP_SERVER_VERSION())) {
            throw new BDPInitServerException(LinkisModuleErrorCodeSummary.DATAWORKCLOUD_MUST_VERSION.getErrorCode(), LinkisModuleErrorCodeSummary.DATAWORKCLOUD_MUST_VERSION.getErrorDesc());
        }
        this.cryptKey = Base64.getMimeEncoder().encodeToString(((String)CommonVars$.MODULE$.apply("wds.linkis.crypt.key", (Object)"bdp-for-server").getValue()).getBytes());
        this.ticketHeader = (String)CommonVars$.MODULE$.apply("wds.linkis.ticket.header", (Object)"bfs_").getValue();
        this.BDP_TEST_USER = CommonVars$.MODULE$.apply("wds.linkis.test.user", (Object)"");
        this.BDP_SERVER_HOME = CommonVars$.MODULE$.apply("wds.linkis.server.home", CommonVars$.MODULE$.apply("LINKIS_HOME", (Object)"").getValue());
        this.BDP_SERVER_DISTINCT_MODE = CommonVars$.MODULE$.apply("wds.linkis.server.distinct.mode", (Object)Boolean.TRUE);
        if (!Predef$.MODULE$.Boolean2boolean((Boolean)this.BDP_SERVER_DISTINCT_MODE().getValue()) && StringUtils.isEmpty((CharSequence)((CharSequence)this.BDP_SERVER_HOME().getValue()))) {
            throw new BDPInitServerException(LinkisModuleErrorCodeSummary.HAVE_NOT_SET.getErrorCode(), LinkisModuleErrorCodeSummary.HAVE_NOT_SET.getErrorDesc());
        }
        this.BDP_SERVER_SOCKET_MODE = CommonVars$.MODULE$.apply("wds.linkis.server.socket.mode", (Object)Boolean.FALSE);
        this.BDP_SERVER_IDENT_STRING = CommonVars$.MODULE$.apply("wds.linkis.server.ident.string", (Object)"true");
        this.BDP_SERVER_SERVER_JETTY_NAME = CommonVars$.MODULE$.apply("wds.linkis.server.jetty.name", (Object)"");
        this.BDP_SERVER_ADDRESS = CommonVars$.MODULE$.apply("wds.linkis.server.address", (Object)Utils$.MODULE$.getLocalHostname());
        this.BDP_SERVER_PORT = CommonVars$.MODULE$.apply("wds.linkis.server.port", (Object)BoxesRunTime.boxToInteger((int)20303));
        this.BDP_SERVER_SECURITY_FILTER = CommonVars$.MODULE$.apply("wds.linkis.server.security.filter", (Object)"org.apache.linkis.server.security.SecurityFilter");
        this.BDP_SERVER_SECURITY_REFERER_VALIDATE = CommonVars$.MODULE$.apply("wds.linkis.server.security.referer.validate", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.BDP_SERVER_SECURITY_SSL = CommonVars$.MODULE$.apply("wds.linkis.server.security.ssl", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.BDP_SERVER_SECURITY_SSL_EXCLUDE_PROTOCOLS = CommonVars$.MODULE$.apply("wds.linkis.server.security.ssl.excludeProtocols", (Object)"SSLv2,SSLv3");
        this.BDP_SERVER_SECURITY_SSL_KEYSTORE_PATH = CommonVars$.MODULE$.apply("wds.linkis.server.security.ssl.keystore.path", (Object)new File((String)this.BDP_SERVER_HOME().getValue(), "keystore").getPath());
        this.BDP_SERVER_SECURITY_SSL_KEYSTORE_TYPE = CommonVars$.MODULE$.apply("wds.linkis.server.security.ssl.keystore.type", (Object)"JKS");
        this.BDP_SERVER_SECURITY_SSL_KEYSTORE_PASSWORD = CommonVars$.MODULE$.apply("wds.linkis.server.security.ssl.keystore.password", (Object)"");
        this.BDP_SERVER_SECURITY_SSL_KEY_MANAGER_PASSWORD = CommonVars$.MODULE$.apply("wds.linkis.server.security.ssl.key.manager.password", (Object)"");
        this.BDP_SERVER_SECURITY_SSL_CIPHER_SUITES = CommonVars$.MODULE$.apply("wds.linkis.server.security.ssl.cipher.suites", (Object)"");
        this.BDP_SERVER_SERVER_CONTEXT_PATH = CommonVars$.MODULE$.apply("wds.linkis.server.context.path", (Object)"/");
        this.BDP_SERVER_RESTFUL_URI = CommonVars$.MODULE$.apply("wds.linkis.server.restful.uri", (Object)new StringBuilder(12).append("/api/rest_j/").append(this.BDP_SERVER_VERSION()).toString());
        this.BDP_SERVER_USER_URI = CommonVars$.MODULE$.apply("wds.linkis.server.user.restful.uri", (Object)new StringBuilder(17).append("/api/rest_j/").append(this.BDP_SERVER_VERSION()).append("/user").toString());
        this.BDP_SERVER_RESTFUL_LOGIN_URI = CommonVars$.MODULE$.apply("wds.linkis.server.user.restful.login.uri", (Object)new File((String)this.BDP_SERVER_USER_URI().getValue(), "login").getPath());
        this.BDP_SERVER_RESTFUL_PASS_AUTH_REQUEST_URI = ((String)CommonVars$.MODULE$.apply("wds.linkis.server.user.restful.uri.pass.auth", (Object)"").getValue()).split(",");
        this.BDP_SERVER_SECURITY_SSL_URI = CommonVars$.MODULE$.apply("wds.linkis.server.user.security.ssl.uri", (Object)new File((String)this.BDP_SERVER_USER_URI().getValue(), "publicKey").getPath());
        this.BDP_SERVER_SOCKET_URI = CommonVars$.MODULE$.apply("wds.linkis.server.socket.uri", (Object)"/ws");
        this.BDP_SERVER_SOCKET_LOGIN_URI = CommonVars$.MODULE$.apply("wds.linkis.server.socket.login.uri", (Object)"/ws/user/login");
        this.BDP_SERVER_WAR = CommonVars$.MODULE$.apply("wds.linkis.server.war", (Object)new File((String)this.BDP_SERVER_HOME().getValue(), "web/dist").getPath());
        this.BDP_SERVER_WAR_TEMPDIR = CommonVars$.MODULE$.apply("wds.linkis.server.war.tempdir", (Object)new File((String)this.BDP_SERVER_HOME().getValue(), "web/webapps").getPath());
        this.BDP_SERVER_SERVER_DEFAULT_DIR_ALLOWED = CommonVars$.MODULE$.apply("wds.linkis.server.default.dir.allowed", (Object)"false");
        this.BDP_SERVER_WEB_SESSION_TIMEOUT = CommonVars$.MODULE$.apply("wds.linkis.server.web.session.timeout", (Object)new TimeType("2h"));
        this.BDP_SERVER_EVENT_QUEUE_SIZE = CommonVars$.MODULE$.apply("wds.linkis.server.event.queue.size", (Object)BoxesRunTime.boxToInteger((int)5000));
        this.BDP_SERVER_EVENT_CONSUMER_THREAD_SIZE = CommonVars$.MODULE$.apply("wds.linkis.server.event.consumer.thread", (Object)BoxesRunTime.boxToInteger((int)10));
        this.BDP_SERVER_EVENT_CONSUMER_THREAD_FREE_MAX = CommonVars$.MODULE$.apply("wds.linkis.server.event.consumer.thread.max.free", (Object)new TimeType("2m"));
        this.BDP_SERVER_SOCKET_QUEUE_SIZE = CommonVars$.MODULE$.apply("wds.linkis.server.socket.queue.size", (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.BDP_SERVER_EVENT_CONSUMER_THREAD_SIZE().getValue()) * 20)));
        this.BDP_SERVER_SOCKET_TEXT_MESSAGE_SIZE_MAX = CommonVars$.MODULE$.apply("wds.linkis.server.socket.text.message.size.max", (Object)"1024000");
        this.BDP_SERVER_ENCODING = Configuration$.MODULE$.BDP_ENCODING();
        this.BDP_SERVER_RESTFUL_SCAN_PACKAGES = CommonVars$.MODULE$.apply("wds.linkis.server.restful.scan.packages", (Object)"");
        this.BDP_SERVER_RESTFUL_REGISTER_CLASSES = CommonVars$.MODULE$.apply("wds.linkis.server.restful.register.classes", (Object)"");
        this.IS_GATEWAY = CommonVars$.MODULE$.apply("wds.linkis.is.gateway", (Object)"false");
        this.BDP_SERVER_WEB_ALLOW_ORIGIN = CommonVars$.MODULE$.apply("wds.linkis.server.web.alloworigin", (Object)"*");
        this.BDP_SERVER_WEB_ALLOW_METHOD = CommonVars$.MODULE$.apply("wds.linkis.server.web.allowmethod", (Object)"POST,GET,OPTIONS,PUT,HEAD,DELETE");
        this.LINKIE_USERNAME_SUFFIX_ENABLE = BoxesRunTime.unboxToBoolean((Object)CommonVars$.MODULE$.apply("linkis.username.suffix.enable", (Object)BoxesRunTime.boxToBoolean((boolean)false)).getValue());
        this.LINKIE_USERNAME_SUFFIX_NAME = (String)CommonVars$.MODULE$.apply("linkis.username.suffix.name", (Object)"_c").getValue();
        this.LINKIS_SERVER_SESSION_TICKETID_KEY = CommonVars$.MODULE$.apply("wds.linkis.session.ticket.key", (Object)"linkis_user_session_ticket_id_v1");
        this.LINKIS_SERVER_SESSION_PROXY_TICKETID_KEY = CommonVars$.MODULE$.apply("wds.linkis.session.proxy.user.ticket.key", (Object)"linkis_user_session_proxy_ticket_id_v1");
        this.LINKIS_SERVER_ENTRANCE_HEADER_KEY = CommonVars$.MODULE$.apply("linkis.server.entrance.header.key", (Object)"jobInstanceKey");
    }
}

