/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.linkis.datasourcemanager.common.util.json.Json;
import org.apache.linkis.metadata.query.common.domain.MetaColumnInfo;
import org.apache.linkis.metadata.query.common.service.AbstractDbMetaService;
import org.apache.linkis.metadata.query.common.service.MetadataConnection;
import org.apache.linkis.metadata.query.service.ElasticConnection;
import org.apache.linkis.metadata.query.service.ElasticParamsMapper;

public class EsMetaService
extends AbstractDbMetaService<ElasticConnection> {
    public MetadataConnection<ElasticConnection> getConnection(String operator, Map<String, Object> params) throws Exception {
        String[] endPoints = new String[]{};
        Object urls = params.get(ElasticParamsMapper.PARAM_ES_URLS.getValue());
        if (!(urls instanceof List)) {
            List urlList = (List)Json.fromJson((String)String.valueOf(urls), List.class, (Class[])new Class[]{String.class});
            assert (urlList != null);
            endPoints = urlList.toArray(endPoints);
        } else {
            endPoints = ((List)urls).toArray(endPoints);
        }
        ElasticConnection conn = new ElasticConnection(endPoints, String.valueOf(params.getOrDefault(ElasticParamsMapper.PARAM_ES_USERNAME.getValue(), "")), String.valueOf(params.getOrDefault(ElasticParamsMapper.PARAM_ES_PASSWORD.getValue(), "")));
        return new MetadataConnection((Object)conn, false);
    }

    public List<String> queryDatabases(ElasticConnection connection) {
        try {
            return connection.getAllIndices();
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to get ElasticSearch indices(\u83b7\u53d6\u7d22\u5f15\u5217\u8868\u5931\u8d25)", e);
        }
    }

    public List<String> queryTables(ElasticConnection connection, String database) {
        try {
            return connection.getTypes(database);
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to get ElasticSearch types(\u83b7\u53d6\u7d22\u5f15\u7c7b\u578b\u5931\u8d25)", e);
        }
    }

    public List<MetaColumnInfo> queryColumns(ElasticConnection connection, String database, String table) {
        try {
            Map<Object, Object> props = connection.getProps(database, table);
            return props.entrySet().stream().map(entry -> {
                MetaColumnInfo info = new MetaColumnInfo();
                info.setName(String.valueOf(entry.getKey()));
                Object value = entry.getValue();
                if (value instanceof Map) {
                    info.setType(String.valueOf(((Map)value).getOrDefault("type", "")));
                }
                return info;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to get ElasticSearch columns(\u83b7\u53d6\u7d22\u5f15\u5b57\u6bb5\u5931\u8d25)", e);
        }
    }
}

