/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.scheduler.queue;

import java.io.Serializable;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.scheduler.executer.ConcurrentTaskInfoSupport;
import org.apache.linkis.scheduler.executer.Executor;
import org.apache.linkis.scheduler.executer.SingleTaskInfoSupport;
import org.apache.linkis.scheduler.queue.Job;
import org.apache.linkis.scheduler.queue.SchedulerEventState$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001\u0002\n\u0014\u0001yA\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!Aa\b\u0001B\u0001B\u0003%q\bC\u0003F\u0001\u0011\u0005a\tC\u0004L\u0001\u0001\u0007I\u0011\u0002'\t\u000fA\u0003\u0001\u0019!C\u0005#\"1q\u000b\u0001Q!\n5C!\u0002\u0017\u0001A\u0002\u0003\u0007I\u0011A\nZ\u0011)y\u0007\u00011AA\u0002\u0013\u00051\u0003\u001d\u0005\nO\u0002\u0001\r\u0011!Q!\niCqA\u001e\u0001A\u0002\u0013%q\u000fC\u0004|\u0001\u0001\u0007I\u0011\u0002?\t\ry\u0004\u0001\u0015)\u0003y\u0011\u0019y\b\u0001\"\u0005\u0002\u0002!9\u0011q\u0004\u0001\u0005\u0012\u0005\u0005\u0002bBA\u001d\u0001\u0011\u0005\u00131\b\u0005\b\u0003{\u0001A\u0011AA \u0005%QuN\u0019#bK6|gN\u0003\u0002\u0015+\u0005)\u0011/^3vK*\u0011acF\u0001\ng\u000eDW\rZ;mKJT!\u0001G\r\u0002\r1Lgn[5t\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0004\u0001M!\u0001aH\u0014+!\t\u0001S%D\u0001\"\u0015\t\u00113%\u0001\u0003mC:<'\"\u0001\u0013\u0002\t)\fg/Y\u0005\u0003M\u0005\u0012aa\u00142kK\u000e$\bC\u0001\u0011)\u0013\tI\u0013E\u0001\u0005Sk:t\u0017M\u00197f!\tY\u0003'D\u0001-\u0015\tic&A\u0003vi&d7O\u0003\u00020/\u000511m\\7n_:L!!\r\u0017\u0003\u000f1{wmZ5oO\u0006\u0019!n\u001c2\u0011\u0005Q*T\"A\n\n\u0005Y\u001a\"a\u0001&pE\u0006AB.[:uK:,'/\u00169eCR,\u0017J\u001c;feZ\fG.T:\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\t1{gnZ\u0001\tKb,7-\u001e;peB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!)F\u0001\tKb,7-\u001e;fe&\u0011A)\u0011\u0002\t\u000bb,7-\u001e;pe\u00061A(\u001b8jiz\"Ba\u0012%J\u0015B\u0011A\u0007\u0001\u0005\u0006e\u0011\u0001\ra\r\u0005\u0006o\u0011\u0001\r\u0001\u000f\u0005\u0006}\u0011\u0001\raP\u0001\ni\u0016\u0014X.\u001b8bi\u0016,\u0012!\u0014\t\u0003s9K!a\u0014\u001e\u0003\u000f\t{w\u000e\\3b]\u0006iA/\u001a:nS:\fG/Z0%KF$\"AU+\u0011\u0005e\u001a\u0016B\u0001+;\u0005\u0011)f.\u001b;\t\u000fY3\u0011\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010J\u0019\u0002\u0015Q,'/\\5oCR,\u0007%\u0001\u0004gkR,(/Z\u000b\u00025B\u00121,\u001a\t\u00049\u0006\u001cW\"A/\u000b\u0005y{\u0016AC2p]\u000e,(O]3oi*\u0011\u0001mI\u0001\u0005kRLG.\u0003\u0002c;\n1a)\u001e;ve\u0016\u0004\"\u0001Z3\r\u0001\u0011IaMCA\u0001\u0002\u0003\u0015\t\u0001\u001b\u0002\u0004?\u00122\u0014a\u00024viV\u0014X\rI\t\u0003S2\u0004\"!\u000f6\n\u0005-T$a\u0002(pi\"Lgn\u001a\t\u0003s5L!A\u001c\u001e\u0003\u0007\u0005s\u00170\u0001\u0006gkR,(/Z0%KF$\"AU9\t\u000fYK\u0011\u0011!a\u0001eB\u00121/\u001e\t\u00049\u0006$\bC\u00013v\t%1\u0017/!A\u0001\u0002\u000b\u0005\u0001.\u0001\u0007mCN$\bK]8he\u0016\u001c8/F\u0001y!\tI\u00140\u0003\u0002{u\t)a\t\\8bi\u0006\u0001B.Y:u!J|wM]3tg~#S-\u001d\u000b\u0003%vDqA\u0016\u0007\u0002\u0002\u0003\u0007\u00010A\u0007mCN$\bK]8he\u0016\u001c8\u000fI\u0001\fO\u0016$\bK]8he\u0016\u001c8/\u0006\u0002\u0002\u0004A1\u0011(!\u0002y\u0003\u0013I1!a\u0002;\u0005\u0019!V\u000f\u001d7feA)\u0011(a\u0003\u0002\u0010%\u0019\u0011Q\u0002\u001e\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u00051QM\\4j]\u0016T1!!\u0007\u0018\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA\u000f\u0003'\u0011qBS8c!J|wM]3tg&sgm\\\u0001\u0007O\u0016$Hj\\4\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003gqA!a\n\u00020A\u0019\u0011\u0011\u0006\u001e\u000e\u0005\u0005-\"bAA\u0017;\u00051AH]8pizJ1!!\r;\u0003\u0019\u0001&/\u001a3fM&!\u0011QGA\u001c\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0007\u001e\u0002\u0007I,h\u000eF\u0001S\u0003\u0011Y\u0017\u000e\u001c7\u0015\u0005\u0005\u0005\u0003cA\u001d\u0002D%\u0019\u0011Q\t\u001e\u0003\r\u0005s\u0017PV1m\u0001")
public class JobDaemon
implements Runnable,
Logging {
    private final Job job;
    private final long listenerUpdateIntervalMs;
    private final Executor executor;
    private boolean terminate;
    private Future<?> future;
    private float lastProgress;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        JobDaemon jobDaemon = this;
        synchronized (jobDaemon) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private boolean terminate() {
        return this.terminate;
    }

    private void terminate_$eq(boolean x$1) {
        this.terminate = x$1;
    }

    public Future<?> future() {
        return this.future;
    }

    public void future_$eq(Future<?> x$1) {
        this.future = x$1;
    }

    private float lastProgress() {
        return this.lastProgress;
    }

    private void lastProgress_$eq(float x$1) {
        this.lastProgress = x$1;
    }

    public Tuple2<Object, JobProgressInfo[]> getProgress() {
        Executor executor = this.executor;
        if (executor instanceof SingleTaskInfoSupport) {
            Executor executor2 = executor;
            return new Tuple2((Object)BoxesRunTime.boxToFloat((float)((SingleTaskInfoSupport)((Object)executor2)).progress()), (Object)((SingleTaskInfoSupport)((Object)executor2)).getProgressInfo());
        }
        if (executor instanceof ConcurrentTaskInfoSupport) {
            Executor executor3 = executor;
            return new Tuple2((Object)BoxesRunTime.boxToFloat((float)((ConcurrentTaskInfoSupport)((Object)executor3)).progress(this.job.getId())), (Object)((ConcurrentTaskInfoSupport)((Object)executor3)).getProgressInfo(this.job.getId()));
        }
        return new Tuple2((Object)BoxesRunTime.boxToFloat((float)0.0f), null);
    }

    public String getLog() {
        Executor executor = this.executor;
        if (executor instanceof SingleTaskInfoSupport) {
            Executor executor2 = executor;
            return ((SingleTaskInfoSupport)((Object)executor2)).log();
        }
        if (executor instanceof ConcurrentTaskInfoSupport) {
            Executor executor3 = executor;
            return ((ConcurrentTaskInfoSupport)((Object)executor3)).log(this.job.getId());
        }
        return "";
    }

    @Override
    public void run() {
        if (this.listenerUpdateIntervalMs < 10L) {
            return;
        }
        Executor executor = this.executor;
        if (executor instanceof SingleTaskInfoSupport) {
        } else if (executor instanceof ConcurrentTaskInfoSupport) {
        } else {
            return;
        }
        while (!SchedulerEventState$.MODULE$.isCompleted(this.job.getState()) && !this.terminate()) {
            String log;
            Tuple2 tuple2 = (Tuple2)Utils$.MODULE$.tryAndWarnMsg((Function0 & Serializable & scala.Serializable)() -> this.getProgress(), new StringBuilder(48).append("Can not get progress information from ").append(this.executor).append(" for job ").append(this.job).append(".").toString(), this.logger());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            float progress = BoxesRunTime.unboxToFloat((Object)tuple2._1());
            JobProgressInfo[] progressInfo = (JobProgressInfo[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)progress), (Object)progressInfo);
            float progress2 = BoxesRunTime.unboxToFloat((Object)tuple22._1());
            JobProgressInfo[] progressInfo2 = (JobProgressInfo[])tuple22._2();
            if (progress2 != this.lastProgress()) {
                this.job.setProgress(progress2);
                Utils$.MODULE$.tryAndWarnMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.job.getProgressListener().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                    x$14.onProgressUpdate(this.job, progress2, progressInfo2);
                    return BoxedUnit.UNIT;
                }), new StringBuilder(33).append("Can not update progress for job ").append(this.job).append(".").toString(), this.logger());
                this.lastProgress_$eq(progress2);
            }
            Object object = StringUtils.isNotEmpty((CharSequence)(log = (String)Utils$.MODULE$.tryAndWarnMsg((Function0 & Serializable & scala.Serializable)() -> this.getLog(), new StringBuilder(32).append("Can not get logs from ").append(this.executor).append(" for job ").append(this.job).append(".").toString(), this.logger()))) ? Utils$.MODULE$.tryAndWarnMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.job.getLogListener().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
                x$15.onLogUpdate(this.job, log);
                return BoxedUnit.UNIT;
            }), new StringBuilder(29).append("Can not update logs for job ").append(this.job).append(".").toString(), this.logger()) : BoxedUnit.UNIT;
            Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep($this.listenerUpdateIntervalMs));
        }
    }

    public Object kill() {
        this.terminate_$eq(true);
        if (this.future() != null && !this.future().isDone()) {
            return BoxesRunTime.boxToBoolean((boolean)this.future().cancel(true));
        }
        return BoxedUnit.UNIT;
    }

    public JobDaemon(Job job, long listenerUpdateIntervalMs, Executor executor) {
        this.job = job;
        this.listenerUpdateIntervalMs = listenerUpdateIntervalMs;
        this.executor = executor;
        Logging.$init$((Logging)this);
        this.terminate = false;
        this.lastProgress = 0.0f;
    }
}

