/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.ElementFacet;
import springfox.documentation.schema.ElementFacetSource;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.Xml;
import springfox.documentation.service.VendorExtension;

public class PropertySpecification
implements ElementFacetSource {
    private final String name;
    private final String description;
    private final ModelSpecification type;
    private final List<ElementFacet> facets = new ArrayList<ElementFacet>();
    private final Boolean nullable;
    private final Boolean required;
    private final Boolean readOnly;
    private final Boolean writeOnly;
    private final Boolean deprecated;
    private final Boolean allowEmptyValue;
    private final Boolean isHidden;
    private final int position;
    private final Object example;
    private final Object defaultValue;
    private final Xml xml;
    private final List<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();

    public PropertySpecification(String name, String description, ModelSpecification type, List<ElementFacet> facets, Boolean nullable, Boolean required, Boolean readOnly, Boolean writeOnly, Boolean deprecated, Boolean allowEmptyValue, Boolean isHidden, int position, Object example, Object defaultValue, Xml xml, List<VendorExtension> vendorExtensions) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.facets.addAll(BuilderDefaults.nullToEmptyList(facets));
        this.nullable = nullable;
        this.required = required;
        this.readOnly = readOnly;
        this.writeOnly = writeOnly;
        this.deprecated = deprecated;
        this.allowEmptyValue = allowEmptyValue;
        this.isHidden = isHidden;
        this.position = position;
        this.example = example;
        this.defaultValue = defaultValue;
        this.xml = xml;
        this.vendorExtensions.addAll(BuilderDefaults.nullToEmptyList(vendorExtensions));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ModelSpecification getType() {
        return this.type;
    }

    public List<ElementFacet> getFacets() {
        return this.facets;
    }

    @Override
    public <T extends ElementFacet> Optional<T> elementFacet(Class<T> clazz) {
        return this.facets.stream().filter(f -> f != null && clazz.isAssignableFrom(f.getClass())).findFirst().map(clazz::cast);
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Boolean nullSafeIsRequired() {
        return this.required != null && this.required != false;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public Boolean getWriteOnly() {
        return this.writeOnly;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public Boolean getHidden() {
        return this.isHidden != null && this.isHidden != false;
    }

    public int getPosition() {
        return this.position;
    }

    public Object getExample() {
        return this.example;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Xml getXml() {
        return this.xml;
    }

    public List<VendorExtension> getVendorExtensions() {
        return this.vendorExtensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertySpecification that = (PropertySpecification)o;
        return this.position == that.position && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.type, that.type) && Objects.equals(this.facets, that.facets) && Objects.equals(this.nullable, that.nullable) && Objects.equals(this.required, that.required) && Objects.equals(this.readOnly, that.readOnly) && Objects.equals(this.writeOnly, that.writeOnly) && Objects.equals(this.deprecated, that.deprecated) && Objects.equals(this.allowEmptyValue, that.allowEmptyValue) && Objects.equals(this.isHidden, that.isHidden) && Objects.equals(this.example, that.example) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.xml, that.xml) && Objects.equals(this.vendorExtensions, that.vendorExtensions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.type, this.facets, this.nullable, this.required, this.readOnly, this.writeOnly, this.deprecated, this.allowEmptyValue, this.isHidden, this.position, this.example, this.defaultValue, this.xml, this.vendorExtensions);
    }

    public String toString() {
        return "PropertySpecification{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", type=" + this.type + ", facets=" + this.facets + ", nullable=" + this.nullable + ", required=" + this.required + ", readOnly=" + this.readOnly + ", writeOnly=" + this.writeOnly + ", deprecated=" + this.deprecated + ", allowEmptyValue=" + this.allowEmptyValue + ", isHidden=" + this.isHidden + ", position=" + this.position + ", example=" + this.example + ", defaultValue=" + this.defaultValue + ", xml=" + this.xml + ", vendorExtensions=" + this.vendorExtensions + '}';
    }
}

