/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.computation.execute;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.entrance.BindEngineLabel;
import org.apache.linkis.manager.label.entity.entrance.ExecuteOnceLabel;
import org.apache.linkis.manager.label.entity.entrance.LoadBalanceLabel;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.manager.label.utils.LabelUtils;
import org.apache.linkis.orchestrator.computation.conf.ComputationOrchestratorConf$;
import org.apache.linkis.orchestrator.computation.execute.CodeExecTaskExecutor;
import org.apache.linkis.orchestrator.computation.execute.CodeExecTaskExecutorManager;
import org.apache.linkis.orchestrator.computation.execute.EngineConnTaskInfo;
import org.apache.linkis.orchestrator.computation.physical.CodeLogicalUnitExecTask;
import org.apache.linkis.orchestrator.ecm.EngineConnManager;
import org.apache.linkis.orchestrator.ecm.EngineConnManagerBuilder;
import org.apache.linkis.orchestrator.ecm.EngineConnManagerBuilder$;
import org.apache.linkis.orchestrator.ecm.entity.DefaultMarkReq;
import org.apache.linkis.orchestrator.ecm.entity.LoadBanlanceMarkReq;
import org.apache.linkis.orchestrator.ecm.entity.Mark;
import org.apache.linkis.orchestrator.ecm.entity.MarkReq;
import org.apache.linkis.orchestrator.ecm.entity.Policy;
import org.apache.linkis.orchestrator.ecm.service.EngineConnExecutor;
import org.apache.linkis.orchestrator.exception.OrchestratorErrorCodeSummary$;
import org.apache.linkis.orchestrator.exception.OrchestratorLabelConflictException;
import org.apache.linkis.orchestrator.exception.OrchestratorRetryException;
import org.apache.linkis.orchestrator.listener.task.TaskLogEvent;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.concurrent.duration.Duration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001B\u0010!\u00015BQ\u0001\u0011\u0001\u0005\u0002\u0005Cqa\u0011\u0001C\u0002\u0013%A\t\u0003\u0004V\u0001\u0001\u0006I!\u0012\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u0019!\u0007\u0001)A\u00051\"9Q\r\u0001b\u0001\n\u00131\u0007BB7\u0001A\u0003%q\rC\u0004o\u0001\t\u0007I\u0011\u00024\t\r=\u0004\u0001\u0015!\u0003h\u0011\u001d\u0001\bA1A\u0005\nEDa\u0001\u001f\u0001!\u0002\u0013\u0011\b\"B=\u0001\t\u0003R\bBB=\u0001\t\u0003\ny\u0002C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005%\u0002\u0001\"\u0005\u0002,!9\u00111\b\u0001\u0005\n\u0005u\u0002bBA(\u0001\u0011\u0005\u0013\u0011\u000b\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\tY\u0007\u0001C!\u0003[Bq!a\u001c\u0001\t\u0013\t\t\bC\u0005\u00028\u0002\t\n\u0011\"\u0003\u0002:\"9\u0011q\u001a\u0001\u0005\n\u0005E\u0007bBAk\u0001\u0011\u0005\u0013q\u001b\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\ti\u000f\u0001C!\u0003_Dq!a>\u0001\t\u0003\nI\u0010C\u0004\u0002~\u0002!\t&a@\t\u000f\t\u001d\u0001\u0001\"\u0015\u0003\n!9!q\u0002\u0001\u0005R\tE\u0001b\u0002B\f\u0001\u0011\u0005#\u0011\u0004\u0002#\t\u00164\u0017-\u001e7u\u0007>$W-\u0012=fGR\u000b7o[#yK\u000e,Ho\u001c:NC:\fw-\u001a:\u000b\u0005\u0005\u0012\u0013aB3yK\u000e,H/\u001a\u0006\u0003G\u0011\n1bY8naV$\u0018\r^5p]*\u0011QEJ\u0001\r_J\u001c\u0007.Z:ue\u0006$xN\u001d\u0006\u0003O!\na\u0001\\5oW&\u001c(BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001]QB\u0004CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB!osJ+g\r\u0005\u00026m5\t\u0001%\u0003\u00028A\tY2i\u001c3f\u000bb,7\rV1tW\u0016CXmY;u_Jl\u0015M\\1hKJ\u0004\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\u000bU$\u0018\u000e\\:\u000b\u0005u2\u0013AB2p[6|g.\u0003\u0002@u\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001C!\t)\u0004!A\nj]N$\u0018M\\2f)>,\u00050Z2vi>\u00148/F\u0001F!\u00111Uj\u0014*\u000e\u0003\u001dS!\u0001S%\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002K\u0017\u0006!Q\u000f^5m\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT$\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u00026!&\u0011\u0011\u000b\t\u0002\u0013\u000b:<\u0017N\\3D_:tG+Y:l\u0013:4w\u000e\u0005\u00026'&\u0011A\u000b\t\u0002\u0015\u0007>$W-\u0012=fGR\u000b7o[#yK\u000e,Ho\u001c:\u0002)%t7\u000f^1oG\u0016$v.\u0012=fGV$xN]:!\u0003I)\u00070Z2UCN\\Gk\\#yK\u000e,Ho\u001c:\u0016\u0003a\u0003BAR'Z%B\u0011!,\u0019\b\u00037~\u0003\"\u0001\u0018\u0019\u000e\u0003uS!A\u0018\u0017\u0002\rq\u0012xn\u001c;?\u0013\t\u0001\u0007'\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\u000e\u0014aa\u0015;sS:<'B\u000111\u0003M)\u00070Z2UCN\\Gk\\#yK\u000e,Ho\u001c:!\u0003a!WMZ1vYR,enZ5oK\u000e{gN\\'b]\u0006<WM]\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\u0011!\u000eJ\u0001\u0004K\u000el\u0017B\u00017j\u0005E)enZ5oK\u000e{gN\\'b]\u0006<WM]\u0001\u001aI\u00164\u0017-\u001e7u\u000b:<\u0017N\\3D_:tW*\u00198bO\u0016\u0014\b%\u0001\fmC\n,G.\u00128hS:,7i\u001c8o\u001b\u0006t\u0017mZ3s\u0003]a\u0017MY3m\u000b:<\u0017N\\3D_:tW*\u00198bO\u0016\u0014\b%\u0001\u0005xC&$Hj\\2l+\u0005\u0011\bcA\u0018tk&\u0011A\u000f\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003_YL!a\u001e\u0019\u0003\t\tKH/Z\u0001\no\u0006LG\u000fT8dW\u0002\n1\"Y:l\u000bb,7-\u001e;peR!1P`A\u0007!\ryCPU\u0005\u0003{B\u0012aa\u00149uS>t\u0007BB@\r\u0001\u0004\t\t!\u0001\u0005fq\u0016\u001cG+Y:l!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004E\u0005A\u0001\u000f[=tS\u000e\fG.\u0003\u0003\u0002\f\u0005\u0015!aF\"pI\u0016dunZ5dC2,f.\u001b;Fq\u0016\u001cG+Y:l\u0011\u001d\ty\u0001\u0004a\u0001\u0003#\tAa^1jiB!\u00111CA\u000e\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005!\u0003\u0014\u0002BA\u000f\u0003+\u0011\u0001\u0002R;sCRLwN\u001c\u000b\u0004w\u0006\u0005\u0002BB@\u000e\u0001\u0004\t\t!\u0001\bde\u0016\fG/Z#yK\u000e,Ho\u001c:\u0015\u0007I\u000b9\u0003\u0003\u0004\u0000\u001d\u0001\u0007\u0011\u0011A\u0001\u000eGJ,\u0017\r^3NCJ\\'+Z9\u0015\t\u00055\u0012\u0011\b\t\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111G5\u0002\r\u0015tG/\u001b;z\u0013\u0011\t9$!\r\u0003\u000f5\u000b'o\u001b*fc\"1qp\u0004a\u0001\u0003\u0003\t1b^1ji\u001a{'/\u00133mKR!\u0011qHA#!\ry\u0013\u0011I\u0005\u0004\u0003\u0007\u0002$\u0001B+oSRDq!a\u0012\u0011\u0001\u0004\tI%\u0001\u0005xC&$H+[7f!\ry\u00131J\u0005\u0004\u0003\u001b\u0002$\u0001\u0002'p]\u001e\f\u0001dZ3u\u0005f,enZ5oK\u000e{gN\\!oIR\u000b7o[%e)\u0015Y\u00181KA0\u0011\u001d\t)&\u0005a\u0001\u0003/\nqb]3sm&\u001cW-\u00138ti\u0006t7-\u001a\t\u0005\u00033\nY&D\u0001=\u0013\r\ti\u0006\u0010\u0002\u0010'\u0016\u0014h/[2f\u0013:\u001cH/\u00198dK\"1\u0011\u0011M\tA\u0002e\u000b\u0001#\u001a8hS:,7i\u001c8o)\u0006\u001c8.\u00133\u0002\u001f\u001d,GOQ=Fq\u0016\u001cG+Y:l\u0013\u0012$2a_A4\u0011\u0019\tIG\u0005a\u00013\u0006QQ\r_3d)\u0006\u001c8.\u00133\u0002\u0011MDW\u000f\u001e3po:$\"!a\u0010\u0002#\rdW-\u0019:Fq\u0016\u001cW\u000f^8s\u0005fLE\r\u0006\u0005\u0002@\u0005M\u0014qOAW\u0011\u0019\t)\b\u0006a\u0001%\u0006AQ\r_3dkR|'\u000fC\u0004\u0002zQ\u0001\r!a\u001f\u0002\r1\f'-\u001a7t!\u0019\ti(a \u0002\u00046\t\u0011*C\u0002\u0002\u0002&\u0013A\u0001T5tiB\"\u0011QQAN!\u0019\t9)a%\u0002\u00186\u0011\u0011\u0011\u0012\u0006\u0005\u0003g\tYI\u0003\u0003\u0002\u000e\u0006=\u0015!\u00027bE\u0016d'bAAIM\u00059Q.\u00198bO\u0016\u0014\u0018\u0002BAK\u0003\u0013\u0013Q\u0001T1cK2\u0004B!!'\u0002\u001c2\u0001A\u0001DAO\u0003o\n\t\u0011!A\u0003\u0002\u0005}%aA0%cE!\u0011\u0011UAT!\ry\u00131U\u0005\u0004\u0003K\u0003$a\u0002(pi\"Lgn\u001a\t\u0004_\u0005%\u0016bAAVa\t\u0019\u0011I\\=\t\u0013\u0005=F\u0003%AA\u0002\u0005E\u0016\u0001\u00044pe\u000e,'+\u001a7fCN,\u0007cA\u0018\u00024&\u0019\u0011Q\u0017\u0019\u0003\u000f\t{w\u000e\\3b]\u0006Y2\r\\3be\u0016CXmY;u_J\u0014\u00150\u00133%I\u00164\u0017-\u001e7uIM*\"!a/+\t\u0005E\u0016QX\u0016\u0003\u0003\u007f\u0003B!!1\u0002L6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\f9-A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u001a\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002N\u0006\r'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)#/Z7pm\u0016,\u00050Z2vi>\u0014hI]8n\u0013:\u001cH/\u00198dKR{W\t_3dkR|'o\u001d\u000b\u0005\u0003\u007f\t\u0019\u000e\u0003\u0004\u0002vY\u0001\rAU\u0001\u0016C\u0012$WI\\4j]\u0016\u001cuN\u001c8UCN\\\u0017J\u001c4p)\u0011\ty$!7\t\r\u0005Ut\u00031\u0001S\u0003Q9W\r^#oO&tWmQ8o]6\u000bg.Y4feR\u0019q-a8\t\u000f\u0005e\u0004\u00041\u0001\u0002bB1\u0011QPA@\u0003G\u0004D!!:\u0002jB1\u0011qQAJ\u0003O\u0004B!!'\u0002j\u0012a\u00111^Ap\u0003\u0003\u0005\tQ!\u0001\u0002 \n\u0019q\f\n\u001a\u0002;\u001d,G/\u00117m\u0013:\u001cH/\u00198dKR{W\t_3dkR|'oQ1dQ\u0016$\"!!=\u0011\r\u0005u\u00141_(S\u0013\r\t)0\u0013\u0002\u0004\u001b\u0006\u0004\u0018!H4fi\u0006cG.\u0012=fGR\u000b7o\u001b+p\u000bb,7-\u001e;pe\u000e\u000b7\r[3\u0015\u0005\u0005m\bCBA?\u0003gL&+\u0001\tv]2{7m[#oO&tWmQ8o]R1\u0011q\bB\u0001\u0005\u0007Aaa`\u000eA\u0002\u0005\u0005\u0001B\u0002B\u00037\u0001\u0007!+\u0001\tfq\u0016\u001cG+Y:l\u000bb,7-\u001e;pe\u0006aQ.\u0019:l\u000b\u000e3\u0015-\u001b7fIR1\u0011q\bB\u0006\u0005\u001bAaa \u000fA\u0002\u0005\u0005\u0001BBA;9\u0001\u0007!+\u0001\u0004eK2,G/\u001a\u000b\u0007\u0003\u007f\u0011\u0019B!\u0006\t\r}l\u0002\u0019AA\u0001\u0011\u0019\t)(\ba\u0001%\u0006\tR.\u0019:l)\u0006\u001c8nQ8na2,G/\u001a3\u0015\u0011\u0005}\"1\u0004B\u000f\u0005?Aaa \u0010A\u0002\u0005\u0005\u0001BBA;=\u0001\u0007!\u000bC\u0004\u0003\"y\u0001\r!!-\u0002\u0013%\u001c8+^2dK\u0016$\u0007")
public class DefaultCodeExecTaskExecutorManager
implements CodeExecTaskExecutorManager,
Logging {
    private final ConcurrentHashMap<EngineConnTaskInfo, CodeExecTaskExecutor> instanceToExecutors;
    private final ConcurrentHashMap<String, CodeExecTaskExecutor> execTaskToExecutor;
    private final EngineConnManager defaultEngineConnManager;
    private final EngineConnManager labelEngineConnManager;
    private final byte[] waitLock;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    @Override
    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    @Override
    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    @Override
    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    @Override
    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DefaultCodeExecTaskExecutorManager defaultCodeExecTaskExecutorManager = this;
        synchronized (defaultCodeExecTaskExecutorManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ConcurrentHashMap<EngineConnTaskInfo, CodeExecTaskExecutor> instanceToExecutors() {
        return this.instanceToExecutors;
    }

    private ConcurrentHashMap<String, CodeExecTaskExecutor> execTaskToExecutor() {
        return this.execTaskToExecutor;
    }

    private EngineConnManager defaultEngineConnManager() {
        return this.defaultEngineConnManager;
    }

    private EngineConnManager labelEngineConnManager() {
        return this.labelEngineConnManager;
    }

    private byte[] waitLock() {
        return this.waitLock;
    }

    @Override
    public Option<CodeExecTaskExecutor> askExecutor(CodeLogicalUnitExecTask execTask, Duration wait) {
        this.logger().info(new StringBuilder(39).append("Start to askExecutor for execId ").append(execTask.getIDInfo()).append(", wait ").append(wait).toString());
        long startTime = System.currentTimeMillis();
        ObjectRef retryException = ObjectRef.create(null);
        None$ executor = None$.MODULE$;
        while (System.currentTimeMillis() - startTime < wait.toMillis() && executor.isEmpty()) {
            Option option = (Option)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> this.askExecutor(execTask), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                Throwable throwable = x0$1;
                if (throwable instanceof LinkisRetryException) {
                    LinkisRetryException linkisRetryException = (LinkisRetryException)throwable;
                    this.logger().warn("request engine failed!", (Throwable)linkisRetryException);
                    retryException$1.elem = linkisRetryException;
                    return None$.MODULE$;
                }
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    throw throwable2;
                }
                throw new MatchError((Object)throwable);
            });
            if (option instanceof Some) {
                Some some = (Some)option;
                CodeExecTaskExecutor e = (CodeExecTaskExecutor)some.value();
                this.logger().info(new StringBuilder(42).append("Finished to askExecutor for execId ").append(execTask.getIDInfo()).append(", wait ").append(System.currentTimeMillis() - startTime).toString());
                executor = Option$.MODULE$.apply((Object)e);
                continue;
            }
            if (System.currentTimeMillis() - startTime >= wait.toMillis()) continue;
            long interval = package$.MODULE$.min(3000L, wait.toMillis() - System.currentTimeMillis() + startTime);
            this.waitForIdle(interval);
        }
        if ((LinkisRetryException)retryException.elem != null && executor.isEmpty()) {
            throw (LinkisRetryException)retryException.elem;
        }
        return executor;
    }

    @Override
    public Option<CodeExecTaskExecutor> askExecutor(CodeLogicalUnitExecTask execTask) {
        this.logger().debug(new StringBuilder(32).append("Start to askExecutor for execId ").append(execTask.getIDInfo()).toString());
        CodeExecTaskExecutor executor = this.createExecutor(execTask);
        this.logger().info(new StringBuilder(35).append("Finished to askExecutor for execId ").append(execTask.getIDInfo()).toString());
        return Option$.MODULE$.apply((Object)executor);
    }

    @Override
    public CodeExecTaskExecutor createExecutor(CodeLogicalUnitExecTask execTask) {
        EngineConnManager engineConnManager = this.getEngineConnManager(execTask.getLabels());
        MarkReq markReq = this.createMarkReq(execTask);
        ExecuteOnceLabel executeOnceLabel = LabelUtil$.MODULE$.getExecuteOnceLabel(execTask.getLabels());
        LoadBalanceLabel loadBalanceLabel = LabelUtil$.MODULE$.getLoadBalanceLabel(execTask.getLabels());
        if (executeOnceLabel != null && loadBalanceLabel != null) {
            throw new OrchestratorLabelConflictException(new StringBuilder(60).append("ExecuteOnceLabel : ").append(markReq.getLabels().get("executeOnce")).append(" should not come with LoadBalanceLabel : ").append(markReq.getLabels().get("loadBalance")).toString());
        }
        Mark mark = engineConnManager.applyMark(markReq);
        markReq.setCreateService(new StringBuilder(9).append(markReq.getCreateService()).append("mark_id: ").append(mark.getMarkId()).toString());
        this.logger().info(new StringBuilder(46).append("create Executor for execId ").append(execTask.getIDInfo()).append(" mark id is ").append(mark.getMarkId()).append(", user ").append(mark.getMarkReq().getUser()).toString());
        execTask.getPhysicalContext().pushLog(new TaskLogEvent((ExecTask)execTask, LogUtils$.MODULE$.generateInfo(new StringBuilder(83).append("Background is starting a new engine for you(\u60a8\u7684\u4efb\u52a1\u6b63\u5728\u8bf7\u6c42\u5f15\u64ce\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85)").append(", execId ").append(execTask.getIDInfo()).append(" mark id is ").append(mark.getMarkId()).toString())));
        EngineConnExecutor engineConnExecutor = engineConnManager.getAvailableEngineConnExecutor(mark, execTask);
        if (engineConnExecutor == null) {
            return null;
        }
        CodeExecTaskExecutor codeExecTaskExecutor = new CodeExecTaskExecutor(engineConnExecutor, (ExecTask)execTask, mark);
        Object object = codeExecTaskExecutor != null ? this.execTaskToExecutor().put(execTask.getId(), codeExecTaskExecutor) : BoxedUnit.UNIT;
        this.logger().info(new StringBuilder(58).append("Finished to create Executor for execId ").append(execTask.getIDInfo()).append(" mark id is ").append(mark.getMarkId()).append(", user ").append(mark.getMarkReq().getUser()).toString());
        return codeExecTaskExecutor;
    }

    public MarkReq createMarkReq(CodeLogicalUnitExecTask execTask) {
        LoadBanlanceMarkReq markReq;
        block4: {
            HashMap<String, String> hashMap;
            DefaultMarkReq defaultMarkReq;
            LoadBalanceLabel loadBalanceLabel = LabelUtil$.MODULE$.getLoadBalanceLabel(execTask.getLabels());
            if (loadBalanceLabel != null) {
                defaultMarkReq = new LoadBanlanceMarkReq();
            } else {
                DefaultMarkReq defaultMarkReq2 = new DefaultMarkReq();
                defaultMarkReq2.registerLabelKey("bindEngine");
                defaultMarkReq = defaultMarkReq2;
            }
            markReq = defaultMarkReq;
            markReq.setPolicyObj(Policy.Task);
            markReq.setCreateService((String)ComputationOrchestratorConf$.MODULE$.DEFAULT_CREATE_SERVICE().getValue());
            markReq.setEngineConnCount(BoxesRunTime.unboxToInt((Object)ComputationOrchestratorConf$.MODULE$.DEFAULT_MARK_MAX_ENGINE().getValue()));
            if (execTask.getParams().getStartupParams() == null) {
                hashMap = new HashMap<String, String>();
            } else {
                scala.collection.mutable.Map startupMap = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(execTask.getParams().getStartupParams().getConfigurationMap()).asScala();
                HashMap properties = new HashMap();
                startupMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Object v = tuple2._2();
                        if (v != null && StringUtils.isNotEmpty((CharSequence)v.toString())) {
                            return properties.put(k, v.toString());
                        }
                        return BoxedUnit.UNIT;
                    }
                    throw new MatchError((Object)tuple2);
                });
                hashMap = properties;
            }
            HashMap<String, String> properties = hashMap;
            markReq.setProperties(properties);
            markReq.setUser(execTask.getExecuteUser());
            if (execTask.getLabels() == null) break block4;
            markReq.setLabels(LabelUtils.labelsToMap(execTask.getLabels()));
        }
        return markReq;
    }

    private void waitForIdle(long waitTime) {
        byte[] byArray = this.waitLock();
        synchronized (byArray) {
            this.waitLock().wait(waitTime);
        }
    }

    @Override
    public Option<CodeExecTaskExecutor> getByEngineConnAndTaskId(ServiceInstance serviceInstance, String engineConnTaskId) {
        CodeExecTaskExecutor maybeExecutors = this.instanceToExecutors().get(new EngineConnTaskInfo(serviceInstance, engineConnTaskId));
        if (maybeExecutors != null) {
            String string = maybeExecutors.getEngineConnTaskId();
            String string2 = engineConnTaskId;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Some((Object)maybeExecutors);
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<CodeExecTaskExecutor> getByExecTaskId(String execTaskId) {
        CodeExecTaskExecutor executor = this.execTaskToExecutor().get(execTaskId);
        return Option$.MODULE$.apply((Object)executor);
    }

    @Override
    public void shutdown() {
    }

    private void clearExecutorById(CodeExecTaskExecutor executor, List<Label<?>> labels, boolean forceRelease) {
        Object object;
        if (executor == null || executor.getEngineConnExecutor() == null) {
            return;
        }
        LoadBalanceLabel loadBalanceLabel = LabelUtil$.MODULE$.getLoadBalanceLabel(labels);
        if (loadBalanceLabel == null || forceRelease) {
            this.logger().info(new StringBuilder(31).append("To release engine ConnExecutor ").append(executor).toString());
            object = Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.getEngineConnManager(labels).releaseEngineConnExecutor(executor.getEngineConnExecutor(), executor.getMark()), this.logger());
        } else {
            this.logger().info(new StringBuilder(55).append("Task has loadBalanceLabel, Not need to delete executor ").append(executor).toString());
            object = BoxedUnit.UNIT;
        }
        this.removeExecutorFromInstanceToExecutors(executor);
    }

    private boolean clearExecutorById$default$3() {
        return false;
    }

    private void removeExecutorFromInstanceToExecutors(CodeExecTaskExecutor executor) {
        this.logger().debug(new StringBuilder(57).append("To delete codeExecTaskExecutor  ").append(executor).append(" from instanceToExecutors").toString());
        EngineConnTaskInfo engineConnTaskInfo = new EngineConnTaskInfo(executor.getEngineConnExecutor().getServiceInstance(), executor.getEngineConnTaskId());
        this.instanceToExecutors().remove(engineConnTaskInfo);
        this.execTaskToExecutor().remove(executor.getExecTaskId());
        this.logger().info(new StringBuilder(55).append("To delete exec task ").append(executor.getExecTask().getIDInfo()).append(" and CodeExecTaskExecutor ").append(executor.getEngineConnExecutor().getServiceInstance()).append(" relation").toString());
    }

    @Override
    public void addEngineConnTaskInfo(CodeExecTaskExecutor executor) {
        if (executor == null || StringUtils.isBlank((CharSequence)executor.getExecTaskId())) {
            throw new OrchestratorRetryException(OrchestratorErrorCodeSummary$.MODULE$.EXECUTION_ERROR_CODE(), "Failed to store task information");
        }
        EngineConnTaskInfo engineConnTaskInfo = new EngineConnTaskInfo(executor.getEngineConnExecutor().getServiceInstance(), executor.getEngineConnTaskId());
        this.instanceToExecutors().put(engineConnTaskInfo, executor);
        this.logger().info(new StringBuilder(61).append("Finished To add codeExecTaskExecutor  ").append(executor).append(" to instanceToExecutors").toString());
    }

    private EngineConnManager getEngineConnManager(List<Label<?>> labels) {
        if (labels == null || labels.isEmpty()) {
            return this.defaultEngineConnManager();
        }
        if (((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(labels).asScala()).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultCodeExecTaskExecutorManager.$anonfun$getEngineConnManager$1(x$1)))) {
            return this.labelEngineConnManager();
        }
        return this.defaultEngineConnManager();
    }

    @Override
    public Map<EngineConnTaskInfo, CodeExecTaskExecutor> getAllInstanceToExecutorCache() {
        return this.instanceToExecutors();
    }

    @Override
    public Map<String, CodeExecTaskExecutor> getAllExecTaskToExecutorCache() {
        return this.execTaskToExecutor();
    }

    @Override
    public void unLockEngineConn(CodeLogicalUnitExecTask execTask, CodeExecTaskExecutor execTaskExecutor) {
        this.logger().info(new StringBuilder(51).append(execTask.getIDInfo()).append(" task be killed or failed , Now to delete executor ").append(execTaskExecutor.getEngineConnExecutor().getServiceInstance()).toString());
        this.clearExecutorById(execTaskExecutor, execTask.getLabels(), this.clearExecutorById$default$3());
    }

    @Override
    public void markECFailed(CodeLogicalUnitExecTask execTask, CodeExecTaskExecutor executor) {
        this.logger().info(new StringBuilder(60).append(execTask.getIDInfo()).append(" task  failed because executor exit, Now to delete executor ").append(executor.getEngineConnExecutor().getServiceInstance()).toString());
        this.clearExecutorById(executor, execTask.getLabels(), true);
    }

    @Override
    public void delete(CodeLogicalUnitExecTask execTask, CodeExecTaskExecutor executor) {
        BindEngineLabel jobGroupLabel = LabelUtil$.MODULE$.getBindEngineLabel(execTask.getLabels());
        boolean isEndJob = false;
        String jobGroupId = "";
        if (jobGroupLabel != null) {
            isEndJob = jobGroupLabel.getIsJobGroupEnd();
            jobGroupId = jobGroupLabel.getJobGroupId();
            if (isEndJob) {
                this.logger().debug(new StringBuilder(85).append("To delete codeExecTaskExecutor  ").append(executor).append(" from execTaskToExecutor for lastjob of jobGroupId : ").append(jobGroupId).toString());
                this.clearExecutorById(executor, execTask.getLabels(), this.clearExecutorById$default$3());
                return;
            }
            this.removeExecutorFromInstanceToExecutors(executor);
            this.logger().info(new StringBuilder(93).append("Subjob is not end of JobGroup with id : ").append(jobGroupId).append(", we will not delete codeExecTaskExecutor with id : ").append(executor).append(" ").toString());
            return;
        }
        this.logger().debug(new StringBuilder(58).append("To delete codeExecTaskExecutor  ").append(executor).append("  from execTaskToExecutor.").toString());
        this.clearExecutorById(executor, execTask.getLabels(), this.clearExecutorById$default$3());
    }

    @Override
    public void markTaskCompleted(CodeLogicalUnitExecTask execTask, CodeExecTaskExecutor executor, boolean isSucceed) {
        Object object;
        if (isSucceed) {
            this.logger().debug(new StringBuilder(47).append("ExecTask(").append(execTask.getIDInfo()).append(") execute  success executor be delete.").toString());
            object = Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete(execTask, executor), this.logger());
        } else if (StringUtils.isBlank((CharSequence)executor.getEngineConnTaskId())) {
            this.logger().error(new StringBuilder(78).append(execTask.getIDInfo()).append(" Failed to submit running, now to remove  codeEngineConnExecutor, forceRelease").toString());
            object = Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.markECFailed(execTask, executor), this.logger());
        } else {
            this.logger().debug(new StringBuilder(46).append("ExecTask(").append(execTask.getIDInfo()).append(") execute  failed executor be unLock.").toString());
            object = Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.unLockEngineConn(execTask, executor), this.logger());
        }
        if (executor != null && executor.getEngineConnExecutor() != null) {
            executor.getEngineConnExecutor().removeTask(executor.getEngineConnTaskId());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getEngineConnManager$1(Label x$1) {
        return x$1 instanceof LoadBalanceLabel;
    }

    public DefaultCodeExecTaskExecutorManager() {
        Logging.$init$((Logging)this);
        this.instanceToExecutors = new ConcurrentHashMap();
        this.execTaskToExecutor = new ConcurrentHashMap();
        EngineConnManagerBuilder builder = EngineConnManagerBuilder$.MODULE$.builder();
        builder.setPolicy(Policy.Process);
        this.defaultEngineConnManager = builder.build();
        EngineConnManagerBuilder builder2 = EngineConnManagerBuilder$.MODULE$.builder();
        builder2.setPolicy(Policy.Label);
        this.labelEngineConnManager = builder2.build();
        this.waitLock = new byte[0];
    }
}

