/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.memtarget;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTargetVisitor;
import org.apache.spark.annotation.Experimental;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class DynamicOffHeapSizingMemoryTarget
implements MemoryTarget {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicOffHeapSizingMemoryTarget.class);
    private final MemoryTarget delegated;
    private static final long MAX_MEMORY_IN_BYTES = GlutenConfig.get().offHeapMemorySize();
    private static final AtomicLong USED_OFFHEAP_BYTES = new AtomicLong();

    public DynamicOffHeapSizingMemoryTarget(MemoryTarget delegated) {
        this.delegated = delegated;
    }

    @Override
    public long borrow(long size) {
        if (size == 0L) {
            return 0L;
        }
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedOnHeapBytes = totalMemory - freeMemory;
        long usedOffHeapBytesNow = USED_OFFHEAP_BYTES.get();
        if (size + usedOffHeapBytesNow + usedOnHeapBytes > MAX_MEMORY_IN_BYTES) {
            LOG.warn(String.format("Failing allocation as unified memory is OOM. Used Off-heap: %d, Used On-Heap: %d, Free On-heap: %d, Total On-heap: %d, Max On-heap: %d, Allocation: %d.", usedOffHeapBytesNow, usedOnHeapBytes, freeMemory, totalMemory, MAX_MEMORY_IN_BYTES, size));
            return 0L;
        }
        long reserved = this.delegated.borrow(size);
        USED_OFFHEAP_BYTES.addAndGet(reserved);
        return reserved;
    }

    @Override
    public long repay(long size) {
        long unreserved = this.delegated.repay(size);
        USED_OFFHEAP_BYTES.addAndGet(-unreserved);
        return unreserved;
    }

    @Override
    public long usedBytes() {
        return this.delegated.usedBytes();
    }

    @Override
    public <T> T accept(MemoryTargetVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public MemoryTarget delegated() {
        return this.delegated;
    }
}

