/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.rest.security.AclPermission;
import org.springframework.security.acls.model.Permission;

public class CompositeAclPermission
extends AclPermission {
    private Permission basePermission;
    private List<Permission> extPermissions;

    public CompositeAclPermission(Permission basePerm) {
        this(basePerm, new ArrayList<Permission>());
    }

    public CompositeAclPermission(Permission basePermission, List<Permission> extPermissions) {
        super(basePermission.getMask() + (!CollectionUtils.isEmpty(extPermissions) ? extPermissions.stream().collect(Collectors.summingInt(Permission::getMask)) : 0));
        this.basePermission = basePermission;
        this.extPermissions = extPermissions;
    }

    public CompositeAclPermission addExtPermission(Permission extPerm) {
        if (CollectionUtils.isEmpty(this.extPermissions)) {
            this.extPermissions = new ArrayList<Permission>();
        }
        this.extPermissions.add(extPerm);
        return this;
    }

    public List<Integer> getExtMasks() {
        if (CollectionUtils.isEmpty(this.extPermissions)) {
            return Collections.emptyList();
        }
        return this.extPermissions.stream().map(Permission::getMask).collect(Collectors.toList());
    }

    @Generated
    public void setBasePermission(Permission basePermission) {
        this.basePermission = basePermission;
    }

    @Generated
    public void setExtPermissions(List<Permission> extPermissions) {
        this.extPermissions = extPermissions;
    }

    @Generated
    public Permission getBasePermission() {
        return this.basePermission;
    }

    @Generated
    public List<Permission> getExtPermissions() {
        return this.extPermissions;
    }
}

