/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.table;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.metadata.table.InternalTablePartitionDetail;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class InternalTablePartition
implements Serializable {
    @JsonProperty(value="partition_columns")
    private String[] partitionColumns;
    @JsonProperty(value="partition_values")
    private List<String> partitionValues;
    @JsonProperty(value="date_partition_format")
    private String datePartitionFormat;
    @JsonProperty(value="partition_details")
    private List<InternalTablePartitionDetail> partitionDetails;

    public InternalTablePartition(String[] partitionColumns, String datePartitionFormat) {
        this.partitionColumns = partitionColumns;
        this.datePartitionFormat = datePartitionFormat;
    }

    @Generated
    public String[] getPartitionColumns() {
        return this.partitionColumns;
    }

    @Generated
    public List<String> getPartitionValues() {
        return this.partitionValues;
    }

    @Generated
    public String getDatePartitionFormat() {
        return this.datePartitionFormat;
    }

    @Generated
    public List<InternalTablePartitionDetail> getPartitionDetails() {
        return this.partitionDetails;
    }

    @Generated
    public void setPartitionColumns(String[] partitionColumns) {
        this.partitionColumns = partitionColumns;
    }

    @Generated
    public void setPartitionValues(List<String> partitionValues) {
        this.partitionValues = partitionValues;
    }

    @Generated
    public void setDatePartitionFormat(String datePartitionFormat) {
        this.datePartitionFormat = datePartitionFormat;
    }

    @Generated
    public void setPartitionDetails(List<InternalTablePartitionDetail> partitionDetails) {
        this.partitionDetails = partitionDetails;
    }

    @Generated
    public InternalTablePartition() {
    }

    public static class DefaultPartitionConditionBuilder {
        public static String buildDateRangeCondition(String datePartitionColumnName, String dateFormat, String startDate, String endDate) {
            return String.format(Locale.ROOT, "%s >= to_date('%s', '%s') AND %s < to_date('%s', '%s')", datePartitionColumnName, DateFormat.formatToDateStr((long)Long.parseLong(startDate), (String)dateFormat), dateFormat, datePartitionColumnName, DateFormat.formatToDateStr((long)Long.parseLong(endDate), (String)dateFormat), dateFormat);
        }

        public String buildTimeRangeCondition(String timePartitionColumnName, String startTime, String endTime) {
            return String.format(Locale.ROOT, "%s >= '%s' AND %s < '%s'", timePartitionColumnName, startTime, timePartitionColumnName, endTime);
        }

        public String buildTimeRangeCondition(String timePartitionColumnName, Long startTime, Long endTime) {
            return String.format(Locale.ROOT, "%s >= %d AND %s < %d", timePartitionColumnName, startTime, timePartitionColumnName, endTime);
        }
    }
}

