/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.candidate;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.metadata.cube.optimization.FrequencyMap;

public class LayoutMetric {
    private FrequencyMap frequencyMap;
    private LatencyMap latencyMap;

    public LayoutMetric(FrequencyMap frequencyMap, LatencyMap latencyMap) {
        this.frequencyMap = frequencyMap;
        this.latencyMap = latencyMap;
    }

    @Generated
    public FrequencyMap getFrequencyMap() {
        return this.frequencyMap;
    }

    @Generated
    public LatencyMap getLatencyMap() {
        return this.latencyMap;
    }

    @Generated
    public void setFrequencyMap(FrequencyMap frequencyMap) {
        this.frequencyMap = frequencyMap;
    }

    @Generated
    public void setLatencyMap(LatencyMap latencyMap) {
        this.latencyMap = latencyMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LayoutMetric)) {
            return false;
        }
        LayoutMetric other = (LayoutMetric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FrequencyMap this$frequencyMap = this.getFrequencyMap();
        FrequencyMap other$frequencyMap = other.getFrequencyMap();
        if (this$frequencyMap == null ? other$frequencyMap != null : !((Object)this$frequencyMap).equals(other$frequencyMap)) {
            return false;
        }
        LatencyMap this$latencyMap = this.getLatencyMap();
        LatencyMap other$latencyMap = other.getLatencyMap();
        return !(this$latencyMap == null ? other$latencyMap != null : !((Object)this$latencyMap).equals(other$latencyMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LayoutMetric;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FrequencyMap $frequencyMap = this.getFrequencyMap();
        result = result * 59 + ($frequencyMap == null ? 43 : ((Object)$frequencyMap).hashCode());
        LatencyMap $latencyMap = this.getLatencyMap();
        result = result * 59 + ($latencyMap == null ? 43 : ((Object)$latencyMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LayoutMetric(frequencyMap=" + this.getFrequencyMap() + ", latencyMap=" + this.getLatencyMap() + ")";
    }

    @Generated
    public LayoutMetric() {
    }

    public static class LatencyMap
    implements Serializable {
        @JsonIgnore
        private NavigableMap<Long, Long> totalLatencyMapPerDay = new TreeMap<Long, Long>();

        @JsonAnySetter
        public void add(String key, long value) {
            this.totalLatencyMapPerDay.put(Long.parseLong(key), value);
        }

        public void incLatency(long queryTime, long value) {
            long totalLatency = this.totalLatencyMapPerDay.getOrDefault(this.getDateInMillis(queryTime), 0L);
            this.totalLatencyMapPerDay.put(this.getDateInMillis(queryTime), totalLatency + value);
        }

        @JsonAnyGetter
        public Map<Long, Long> getMap() {
            return this.totalLatencyMapPerDay;
        }

        public LatencyMap merge(LatencyMap other) {
            other.getTotalLatencyMapPerDay().forEach((k, v) -> this.totalLatencyMapPerDay.merge((Long)k, (Long)v, Long::sum));
            return this;
        }

        @JsonIgnore
        public double getLatencyByDate(long queryTime) {
            return this.totalLatencyMapPerDay.get(this.getDateInMillis(queryTime)) == null ? 0.0 : (double)((Long)this.totalLatencyMapPerDay.get(this.getDateInMillis(queryTime))).longValue();
        }

        private long getDateInMillis(long queryTime) {
            return TimeUtil.getDayStart((long)queryTime);
        }

        @Generated
        public NavigableMap<Long, Long> getTotalLatencyMapPerDay() {
            return this.totalLatencyMapPerDay;
        }

        @Generated
        public void setTotalLatencyMapPerDay(NavigableMap<Long, Long> totalLatencyMapPerDay) {
            this.totalLatencyMapPerDay = totalLatencyMapPerDay;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LatencyMap)) {
                return false;
            }
            LatencyMap other = (LatencyMap)o;
            if (!other.canEqual(this)) {
                return false;
            }
            NavigableMap<Long, Long> this$totalLatencyMapPerDay = this.getTotalLatencyMapPerDay();
            NavigableMap<Long, Long> other$totalLatencyMapPerDay = other.getTotalLatencyMapPerDay();
            return !(this$totalLatencyMapPerDay == null ? other$totalLatencyMapPerDay != null : !this$totalLatencyMapPerDay.equals(other$totalLatencyMapPerDay));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LatencyMap;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NavigableMap<Long, Long> $totalLatencyMapPerDay = this.getTotalLatencyMapPerDay();
            result = result * 59 + ($totalLatencyMapPerDay == null ? 43 : $totalLatencyMapPerDay.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LayoutMetric.LatencyMap(totalLatencyMapPerDay=" + this.getTotalLatencyMapPerDay() + ")";
        }

        @Generated
        public LatencyMap(NavigableMap<Long, Long> totalLatencyMapPerDay) {
            this.totalLatencyMapPerDay = totalLatencyMapPerDay;
        }

        @Generated
        public LatencyMap() {
        }
    }
}

