/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.query.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.logging.LogOutputStream;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.guava30.shaded.common.base.Strings;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.query.QueryHistoryDAO;
import org.apache.kylin.metadata.query.QueryHistoryMapper;
import org.apache.kylin.metadata.query.QueryHistoryRealizationMapper;
import org.apache.kylin.metadata.query.QueryStatisticsMapper;
import org.apache.kylin.metadata.query.RDBMSQueryHistoryDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHisStoreUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryHisStoreUtil.class);
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static final String CREATE_QUERY_HISTORY_TABLE = "create.queryhistory.store.table";
    private static final String CREATE_QUERY_HISTORY_INDEX_PREFIX = "create.queryhistory.store.tableindex";
    private static final int CREATE_QUERY_HISTORY_INDEX_SIZE = 12;
    static final String[] QUERY_HISTORY_INDEX_NAMES = new String[12];
    private static final String CREATE_QUERY_HISTORY_REALIZATION_TABLE = "create.queryhistoryrealization.store.table";
    private static final String CREATE_QUERY_HISTORY_REALIZATION_INDEX1 = "create.queryhistoryrealization.store.tableindex1";
    private static final String CREATE_QUERY_HISTORY_REALIZATION_INDEX2 = "create.queryhistoryrealization.store.tableindex2";
    private static final String CREATE_QUERY_HISTORY_REALIZATION_INDEX3 = "create.queryhistoryrealization.store.tableindex3";
    private static final String CREATE_QUERY_HISTORY_REALIZATION_INDEX4 = "create.queryhistoryrealization.store.tableindex4";
    private static final String CREATE_QUERY_HISTORY_REALIZATION_INDEX5 = "create.queryhistoryrealization.store.tableindex5";
    private static final String CREATE_QUERY_HISTORY_REALIZATION_INDEX6 = "create.queryhistoryrealization.store.tableindex6";
    static final String[] QUERY_HISTORY_REALIZATION_INDEX_NAMES;

    private QueryHisStoreUtil() {
    }

    public static SqlSessionFactory getSqlSessionFactory(DataSource dataSource, String qhTableName, String qhRealizationTableName) {
        return (SqlSessionFactory)Singletons.getInstance((String)"query-history-sql-session-factory", SqlSessionFactory.class, clz -> {
            JdbcTransactionFactory transactionFactory = new JdbcTransactionFactory();
            Environment environment = new Environment("query history", (TransactionFactory)transactionFactory, dataSource);
            Configuration configuration = new Configuration(environment);
            configuration.setUseGeneratedKeys(true);
            configuration.setJdbcTypeForNull(JdbcType.NULL);
            configuration.addMapper(QueryHistoryMapper.class);
            configuration.addMapper(QueryHistoryRealizationMapper.class);
            configuration.addMapper(QueryStatisticsMapper.class);
            QueryHisStoreUtil.createQueryHistoryIfNotExist((BasicDataSource)dataSource, qhTableName);
            QueryHisStoreUtil.createQueryHistoryRealizationIfNotExist((BasicDataSource)dataSource, qhRealizationTableName);
            return new SqlSessionFactoryBuilder().build(configuration);
        });
    }

    private static void createQueryHistoryIfNotExist(BasicDataSource dataSource, String qhTableName) throws SQLException, IOException {
        try (Connection connection = dataSource.getConnection();){
            Properties properties = JdbcUtil.getProperties((BasicDataSource)dataSource);
            if (!JdbcUtil.isTableExists((Connection)connection, (String)qhTableName, (boolean)false)) {
                ScriptRunner sr = new ScriptRunner(connection);
                sr.setLogWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream(log), DEFAULT_CHARSET)));
                sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(String.format(Locale.ROOT, properties.getProperty(CREATE_QUERY_HISTORY_TABLE), qhTableName).getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
                log.info("Succeed to create query history table: {}", (Object)qhTableName);
            }
        }
        QueryHisStoreUtil.createIndexIfNotExist(dataSource, qhTableName, QUERY_HISTORY_INDEX_NAMES);
    }

    private static void createIndexIfNotExist(BasicDataSource dataSource, String tableName, String[] indexNames) {
        try (Connection connection = dataSource.getConnection();){
            for (int i = 0; i < indexNames.length; ++i) {
                String indexConfig = indexNames[i];
                String indexName = tableName + "_ix" + (i + 1);
                Properties properties = JdbcUtil.getProperties((BasicDataSource)dataSource);
                String sql = properties.getProperty(indexConfig);
                if (Strings.isNullOrEmpty((String)sql) || JdbcUtil.isIndexExists((Connection)connection, (String)tableName, (String)indexName, (boolean)false)) continue;
                ScriptRunner sr = new ScriptRunner(connection);
                sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(String.format(Locale.ROOT, properties.getProperty(indexConfig), tableName, tableName).getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
                log.info("Succeed to create table {} index: {}", (Object)tableName, (Object)indexName);
            }
        }
        catch (Exception e) {
            log.warn("Failed create index on table {}", (Object)tableName, (Object)e);
        }
    }

    private static void createQueryHistoryRealizationIfNotExist(BasicDataSource dataSource, String qhRealizationTableName) throws SQLException, IOException {
        try (Connection connection = dataSource.getConnection();){
            Properties properties = JdbcUtil.getProperties((BasicDataSource)dataSource);
            if (!JdbcUtil.isTableExists((Connection)connection, (String)qhRealizationTableName, (boolean)false)) {
                ScriptRunner sr = new ScriptRunner(connection);
                sr.setLogWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream(log), DEFAULT_CHARSET)));
                sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(String.format(Locale.ROOT, properties.getProperty(CREATE_QUERY_HISTORY_REALIZATION_TABLE), qhRealizationTableName).getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
            }
        }
        QueryHisStoreUtil.createIndexIfNotExist(dataSource, qhRealizationTableName, QUERY_HISTORY_REALIZATION_INDEX_NAMES);
    }

    public static void cleanQueryHistory() {
        try (SetThreadName ignored = new SetThreadName("QueryHistoryCleanWorker", new Object[0]);){
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            NProjectManager projectManager = NProjectManager.getInstance(config);
            QueryHisStoreUtil.getQueryHistoryDao().deleteQueryHistoriesIfMaxSizeReached();
            QueryHisStoreUtil.getQueryHistoryDao().deleteQueryHistoriesIfRetainTimeReached();
            Map<String, Long> projectCounts = QueryHisStoreUtil.getQueryHistoryDao().getQueryCountByProject();
            for (ProjectInstance project : projectManager.listAllProjects()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Thread is interrupted: " + Thread.currentThread().getName());
                }
                long projectCount = projectCounts.getOrDefault(project.getName(), 0L);
                QueryHisStoreUtil.cleanQueryHistory(project.getName(), projectCount);
            }
        }
    }

    public static Long getQueryHistoryMinQueryTime() {
        return QueryHisStoreUtil.getQueryHistoryDao().getQueryHistoryMinQueryTime();
    }

    public static void cleanQueryHistory(String projectName, long historyCount) {
        long projectMaxSize = KylinConfig.getInstanceFromEnv().getQueryHistoryProjectMaxSize();
        if (historyCount <= projectMaxSize) {
            log.info("Query histories of project<{}> is less than the maximum limit, so skip it.", (Object)projectName);
            return;
        }
        try {
            StopWatch watch = StopWatch.createStarted();
            log.info("Start to delete query histories that are beyond max size for project<{}>, records:{}", (Object)projectName, (Object)historyCount);
            QueryHisStoreUtil.getQueryHistoryDao().deleteOldestQueryHistoriesByProject(projectName, (int)(historyCount - projectMaxSize));
            watch.stop();
            log.info("Query histories cleanup for project<{}> finished, it took {}ms", (Object)projectName, (Object)watch.getTime());
        }
        catch (Exception e) {
            log.error("Clean query histories for project<{}> failed", (Object)projectName, (Object)e);
        }
    }

    private static QueryHistoryDAO getQueryHistoryDao() {
        return RDBMSQueryHistoryDAO.getInstance();
    }

    static {
        for (int i = 0; i < 12; ++i) {
            QueryHisStoreUtil.QUERY_HISTORY_INDEX_NAMES[i] = CREATE_QUERY_HISTORY_INDEX_PREFIX + (i + 1);
        }
        QUERY_HISTORY_REALIZATION_INDEX_NAMES = new String[]{CREATE_QUERY_HISTORY_REALIZATION_INDEX1, CREATE_QUERY_HISTORY_REALIZATION_INDEX2, CREATE_QUERY_HISTORY_REALIZATION_INDEX3, CREATE_QUERY_HISTORY_REALIZATION_INDEX4, CREATE_QUERY_HISTORY_REALIZATION_INDEX5, CREATE_QUERY_HISTORY_REALIZATION_INDEX6};
    }
}

