/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.query;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.util.DaemonThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryThresholdUpdater {
    protected static final Logger logger = LoggerFactory.getLogger(BigQueryThresholdUpdater.class);
    private static final double SLOPE = 7.56178E-7;
    private static final double OFFSET = 1.95538E-8;
    private static final ThreadPoolExecutor updateThreadPool = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DaemonThreadFactory("big-query-threshold-updater-thread"));
    private static long lastUpdateTime = System.currentTimeMillis();
    private static long bigQueryThreshold = KapConfig.getInstanceFromEnv().getBigQuerySourceScanRowsThreshold();
    private static final Map<Long, StatInfo> queryScanRowsToStatsMap = new HashMap<Long, StatInfo>();

    private BigQueryThresholdUpdater() {
    }

    public static void initBigQueryThresholdBySparkResource(int instance, int core) {
        if (bigQueryThreshold < 0L) {
            double timeToRowCountRatio = 1.95538E-8 + 7.56178E-7 / (double)(instance * core);
            bigQueryThreshold = (long)((double)KapConfig.getInstanceFromEnv().getBigQuerySecond() / timeToRowCountRatio);
            logger.info("Init big query threshold auto, spark instanceNum: {}, coreNum:{}, timeToRowCountRatio:{}, bigQueryRowCountThreshold:{}", new Object[]{instance, core, timeToRowCountRatio, bigQueryThreshold});
        }
    }

    public static void resetBigQueryThreshold() {
        bigQueryThreshold = KapConfig.getInstanceFromEnv().getBigQuerySourceScanRowsThreshold();
    }

    public static void setLastUpdateTime(long updateTime) {
        lastUpdateTime = updateTime;
    }

    public static long getBigQueryThreshold() {
        return bigQueryThreshold;
    }

    public static void collectQueryScanRowsAndTime(long duration, long scanRows) {
        if (duration < KapConfig.getInstanceFromEnv().getBigQuerySecond() * 1000L || scanRows <= 0L) {
            return;
        }
        updateThreadPool.submit(() -> {
            StatInfo statInfo;
            if (queryScanRowsToStatsMap.containsKey(scanRows)) {
                statInfo = queryScanRowsToStatsMap.get(scanRows);
            } else {
                statInfo = new StatInfo();
                queryScanRowsToStatsMap.put(scanRows, statInfo);
            }
            statInfo.addDuration(duration);
            long now = System.currentTimeMillis();
            if (now - lastUpdateTime >= KapConfig.getInstanceFromEnv().getBigQueryThresholdUpdateIntervalSecond() * 1000L) {
                StringBuilder logRecord = new StringBuilder();
                logRecord.append("SampleCnt:").append(queryScanRowsToStatsMap.size()).append(";");
                long bigQueryThresholdUpdate = Long.MAX_VALUE;
                for (Map.Entry<Long, StatInfo> entry : queryScanRowsToStatsMap.entrySet()) {
                    StatInfo curStatInfo = entry.getValue();
                    if (curStatInfo.getCount() <= 0) continue;
                    long recordScanRows = entry.getKey();
                    double durationAvg = curStatInfo.getDurationAvg();
                    double durationVariance = curStatInfo.getDurationVariance();
                    logRecord.append("scanRows:").append(recordScanRows).append(",cnt:").append(curStatInfo.count).append(",avgTime:").append(durationAvg).append(",varTime:").append(durationVariance).append(";");
                    bigQueryThresholdUpdate = Math.min(bigQueryThresholdUpdate, recordScanRows);
                }
                if (bigQueryThresholdUpdate < Long.MAX_VALUE) {
                    bigQueryThreshold = bigQueryThresholdUpdate;
                    logRecord.append("updateThreshold:").append(bigQueryThreshold);
                }
                logger.info(logRecord.toString());
                BigQueryThresholdUpdater.setLastUpdateTime(now);
                queryScanRowsToStatsMap.clear();
            }
        });
    }

    public static class StatInfo {
        private int count;
        private double durationSum;
        private double durationSquareSum;

        public void addDuration(long durationMillis) {
            double durationSec = (double)durationMillis / 1000.0;
            ++this.count;
            this.durationSum += durationSec;
            this.durationSquareSum += durationSec * durationSec;
        }

        public double getDurationAvg() {
            return this.durationSum / (double)this.count;
        }

        public double getDurationVariance() {
            double durationAvg = this.getDurationAvg();
            return this.durationSquareSum / (double)this.count + durationAvg * durationAvg;
        }

        @Generated
        public int getCount() {
            return this.count;
        }
    }
}

