/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;

public class ExpandableMeasureUtil {
    private final BiConsumer<NDataModel, ComputedColumnDesc> evaluateExprAndType;

    public ExpandableMeasureUtil(BiConsumer<NDataModel, ComputedColumnDesc> evaluateExprAndType) {
        this.evaluateExprAndType = evaluateExprAndType;
    }

    public static void expandIndexPlanIndexes(IndexPlan plan, NDataModel model) {
        if (plan.getIndexes() == null) {
            return;
        }
        for (IndexEntity index : plan.getIndexes()) {
            if (index.getMeasures() == null) continue;
            HashSet measureIds = Sets.newHashSet(index.getMeasures());
            LinkedList expandedIds = Lists.newLinkedList();
            for (Integer measureId : index.getMeasures()) {
                if (!model.getEffectiveExpandedMeasures().containsKey(measureId)) continue;
                for (Integer internalId : model.getEffectiveExpandedMeasures().get(measureId)) {
                    if (measureIds.contains(internalId)) continue;
                    measureIds.add(internalId);
                    expandedIds.add(internalId);
                }
            }
            Collections.sort(expandedIds);
            index.getMeasures().addAll(expandedIds);
            if (index.getLayouts() == null) continue;
            for (LayoutEntity layout : index.getLayouts()) {
                ArrayList colOrders = Lists.newArrayList(layout.getColOrder());
                colOrders.addAll(expandedIds);
                layout.setColOrder(colOrders);
            }
        }
    }

    public static void expandRuleBasedIndex(RuleBasedIndex ruleBasedIndex, NDataModel model) {
        if (ruleBasedIndex == null || ruleBasedIndex.getAggregationGroups() == null) {
            return;
        }
        for (NAggregationGroup aggGrp : ruleBasedIndex.getAggregationGroups()) {
            if (aggGrp.getMeasures() == null) continue;
            HashSet measureIds = Sets.newHashSet((Object[])aggGrp.getMeasures());
            for (Integer measureId : aggGrp.getMeasures()) {
                if (!model.getEffectiveExpandedMeasures().containsKey(measureId)) continue;
                measureIds.addAll(model.getEffectiveExpandedMeasures().get(measureId));
            }
            Object[] newMeasureIds = measureIds.toArray(new Integer[0]);
            Arrays.sort(newMeasureIds);
            aggGrp.setMeasures((Integer[])newMeasureIds);
        }
        ruleBasedIndex.adjustMeasures();
        ruleBasedIndex.adjustDimensions();
    }

    public void deleteExpandableMeasureInternalMeasures(NDataModel model) {
        HashSet<Integer> toBeTombInternalIds = new HashSet<Integer>();
        HashSet<Integer> aliveInternalIds = new HashSet<Integer>();
        for (NDataModel.Measure measure : model.getAllMeasures()) {
            if (measure.getType() != NDataModel.MeasureType.EXPANDABLE) continue;
            if (measure.isTomb()) {
                toBeTombInternalIds.addAll(measure.getInternalIds());
                continue;
            }
            aliveInternalIds.addAll(measure.getInternalIds());
        }
        toBeTombInternalIds.removeAll(aliveInternalIds);
        for (NDataModel.Measure measure : model.getAllMeasures()) {
            if (measure.getType() != NDataModel.MeasureType.INTERNAL || !toBeTombInternalIds.contains(measure.getId())) continue;
            measure.setTomb(true);
        }
    }

    public void expandExpandableMeasure(NDataModel model) {
        ArrayList<NDataModel.Measure> measuresBefore = new ArrayList<NDataModel.Measure>(model.getAllMeasures());
        int nextCCIdx = 0;
        int nextMeasureIdx = 0;
        long ccCreationTs = System.currentTimeMillis();
        for (NDataModel.Measure measure : measuresBefore) {
            MeasureType measureType;
            if (measure.isTomb() || !(measureType = measure.getFunction().getMeasureType()).expandable()) continue;
            List<FunctionDesc> internalFuncs = measureType.convertToInternalFunctionDesc(measure.getFunction());
            for (FunctionDesc internalFunc : internalFuncs) {
                for (int i = 0; i < internalFunc.getParameters().size(); ++i) {
                    ParameterDesc param = internalFunc.getParameters().get(i);
                    if (!param.getType().equalsIgnoreCase("math_expression")) continue;
                    ComputedColumnDesc cc = this.findOrCreateCC(model, param.getValue(), ComputedColumnUtil.newAutoCCName(ccCreationTs, nextCCIdx++));
                    ParameterDesc ccParam = new ParameterDesc();
                    ccParam.setType("column");
                    ccParam.setValue(cc.getFullName());
                    internalFunc.getParameters().set(i, ccParam);
                }
            }
            int nextMid = model.getMaxMeasureId() + 1;
            LinkedList<NDataModel.Measure> missingInternalMeasures = new LinkedList<NDataModel.Measure>();
            LinkedList<Integer> internalMeasureIds = new LinkedList<Integer>();
            for (FunctionDesc internalFunc : internalFuncs) {
                try {
                    internalFunc.init(model);
                }
                catch (Exception ccParam) {
                    // empty catch block
                }
                boolean missing = true;
                for (NDataModel.Measure existingMeasure : model.getAllMeasures()) {
                    if (existingMeasure.isTomb() || !existingMeasure.getFunction().equals(internalFunc)) continue;
                    internalMeasureIds.add(existingMeasure.getId());
                    missing = false;
                    break;
                }
                if (!missing) continue;
                NDataModel.Measure missingInternalMeasure = new NDataModel.Measure();
                missingInternalMeasure.setId(nextMid++);
                missingInternalMeasure.setName(String.format(Locale.ROOT, "%s_%s_%s_%d", measure.getName(), internalFunc.getExpression(), internalFunc.getParameters().get(0).getValue().replaceAll("[^A-Za-z0-9]", "_"), nextMeasureIdx++));
                missingInternalMeasure.setFunction(internalFunc);
                missingInternalMeasure.setType(NDataModel.MeasureType.INTERNAL);
                missingInternalMeasures.add(missingInternalMeasure);
                internalMeasureIds.add(missingInternalMeasure.getId());
            }
            measure.setInternalIds(internalMeasureIds);
            measure.setType(NDataModel.MeasureType.EXPANDABLE);
            model.getAllMeasures().addAll(missingInternalMeasures);
        }
    }

    private ComputedColumnDesc findOrCreateCC(NDataModel model, String expr, String newCCName) {
        ComputedColumnDesc ccDesc = new ComputedColumnDesc();
        ccDesc.setExpression(expr);
        ComputedColumnDesc found = ComputedColumnUtil.findCCByExpr(Lists.newArrayList((Object[])new NDataModel[]{model}), ccDesc);
        if (found != null) {
            return found;
        }
        List<NDataModel> otherModels = NDataflowManager.getInstance(KylinConfig.getInstanceFromEnv(), model.getProject()).listUnderliningDataModels();
        found = ComputedColumnUtil.findCCByExpr(otherModels, ccDesc);
        if (found != null) {
            ccDesc = found;
        } else {
            ccDesc.setTableIdentity(model.getRootFactTableName());
            ccDesc.setTableAlias(model.getRootFactTable().getAlias());
            ccDesc.setComment("Auto generated for CORR measure");
            ccDesc.setDatatype("ANY");
            ccDesc.setExpression(expr);
            ccDesc.setColumnName(newCCName);
        }
        model.getComputedColumnDescs().add(ccDesc);
        this.evaluateExprAndType.accept(model, ccDesc);
        NDataModel.NamedColumn ccColumn = new NDataModel.NamedColumn();
        ccColumn.setName(ccDesc.getColumnName());
        ccColumn.setAliasDotColumn(ccDesc.getFullName());
        ccColumn.setId(model.getMaxColumnId() + 1);
        model.getAllNamedColumns().add(ccColumn);
        return ccDesc;
    }
}

