/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.BiMap;
import org.apache.kylin.guava30.shaded.common.collect.HashBiMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.BadModelException;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.alias.AliasDeduce;
import org.apache.kylin.metadata.model.alias.AliasMapping;
import org.apache.kylin.metadata.model.alias.ExpressionComparator;
import org.apache.kylin.metadata.model.graph.JoinsGraph;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;

public class ComputedColumnUtil {
    private static final Logger logger = LoggerFactory.getLogger(ComputedColumnUtil.class);
    public static final String CC_NAME_PREFIX = "CC_AUTO_";
    public static final String DEFAULT_CC_NAME = "CC_AUTO_1";
    private static RexStrExtractor EXTRACTOR = null;

    public static String newAutoCCName(long ts, int index) {
        return String.format(Locale.ROOT, "%s_%s_%s", CC_NAME_PREFIX, ts, index);
    }

    public static String uniqueCCName(String unique) {
        return String.format(Locale.ROOT, "%s_%s", CC_NAME_PREFIX, unique);
    }

    public static String shareCCNameAcrossModel(ComputedColumnDesc newCC, NDataModel newModel, List<NDataModel> otherModels) {
        try {
            JoinsGraph newCCGraph = ComputedColumnUtil.getCCExprRelatedSubgraph(newCC, newModel);
            for (NDataModel existingModel : otherModels) {
                for (ComputedColumnDesc existingCC : existingModel.getComputedColumnDescs()) {
                    JoinsGraph existCCGraph;
                    AliasMapping aliasMapping;
                    boolean sameCCExpr;
                    if (!StringUtils.equals((CharSequence)newCC.getTableIdentity(), (CharSequence)existingCC.getTableIdentity()) || !(sameCCExpr = ComputedColumnUtil.isSameCCExpr(existingCC, newCC, aliasMapping = ComputedColumnUtil.getAliasMappingFromJoinsGraph(newCCGraph, existCCGraph = ComputedColumnUtil.getCCExprRelatedSubgraph(existingCC, existingModel))))) continue;
                    return existingCC.getColumnName();
                }
            }
        }
        catch (Exception e) {
            logger.debug("share cc: '{}' name cross model fail", (Object)newCC.getExpression(), (Object)e);
            return null;
        }
        return null;
    }

    public static Set<String> getCCUsedColsWithProject(String project, ColumnDesc columnDesc) {
        NDataModel model = ComputedColumnUtil.getModel(project, columnDesc.getName());
        return ComputedColumnUtil.getCCUsedColsWithModel(model, columnDesc);
    }

    static Map<String, Set<String>> getCCUsedColsMapWithModel(NDataModel model, ColumnDesc columnDesc) {
        return ComputedColumnUtil.getCCUsedColsMap(model, columnDesc.getName());
    }

    public static Set<String> getCCUsedColsWithModel(NDataModel model, ColumnDesc columnDesc) {
        return ComputedColumnUtil.getCCUsedCols(model, columnDesc.getName(), columnDesc.getComputedColumnExpr());
    }

    public static Set<String> getCCUsedColsWithModel(NDataModel model, ComputedColumnDesc ccDesc) {
        return ComputedColumnUtil.getCCUsedCols(model, ccDesc.getColumnName(), ccDesc.getExpression());
    }

    public static Set<String> getAllCCUsedColsInModel(NDataModel dataModel) {
        HashSet<String> ccUsedColsInModel = new HashSet<String>();
        List<ComputedColumnDesc> ccList = dataModel.getComputedColumnDescs();
        for (ComputedColumnDesc ccDesc : ccList) {
            ccUsedColsInModel.addAll(ComputedColumnUtil.getCCUsedColsWithModel(dataModel, ccDesc));
        }
        return ccUsedColsInModel;
    }

    public static ColumnDesc[] createComputedColumns(List<ComputedColumnDesc> computedColumnDescs, TableDesc tableDesc) {
        MutableInt id = new MutableInt(tableDesc.getColumnCount());
        return (ColumnDesc[])computedColumnDescs.stream().filter(input -> tableDesc.getIdentity().equalsIgnoreCase(input.getTableIdentity())).map(input -> {
            id.increment();
            ColumnDesc columnDesc = new ColumnDesc(id.toString(), input.getColumnName(), input.getDatatype(), input.getComment(), null, null, input.getInnerExpression());
            columnDesc.init(tableDesc);
            return columnDesc;
        }).toArray(ColumnDesc[]::new);
    }

    public static Map<String, Set<String>> getCCUsedColsMap(NDataModel model, String colName) {
        HashMap usedCols = Maps.newHashMap();
        Map<String, String> aliasTableMap = ComputedColumnUtil.getAliasTableMap(model);
        Preconditions.checkState((aliasTableMap.size() > 0 ? 1 : 0) != 0, (String)"can not find cc:%s's table alias", (Object)colName);
        ComputedColumnDesc targetCC = model.getComputedColumnDescs().stream().filter(cc -> cc.getColumnName().equalsIgnoreCase(colName)).findFirst().orElse(null);
        if (targetCC == null) {
            throw new IllegalStateException("ComputedColumn(name: " + colName + ") is not on model: " + model.getUuid());
        }
        List<Pair<String, String>> colsWithAlias = ExprIdentifierFinder.getExprIdentifiers(targetCC.getExpression());
        for (Pair<String, String> cols : colsWithAlias) {
            String tableIdentifier = aliasTableMap.get(cols.getFirst());
            usedCols.putIfAbsent(tableIdentifier, Sets.newHashSet());
            ((Set)usedCols.get(tableIdentifier)).add(cols.getSecond());
        }
        return usedCols;
    }

    private static Set<String> getCCUsedCols(NDataModel model, String colName, String ccExpr) {
        HashSet<String> usedCols = new HashSet<String>();
        Map<String, String> aliasTableMap = ComputedColumnUtil.getAliasTableMap(model);
        Preconditions.checkState((aliasTableMap.size() > 0 ? 1 : 0) != 0, (String)"can not find cc:%s's table alias", (Object)colName);
        List<Pair<String, String>> colsWithAlias = ExprIdentifierFinder.getExprIdentifiers(ccExpr);
        for (Pair<String, String> cols : colsWithAlias) {
            String tableIdentifier = aliasTableMap.get(cols.getFirst());
            usedCols.add(tableIdentifier + "." + (String)cols.getSecond());
        }
        return usedCols;
    }

    private static Map<String, String> getAliasTableMap(NDataModel model) {
        HashMap<String, String> tableWithAlias = new HashMap<String, String>();
        for (String alias : model.getAliasMap().keySet()) {
            String tableName = model.getAliasMap().get(alias).getTableDesc().getIdentity();
            tableWithAlias.put(alias, tableName);
        }
        return tableWithAlias;
    }

    private static NDataModel getModel(String project, String ccName) {
        List<NDataModel> models = NDataflowManager.getInstance(KylinConfig.getInstanceFromEnv(), project).listUnderliningDataModels();
        for (NDataModel model : models) {
            Set<String> computedColumnNames = model.getComputedColumnNames();
            if (!computedColumnNames.contains(ccName)) continue;
            return model;
        }
        return null;
    }

    public static void singleCCConflictCheck(NDataModel existingModel, NDataModel newModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC, CCConflictHandler handler) {
        AliasMapping aliasMapping = ComputedColumnUtil.getCCAliasMapping(existingModel, newModel, existingCC, newCC);
        boolean sameModel = ComputedColumnUtil.isSameModel(existingModel, newModel);
        boolean sameName = ComputedColumnUtil.isSameName(existingCC, newCC);
        boolean sameCCExpr = ComputedColumnUtil.isSameCCExpr(existingCC, newCC, aliasMapping);
        if (sameName && sameCCExpr) {
            handler.handleOnSameExprSameName(existingModel, existingCC, newCC);
        }
        if (sameName) {
            if (sameModel) {
                handler.handleOnSingleModelSameName(existingModel, existingCC, newCC);
            }
            if (!ComputedColumnUtil.isSameAliasTable(existingCC, newCC, aliasMapping)) {
                handler.handleOnWrongPositionName(existingModel, existingCC, newCC, aliasMapping);
            }
            if (!sameCCExpr) {
                handler.handleOnSameNameDiffExpr(existingModel, newModel, existingCC, newCC);
            }
        }
        if (sameCCExpr) {
            if (sameModel) {
                handler.handleOnSingleModelSameExpr(existingModel, existingCC, newCC);
            }
            if (!ComputedColumnUtil.isSameAliasTable(existingCC, newCC, aliasMapping)) {
                handler.handleOnWrongPositionExpr(existingModel, existingCC, newCC, aliasMapping);
            }
            if (!sameName) {
                handler.handleOnSameExprDiffName(existingModel, existingCC, newCC);
            }
        }
    }

    private static boolean isSameModel(NDataModel existingModel, NDataModel newModel) {
        if (existingModel == null) {
            return false;
        }
        return existingModel.equals((Object)newModel);
    }

    private static AliasMapping getAliasMappingFromJoinsGraph(JoinsGraph fromGraph, JoinsGraph toMatchGraph) {
        AliasMapping adviceAliasMapping = null;
        Map<String, String> matches = fromGraph.matchAlias(toMatchGraph, true);
        if (matches != null && !matches.isEmpty()) {
            HashBiMap biMap = HashBiMap.create();
            biMap.putAll(matches);
            adviceAliasMapping = new AliasMapping((BiMap<String, String>)biMap);
        }
        return adviceAliasMapping;
    }

    private static AliasMapping getCCAliasMapping(NDataModel existingModel, NDataModel newModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC) {
        JoinsGraph newCCGraph = ComputedColumnUtil.getCCExprRelatedSubgraph(newCC, newModel);
        JoinsGraph existCCGraph = ComputedColumnUtil.getCCExprRelatedSubgraph(existingCC, existingModel);
        return ComputedColumnUtil.getAliasMappingFromJoinsGraph(newCCGraph, existCCGraph);
    }

    public static JoinsGraph getCCExprRelatedSubgraph(ComputedColumnDesc cc, NDataModel model) {
        Set<String> aliasSets = CalciteParser.getUsedAliasSet(cc.getExpression());
        if (cc.getTableAlias() != null) {
            aliasSets.add(cc.getTableAlias());
        }
        return model.getJoinsGraph().getSubGraphByAlias(aliasSets);
    }

    public static boolean isSameName(ComputedColumnDesc col1, ComputedColumnDesc col2) {
        return StringUtils.equalsIgnoreCase((CharSequence)(col1.getTableIdentity() + "." + col1.getColumnName()), (CharSequence)(col2.getTableIdentity() + "." + col2.getColumnName()));
    }

    private static boolean isSameCCExpr(ComputedColumnDesc existingCC, ComputedColumnDesc newCC, AliasMapping aliasMapping) {
        if (existingCC.getExpression() == null) {
            return newCC.getExpression() == null;
        }
        if (newCC.getExpression() == null) {
            return false;
        }
        return ExpressionComparator.isNodeEqual(CalciteParser.getReadonlyExpNode(newCC.getExpression()), CalciteParser.getReadonlyExpNode(existingCC.getExpression()), aliasMapping, AliasDeduce.NO_OP);
    }

    public static ComputedColumnDesc findCCByExpr(List<NDataModel> models, ComputedColumnDesc ccToFind) {
        for (NDataModel model : models) {
            for (ComputedColumnDesc existingCC : model.getComputedColumnDescs()) {
                AliasMapping aliasMapping;
                if (!ComputedColumnUtil.isSameCCExpr(existingCC, ccToFind, aliasMapping = ComputedColumnUtil.getCCAliasMapping(model, model, existingCC, ccToFind))) continue;
                return existingCC;
            }
        }
        return null;
    }

    private static boolean isSameAliasTable(ComputedColumnDesc existingCC, ComputedColumnDesc newCC, AliasMapping adviceAliasMapping) {
        if (adviceAliasMapping == null) {
            return false;
        }
        String existingAlias = existingCC.getTableAlias();
        String newAlias = newCC.getTableAlias();
        return StringUtils.equals((CharSequence)newAlias, (CharSequence)((CharSequence)adviceAliasMapping.getAliasMap().get((Object)existingAlias)));
    }

    public static List<ComputedColumnDesc> getAuthorizedCC(List<NDataModel> modelList, Predicate<Set<String>> isColumnAuthorizedFunc) {
        ArrayList authorizedCC = Lists.newArrayList();
        HashSet checkedCC = Sets.newHashSet();
        HashSet checkedCCUsedSourceCols = Sets.newHashSet();
        for (NDataModel model : modelList) {
            HashMap ccUsedColsMap = Maps.newHashMap();
            for (ComputedColumnDesc cc : model.getComputedColumnDescs()) {
                if (checkedCC.contains(cc)) continue;
                ccUsedColsMap.put(cc.getIdentName(), ComputedColumnUtil.getCCUsedColsWithModel(model, cc));
            }
            for (ComputedColumnDesc cc : model.getComputedColumnDescs()) {
                if (checkedCC.contains(cc)) continue;
                HashSet ccUsedSourceCols = Sets.newHashSet();
                ComputedColumnUtil.collectCCUsedSourceCols(cc.getIdentName(), ccUsedColsMap, ccUsedSourceCols);
                ccUsedSourceCols.removeIf(checkedCCUsedSourceCols::contains);
                if (ccUsedSourceCols.isEmpty() || isColumnAuthorizedFunc.test(ccUsedSourceCols)) {
                    authorizedCC.add(cc);
                    checkedCCUsedSourceCols.addAll(ccUsedSourceCols);
                }
                checkedCC.add(cc);
            }
        }
        return authorizedCC;
    }

    public static void collectCCUsedSourceCols(String ccColName, Map<String, Set<String>> ccUsedColsMap, Set<String> ccUsedSourceCols) {
        if (!ccUsedColsMap.containsKey(ccColName)) {
            ccUsedSourceCols.add(ccColName);
            return;
        }
        for (String usedColumn : ccUsedColsMap.get(ccColName)) {
            ComputedColumnUtil.collectCCUsedSourceCols(usedColumn, ccUsedColsMap, ccUsedSourceCols);
        }
    }

    public static List<ComputedColumnDesc> deepCopy(List<ComputedColumnDesc> ccList) {
        ArrayList result = Lists.newArrayList();
        try {
            for (ComputedColumnDesc cc : ccList) {
                result.add(JsonUtil.deepCopy((Object)cc, ComputedColumnDesc.class));
            }
        }
        catch (IOException e) {
            logger.error("failed to deep copy cc list", (Throwable)e);
        }
        return result;
    }

    public static void computeMd5(KylinConfig config, NDataModel model, ComputedColumnDesc cc) {
        if (EXTRACTOR == null) {
            throw new KylinRuntimeException("When update or insert CC, a RexStrExtractor must be Specified.");
        }
        try {
            String rexStr = EXTRACTOR.extract(model, config, cc.getInnerExpression());
            String subJoinGraphStr = ComputedColumnUtil.getCCExprRelatedSubgraph(cc, model).toString(true, true);
            cc.setExpressionMD5(DigestUtils.md5DigestAsHex((byte[])(subJoinGraphStr + rexStr).getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_COMPUTED_COLUMN_EXPRESSION, "Compute md5 for cc failed!", (Throwable)e);
        }
    }

    @Generated
    public static void setEXTRACTOR(RexStrExtractor EXTRACTOR) {
        ComputedColumnUtil.EXTRACTOR = EXTRACTOR;
    }

    public static interface RexStrExtractor {
        public String extract(NDataModel var1, KylinConfig var2, String var3) throws SqlParseException;
    }

    public static class CCConflictDetail {
        private String existingModelName;
        private ComputedColumnDesc existingCC;
        private ComputedColumnDesc newCC;

        public CCConflictDetail(String existingModelName, ComputedColumnDesc existingCC, ComputedColumnDesc newCC) {
            this.existingModelName = existingModelName;
            this.existingCC = existingCC;
            this.newCC = newCC;
        }

        public KylinException getAdjustKylinException() {
            return new KylinException((ErrorCodeProducer)ErrorCodeServer.COMPUTED_COLUMN_CONFLICT_ADJUST_INFO, new Object[]{this.newCC.getColumnName(), this.newCC.getExpression(), this.existingCC.getColumnName(), this.existingCC.getExpression(), this.existingCC.getColumnName()});
        }

        public KylinException getNameConflictKylinException() {
            return new KylinException((ErrorCodeProducer)ErrorCodeServer.COMPUTED_COLUMN_NAME_CONFLICT, new Object[]{this.newCC.getColumnName(), this.newCC.getExpression(), this.existingModelName});
        }

        public KylinException getExprConflictKylinException() {
            return new KylinException((ErrorCodeProducer)ErrorCodeServer.COMPUTED_COLUMN_EXPR_CONFLICT, new Object[]{this.newCC.getColumnName(), this.newCC.getExpression(), this.existingModelName});
        }

        @Generated
        public String getExistingModelName() {
            return this.existingModelName;
        }

        @Generated
        public ComputedColumnDesc getExistingCC() {
            return this.existingCC;
        }

        @Generated
        public ComputedColumnDesc getNewCC() {
            return this.newCC;
        }

        @Generated
        public void setExistingModelName(String existingModelName) {
            this.existingModelName = existingModelName;
        }

        @Generated
        public void setExistingCC(ComputedColumnDesc existingCC) {
            this.existingCC = existingCC;
        }

        @Generated
        public void setNewCC(ComputedColumnDesc newCC) {
            this.newCC = newCC;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CCConflictDetail)) {
                return false;
            }
            CCConflictDetail other = (CCConflictDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$existingModelName = this.getExistingModelName();
            String other$existingModelName = other.getExistingModelName();
            if (this$existingModelName == null ? other$existingModelName != null : !this$existingModelName.equals(other$existingModelName)) {
                return false;
            }
            ComputedColumnDesc this$existingCC = this.getExistingCC();
            ComputedColumnDesc other$existingCC = other.getExistingCC();
            if (this$existingCC == null ? other$existingCC != null : !((Object)this$existingCC).equals(other$existingCC)) {
                return false;
            }
            ComputedColumnDesc this$newCC = this.getNewCC();
            ComputedColumnDesc other$newCC = other.getNewCC();
            return !(this$newCC == null ? other$newCC != null : !((Object)this$newCC).equals(other$newCC));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CCConflictDetail;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $existingModelName = this.getExistingModelName();
            result = result * 59 + ($existingModelName == null ? 43 : $existingModelName.hashCode());
            ComputedColumnDesc $existingCC = this.getExistingCC();
            result = result * 59 + ($existingCC == null ? 43 : ((Object)$existingCC).hashCode());
            ComputedColumnDesc $newCC = this.getNewCC();
            result = result * 59 + ($newCC == null ? 43 : ((Object)$newCC).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ComputedColumnUtil.CCConflictDetail(existingModelName=" + this.getExistingModelName() + ", existingCC=" + this.getExistingCC() + ", newCC=" + this.getNewCC() + ")";
        }
    }

    public static class CCConflictInfo {
        private List<CCConflictDetail> sameExprDiffNameDetails = Lists.newArrayList();
        private List<CCConflictDetail> sameNameDiffExprDetails = Lists.newArrayList();

        public void addSameExprDiffNameDetail(CCConflictDetail ccConflictDetail) {
            this.sameExprDiffNameDetails.add(ccConflictDetail);
        }

        public void addSameNameDiffExprDetail(CCConflictDetail ccConflictDetail) {
            this.sameNameDiffExprDetails.add(ccConflictDetail);
        }

        public boolean noneConflict() {
            return !this.hasSameNameConflict() && !this.hasSameExprConflict();
        }

        public boolean hasSameNameConflict() {
            return CollectionUtils.isNotEmpty(this.sameNameDiffExprDetails);
        }

        public boolean hasSameExprConflict() {
            return CollectionUtils.isNotEmpty(this.sameExprDiffNameDetails);
        }

        public List<KylinException> getSameNameConflictException() {
            return this.sameNameDiffExprDetails.stream().filter(Objects::nonNull).map(CCConflictDetail::getNameConflictKylinException).collect(Collectors.toList());
        }

        public List<KylinException> getSameExprConflictException() {
            return this.sameExprDiffNameDetails.stream().filter(Objects::nonNull).map(CCConflictDetail::getExprConflictKylinException).collect(Collectors.toList());
        }

        public List<KylinException> getAllConflictException() {
            ArrayList exceptionList = Lists.newArrayList();
            exceptionList.addAll(this.getSameExprConflictException());
            exceptionList.addAll(this.getSameNameConflictException());
            return exceptionList;
        }

        public Pair<List<ComputedColumnDesc>, List<CCConflictDetail>> getAdjustedCCList(List<ComputedColumnDesc> inputCCDescList) {
            ArrayList resultCCDescList = Lists.newArrayList();
            ArrayList adjustDetails = Lists.newArrayList();
            for (ComputedColumnDesc ccDesc : inputCCDescList) {
                for (CCConflictDetail detail : this.sameExprDiffNameDetails) {
                    ComputedColumnDesc existingCC = detail.getExistingCC();
                    ComputedColumnDesc newCC = detail.getNewCC();
                    if (!newCC.equals(ccDesc)) continue;
                    logger.info("adjust cc name {} to {}", (Object)newCC.getColumnName(), (Object)existingCC.getColumnName());
                    ccDesc.setColumnName(existingCC.getColumnName());
                    adjustDetails.add(detail);
                    break;
                }
                resultCCDescList.add(ccDesc);
            }
            return Pair.newPair((Object)resultCCDescList, (Object)adjustDetails);
        }

        @Generated
        public List<CCConflictDetail> getSameExprDiffNameDetails() {
            return this.sameExprDiffNameDetails;
        }

        @Generated
        public List<CCConflictDetail> getSameNameDiffExprDetails() {
            return this.sameNameDiffExprDetails;
        }

        @Generated
        public void setSameExprDiffNameDetails(List<CCConflictDetail> sameExprDiffNameDetails) {
            this.sameExprDiffNameDetails = sameExprDiffNameDetails;
        }

        @Generated
        public void setSameNameDiffExprDetails(List<CCConflictDetail> sameNameDiffExprDetails) {
            this.sameNameDiffExprDetails = sameNameDiffExprDetails;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CCConflictInfo)) {
                return false;
            }
            CCConflictInfo other = (CCConflictInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<CCConflictDetail> this$sameExprDiffNameDetails = this.getSameExprDiffNameDetails();
            List<CCConflictDetail> other$sameExprDiffNameDetails = other.getSameExprDiffNameDetails();
            if (this$sameExprDiffNameDetails == null ? other$sameExprDiffNameDetails != null : !((Object)this$sameExprDiffNameDetails).equals(other$sameExprDiffNameDetails)) {
                return false;
            }
            List<CCConflictDetail> this$sameNameDiffExprDetails = this.getSameNameDiffExprDetails();
            List<CCConflictDetail> other$sameNameDiffExprDetails = other.getSameNameDiffExprDetails();
            return !(this$sameNameDiffExprDetails == null ? other$sameNameDiffExprDetails != null : !((Object)this$sameNameDiffExprDetails).equals(other$sameNameDiffExprDetails));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CCConflictInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<CCConflictDetail> $sameExprDiffNameDetails = this.getSameExprDiffNameDetails();
            result = result * 59 + ($sameExprDiffNameDetails == null ? 43 : ((Object)$sameExprDiffNameDetails).hashCode());
            List<CCConflictDetail> $sameNameDiffExprDetails = this.getSameNameDiffExprDetails();
            result = result * 59 + ($sameNameDiffExprDetails == null ? 43 : ((Object)$sameNameDiffExprDetails).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ComputedColumnUtil.CCConflictInfo(sameExprDiffNameDetails=" + this.getSameExprDiffNameDetails() + ", sameNameDiffExprDetails=" + this.getSameNameDiffExprDetails() + ")";
        }

        @Generated
        public CCConflictInfo() {
        }
    }

    public static class AdjustCCConflictHandler
    extends DefaultCCConflictHandler {
        private CCConflictInfo ccConflictInfo;

        @Override
        public void handleOnSameNameDiffExpr(NDataModel existingModel, NDataModel newModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC) {
            CCConflictDetail detail = new CCConflictDetail(existingModel.getAlias(), existingCC, newCC);
            this.ccConflictInfo.addSameNameDiffExprDetail(detail);
        }

        @Override
        public void handleOnSameExprDiffName(NDataModel existingModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC) {
            CCConflictDetail detail = new CCConflictDetail(existingModel.getAlias(), existingCC, newCC);
            this.ccConflictInfo.addSameExprDiffNameDetail(detail);
        }

        @Generated
        public AdjustCCConflictHandler(CCConflictInfo ccConflictInfo) {
            this.ccConflictInfo = ccConflictInfo;
        }

        @Generated
        public CCConflictInfo getCcConflictInfo() {
            return this.ccConflictInfo;
        }
    }

    public static class DefaultCCConflictHandler
    extends BasicCCConflictHandler {
        @Override
        public void handleOnSameNameDiffExpr(NDataModel existingModel, NDataModel newModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC) {
            JoinsGraph ccJoinsGraph = ComputedColumnUtil.getCCExprRelatedSubgraph(existingCC, existingModel);
            AliasMapping aliasMapping = ComputedColumnUtil.getAliasMappingFromJoinsGraph(ccJoinsGraph, newModel.getJoinsGraph());
            String advisedExpr = aliasMapping == null ? null : CalciteParser.replaceAliasInExpr(existingCC.getExpression(), aliasMapping.getAliasMap());
            String finalExpr = advisedExpr != null ? advisedExpr : existingCC.getExpression();
            String msg = String.format(Locale.ROOT, MsgPicker.getMsg().getComputedColumnNameDuplicated(), newCC.getFullName(), existingModel.getAlias(), finalExpr);
            throw new BadModelException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_COMPUTED_COLUMN_NAME, msg, BadModelException.CauseType.SAME_NAME_DIFF_EXPR, advisedExpr, existingModel.getAlias(), newCC.getFullName());
        }

        @Override
        public void handleOnWrongPositionName(NDataModel existingModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC, AliasMapping positionAliasMapping) {
            String advice = positionAliasMapping == null ? null : (String)positionAliasMapping.getAliasMap().get((Object)existingCC.getTableAlias());
            String msg = null;
            msg = advice != null ? String.format(Locale.ROOT, "Computed column %s is already defined in model %s, to reuse it you have to define it on alias table: %s", newCC.getColumnName(), existingModel.getAlias(), advice) : String.format(Locale.ROOT, "Computed column %s is already defined in model %s, no suggestion could be provided to reuse it", newCC.getColumnName(), existingModel.getAlias());
            throw new BadModelException(msg, BadModelException.CauseType.WRONG_POSITION_DUE_TO_NAME, advice, existingModel.getAlias(), newCC.getFullName());
        }

        @Override
        public void handleOnWrongPositionExpr(NDataModel existingModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC, AliasMapping positionAliasMapping) {
            String advice = positionAliasMapping == null ? null : (String)positionAliasMapping.getAliasMap().get((Object)existingCC.getTableAlias());
            String msg = null;
            msg = advice != null ? String.format(Locale.ROOT, "Computed column %s's expression is already defined in model %s, to reuse it you have to define it on alias table: %s", newCC.getColumnName(), existingModel.getAlias(), advice) : String.format(Locale.ROOT, "Computed column %s's expression is already defined in model %s, no suggestion could be provided to reuse it", newCC.getColumnName(), existingModel.getAlias());
            throw new BadModelException(msg, BadModelException.CauseType.WRONG_POSITION_DUE_TO_EXPR, advice, existingModel.getAlias(), newCC.getFullName());
        }

        @Override
        public void handleOnSameExprDiffName(NDataModel existingModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC) {
            String adviseName = existingCC.getColumnName();
            String msg = String.format(Locale.ROOT, MsgPicker.getMsg().getComputedColumnExpressionDuplicated(), existingModel.getAlias(), existingCC.getColumnName());
            throw new BadModelException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_COMPUTED_COLUMN_EXPRESSION, msg, BadModelException.CauseType.SAME_EXPR_DIFF_NAME, adviseName, existingModel.getAlias(), newCC.getFullName());
        }

        @Override
        public void handleOnSingleModelSameName(NDataModel existingModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC) {
            String msg = MsgPicker.getMsg().getComputedColumnNameDuplicatedSingleModel();
            throw new BadModelException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_COMPUTED_COLUMN_NAME, msg, BadModelException.CauseType.SELF_CONFLICT_WITH_SAME_NAME, null, null, newCC.getFullName());
        }

        @Override
        public void handleOnSingleModelSameExpr(NDataModel existingModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC) {
            String ccFullName = newCC.getFullName();
            String errorMsg = "In model " + existingModel.getAlias() + ", computed columns " + existingCC.getFullName() + " and " + ccFullName + " have equivalent expressions.";
            logger.error(errorMsg);
            String msg = MsgPicker.getMsg().getComputedColumnExpressionDuplicatedSingleModel();
            throw new BadModelException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_COMPUTED_COLUMN_EXPRESSION, msg, BadModelException.CauseType.SELF_CONFLICT_WITH_SAME_EXPRESSION, null, null, ccFullName);
        }
    }

    public static class BasicCCConflictHandler
    implements CCConflictHandler {
        @Override
        public void handleOnWrongPositionName(NDataModel existingModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC, AliasMapping positionAliasMapping) {
        }

        @Override
        public void handleOnSameNameDiffExpr(NDataModel existingModel, NDataModel newModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC) {
        }

        @Override
        public void handleOnWrongPositionExpr(NDataModel existingModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC, AliasMapping positionAliasMapping) {
        }

        @Override
        public void handleOnSameExprDiffName(NDataModel existingModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC) {
        }

        @Override
        public void handleOnSameExprSameName(NDataModel existingModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC) {
        }

        @Override
        public void handleOnSingleModelSameName(NDataModel existingModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC) {
        }

        @Override
        public void handleOnSingleModelSameExpr(NDataModel existingModel, ComputedColumnDesc existingCC, ComputedColumnDesc newCC) {
        }
    }

    public static interface CCConflictHandler {
        public void handleOnWrongPositionName(NDataModel var1, ComputedColumnDesc var2, ComputedColumnDesc var3, AliasMapping var4);

        public void handleOnSameNameDiffExpr(NDataModel var1, NDataModel var2, ComputedColumnDesc var3, ComputedColumnDesc var4);

        public void handleOnWrongPositionExpr(NDataModel var1, ComputedColumnDesc var2, ComputedColumnDesc var3, AliasMapping var4);

        public void handleOnSameExprDiffName(NDataModel var1, ComputedColumnDesc var2, ComputedColumnDesc var3);

        public void handleOnSameExprSameName(NDataModel var1, ComputedColumnDesc var2, ComputedColumnDesc var3);

        public void handleOnSingleModelSameName(NDataModel var1, ComputedColumnDesc var2, ComputedColumnDesc var3);

        public void handleOnSingleModelSameExpr(NDataModel var1, ComputedColumnDesc var2, ComputedColumnDesc var3);
    }

    public static class ExprIdentifierFinder
    extends SqlBasicVisitor<SqlNode> {
        List<Pair<String, String>> columnWithTableAlias = new ArrayList<Pair<String, String>>();

        ExprIdentifierFinder() {
        }

        List<Pair<String, String>> getIdentifiers() {
            return this.columnWithTableAlias;
        }

        public static List<Pair<String, String>> getExprIdentifiers(String expr) {
            SqlNode exprNode = CalciteParser.getReadonlyExpNode(expr);
            ExprIdentifierFinder id = new ExprIdentifierFinder();
            exprNode.accept((SqlVisitor)id);
            return id.getIdentifiers();
        }

        public SqlNode visit(SqlCall call) {
            for (SqlNode operand : call.getOperandList()) {
                if (operand == null) continue;
                operand.accept((SqlVisitor)this);
            }
            return null;
        }

        public SqlNode visit(SqlIdentifier id) {
            if (id.names.size() == 2) {
                this.columnWithTableAlias.add((Pair<String, String>)Pair.newPair((Object)id.names.get(0), (Object)id.names.get(1)));
            }
            return null;
        }
    }
}

