/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.MapDifference;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.graph.Graph;
import org.apache.kylin.guava30.shaded.common.graph.GraphBuilder;
import org.apache.kylin.guava30.shaded.common.graph.MutableGraph;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.schema.ModelEdgeCollector;
import org.apache.kylin.metadata.model.schema.SchemaNode;

public class SchemaUtil {
    public static SchemaDifference diff(String project, KylinConfig sourceConfig, KylinConfig targetConfig, List<TableDesc> incrTableDescList) {
        Graph<SchemaNode> sourceGraph = SchemaUtil.dependencyGraph(project, sourceConfig, incrTableDescList);
        Graph<SchemaNode> targetGraph = SchemaUtil.dependencyGraph(project, targetConfig);
        return new SchemaDifference(sourceGraph, targetGraph);
    }

    public static Graph<SchemaNode> dependencyGraph(String project, KylinConfig config, List<TableDesc> incrTableDescList) {
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance(config, project);
        NIndexPlanManager planManager = NIndexPlanManager.getInstance(config, project);
        ArrayList tableDescs = Lists.newArrayList(tableManager.listAllTables());
        tableDescs.addAll(incrTableDescList);
        return SchemaUtil.dependencyGraph(tableDescs, planManager.listAllIndexPlans());
    }

    public static SchemaDifference diff(String project, KylinConfig sourceConfig, KylinConfig targetConfig) {
        Graph<SchemaNode> sourceGraph = SchemaUtil.dependencyGraph(project, sourceConfig);
        Graph<SchemaNode> targetGraph = SchemaUtil.dependencyGraph(project, targetConfig);
        return new SchemaDifference(sourceGraph, targetGraph);
    }

    public static Graph<SchemaNode> dependencyGraph(String project, KylinConfig config) {
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance(config, project);
        NIndexPlanManager planManager = NIndexPlanManager.getInstance(config, project);
        return SchemaUtil.dependencyGraph(tableManager.listAllTables(), planManager.listAllIndexPlans());
    }

    public static Graph<SchemaNode> dependencyGraph(String project, NDataModel model) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance(config, project);
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance(config, project);
        String factTableName = model.getRootFactTableName();
        TableDesc table = tableManager.getTableDesc(factTableName);
        ArrayList tables = Lists.newArrayList();
        ArrayList indexPlans = Lists.newArrayList();
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(model.getUuid());
        if (!indexPlan.isBroken()) {
            indexPlans.add(indexPlan);
        }
        tables.add(table);
        List<JoinTableDesc> joinTables = model.getJoinTables();
        for (JoinTableDesc joinTable : joinTables) {
            tables.add(tableManager.getTableDesc(joinTable.getTable()));
        }
        return SchemaUtil.dependencyGraph(tables, indexPlans);
    }

    public static Graph<SchemaNode> dependencyGraph(String project, String tableIdentity) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance(config, project);
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance(config, project);
        TableDesc table = tableManager.getTableDesc(tableIdentity);
        ArrayList tables = Lists.newArrayList();
        ArrayList indexPlans = Lists.newArrayList();
        Preconditions.checkNotNull((Object)table, (Object)String.format(Locale.ROOT, "Table(%s) not exist in project(%s)", tableIdentity, project));
        tables.add(table);
        NDataModelManager modelManager = NDataModelManager.getInstance(KylinConfig.readSystemKylinConfig(), project);
        List<NDataModel> models = modelManager.listAllModels().stream().filter(model -> model.isBroken() || SchemaUtil.isTableRelatedModel(tableIdentity, model)).collect(Collectors.toList());
        models.forEach(model -> {
            if (!model.isBroken()) {
                indexPlans.add(indexPlanManager.getIndexPlan(model.getUuid()));
            }
            tableManager.getTableDesc(model.getRootFactTableName());
            List<JoinTableDesc> joinTables = model.getJoinTables();
            joinTables.stream().map(JoinTableDesc::getTable).map(tableManager::getTableDesc).filter(Objects::nonNull).forEach(tables::add);
        });
        return SchemaUtil.dependencyGraph(tables, indexPlans);
    }

    private static boolean isTableRelatedModel(String tableIdentity, NDataModel model) {
        List<JoinTableDesc> joinTables = model.getJoinTables();
        for (JoinTableDesc joinTable : joinTables) {
            TableRef tableRef = joinTable.getTableRef();
            if (!tableRef.getTableIdentity().equalsIgnoreCase(tableIdentity)) continue;
            return true;
        }
        return model.getRootFactTableName().equalsIgnoreCase(tableIdentity);
    }

    static Graph<SchemaNode> dependencyGraph(List<TableDesc> tables, List<IndexPlan> plans) {
        MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).build();
        tables.forEach(table -> {
            for (ColumnDesc column : table.getColumns()) {
                graph.putEdge((Object)SchemaNode.ofTableColumn(column), (Object)SchemaNode.ofTable(table));
            }
        });
        for (IndexPlan plan : plans) {
            new ModelEdgeCollector(plan, (MutableGraph<SchemaNode>)graph).collect();
        }
        return graph;
    }

    public static class SchemaDifference {
        private final Graph<SchemaNode> sourceGraph;
        private final Graph<SchemaNode> targetGraph;
        private final MapDifference<SchemaNode.SchemaNodeIdentifier, SchemaNode> nodeDiff;

        public SchemaDifference(Graph<SchemaNode> sourceGraph, Graph<SchemaNode> targetGraph) {
            this.sourceGraph = sourceGraph;
            this.targetGraph = targetGraph;
            this.nodeDiff = Maps.difference(this.toSchemaNodeMap(sourceGraph), this.toSchemaNodeMap(targetGraph));
        }

        private Map<SchemaNode.SchemaNodeIdentifier, SchemaNode> toSchemaNodeMap(Graph<SchemaNode> sourceGraph) {
            return sourceGraph.nodes().stream().collect(Collectors.toMap(SchemaNode::getIdentifier, Function.identity()));
        }

        @Generated
        public Graph<SchemaNode> getSourceGraph() {
            return this.sourceGraph;
        }

        @Generated
        public Graph<SchemaNode> getTargetGraph() {
            return this.targetGraph;
        }

        @Generated
        public MapDifference<SchemaNode.SchemaNodeIdentifier, SchemaNode> getNodeDiff() {
            return this.nodeDiff;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchemaDifference)) {
                return false;
            }
            SchemaDifference other = (SchemaDifference)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Graph<SchemaNode> this$sourceGraph = this.getSourceGraph();
            Graph<SchemaNode> other$sourceGraph = other.getSourceGraph();
            if (this$sourceGraph == null ? other$sourceGraph != null : !this$sourceGraph.equals(other$sourceGraph)) {
                return false;
            }
            Graph<SchemaNode> this$targetGraph = this.getTargetGraph();
            Graph<SchemaNode> other$targetGraph = other.getTargetGraph();
            if (this$targetGraph == null ? other$targetGraph != null : !this$targetGraph.equals(other$targetGraph)) {
                return false;
            }
            MapDifference<SchemaNode.SchemaNodeIdentifier, SchemaNode> this$nodeDiff = this.getNodeDiff();
            MapDifference<SchemaNode.SchemaNodeIdentifier, SchemaNode> other$nodeDiff = other.getNodeDiff();
            return !(this$nodeDiff == null ? other$nodeDiff != null : !this$nodeDiff.equals(other$nodeDiff));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SchemaDifference;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Graph<SchemaNode> $sourceGraph = this.getSourceGraph();
            result = result * 59 + ($sourceGraph == null ? 43 : $sourceGraph.hashCode());
            Graph<SchemaNode> $targetGraph = this.getTargetGraph();
            result = result * 59 + ($targetGraph == null ? 43 : $targetGraph.hashCode());
            MapDifference<SchemaNode.SchemaNodeIdentifier, SchemaNode> $nodeDiff = this.getNodeDiff();
            result = result * 59 + ($nodeDiff == null ? 43 : $nodeDiff.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SchemaUtil.SchemaDifference(sourceGraph=" + this.getSourceGraph() + ", targetGraph=" + this.getTargetGraph() + ", nodeDiff=" + this.getNodeDiff() + ")";
        }
    }
}

