/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.schema.SchemaNode;
import org.apache.kylin.metadata.model.schema.SchemaNodeType;

public class SchemaChangeCheckResult {
    @JsonProperty
    private Map<String, ModelSchemaChange> models = new HashMap<String, ModelSchemaChange>();
    @JsonIgnore
    private List<TableDesc> existTableList = new ArrayList<TableDesc>();

    public void addMissingItems(List<ChangedItem> missingItems) {
        missingItems.forEach(schemaChange -> {
            ModelSchemaChange modelSchemaChange = this.models.getOrDefault(schemaChange.getModelAlias(), new ModelSchemaChange());
            modelSchemaChange.getMissingItems().add((ChangedItem)schemaChange);
            this.models.put(schemaChange.getModelAlias(), modelSchemaChange);
        });
    }

    public void addNewItems(List<ChangedItem> newItems) {
        newItems.forEach(schemaChange -> {
            ModelSchemaChange modelSchemaChange = this.models.getOrDefault(schemaChange.getModelAlias(), new ModelSchemaChange());
            modelSchemaChange.getNewItems().add((ChangedItem)schemaChange);
            this.models.put(schemaChange.getModelAlias(), modelSchemaChange);
        });
    }

    public void addUpdateItems(List<UpdatedItem> updateItems) {
        updateItems.forEach(item -> {
            ModelSchemaChange modelSchemaChange = this.models.getOrDefault(item.getModelAlias(), new ModelSchemaChange());
            modelSchemaChange.getUpdateItems().add((UpdatedItem)item);
            this.models.put(item.getModelAlias(), modelSchemaChange);
        });
    }

    public void addReduceItems(List<ChangedItem> reduceItems) {
        reduceItems.forEach(schemaChange -> {
            ModelSchemaChange modelSchemaChange = this.models.getOrDefault(schemaChange.getModelAlias(), new ModelSchemaChange());
            modelSchemaChange.getReduceItems().add((ChangedItem)schemaChange);
            this.models.put(schemaChange.getModelAlias(), modelSchemaChange);
        });
    }

    @JsonIgnore
    public void areEqual(List<String> modelAlias) {
        modelAlias.forEach(model -> this.models.putIfAbsent((String)model, new ModelSchemaChange()));
    }

    @Generated
    public SchemaChangeCheckResult() {
    }

    @Generated
    public Map<String, ModelSchemaChange> getModels() {
        return this.models;
    }

    @Generated
    public List<TableDesc> getExistTableList() {
        return this.existTableList;
    }

    @Generated
    public void setModels(Map<String, ModelSchemaChange> models) {
        this.models = models;
    }

    @Generated
    public void setExistTableList(List<TableDesc> existTableList) {
        this.existTableList = existTableList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaChangeCheckResult)) {
            return false;
        }
        SchemaChangeCheckResult other = (SchemaChangeCheckResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, ModelSchemaChange> this$models = this.getModels();
        Map<String, ModelSchemaChange> other$models = other.getModels();
        if (this$models == null ? other$models != null : !((Object)this$models).equals(other$models)) {
            return false;
        }
        List<TableDesc> this$existTableList = this.getExistTableList();
        List<TableDesc> other$existTableList = other.getExistTableList();
        return !(this$existTableList == null ? other$existTableList != null : !((Object)this$existTableList).equals(other$existTableList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SchemaChangeCheckResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ModelSchemaChange> $models = this.getModels();
        result = result * 59 + ($models == null ? 43 : ((Object)$models).hashCode());
        List<TableDesc> $existTableList = this.getExistTableList();
        result = result * 59 + ($existTableList == null ? 43 : ((Object)$existTableList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SchemaChangeCheckResult(models=" + this.getModels() + ", existTableList=" + this.getExistTableList() + ")";
    }

    public static class BaseItemParameter {
        private boolean hasSameName;
        private boolean hasSameNameBroken;
        private boolean importable;
        private boolean creatable;
        private boolean overwritable;

        @Generated
        public boolean isHasSameName() {
            return this.hasSameName;
        }

        @Generated
        public boolean isHasSameNameBroken() {
            return this.hasSameNameBroken;
        }

        @Generated
        public boolean isImportable() {
            return this.importable;
        }

        @Generated
        public boolean isCreatable() {
            return this.creatable;
        }

        @Generated
        public boolean isOverwritable() {
            return this.overwritable;
        }

        @Generated
        public void setHasSameName(boolean hasSameName) {
            this.hasSameName = hasSameName;
        }

        @Generated
        public void setHasSameNameBroken(boolean hasSameNameBroken) {
            this.hasSameNameBroken = hasSameNameBroken;
        }

        @Generated
        public void setImportable(boolean importable) {
            this.importable = importable;
        }

        @Generated
        public void setCreatable(boolean creatable) {
            this.creatable = creatable;
        }

        @Generated
        public void setOverwritable(boolean overwritable) {
            this.overwritable = overwritable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseItemParameter)) {
                return false;
            }
            BaseItemParameter other = (BaseItemParameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isHasSameName() != other.isHasSameName()) {
                return false;
            }
            if (this.isHasSameNameBroken() != other.isHasSameNameBroken()) {
                return false;
            }
            if (this.isImportable() != other.isImportable()) {
                return false;
            }
            if (this.isCreatable() != other.isCreatable()) {
                return false;
            }
            return this.isOverwritable() == other.isOverwritable();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BaseItemParameter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHasSameName() ? 79 : 97);
            result = result * 59 + (this.isHasSameNameBroken() ? 79 : 97);
            result = result * 59 + (this.isImportable() ? 79 : 97);
            result = result * 59 + (this.isCreatable() ? 79 : 97);
            result = result * 59 + (this.isOverwritable() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "SchemaChangeCheckResult.BaseItemParameter(hasSameName=" + this.isHasSameName() + ", hasSameNameBroken=" + this.isHasSameNameBroken() + ", importable=" + this.isImportable() + ", creatable=" + this.isCreatable() + ", overwritable=" + this.isOverwritable() + ")";
        }

        @Generated
        public BaseItemParameter(boolean hasSameName, boolean hasSameNameBroken, boolean importable, boolean creatable, boolean overwritable) {
            this.hasSameName = hasSameName;
            this.hasSameNameBroken = hasSameNameBroken;
            this.importable = importable;
            this.creatable = creatable;
            this.overwritable = overwritable;
        }
    }

    public static enum UN_IMPORT_REASON {
        SAME_CC_NAME_HAS_DIFFERENT_EXPR,
        DIFFERENT_CC_NAME_HAS_SAME_EXPR,
        USED_UNLOADED_TABLE,
        TABLE_COLUMN_DATATYPE_CHANGED,
        MISSING_TABLE_COLUMN,
        MISSING_TABLE,
        NONE;

    }

    public static class ConflictReason {
        @JsonProperty(value="reason")
        UN_IMPORT_REASON reason;
        @JsonProperty(value="conflict_item")
        String conflictItem;

        @Generated
        public UN_IMPORT_REASON getReason() {
            return this.reason;
        }

        @Generated
        public String getConflictItem() {
            return this.conflictItem;
        }

        @Generated
        public void setReason(UN_IMPORT_REASON reason) {
            this.reason = reason;
        }

        @Generated
        public void setConflictItem(String conflictItem) {
            this.conflictItem = conflictItem;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConflictReason)) {
                return false;
            }
            ConflictReason other = (ConflictReason)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UN_IMPORT_REASON this$reason = this.getReason();
            UN_IMPORT_REASON other$reason = other.getReason();
            if (this$reason == null ? other$reason != null : !((Object)((Object)this$reason)).equals((Object)other$reason)) {
                return false;
            }
            String this$conflictItem = this.getConflictItem();
            String other$conflictItem = other.getConflictItem();
            return !(this$conflictItem == null ? other$conflictItem != null : !this$conflictItem.equals(other$conflictItem));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConflictReason;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UN_IMPORT_REASON $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : ((Object)((Object)$reason)).hashCode());
            String $conflictItem = this.getConflictItem();
            result = result * 59 + ($conflictItem == null ? 43 : $conflictItem.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SchemaChangeCheckResult.ConflictReason(reason=" + (Object)((Object)this.getReason()) + ", conflictItem=" + this.getConflictItem() + ")";
        }

        @Generated
        public ConflictReason() {
        }

        @Generated
        public ConflictReason(UN_IMPORT_REASON reason, String conflictItem) {
            this.reason = reason;
            this.conflictItem = conflictItem;
        }
    }

    public static class UpdatedItem
    extends BaseItem {
        @JsonIgnore
        private SchemaNode firstSchemaNode;
        @JsonIgnore
        private SchemaNode secondSchemaNode;

        @JsonProperty(value="first_attributes")
        public Map<String, Object> getFirstAttributes() {
            return this.firstSchemaNode.getAttributes();
        }

        @JsonProperty(value="second_attributes")
        public Map<String, Object> getSecondAttributes() {
            return this.secondSchemaNode.getAttributes();
        }

        @JsonProperty(value="first_detail")
        public String getFirstDetail() {
            return this.getDetail(this.firstSchemaNode);
        }

        @JsonProperty(value="second_detail")
        public String getSecondDetail() {
            return this.getDetail(this.secondSchemaNode);
        }

        public UpdatedItem(SchemaNode first, SchemaNode second, String modelAlias, UN_IMPORT_REASON reason, String conflictItem, BaseItemParameter parameter) {
            super(second.getType(), modelAlias, new ConflictReason(reason, conflictItem), parameter.hasSameName, parameter.hasSameNameBroken, parameter.importable, parameter.creatable, parameter.overwritable);
            this.firstSchemaNode = first;
            this.secondSchemaNode = second;
        }

        public static UpdatedItem getSchemaUpdate(SchemaNode first, SchemaNode second, String modelAlias, UN_IMPORT_REASON reason, String conflictItem, BaseItemParameter parameter) {
            return new UpdatedItem(first, second, modelAlias, reason, conflictItem, parameter);
        }

        public static UpdatedItem getSchemaUpdate(SchemaNode first, SchemaNode second, String modelAlias, BaseItemParameter parameter) {
            return UpdatedItem.getSchemaUpdate(first, second, modelAlias, UN_IMPORT_REASON.NONE, null, parameter);
        }

        @Generated
        public SchemaNode getFirstSchemaNode() {
            return this.firstSchemaNode;
        }

        @Generated
        public SchemaNode getSecondSchemaNode() {
            return this.secondSchemaNode;
        }

        @Generated
        public void setFirstSchemaNode(SchemaNode firstSchemaNode) {
            this.firstSchemaNode = firstSchemaNode;
        }

        @Generated
        public void setSecondSchemaNode(SchemaNode secondSchemaNode) {
            this.secondSchemaNode = secondSchemaNode;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdatedItem)) {
                return false;
            }
            UpdatedItem other = (UpdatedItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SchemaNode this$firstSchemaNode = this.getFirstSchemaNode();
            SchemaNode other$firstSchemaNode = other.getFirstSchemaNode();
            if (this$firstSchemaNode == null ? other$firstSchemaNode != null : !((Object)this$firstSchemaNode).equals(other$firstSchemaNode)) {
                return false;
            }
            SchemaNode this$secondSchemaNode = this.getSecondSchemaNode();
            SchemaNode other$secondSchemaNode = other.getSecondSchemaNode();
            return !(this$secondSchemaNode == null ? other$secondSchemaNode != null : !((Object)this$secondSchemaNode).equals(other$secondSchemaNode));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UpdatedItem;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SchemaNode $firstSchemaNode = this.getFirstSchemaNode();
            result = result * 59 + ($firstSchemaNode == null ? 43 : ((Object)$firstSchemaNode).hashCode());
            SchemaNode $secondSchemaNode = this.getSecondSchemaNode();
            result = result * 59 + ($secondSchemaNode == null ? 43 : ((Object)$secondSchemaNode).hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "SchemaChangeCheckResult.UpdatedItem(firstSchemaNode=" + this.getFirstSchemaNode() + ", secondSchemaNode=" + this.getSecondSchemaNode() + ")";
        }
    }

    public static class ChangedItem
    extends BaseItem {
        private SchemaNode schemaNode;

        public ChangedItem(SchemaNodeType type, SchemaNode schemaNode, String modelAlias, UN_IMPORT_REASON reason, String conflictItem, BaseItemParameter parameter) {
            super(type, modelAlias, new ConflictReason(reason, conflictItem), parameter.hasSameName, parameter.hasSameNameBroken, parameter.importable, parameter.creatable, parameter.overwritable);
            this.schemaNode = schemaNode;
        }

        public static ChangedItem createUnImportableSchemaNode(SchemaNodeType type, SchemaNode schemaNode, UN_IMPORT_REASON reason, String conflictItem, boolean hasSameName, boolean hasSameNameBroken) {
            return new ChangedItem(type, schemaNode, null, reason, conflictItem, new BaseItemParameter(hasSameName, hasSameNameBroken, false, false, false));
        }

        public static ChangedItem createUnImportableSchemaNode(SchemaNodeType type, SchemaNode schemaNode, String modelAlias, UN_IMPORT_REASON reason, String conflictItem, boolean hasSameName, boolean hasSameNameBroken) {
            return new ChangedItem(type, schemaNode, modelAlias, reason, conflictItem, new BaseItemParameter(hasSameName, hasSameNameBroken, false, false, false));
        }

        public static ChangedItem createOverwritableSchemaNode(SchemaNodeType type, SchemaNode schemaNode, boolean hasSameName, boolean hasSameNameBroken) {
            return new ChangedItem(type, schemaNode, null, null, null, new BaseItemParameter(hasSameName, hasSameNameBroken, true, true, true));
        }

        public static ChangedItem createOverwritableSchemaNode(SchemaNodeType type, SchemaNode schemaNode, String modelAlias, boolean hasSameName, boolean hasSameNameBroken) {
            return new ChangedItem(type, schemaNode, modelAlias, null, null, new BaseItemParameter(hasSameName, hasSameNameBroken, true, true, true));
        }

        public static ChangedItem createCreatableSchemaNode(SchemaNodeType type, SchemaNode schemaNode, boolean hasSameName, boolean hasSameNameBroken) {
            return new ChangedItem(type, schemaNode, null, null, null, new BaseItemParameter(hasSameName, hasSameNameBroken, true, true, false));
        }

        @Override
        public String getModelAlias() {
            return this.modelAlias != null ? this.modelAlias : this.schemaNode.getSubject();
        }

        public String getDetail() {
            return this.getDetail(this.schemaNode);
        }

        public Map<String, Object> getAttributes() {
            return this.schemaNode.getAttributes();
        }

        @Generated
        public SchemaNode getSchemaNode() {
            return this.schemaNode;
        }

        @Generated
        public void setSchemaNode(SchemaNode schemaNode) {
            this.schemaNode = schemaNode;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChangedItem)) {
                return false;
            }
            ChangedItem other = (ChangedItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SchemaNode this$schemaNode = this.getSchemaNode();
            SchemaNode other$schemaNode = other.getSchemaNode();
            return !(this$schemaNode == null ? other$schemaNode != null : !((Object)this$schemaNode).equals(other$schemaNode));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ChangedItem;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SchemaNode $schemaNode = this.getSchemaNode();
            result = result * 59 + ($schemaNode == null ? 43 : ((Object)$schemaNode).hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "SchemaChangeCheckResult.ChangedItem(schemaNode=" + this.getSchemaNode() + ")";
        }

        @Generated
        public ChangedItem() {
        }

        @Generated
        public ChangedItem(SchemaNode schemaNode) {
            this.schemaNode = schemaNode;
        }
    }

    public static class BaseItem {
        @JsonProperty(value="type")
        SchemaNodeType type;
        @JsonProperty(value="model_alias")
        String modelAlias;
        @JsonUnwrapped
        ConflictReason conflictReason;
        @JsonProperty(value="has_same_name")
        boolean hasSameName;
        @JsonProperty(value="has_same_name_broken")
        boolean hasSameNameBroken;
        @JsonProperty(value="importable")
        boolean importable;
        @JsonProperty(value="creatable")
        boolean creatable;
        @JsonProperty(value="overwritable")
        boolean overwritable;

        @JsonIgnore
        public String getDetail(SchemaNode schemaNode) {
            switch (schemaNode.getType()) {
                case TABLE_COLUMN: {
                    return schemaNode.getKey();
                }
                case MODEL_DIMENSION: 
                case MODEL_MEASURE: {
                    return (String)schemaNode.getAttributes().get("name");
                }
            }
            return schemaNode.getDetail();
        }

        @Generated
        public SchemaNodeType getType() {
            return this.type;
        }

        @Generated
        public String getModelAlias() {
            return this.modelAlias;
        }

        @Generated
        public ConflictReason getConflictReason() {
            return this.conflictReason;
        }

        @Generated
        public boolean isHasSameName() {
            return this.hasSameName;
        }

        @Generated
        public boolean isHasSameNameBroken() {
            return this.hasSameNameBroken;
        }

        @Generated
        public boolean isImportable() {
            return this.importable;
        }

        @Generated
        public boolean isCreatable() {
            return this.creatable;
        }

        @Generated
        public boolean isOverwritable() {
            return this.overwritable;
        }

        @Generated
        public void setType(SchemaNodeType type) {
            this.type = type;
        }

        @Generated
        public void setModelAlias(String modelAlias) {
            this.modelAlias = modelAlias;
        }

        @Generated
        public void setConflictReason(ConflictReason conflictReason) {
            this.conflictReason = conflictReason;
        }

        @Generated
        public void setHasSameName(boolean hasSameName) {
            this.hasSameName = hasSameName;
        }

        @Generated
        public void setHasSameNameBroken(boolean hasSameNameBroken) {
            this.hasSameNameBroken = hasSameNameBroken;
        }

        @Generated
        public void setImportable(boolean importable) {
            this.importable = importable;
        }

        @Generated
        public void setCreatable(boolean creatable) {
            this.creatable = creatable;
        }

        @Generated
        public void setOverwritable(boolean overwritable) {
            this.overwritable = overwritable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseItem)) {
                return false;
            }
            BaseItem other = (BaseItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SchemaNodeType this$type = this.getType();
            SchemaNodeType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$modelAlias = this.getModelAlias();
            String other$modelAlias = other.getModelAlias();
            if (this$modelAlias == null ? other$modelAlias != null : !this$modelAlias.equals(other$modelAlias)) {
                return false;
            }
            ConflictReason this$conflictReason = this.getConflictReason();
            ConflictReason other$conflictReason = other.getConflictReason();
            if (this$conflictReason == null ? other$conflictReason != null : !((Object)this$conflictReason).equals(other$conflictReason)) {
                return false;
            }
            if (this.isHasSameName() != other.isHasSameName()) {
                return false;
            }
            if (this.isHasSameNameBroken() != other.isHasSameNameBroken()) {
                return false;
            }
            if (this.isImportable() != other.isImportable()) {
                return false;
            }
            if (this.isCreatable() != other.isCreatable()) {
                return false;
            }
            return this.isOverwritable() == other.isOverwritable();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BaseItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SchemaNodeType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $modelAlias = this.getModelAlias();
            result = result * 59 + ($modelAlias == null ? 43 : $modelAlias.hashCode());
            ConflictReason $conflictReason = this.getConflictReason();
            result = result * 59 + ($conflictReason == null ? 43 : ((Object)$conflictReason).hashCode());
            result = result * 59 + (this.isHasSameName() ? 79 : 97);
            result = result * 59 + (this.isHasSameNameBroken() ? 79 : 97);
            result = result * 59 + (this.isImportable() ? 79 : 97);
            result = result * 59 + (this.isCreatable() ? 79 : 97);
            result = result * 59 + (this.isOverwritable() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "SchemaChangeCheckResult.BaseItem(type=" + (Object)((Object)this.getType()) + ", modelAlias=" + this.getModelAlias() + ", conflictReason=" + this.getConflictReason() + ", hasSameName=" + this.isHasSameName() + ", hasSameNameBroken=" + this.isHasSameNameBroken() + ", importable=" + this.isImportable() + ", creatable=" + this.isCreatable() + ", overwritable=" + this.isOverwritable() + ")";
        }

        @Generated
        public BaseItem() {
        }

        @Generated
        public BaseItem(SchemaNodeType type, String modelAlias, ConflictReason conflictReason, boolean hasSameName, boolean hasSameNameBroken, boolean importable, boolean creatable, boolean overwritable) {
            this.type = type;
            this.modelAlias = modelAlias;
            this.conflictReason = conflictReason;
            this.hasSameName = hasSameName;
            this.hasSameNameBroken = hasSameNameBroken;
            this.importable = importable;
            this.creatable = creatable;
            this.overwritable = overwritable;
        }
    }

    public static class ModelSchemaChange {
        private int differences;
        @JsonProperty(value="missing_items")
        private List<ChangedItem> missingItems = new ArrayList<ChangedItem>();
        @JsonProperty(value="new_items")
        private List<ChangedItem> newItems = new ArrayList<ChangedItem>();
        @JsonProperty(value="update_items")
        private List<UpdatedItem> updateItems = new ArrayList<UpdatedItem>();
        @JsonProperty(value="reduce_items")
        private List<ChangedItem> reduceItems = new ArrayList<ChangedItem>();

        @JsonProperty(value="importable")
        public boolean importable() {
            return Stream.of(this.missingItems, this.newItems, this.updateItems, this.reduceItems).flatMap(Collection::stream).allMatch(BaseItem::isImportable);
        }

        @JsonProperty(value="creatable")
        public boolean creatable() {
            return Stream.of(this.missingItems, this.newItems, this.updateItems, this.reduceItems).flatMap(Collection::stream).allMatch(BaseItem::isCreatable);
        }

        @JsonProperty(value="")
        public boolean overwritable() {
            return Stream.of(this.missingItems, this.newItems, this.updateItems, this.reduceItems).flatMap(Collection::stream).allMatch(BaseItem::isOverwritable);
        }

        public int getDifferences() {
            return this.missingItems.size() + this.newItems.size() + this.updateItems.size() + this.reduceItems.size();
        }

        @JsonProperty(value="has_same_name")
        public boolean hasSameName() {
            return Stream.of(this.missingItems, this.newItems, this.updateItems, this.reduceItems).flatMap(Collection::stream).allMatch(BaseItem::isHasSameName);
        }

        @JsonProperty(value="has_same_name_broken")
        public boolean hasSameNameBroken() {
            Set set = Stream.of(this.missingItems, this.newItems, this.updateItems, this.reduceItems).flatMap(Collection::stream).collect(Collectors.toSet());
            return !set.isEmpty() && set.stream().allMatch(BaseItem::isHasSameNameBroken);
        }

        @Generated
        public ModelSchemaChange() {
        }

        @Generated
        public List<ChangedItem> getMissingItems() {
            return this.missingItems;
        }

        @Generated
        public List<ChangedItem> getNewItems() {
            return this.newItems;
        }

        @Generated
        public List<UpdatedItem> getUpdateItems() {
            return this.updateItems;
        }

        @Generated
        public List<ChangedItem> getReduceItems() {
            return this.reduceItems;
        }

        @Generated
        public void setDifferences(int differences) {
            this.differences = differences;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModelSchemaChange)) {
                return false;
            }
            ModelSchemaChange other = (ModelSchemaChange)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDifferences() != other.getDifferences()) {
                return false;
            }
            List<ChangedItem> this$missingItems = this.getMissingItems();
            List<ChangedItem> other$missingItems = other.getMissingItems();
            if (this$missingItems == null ? other$missingItems != null : !((Object)this$missingItems).equals(other$missingItems)) {
                return false;
            }
            List<ChangedItem> this$newItems = this.getNewItems();
            List<ChangedItem> other$newItems = other.getNewItems();
            if (this$newItems == null ? other$newItems != null : !((Object)this$newItems).equals(other$newItems)) {
                return false;
            }
            List<UpdatedItem> this$updateItems = this.getUpdateItems();
            List<UpdatedItem> other$updateItems = other.getUpdateItems();
            if (this$updateItems == null ? other$updateItems != null : !((Object)this$updateItems).equals(other$updateItems)) {
                return false;
            }
            List<ChangedItem> this$reduceItems = this.getReduceItems();
            List<ChangedItem> other$reduceItems = other.getReduceItems();
            return !(this$reduceItems == null ? other$reduceItems != null : !((Object)this$reduceItems).equals(other$reduceItems));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ModelSchemaChange;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDifferences();
            List<ChangedItem> $missingItems = this.getMissingItems();
            result = result * 59 + ($missingItems == null ? 43 : ((Object)$missingItems).hashCode());
            List<ChangedItem> $newItems = this.getNewItems();
            result = result * 59 + ($newItems == null ? 43 : ((Object)$newItems).hashCode());
            List<UpdatedItem> $updateItems = this.getUpdateItems();
            result = result * 59 + ($updateItems == null ? 43 : ((Object)$updateItems).hashCode());
            List<ChangedItem> $reduceItems = this.getReduceItems();
            result = result * 59 + ($reduceItems == null ? 43 : ((Object)$reduceItems).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SchemaChangeCheckResult.ModelSchemaChange(differences=" + this.getDifferences() + ", missingItems=" + this.getMissingItems() + ", newItems=" + this.getNewItems() + ", updateItems=" + this.getUpdateItems() + ", reduceItems=" + this.getReduceItems() + ")";
        }

        @Generated
        private void setMissingItems(List<ChangedItem> missingItems) {
            this.missingItems = missingItems;
        }

        @Generated
        private void setNewItems(List<ChangedItem> newItems) {
            this.newItems = newItems;
        }

        @Generated
        private void setUpdateItems(List<UpdatedItem> updateItems) {
            this.updateItems = updateItems;
        }

        @Generated
        private void setReduceItems(List<ChangedItem> reduceItems) {
            this.reduceItems = reduceItems;
        }
    }
}

