/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruthTable<E> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TruthTable.class);
    private final List<Expr<E>> allOperands;
    private final Expr<E> expr;

    TruthTable(List<Expr<E>> allOperands, Expr<E> expr) {
        this.allOperands = allOperands;
        this.expr = expr;
    }

    public String toString() {
        return "TruthTable{allOperands=" + this.allOperands + ", expr=" + this.expr + '}';
    }

    public int hashCode() {
        return this.allOperands.hashCode() * 31 + this.expr.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TruthTable)) {
            return false;
        }
        TruthTable tbl2 = (TruthTable)obj;
        log.debug("Comparing table1: {} with table2 {}", (Object)this, (Object)tbl2);
        if (this.allOperands.size() != tbl2.allOperands.size()) {
            return false;
        }
        for (Expr<E> operand : this.allOperands) {
            if (tbl2.allOperands.contains(operand)) continue;
            return false;
        }
        InputGenerator tbl1InputGenerator = new InputGenerator();
        while (tbl1InputGenerator.hasNext()) {
            Object input = tbl1InputGenerator.next();
            if (this.eval((Input<E>)input) == tbl2.eval(((Input)input).mapOperands(tbl2.allOperands))) continue;
            return false;
        }
        return true;
    }

    public boolean eval(Input<E> input) {
        return this.doEval(this.expr, input);
    }

    private boolean doEval(Expr<E> expr, Input<E> input) {
        switch (expr.op) {
            case IDENTITY: {
                return input.getValue(expr);
            }
            case NOT: {
                return !this.doEval(expr.operands.get(0), input);
            }
            case AND: {
                for (Expr innerExpr : expr.operands) {
                    if (this.doEval(innerExpr, input)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (Expr innerExpr : expr.operands) {
                    if (!this.doEval(innerExpr, input)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalStateException("Invalid Operator" + (Object)((Object)expr.op));
    }

    public static class ExprBuilder<T> {
        Set<Expr<T>> allOperandSet = new HashSet<Expr<T>>();
        Deque<Operator> operatorStack = new ArrayDeque<Operator>();
        Deque<List<Expr<T>>> exprsStack = new ArrayDeque<List<Expr<T>>>();
        Comparator<T> operandComparator;

        public ExprBuilder(Comparator<T> operandComparator) {
            this.operandComparator = operandComparator;
            this.exprsStack.push(new LinkedList());
        }

        public ExprBuilder<T> compositeStart(Operator operator) {
            this.operatorStack.push(operator);
            this.exprsStack.push(new LinkedList());
            return this;
        }

        public ExprBuilder<T> compositeEnd() {
            Expr<T> composited = new Expr<T>(this.operatorStack.pop(), this.operandComparator, this.exprsStack.pop());
            Objects.requireNonNull(this.exprsStack.peek()).add(composited);
            return this;
        }

        public ExprBuilder<T> addExpr(T operand) {
            Expr<T> expr = new Expr<T>(operand, this.operandComparator);
            this.allOperandSet.add(expr);
            Objects.requireNonNull(this.exprsStack.peek()).add(expr);
            return this;
        }

        protected Expr<T> build() {
            return Objects.requireNonNull(this.exprsStack.peek()).get(0);
        }
    }

    static class Expr<T> {
        Operator op;
        List<Expr<T>> operands;
        T operand;
        Comparator<T> operandComparator;

        Expr(Operator op, Comparator<T> operandComparator, List<Expr<T>> operands) {
            this.op = op;
            this.operands = operands;
            this.operandComparator = operandComparator;
        }

        Expr(T operand, Comparator<T> operandComparator) {
            this.op = Operator.IDENTITY;
            this.operand = operand;
            this.operandComparator = operandComparator;
            this.operands = Collections.emptyList();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Expr)) {
                return false;
            }
            Expr that = (Expr)obj;
            if (this.op != that.op || this.operands.size() != that.operands.size() || this.operandComparator.compare(this.operand, that.operand) != 0) {
                return false;
            }
            for (int i = 0; i < this.operands.size(); ++i) {
                if (Objects.equals(this.operands.get(i), that.operands.get(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.op.hashCode();
            result = 31 * result + this.operand.hashCode();
            for (Expr<T> expr : this.operands) {
                result = 31 * result + expr.hashCode();
            }
            return result;
        }

        public String toString() {
            String exprStr = StringUtils.join((Object[])new Object[]{this.operands, ", ", "[", "]"});
            return "Expr{op=" + (Object)((Object)this.op) + ", operands=" + exprStr + ", operand=" + this.operand + '}';
        }
    }

    public static enum Operator {
        AND,
        OR,
        NOT,
        IDENTITY;

    }

    private class InputGenerator<T>
    implements Iterator<Input<T>> {
        int inputSize;
        int inputMax;
        int inputBits;

        private InputGenerator() {
            this.inputSize = TruthTable.this.allOperands.size();
            this.inputMax = (int)Math.pow(2.0, this.inputSize);
            this.inputBits = 0;
        }

        @Override
        public boolean hasNext() {
            return this.inputBits < this.inputMax;
        }

        @Override
        public Input<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            HashMap input = new HashMap();
            if (log.isTraceEnabled()) {
                log.trace("Generating next input {}, max inputValues bits {}", (Object)Integer.toBinaryString(this.inputBits), (Object)Integer.toBinaryString(this.inputMax - 1));
            }
            for (int i = 0; i < this.inputSize; ++i) {
                boolean value = (this.inputBits & 1 << i) != 0;
                input.put((Expr)TruthTable.this.allOperands.get(i), value);
            }
            ++this.inputBits;
            return new Input(input);
        }
    }

    private static class Input<T> {
        private final Map<Expr<T>, Boolean> inputValues;

        Input(Map<Expr<T>, Boolean> inputValues) {
            this.inputValues = inputValues;
        }

        boolean getValue(Expr<T> expr) {
            return this.inputValues.get(expr);
        }

        Input<T> mapOperands(List<Expr<T>> operands) {
            Preconditions.checkArgument((operands.size() == this.inputValues.size() ? 1 : 0) != 0);
            HashMap<Expr<T>, Boolean> mappedInput = new HashMap<Expr<T>, Boolean>();
            for (Expr<T> expr : operands) {
                Preconditions.checkArgument((this.inputValues.get(expr) != null ? 1 : 0) != 0, (Object)"Invalid table expr for operands mapping");
                mappedInput.put(expr, this.inputValues.get(expr));
            }
            Preconditions.checkArgument((mappedInput.size() == this.inputValues.size() ? 1 : 0) != 0);
            return new Input<T>(mappedInput);
        }
    }
}

