/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.streaming.KafkaConfig;
import org.apache.kylin.metadata.streaming.KafkaConfigManager;
import org.apache.kylin.metadata.table.ATable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class TableDesc
extends ATable
implements Serializable,
ISourceAware {
    public static final String TABLE_TYPE_VIEW = "VIEW";
    public static final long NOT_READY = -1L;
    private static final String TRANSACTIONAL_TABLE_NAME_SUFFIX = "_hive_tx_intermediate";
    @JsonProperty(value="source_type")
    private int sourceType = 0;
    @JsonProperty(value="table_type")
    private String tableType;
    private Boolean hasInternal;
    private boolean hasInternalDeprecated = false;
    @JsonProperty(value="top")
    private boolean isTop;
    @JsonProperty(value="data_gen")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dataGen;
    @JsonProperty(value="increment_loading")
    private boolean incrementLoading;
    @JsonProperty(value="last_snapshot_path")
    private String lastSnapshotPath;
    @JsonProperty(value="last_snapshot_size")
    private long lastSnapshotSize;
    @JsonProperty(value="snapshot_last_modified")
    private long snapshotLastModified;
    @JsonProperty(value="query_hit_count")
    private int snapshotHitCount = 0;
    @JsonProperty(value="partition_column")
    private String partitionColumn;
    @JsonProperty(value="snapshot_partitions")
    private Map<String, Long> snapshotPartitions = Maps.newHashMap();
    @JsonProperty(value="snapshot_partitions_info")
    private Map<String, SnapshotPartitionInfo> snapshotPartitionsInfo = Maps.newHashMap();
    @JsonProperty(value="snapshot_total_rows")
    private long snapshotTotalRows;
    @JsonProperty(value="snapshot_partition_col")
    private String snapshotPartitionCol;
    @JsonProperty(value="selected_snapshot_partition_col")
    private String selectedSnapshotPartitionCol;
    @JsonProperty(value="temp_snapshot_path")
    private String tempSnapshotPath;
    @JsonProperty(value="snapshot_has_broken")
    private boolean snapshotHasBroken;
    private KafkaConfig kafkaConfig;
    @JsonProperty(value="transactional")
    private boolean isTransactional;
    private Boolean isRangePartition;
    private boolean rangePartitionDeprecated;
    @JsonProperty(value="partition_desc")
    private PartitionDesc partitionDesc;
    @JsonProperty(value="table_comment")
    private String tableComment;

    public static Pair<String, String> parseResourcePath(String path) {
        String prj;
        String table;
        int dash;
        int cut;
        if (path.endsWith(".json")) {
            path = path.substring(0, path.length() - ".json".length());
        }
        if ((cut = path.lastIndexOf("/")) >= 0) {
            path = path.substring(cut + 1);
        }
        if ((dash = path.indexOf("--")) >= 0) {
            table = path.substring(0, dash);
            prj = path.substring(dash + 2);
        } else {
            table = path;
            prj = null;
        }
        return Pair.newPair((Object)table, prj);
    }

    public TableDesc() {
    }

    public TableDesc(TableDesc other) {
        this.uuid = other.uuid;
        this.lastModified = other.lastModified;
        this.createTime = other.createTime;
        this.name = other.name;
        this.hasInternal = other.hasInternal;
        this.hasInternalDeprecated = other.hasInternalDeprecated;
        this.rangePartitionDeprecated = other.rangePartitionDeprecated;
        this.sourceType = other.sourceType;
        this.tableType = other.tableType;
        this.dataGen = other.dataGen;
        this.incrementLoading = other.incrementLoading;
        this.columns = new ColumnDesc[other.columns.length];
        for (int i = 0; i < other.columns.length; ++i) {
            this.columns[i] = new ColumnDesc(other.columns[i]);
            this.columns[i].init(this);
        }
        this.isTop = other.isTop;
        this.project = other.project;
        this.database.setName(other.getDatabase());
        this.identity = other.identity;
        this.lastSnapshotPath = other.lastSnapshotPath;
        this.lastSnapshotSize = other.lastSnapshotSize;
        this.partitionColumn = other.partitionColumn;
        this.snapshotPartitions = other.snapshotPartitions;
        this.snapshotPartitionsInfo = other.snapshotPartitionsInfo;
        this.snapshotTotalRows = other.snapshotTotalRows;
        this.selectedSnapshotPartitionCol = other.selectedSnapshotPartitionCol;
        this.snapshotPartitionCol = other.snapshotPartitionCol;
        this.snapshotLastModified = other.getSnapshotLastModified();
        this.snapshotHasBroken = other.snapshotHasBroken;
        this.kafkaConfig = other.kafkaConfig;
        this.isTransactional = other.isTransactional;
        this.isRangePartition = other.isRangePartition;
        this.partitionDesc = other.partitionDesc;
        this.tableComment = other.tableComment;
        this.setMvcc(other.getMvcc());
    }

    @JsonGetter(value="range_partition")
    public boolean isRangePartition() {
        return this.isRangePartition == null ? this.rangePartitionDeprecated : this.isRangePartition;
    }

    @JsonSetter(value="range_partition")
    public void setRangePartition(boolean isRangePartition) {
        this.isRangePartition = isRangePartition;
    }

    @JsonGetter(value="has_internal")
    public boolean isHasInternal() {
        return this.hasInternal == null ? this.hasInternalDeprecated : this.hasInternal;
    }

    @JsonSetter(value="has_internal")
    public void setHasInternal(boolean hasInternal) {
        this.hasInternal = hasInternal;
    }

    @JsonSetter(value="has_Internal")
    @Deprecated
    public void setHasInternalDeprecated(boolean hasInternalDeprecated) {
        this.hasInternalDeprecated = hasInternalDeprecated;
    }

    @JsonSetter(value="rangePartition")
    @Deprecated
    public void setRangePartitionDeprecated(boolean rangePartitionDeprecated) {
        this.rangePartitionDeprecated = rangePartitionDeprecated;
    }

    public boolean isAccessible(boolean turnOnStreaming) {
        return turnOnStreaming || this.getSourceType() != 1;
    }

    public MetadataType resourceType() {
        return MetadataType.TABLE_INFO;
    }

    public TableDesc appendColumns(ColumnDesc[] computedColumns, boolean makeCopy) {
        if (ArrayUtils.isEmpty((Object[])computedColumns)) {
            return this;
        }
        TableDesc ret = makeCopy ? new TableDesc(this) : this;
        Object[] existingColumns = ret.columns;
        ArrayList newColumns = Lists.newArrayList();
        for (ColumnDesc computedColumn : computedColumns) {
            boolean isFreshCC = true;
            for (Object existingColumn : existingColumns) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)((ColumnDesc)existingColumn).getName(), (CharSequence)computedColumn.getName())) continue;
                if (!((ColumnDesc)existingColumn).isComputedColumn()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "There is already a column named %s on table %s, please change your computed column name", computedColumn.getName(), this.getIdentity()));
                }
                isFreshCC = false;
            }
            if (!isFreshCC) continue;
            newColumns.add(computedColumn);
        }
        ArrayList expandedColumns = Lists.newArrayList((Object[])existingColumns);
        for (ColumnDesc newColumnDesc : newColumns) {
            newColumnDesc.init(ret);
            expandedColumns.add(newColumnDesc);
        }
        ret.columns = expandedColumns.toArray(new ColumnDesc[0]);
        return ret;
    }

    public ColumnDesc findColumnByName(String name) {
        int lastIndexOfDot = name.lastIndexOf(".");
        if (lastIndexOfDot >= 0) {
            name = name.substring(lastIndexOfDot + 1);
        }
        for (ColumnDesc c : this.columns) {
            if (!name.equalsIgnoreCase(c.getOriginalName())) continue;
            return c;
        }
        return null;
    }

    public String getBackTickIdentity() {
        return this.getBackTickCaseSensitiveIdentity("");
    }

    public String getDoubleQuoteIdentity() {
        return this.getDoubleQuoteCaseSensitiveIdentity("");
    }

    public String getBackTickTransactionalTableIdentity(String suffix) {
        return this.getBackTickCaseSensitiveIdentity(TRANSACTIONAL_TABLE_NAME_SUFFIX.toUpperCase(Locale.ROOT) + suffix);
    }

    public String getBackTickTransactionalTableIdentity(String temporaryWritableDB, String suffix) {
        String fullSuffix = TRANSACTIONAL_TABLE_NAME_SUFFIX.toUpperCase(Locale.ROOT) + suffix;
        if (StringUtils.isNotBlank((CharSequence)temporaryWritableDB)) {
            return String.format(Locale.ROOT, "`%s`.`%s`", temporaryWritableDB.toUpperCase(Locale.ROOT), this.getCaseSensitiveName() + fullSuffix);
        }
        return this.getBackTickTransactionalTableIdentity(suffix);
    }

    private String getBackTickCaseSensitiveIdentity(String suffix) {
        return "null".equals(this.getCaseSensitiveDatabase()) ? String.format(Locale.ROOT, "`%s`", this.getCaseSensitiveName()) : String.format(Locale.ROOT, "`%s`.`%s`", this.getCaseSensitiveDatabase(), this.getCaseSensitiveName() + suffix);
    }

    private String getDoubleQuoteCaseSensitiveIdentity(String suffix) {
        return "null".equals(this.getCaseSensitiveDatabase()) ? String.format(Locale.ROOT, "\"%s\"", this.getCaseSensitiveName()) : String.format(Locale.ROOT, "\"%s\".\"%s\"", this.getCaseSensitiveDatabase(), this.getCaseSensitiveName() + suffix);
    }

    public boolean isView() {
        return StringUtils.containsIgnoreCase((CharSequence)this.tableType, (CharSequence)TABLE_TYPE_VIEW);
    }

    public int getMaxColumnIndex() {
        if (this.columns == null) {
            return -1;
        }
        int max = -1;
        for (ColumnDesc col : this.columns) {
            int idx = col.getZeroBasedIndex();
            max = Math.max(max, idx);
        }
        return max;
    }

    public int getColumnCount() {
        return this.getMaxColumnIndex() + 1;
    }

    public String getDataGen() {
        return this.dataGen;
    }

    public long getSnapshotLastModified() {
        if (this.snapshotLastModified == 0L) {
            return this.lastModified;
        }
        return this.snapshotLastModified;
    }

    @Override
    public void init(String project) {
        super.init(project);
        if (this.sourceType == 1) {
            this.kafkaConfig = KafkaConfigManager.getInstance(KylinConfig.getInstanceFromEnv(), project).getKafkaConfig(this.getIdentity());
        }
    }

    public int hashCode() {
        return this.getTableAlias().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableDesc tableDesc = (TableDesc)o;
        if (this.sourceType != tableDesc.sourceType) {
            return false;
        }
        if (!Objects.equals(this.name, tableDesc.name)) {
            return false;
        }
        if (!Arrays.equals(this.columns, tableDesc.columns)) {
            return false;
        }
        return this.getIdentity().equals(tableDesc.getIdentity());
    }

    public String getTransactionalTableIdentity() {
        return (this.getIdentity() + TRANSACTIONAL_TABLE_NAME_SUFFIX).toUpperCase(Locale.ROOT);
    }

    public String getTransactionalTableIdentity(String temporaryWritableDB) {
        if (StringUtils.isNotBlank((CharSequence)temporaryWritableDB)) {
            return (String.format(Locale.ROOT, "%s.%s", temporaryWritableDB, this.getCaseSensitiveName()) + TRANSACTIONAL_TABLE_NAME_SUFFIX).toUpperCase(Locale.ROOT);
        }
        return this.getTransactionalTableIdentity();
    }

    public String getTransactionalTableName() {
        return (this.getName() + TRANSACTIONAL_TABLE_NAME_SUFFIX).toUpperCase(Locale.ROOT);
    }

    public String toString() {
        return "TableDesc{name='" + this.name + '\'' + ", columns=" + Arrays.toString(this.columns) + ", sourceType=" + this.sourceType + ", tableType='" + this.tableType + '\'' + ", database=" + this.database + ", identity='" + this.getIdentity() + '\'' + '}';
    }

    public static TableDesc mockup(String tableName) {
        TableDesc mockup = new TableDesc();
        mockup.setName(tableName);
        return mockup;
    }

    @Override
    public KylinConfig getConfig() {
        ProjectInstance projectInstance = NProjectManager.getInstance(KylinConfig.getInstanceFromEnv()).getProject(this.project);
        return projectInstance.getConfig();
    }

    @Override
    public int getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(int sourceType) {
        this.sourceType = sourceType;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public void deleteSnapshot(boolean makeBroken) {
        this.lastSnapshotPath = null;
        this.snapshotPartitionCol = null;
        this.snapshotPartitions = Maps.newHashMap();
        this.snapshotPartitionsInfo = Maps.newHashMap();
        this.selectedSnapshotPartitionCol = null;
        this.lastSnapshotSize = 0L;
        this.snapshotHasBroken = makeBroken;
    }

    public void copySnapshotFrom(TableDesc originTable) {
        this.setLastSnapshotPath(originTable.getLastSnapshotPath());
        this.setLastSnapshotSize(originTable.getLastSnapshotSize());
        this.setSnapshotPartitions(originTable.getSnapshotPartitions());
        this.setSnapshotPartitionCol(originTable.getSnapshotPartitionCol());
        this.setSelectedSnapshotPartitionCol(originTable.getSelectedSnapshotPartitionCol());
        this.setSnapshotLastModified(originTable.getSnapshotLastModified());
        this.setSnapshotHasBroken(originTable.isSnapshotHasBroken());
    }

    public void resetSnapshotPartitions(Set<String> snapshotPartitions) {
        this.snapshotPartitions = snapshotPartitions.stream().collect(Collectors.toMap(Function.identity(), item -> -1L));
        this.snapshotPartitionsInfo.clear();
    }

    public void putPartitionSize(String partition, long size) {
        this.snapshotPartitions.put(partition, size);
    }

    public void putPartitionRow(String partition, long row) {
        SnapshotPartitionInfo snapshotPartitionInfo = this.snapshotPartitionsInfo.get(partition);
        if (snapshotPartitionInfo != null) {
            snapshotPartitionInfo.setTotalRows(row);
        } else {
            snapshotPartitionInfo = new SnapshotPartitionInfo();
            snapshotPartitionInfo.setTotalRows(row);
            this.snapshotPartitionsInfo.put(partition, snapshotPartitionInfo);
        }
    }

    public long getPartitionRow(String partition) {
        SnapshotPartitionInfo snapshotPartitionInfo = this.snapshotPartitionsInfo.get(partition);
        if (snapshotPartitionInfo != null) {
            return snapshotPartitionInfo.getTotalRows();
        }
        return 0L;
    }

    public void addSnapshotPartitions(Set<String> snapshotPartitions) {
        snapshotPartitions.forEach(part -> this.snapshotPartitions.put((String)part, -1L));
    }

    public Set<String> getNotReadyPartitions() {
        HashSet notReadyPartitions = Sets.newHashSet();
        this.snapshotPartitions.forEach((item, ready) -> {
            if (ready == -1L) {
                notReadyPartitions.add(item);
            }
        });
        return notReadyPartitions;
    }

    public Set<String> getReadyPartitions() {
        HashSet readyPartitions = Sets.newHashSet();
        this.snapshotPartitions.forEach((item, ready) -> {
            if (ready != -1L) {
                readyPartitions.add(item);
            }
        });
        return readyPartitions;
    }

    public KafkaConfig getKafkaConfig() {
        return this.kafkaConfig;
    }

    public void setKafkaConfig(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
    }

    public boolean isKafkaTable() {
        return this.getSourceType() == 1 && this.getKafkaConfig() != null;
    }

    public String getTableAlias() {
        if (this.kafkaConfig != null && this.kafkaConfig.hasBatchTable()) {
            return this.kafkaConfig.getBatchTable();
        }
        return this.getIdentity();
    }

    public boolean isLogicalView() {
        return KylinConfig.getInstanceFromEnv().getDDLLogicalViewDB().equalsIgnoreCase(this.getDatabase());
    }

    @Generated
    public boolean isTop() {
        return this.isTop;
    }

    @Generated
    public void setTop(boolean isTop) {
        this.isTop = isTop;
    }

    @Generated
    public boolean isIncrementLoading() {
        return this.incrementLoading;
    }

    @Generated
    public void setIncrementLoading(boolean incrementLoading) {
        this.incrementLoading = incrementLoading;
    }

    @Generated
    public String getLastSnapshotPath() {
        return this.lastSnapshotPath;
    }

    @Generated
    public void setLastSnapshotPath(String lastSnapshotPath) {
        this.lastSnapshotPath = lastSnapshotPath;
    }

    @Generated
    public long getLastSnapshotSize() {
        return this.lastSnapshotSize;
    }

    @Generated
    public void setLastSnapshotSize(long lastSnapshotSize) {
        this.lastSnapshotSize = lastSnapshotSize;
    }

    @Generated
    public void setSnapshotLastModified(long snapshotLastModified) {
        this.snapshotLastModified = snapshotLastModified;
    }

    @Generated
    public int getSnapshotHitCount() {
        return this.snapshotHitCount;
    }

    @Generated
    public void setSnapshotHitCount(int snapshotHitCount) {
        this.snapshotHitCount = snapshotHitCount;
    }

    @Generated
    public void setPartitionColumn(String partitionColumn) {
        this.partitionColumn = partitionColumn;
    }

    @Generated
    public String getPartitionColumn() {
        return this.partitionColumn;
    }

    @Generated
    public Map<String, Long> getSnapshotPartitions() {
        return this.snapshotPartitions;
    }

    @Generated
    public void setSnapshotPartitions(Map<String, Long> snapshotPartitions) {
        this.snapshotPartitions = snapshotPartitions;
    }

    @Generated
    public Map<String, SnapshotPartitionInfo> getSnapshotPartitionsInfo() {
        return this.snapshotPartitionsInfo;
    }

    @Generated
    public void setSnapshotPartitionsInfo(Map<String, SnapshotPartitionInfo> snapshotPartitionsInfo) {
        this.snapshotPartitionsInfo = snapshotPartitionsInfo;
    }

    @Generated
    public long getSnapshotTotalRows() {
        return this.snapshotTotalRows;
    }

    @Generated
    public void setSnapshotTotalRows(long snapshotTotalRows) {
        this.snapshotTotalRows = snapshotTotalRows;
    }

    @Generated
    public String getSnapshotPartitionCol() {
        return this.snapshotPartitionCol;
    }

    @Generated
    public void setSnapshotPartitionCol(String snapshotPartitionCol) {
        this.snapshotPartitionCol = snapshotPartitionCol;
    }

    @Generated
    public void setSelectedSnapshotPartitionCol(String selectedSnapshotPartitionCol) {
        this.selectedSnapshotPartitionCol = selectedSnapshotPartitionCol;
    }

    @Generated
    public String getSelectedSnapshotPartitionCol() {
        return this.selectedSnapshotPartitionCol;
    }

    @Generated
    public void setTempSnapshotPath(String tempSnapshotPath) {
        this.tempSnapshotPath = tempSnapshotPath;
    }

    @Generated
    public String getTempSnapshotPath() {
        return this.tempSnapshotPath;
    }

    @Generated
    public void setSnapshotHasBroken(boolean snapshotHasBroken) {
        this.snapshotHasBroken = snapshotHasBroken;
    }

    @Generated
    public boolean isSnapshotHasBroken() {
        return this.snapshotHasBroken;
    }

    @Generated
    public void setTransactional(boolean isTransactional) {
        this.isTransactional = isTransactional;
    }

    @Generated
    public boolean isTransactional() {
        return this.isTransactional;
    }

    @Generated
    public void setPartitionDesc(PartitionDesc partitionDesc) {
        this.partitionDesc = partitionDesc;
    }

    @Generated
    public PartitionDesc getPartitionDesc() {
        return this.partitionDesc;
    }

    @Generated
    public String getTableComment() {
        return this.tableComment;
    }

    @Generated
    public void setTableComment(String tableComment) {
        this.tableComment = tableComment;
    }

    public static class SnapshotPartitionInfo
    implements Serializable {
        @JsonProperty(value="total_rows")
        private long totalRows;

        @Generated
        public void setTotalRows(long totalRows) {
            this.totalRows = totalRows;
        }

        @Generated
        public long getTotalRows() {
            return this.totalRows;
        }

        @Generated
        public SnapshotPartitionInfo() {
        }

        @Generated
        public SnapshotPartitionInfo(long totalRows) {
            this.totalRows = totalRows;
        }
    }
}

