/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.insensitive;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.insensitive.InsensitiveRequest;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ProjectInsensitiveRequest
extends InsensitiveRequest {
    @Override
    default public List<String> inSensitiveFields() {
        return Collections.singletonList("project");
    }

    @Override
    default public void updateField() {
        for (String fieldName : this.inSensitiveFields()) {
            Field field = this.getDeclaredField(this.getClass(), fieldName);
            if (field == null) continue;
            Unsafe.changeAccessibleObject((AccessibleObject)field, (boolean)true);
            try {
                String projectName = (String)field.get(this);
                if (StringUtils.isEmpty((CharSequence)projectName)) {
                    return;
                }
                NProjectManager projectManager = NProjectManager.getInstance(KylinConfig.getInstanceFromEnv());
                ProjectInstance projectInstance = projectManager.getProject(projectName);
                if (projectInstance == null) {
                    return;
                }
                field.set(this, projectInstance.getName());
            }
            catch (IllegalAccessException e) {
                LogHolder.log.warn("update project name failed ", (Throwable)e);
            }
        }
    }

    public static final class LogHolder {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(LogHolder.class);
    }
}

