/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.favorite;

import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.asynctask.AbstractAsyncTask;
import org.apache.kylin.metadata.asynctask.MetadataRestoreTask;
import org.apache.kylin.metadata.favorite.AsyncAccelerationTask;
import org.apache.kylin.metadata.favorite.AsyncTaskStore;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class AsyncTaskManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncTaskManager.class);
    public static final String ASYNC_ACCELERATION_TASK = "async_acceleration_task";
    public static final String METADATA_RECOVER_TASK = "metadata_recover_task";
    public static final List<String> ALL_TASK_TYPES = Lists.newArrayList((Object[])new String[]{"async_acceleration_task", "metadata_recover_task"});
    private final AsyncTaskStore asyncTaskStore;
    private final String project;

    private AsyncTaskManager(String project) throws Exception {
        this.project = project;
        this.asyncTaskStore = new AsyncTaskStore(KylinConfig.getInstanceFromEnv());
    }

    public static AsyncTaskManager getInstance(String project) {
        return (AsyncTaskManager)Singletons.getInstance((String)project, AsyncTaskManager.class);
    }

    public DataSourceTransactionManager getTransactionManager() {
        return this.asyncTaskStore.getTransactionManager();
    }

    public void save(AbstractAsyncTask asyncTask) {
        if (asyncTask.getTaskType().equalsIgnoreCase(ASYNC_ACCELERATION_TASK)) {
            this.saveOrUpdateAsyncAccelerationTask(asyncTask);
        } else if (asyncTask.getTaskType().equalsIgnoreCase(METADATA_RECOVER_TASK)) {
            this.saveOrUpdateMetadataRestoreTask(asyncTask);
        }
    }

    private void saveOrUpdateMetadataRestoreTask(AbstractAsyncTask asyncTask) {
        AbstractAsyncTask asyncTask1 = this.get(asyncTask.getTaskType(), asyncTask.getTaskKey());
        if (asyncTask1 == null) {
            asyncTask.setCreateTime(System.currentTimeMillis());
            asyncTask.setUpdateTime(asyncTask.getCreateTime());
            this.asyncTaskStore.save(asyncTask);
        } else {
            asyncTask.setUpdateTime(System.currentTimeMillis());
            this.asyncTaskStore.update(asyncTask);
        }
    }

    private void saveOrUpdateAsyncAccelerationTask(AbstractAsyncTask asyncTask) {
        asyncTask.setTaskKey(this.project);
        if (asyncTask.getId() == 0) {
            asyncTask.setProject(this.project);
            asyncTask.setCreateTime(System.currentTimeMillis());
            asyncTask.setUpdateTime(asyncTask.getCreateTime());
            this.asyncTaskStore.save(asyncTask);
        } else {
            asyncTask.setUpdateTime(System.currentTimeMillis());
            this.asyncTaskStore.update(asyncTask);
        }
    }

    public <T extends AbstractAsyncTask> T copyForWrite(T task) {
        return task;
    }

    public AbstractAsyncTask get(String taskType) {
        return this.get(taskType, this.project);
    }

    public AbstractAsyncTask get(String taskType, String taskKey) {
        if (!taskType.equalsIgnoreCase(ASYNC_ACCELERATION_TASK) && !taskType.equalsIgnoreCase(METADATA_RECOVER_TASK)) {
            throw new IllegalArgumentException("TaskType " + taskType + "is not supported!");
        }
        AbstractAsyncTask asyncTask = this.asyncTaskStore.queryByTypeAndKey(taskType, taskKey);
        switch (taskType) {
            case "async_acceleration_task": {
                if (asyncTask == null) {
                    return new AsyncAccelerationTask(false, Maps.newHashMap(), ASYNC_ACCELERATION_TASK);
                }
                return AsyncAccelerationTask.copyFromAbstractTask(asyncTask);
            }
            case "metadata_recover_task": {
                return MetadataRestoreTask.copyFromAbstractTask(asyncTask);
            }
        }
        return asyncTask;
    }

    public List<AbstractAsyncTask> getAllAsyncTaskByType(String taskType) {
        if (!taskType.equalsIgnoreCase(ASYNC_ACCELERATION_TASK) && !taskType.equalsIgnoreCase(METADATA_RECOVER_TASK)) {
            throw new IllegalArgumentException("TaskType " + taskType + "is not supported!");
        }
        return this.asyncTaskStore.queryByType(taskType);
    }

    public static void resetAccelerationTagMap(String project) {
        log.info("reset acceleration tag for project({})", (Object)project);
        AsyncTaskManager manager = AsyncTaskManager.getInstance(project);
        JdbcUtil.withTxAndRetry((DataSourceTransactionManager)manager.getTransactionManager(), () -> {
            AsyncAccelerationTask asyncAcceleration = (AsyncAccelerationTask)manager.get(ASYNC_ACCELERATION_TASK);
            AsyncAccelerationTask copied = manager.copyForWrite(asyncAcceleration);
            copied.setAlreadyRunning(false);
            copied.setUserRefreshedTagMap(Maps.newHashMap());
            manager.save(asyncAcceleration);
            return null;
        });
        log.info("rest acceleration tag successfully for project({})", (Object)project);
    }

    public static void cleanAccelerationTagByUser(String project, String userName) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ProjectInstance projectInstance = NProjectManager.getInstance(kylinConfig).getProject(project);
        if (!projectInstance.isSemiAutoMode()) {
            log.debug("Recommendation is forbidden of project({}), there's no need to clean acceleration tag", (Object)project);
            return;
        }
        log.info("start to clean acceleration tag by user");
        AsyncTaskManager manager = AsyncTaskManager.getInstance(project);
        JdbcUtil.withTxAndRetry((DataSourceTransactionManager)manager.getTransactionManager(), () -> {
            AsyncAccelerationTask asyncAcceleration = (AsyncAccelerationTask)manager.get(ASYNC_ACCELERATION_TASK);
            AsyncAccelerationTask copied = manager.copyForWrite(asyncAcceleration);
            copied.getUserRefreshedTagMap().put(userName, false);
            manager.save(asyncAcceleration);
            return null;
        });
        log.info("clean acceleration tag successfully for project({}: by user {})", (Object)project, (Object)userName);
    }
}

