/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.storage;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.storage.GarbageStorageCollector;
import org.apache.kylin.metadata.cube.storage.StorageInfoCollector;
import org.apache.kylin.metadata.cube.storage.StorageInfoEnum;
import org.apache.kylin.metadata.cube.storage.StorageQuotaCollector;
import org.apache.kylin.metadata.cube.storage.StorageVolumeInfo;
import org.apache.kylin.metadata.cube.storage.TotalStorageCollector;

public class ProjectStorageInfoCollector {
    private List<StorageInfoCollector> collectors = Lists.newArrayList();
    private static GarbageStorageCollector garbageStorageCollector = new GarbageStorageCollector();
    private static TotalStorageCollector totalStorageCollector = new TotalStorageCollector();
    private static StorageQuotaCollector storageQuotaCollector = new StorageQuotaCollector();

    public ProjectStorageInfoCollector(List<StorageInfoEnum> storageInfoList) {
        if (CollectionUtils.isNotEmpty(storageInfoList)) {
            storageInfoList.forEach(this::addCollectors);
        }
    }

    private void collect(KylinConfig config, String project, StorageVolumeInfo storageVolumeInfo) {
        for (StorageInfoCollector collector : this.collectors) {
            try {
                collector.collect(config, project, storageVolumeInfo);
            }
            catch (Exception e) {
                storageVolumeInfo.getThrowableMap().put(collector.getType(), e);
            }
        }
    }

    private void addCollectors(StorageInfoEnum storageInfoEnum) {
        switch (storageInfoEnum) {
            case GARBAGE_STORAGE: {
                this.collectors.add(garbageStorageCollector);
                break;
            }
            case TOTAL_STORAGE: {
                this.collectors.add(totalStorageCollector);
                break;
            }
            case STORAGE_QUOTA: {
                this.collectors.add(storageQuotaCollector);
                break;
            }
        }
    }

    public StorageVolumeInfo getStorageVolumeInfo(KylinConfig config, String project) {
        StorageVolumeInfo storageVolumeInfo = new StorageVolumeInfo();
        if (StringUtils.isBlank((CharSequence)project) || CollectionUtils.isEmpty(this.collectors)) {
            return storageVolumeInfo;
        }
        this.collect(config, project, storageVolumeInfo);
        return storageVolumeInfo;
    }
}

