/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Range;
import org.apache.kylin.metadata.cube.model.DimensionRangeInfo;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegDetails;
import org.apache.kylin.metadata.cube.model.NDataSegDetailsManager;
import org.apache.kylin.metadata.cube.model.NDataSegmentManager;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.SegmentPartition;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.TimeRange;
import org.apache.kylin.metadata.model.util.MultiPartitionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NDataSegment
extends RootPersistentEntity
implements ISegment,
Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NDataSegment.class);
    @JsonProperty(value="model_uuid")
    private String modelUuid;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="create_time_utc")
    private long createTimeUTC;
    @JsonProperty(value="status")
    private SegmentStatusEnum status;
    @JsonProperty(value="segRange")
    private SegmentRange segmentRange;
    @JsonProperty(value="timeRange")
    private TimeRange timeRange;
    @JsonProperty(value="dimension_range_info_map")
    private Map<String, DimensionRangeInfo> dimensionRangeInfoMap = Maps.newHashMap();
    @JsonProperty(value="parameters")
    private Map<String, String> parameters;
    @JsonProperty(value="dictionaries")
    private Map<String, String> dictionaries;
    @JsonProperty(value="snapshots")
    private Map<String, String> snapshots;
    @JsonProperty(value="last_build_time")
    private long lastBuildTime;
    @JsonProperty(value="source_count")
    private long sourceCount = 0L;
    @JsonProperty(value="source_bytes_size")
    private long sourceBytesSize = 0L;
    @JsonProperty(value="column_source_bytes")
    private Map<String, Long> columnSourceBytes = Maps.newHashMap();
    @JsonProperty(value="ori_snapshot_size")
    private Map<String, Long> oriSnapshotSize = Maps.newHashMap();
    private Long storageSize = null;
    private Long storageFileCount = null;
    @JsonProperty(value="additionalInfo")
    private Map<String, String> additionalInfo = Maps.newLinkedHashMap();
    @JsonProperty(value="is_realtime_segment")
    private boolean isRealtimeSegment = false;
    @JsonProperty(value="is_snapshot_ready")
    private boolean isSnapshotReady = false;
    @JsonProperty(value="is_dict_ready")
    private boolean isDictReady = false;
    @JsonProperty(value="is_flat_table_ready")
    private boolean isFlatTableReady = false;
    @JsonProperty(value="is_fact_view_ready")
    private boolean isFactViewReady = false;
    @JsonProperty(value="multi_partitions")
    private List<SegmentPartition> multiPartitions = Lists.newArrayList();
    @JsonProperty(value="max_bucket_id")
    private long maxBucketId = -1L;
    private transient Map<Long, SegmentPartition> partitionMap = Maps.newHashMap();
    private volatile transient LayoutInfo layoutInfo;
    private Map<String, String> extraBuildOptions = Maps.newHashMap();
    private NDataflow dataflow;

    public NDataSegment() {
    }

    public static NDataSegment empty() {
        return new NDataSegment(false);
    }

    protected NDataSegment(boolean lazyload) {
        if (lazyload) {
            throw new IllegalArgumentException("only manager which deserialize object can lazy load segmentdetail");
        }
        this.layoutInfo = new LayoutInfo();
    }

    public NDataSegment(NDataSegment other) {
        this.uuid = other.uuid;
        this.modelUuid = other.modelUuid;
        this.dataflow = other.dataflow;
        this.name = other.name;
        this.createTimeUTC = other.createTimeUTC;
        this.status = other.status;
        this.segmentRange = other.segmentRange;
        this.timeRange = other.timeRange;
        this.dictionaries = other.dictionaries;
        this.lastBuildTime = other.lastBuildTime;
        this.sourceCount = other.sourceCount;
        this.additionalInfo = other.additionalInfo;
        this.isSnapshotReady = other.isSnapshotReady;
        this.isDictReady = other.isDictReady;
        this.isFlatTableReady = other.isFlatTableReady;
        this.isFactViewReady = other.isFactViewReady;
        this.setMvcc(other.getMvcc());
        this.layoutInfo = new LayoutInfo(other.getSegDetails());
    }

    public <T extends Comparable<?>> NDataSegment(NDataflow df, SegmentRange<T> segmentRange) {
        this.modelUuid = df.getUuid();
        this.dataflow = df;
        this.segmentRange = segmentRange;
        this.name = Segments.makeSegmentName(segmentRange);
        this.createTimeUTC = System.currentTimeMillis();
        this.status = SegmentStatusEnum.NEW;
        this.layoutInfo = new LayoutInfo();
    }

    public <T extends Comparable<?>> NDataSegment(NDataflow df, SegmentRange<T> segmentRange, Map<String, DimensionRangeInfo> dimensionRangeInfoMap) {
        this.dataflow = df;
        this.segmentRange = segmentRange;
        this.name = Segments.makeSegmentName(segmentRange);
        this.uuid = RandomUtil.randomUUIDStr();
        this.createTimeUTC = System.currentTimeMillis();
        this.status = SegmentStatusEnum.NEW;
        this.layoutInfo = new LayoutInfo();
        this.dimensionRangeInfoMap = dimensionRangeInfoMap;
    }

    public <T extends Comparable<?>> NDataSegment(NDataflow df, SegmentRange<T> segRange, String uuid) {
        this(df, segRange);
        if (!StringUtils.isEmpty((CharSequence)uuid)) {
            this.uuid = uuid;
        }
        HashMap<Long, NDataLayout> layouts = new HashMap<Long, NDataLayout>();
        for (LayoutEntity layout : df.getIndexPlan().getAllLayouts()) {
            NDataLayout ly = NDataLayout.newDataLayout(df, this.getId(), layout.getId());
            layouts.put(ly.getLayoutId(), ly);
        }
        this.layoutInfo = new LayoutInfo(layouts);
    }

    void initAfterReload() {
        this.multiPartitions.forEach(partition -> {
            partition.setSegment(this);
            this.partitionMap.put(partition.getPartitionId(), (SegmentPartition)partition);
        });
    }

    void initDataFlow() {
        if (this.dataflow == null) {
            this.dataflow = NDataflowManager.getInstance(KylinConfig.getInstanceFromEnv(), this.project).getDataflow(this.modelUuid);
        }
    }

    @Override
    public KylinConfig getConfig() {
        return this.dataflow.getConfig();
    }

    @Override
    public boolean isOffsetCube() {
        return this.segmentRange instanceof SegmentRange.KafkaOffsetPartitionedSegmentRange;
    }

    @Override
    public SegmentRange getSegRange() {
        return this.segmentRange;
    }

    @Override
    public SegmentRange.KafkaOffsetPartitionedSegmentRange getKSRange() {
        if (this.segmentRange instanceof SegmentRange.KafkaOffsetPartitionedSegmentRange) {
            return (SegmentRange.KafkaOffsetPartitionedSegmentRange)this.segmentRange;
        }
        return null;
    }

    @Override
    public Map<String, DimensionRangeInfo> getDimensionRangeInfoMap() {
        return this.dimensionRangeInfoMap;
    }

    @Override
    public TimeRange getTSRange() {
        if (this.timeRange != null) {
            return this.timeRange;
        }
        if (this.segmentRange instanceof SegmentRange.TimePartitionedSegmentRange) {
            SegmentRange.TimePartitionedSegmentRange tsr = (SegmentRange.TimePartitionedSegmentRange)this.segmentRange;
            return new TimeRange(tsr.getStart(), tsr.getEnd());
        }
        if (this.segmentRange instanceof SegmentRange.KafkaOffsetPartitionedSegmentRange) {
            SegmentRange.KafkaOffsetPartitionedSegmentRange tsr = (SegmentRange.KafkaOffsetPartitionedSegmentRange)this.segmentRange;
            return new TimeRange(tsr.getStart(), tsr.getEnd(), tsr.getSourcePartitionOffsetStart(), tsr.getSourcePartitionOffsetEnd());
        }
        return null;
    }

    @Override
    public Range<Long> getRange() {
        TimeRange tsRange = this.getTSRange();
        return Range.closedOpen((Comparable)Long.valueOf(tsRange.getStart()), (Comparable)Long.valueOf(tsRange.getEnd()));
    }

    public void setSegmentRange(SegmentRange segmentRange) {
        this.checkIsNotCachedAndShared();
        this.segmentRange = segmentRange;
    }

    public void setDimensionRangeInfoMap(Map<String, DimensionRangeInfo> dimensionRangeInfoMap) {
        this.checkIsNotCachedAndShared();
        this.dimensionRangeInfoMap = dimensionRangeInfoMap;
    }

    public void setTimeRange(TimeRange timeRange) {
        this.checkIsNotCachedAndShared();
        this.timeRange = timeRange;
    }

    public NDataSegDetails getSegDetails() {
        return this.getLayoutInfo().getSegDetails();
    }

    @Override
    public int getLayoutSize() {
        return this.getLayoutInfo().getLayoutSize();
    }

    @Override
    public int getEffectiveLayoutSize() {
        return (int)this.getLayoutInfo().getLayoutsMap().values().stream().filter(NDataLayout::filterEffectiveLayout).count();
    }

    public NDataLayout getLayout(long layoutId) {
        return this.getLayout(layoutId, false);
    }

    public NDataLayout getLayout(long layoutId, boolean includingNonWorkingLayout) {
        if (includingNonWorkingLayout) {
            return this.getAllLayoutsMap().get(layoutId);
        }
        return this.getLayoutsMap().get(layoutId);
    }

    public Map<Long, NDataLayout> getLayoutsMap() {
        return this.getLayoutInfo().getLayoutsMap();
    }

    public Map<Long, NDataLayout> getAllLayoutsMap() {
        return this.getLayoutInfo().getAllLayoutsMap();
    }

    public Set<Long> getLayoutIds() {
        return this.getLayoutInfo().getLayoutIds();
    }

    public List<Long> getMultiPartitionIds() {
        return this.getLayoutInfo().getMultiPartitionIds();
    }

    public Long getBucketId(long cuboidId, Long partitionId) {
        return this.getLayoutInfo().getBucketId(cuboidId, partitionId);
    }

    public boolean isAlreadyBuilt(long layoutId) {
        return this.getLayoutInfo().isAlreadyBuilt(layoutId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutInfo getLayoutInfo() {
        boolean doInit = false;
        if (this.layoutInfo == null) {
            NDataSegment nDataSegment = this;
            synchronized (nDataSegment) {
                if (this.layoutInfo == null) {
                    doInit = true;
                    this.layoutInfo = new LayoutInfo(true);
                }
            }
        }
        if (doInit) {
            this.setDependencies(Collections.singletonList(this.layoutInfo.getSegDetails()));
        }
        return this.layoutInfo;
    }

    @Override
    public NDataModel getModel() {
        return this.dataflow.getModel();
    }

    public IndexPlan getIndexPlan() {
        return this.dataflow.getIndexPlan();
    }

    @Override
    public void validate() {
    }

    public NDataflow getDataflow() {
        return this.dataflow;
    }

    public void setDataflow(NDataflow df) {
        this.dataflow = df;
        if (!df.getUuid().equals(this.modelUuid)) {
            this.checkIsNotCachedAndShared();
            this.modelUuid = df.getUuid();
        }
    }

    public void setId(String uuid) {
        this.checkIsNotCachedAndShared();
        this.uuid = uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkIsNotCachedAndShared();
        this.name = name;
    }

    @Override
    public SegmentStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(SegmentStatusEnum status) {
        this.checkIsNotCachedAndShared();
        this.status = status;
    }

    @Override
    public long getLastBuildTime() {
        return this.lastBuildTime;
    }

    public void setLastBuildTime(long lastBuildTime) {
        this.checkIsNotCachedAndShared();
        this.lastBuildTime = lastBuildTime;
    }

    public Map<String, String> getParameters() {
        if (this.parameters == null) {
            this.parameters = Maps.newConcurrentMap();
        }
        return this.isCachedAndShared() ? ImmutableMap.copyOf(this.parameters) : this.parameters;
    }

    public String getParameter(String key) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(key);
    }

    public void setParameters(Map<String, String> parameters) {
        this.checkIsNotCachedAndShared();
        this.parameters = parameters;
    }

    public void addParameter(String key, String value) {
        this.checkIsNotCachedAndShared();
        if (this.parameters == null) {
            this.parameters = Maps.newConcurrentMap();
        }
        this.parameters.put(key, value);
    }

    public Map<String, String> getDictionaries() {
        if (this.dictionaries == null) {
            this.dictionaries = Maps.newConcurrentMap();
        }
        return this.isCachedAndShared() ? ImmutableMap.copyOf(this.dictionaries) : this.dictionaries;
    }

    public void putDictResPath(TblColRef col, String dictResPath) {
        this.checkIsNotCachedAndShared();
        this.getDictionaries();
        String dictKey = col.getIdentity();
        this.dictionaries.put(dictKey, dictResPath);
    }

    public void setDictionaries(Map<String, String> dictionaries) {
        this.checkIsNotCachedAndShared();
        this.dictionaries = dictionaries;
    }

    public long getCreateTimeUTC() {
        return this.createTimeUTC;
    }

    public void setCreateTimeUTC(long createTimeUTC) {
        this.checkIsNotCachedAndShared();
        this.createTimeUTC = createTimeUTC;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.isCachedAndShared() ? ImmutableMap.copyOf(this.additionalInfo) : this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.checkIsNotCachedAndShared();
        this.additionalInfo = additionalInfo;
    }

    public long getSourceCount() {
        if (CollectionUtils.isEmpty(this.multiPartitions)) {
            return this.sourceCount;
        }
        return this.multiPartitions.stream().mapToLong(SegmentPartition::getSourceCount).sum();
    }

    public void setSourceCount(long sourceCount) {
        this.checkIsNotCachedAndShared();
        this.sourceCount = sourceCount;
    }

    public long getSourceBytesSize() {
        return this.sourceBytesSize;
    }

    public void setSourceBytesSize(long sourceBytesSize) {
        this.checkIsNotCachedAndShared();
        this.sourceBytesSize = sourceBytesSize;
    }

    public Map<String, Long> getColumnSourceBytes() {
        if (this.sourceCount == 0L) {
            if (!this.columnSourceBytes.isEmpty()) {
                log.warn("Segment[{}] sourceCount is 0, but columnSourceBytes non-empty.", (Object)this.getId());
            }
            return Maps.newHashMap();
        }
        return this.columnSourceBytes;
    }

    public void setColumnSourceBytes(Map<String, Long> columnSourceBytes) {
        this.columnSourceBytes = columnSourceBytes;
    }

    public List<SegmentPartition> getMultiPartitions() {
        return this.multiPartitions;
    }

    public void setMultiPartitions(List<SegmentPartition> multiPartitions) {
        this.checkIsNotCachedAndShared();
        this.multiPartitions = multiPartitions;
    }

    public Set<Long> getAllPartitionIds() {
        return this.multiPartitions.stream().map(SegmentPartition::getPartitionId).collect(Collectors.toSet());
    }

    public MetadataType resourceType() {
        return MetadataType.SEGMENT;
    }

    public void checkIsNotCachedAndShared() {
        if (this.isCachedAndShared()) {
            throw new IllegalStateException();
        }
    }

    public long getStorageBytesSize() {
        if (this.storageSize == null) {
            long size = 0L;
            Collection<NDataLayout> dataLayouts = this.getLayoutsMap().values();
            for (NDataLayout dataLayout : dataLayouts) {
                size += dataLayout.getByteSize();
            }
            this.storageSize = size;
        }
        return this.storageSize;
    }

    public long getStorageFileCount() {
        if (this.storageFileCount == null) {
            long fileCount = 0L;
            Collection<NDataLayout> dataLayouts = this.getLayoutsMap().values();
            for (NDataLayout dataLayout : dataLayouts) {
                fileCount += dataLayout.getFileCount();
            }
            this.storageFileCount = fileCount;
        }
        return this.storageFileCount;
    }

    public boolean isRealtimeSegment() {
        return this.isRealtimeSegment;
    }

    public void setRealtimeSegment(boolean realtimeSegment) {
        this.isRealtimeSegment = realtimeSegment;
    }

    public boolean isSnapshotReady() {
        return this.isSnapshotReady;
    }

    public void setSnapshotReady(boolean snapshotReady) {
        this.isSnapshotReady = snapshotReady;
    }

    public boolean isDictReady() {
        boolean forceBuild = Boolean.parseBoolean(this.extraBuildOptions.getOrDefault("job.retry.segment.force-build-dict", "false"));
        return this.isDictReady && !forceBuild;
    }

    public void setDictReady(boolean dictReady) {
        this.isDictReady = dictReady;
    }

    public boolean buildedDictColShouldRebuild() {
        return Boolean.parseBoolean(this.extraBuildOptions.getOrDefault("job.retry.segment.force-build-dict", "false"));
    }

    public boolean isFlatTableReady() {
        return this.isFlatTableReady;
    }

    public void setFlatTableReady(boolean flatTableReady) {
        this.isFlatTableReady = flatTableReady;
    }

    public boolean isFactViewReady() {
        return this.isFactViewReady;
    }

    public void setFactViewReady(boolean factViewReady) {
        this.isFactViewReady = factViewReady;
    }

    public SegmentPartition getPartition(long partitionId) {
        return this.partitionMap.get(partitionId);
    }

    public boolean isPartitionOverlap(String[] value) {
        ArrayList newValues = Lists.newArrayList();
        newValues.add(value);
        return !this.findDuplicatePartitions(newValues).isEmpty();
    }

    public List<String[]> findDuplicatePartitions(List<String[]> newValues) {
        NDataModel model = this.getModel();
        Preconditions.checkState((boolean)model.isMultiPartitionModel());
        List<Long> oldPartitionIds = this.getMultiPartitions().stream().map(SegmentPartition::getPartitionId).collect(Collectors.toList());
        List<String[]> oldPartitionValues = model.getMultiPartitionDesc().getPartitionValuesById(oldPartitionIds);
        return MultiPartitionUtil.findDuplicateValues(oldPartitionValues, newValues);
    }

    public long increaseBucket(long step) {
        this.checkIsNotCachedAndShared();
        return this.maxBucketId += step;
    }

    public void setMaxBucketId(long maxBucketId) {
        this.checkIsNotCachedAndShared();
        this.maxBucketId = maxBucketId;
    }

    public NDataSegment copy() {
        this.initDataFlow();
        return ((NDataSegmentManager)this.dataflow.getConfig().getManager(this.project, NDataSegmentManager.class)).copy(this);
    }

    public NDataSegment copyForWrite() {
        this.initDataFlow();
        return ((NDataSegmentManager)this.dataflow.getConfig().getManager(this.project, NDataSegmentManager.class)).copyForWrite(this);
    }

    public String getPartitionCondition() {
        PartitionDesc descDRP = this.dataflow.getModel().getPartitionDesc();
        if (Objects.isNull(descDRP) || Objects.isNull(descDRP.getPartitionDateColumn()) || Objects.isNull(this.segmentRange) || this.segmentRange.isInfinite()) {
            log.info("No available PARTITION-CONDITION segment {}", (Object)this.modelUuid);
            return null;
        }
        return descDRP.getPartitionConditionBuilder().buildDateRangeCondition(descDRP, this, this.segmentRange);
    }

    @Override
    public int compareTo(ISegment other) {
        SegmentRange x = this.getSegRange();
        return x.compareTo(other.getSegRange());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDataSegment other = (NDataSegment)obj;
        return this.uuid.equals(other.uuid);
    }

    public String toString() {
        return "NDataSegment [" + this.modelUuid + "," + this.uuid + "," + this.segmentRange + "," + this.status + "]";
    }

    public String displayIdName() {
        return String.format(Locale.ROOT, "[uuid:%s,name:%s]", this.uuid, this.name);
    }

    @Generated
    public String getModelUuid() {
        return this.modelUuid;
    }

    @Generated
    public Map<String, Long> getOriSnapshotSize() {
        return this.oriSnapshotSize;
    }

    @Generated
    public void setOriSnapshotSize(Map<String, Long> oriSnapshotSize) {
        this.oriSnapshotSize = oriSnapshotSize;
    }

    @Generated
    public long getMaxBucketId() {
        return this.maxBucketId;
    }

    @Generated
    public Map<Long, SegmentPartition> getPartitionMap() {
        return this.partitionMap;
    }

    @Generated
    public Map<String, String> getExtraBuildOptions() {
        return this.extraBuildOptions;
    }

    @Generated
    public void setExtraBuildOptions(Map<String, String> extraBuildOptions) {
        this.extraBuildOptions = extraBuildOptions;
    }

    public class LayoutInfoOnlyForTest
    extends LayoutInfo {
        public LayoutInfoOnlyForTest(Map<Long, NDataLayout> layoutsMap) {
            super(layoutsMap);
        }
    }

    private class LayoutInfo {
        private NDataSegDetails segDetails;
        private Map<Long, NDataLayout> allLayoutsMap = Collections.emptyMap();
        private Map<Long, NDataLayout> effectiveLayoutsMap = Collections.emptyMap();
        private Map<Long, Map<Long, Long>> partitionBucketMap = Maps.newHashMap();

        public LayoutInfo() {
            this(false);
        }

        public LayoutInfo(NDataSegDetails segDetails) {
            this.segDetails = segDetails;
        }

        public LayoutInfo(Map<Long, NDataLayout> layoutsMap) {
            this.allLayoutsMap = layoutsMap;
            this.effectiveLayoutsMap = layoutsMap.entrySet().stream().filter(entry -> NDataLayout.filterEffectiveLayout((NDataLayout)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        private LayoutInfo(boolean loadDetail) {
            if (!loadDetail) {
                return;
            }
            this.segDetails = NDataSegDetailsManager.getInstance(NDataSegment.this.getConfig(), NDataSegment.this.project).getForSegment(NDataSegment.this);
            if (this.segDetails == null) {
                this.segDetails = NDataSegDetails.newSegDetails(NDataSegment.this.dataflow, NDataSegment.this.uuid);
            }
            NDataSegment.this.setDependencies(Collections.singletonList(this.segDetails));
            IndexPlan indexPlan = NDataSegment.this.dataflow.getIndexPlan();
            if (!indexPlan.isBroken()) {
                List<NDataLayout> filteredCuboids = this.segDetails.getAllLayouts().stream().filter(dataLayout -> indexPlan.getLayoutEntity(dataLayout.getLayoutId()) != null).collect(Collectors.toList());
                this.segDetails.setLayouts(filteredCuboids);
            }
            this.segDetails.setCachedAndShared(NDataSegment.this.isCachedAndShared());
            List<NDataLayout> allLayouts = this.segDetails.getAllLayouts();
            this.allLayoutsMap = Maps.newHashMap();
            this.effectiveLayoutsMap = Maps.newHashMap();
            for (NDataLayout layout : allLayouts) {
                this.allLayoutsMap.put(layout.getLayoutId(), layout);
                if (!NDataLayout.filterEffectiveLayout(layout)) continue;
                this.effectiveLayoutsMap.put(layout.getLayoutId(), layout);
                HashMap cuboidBucketMap = Maps.newHashMap();
                layout.getMultiPartition().forEach(dataPartition -> cuboidBucketMap.put(dataPartition.getPartitionId(), dataPartition.getBucketId()));
                this.partitionBucketMap.put(layout.getLayoutId(), cuboidBucketMap);
            }
        }

        public int getLayoutSize() {
            return this.effectiveLayoutsMap.size();
        }

        public NDataLayout getLayout(long layoutId) {
            return this.effectiveLayoutsMap.get(layoutId);
        }

        public Map<Long, NDataLayout> getLayoutsMap() {
            return this.effectiveLayoutsMap;
        }

        public Map<Long, NDataLayout> getAllLayoutsMap() {
            return this.allLayoutsMap;
        }

        public Set<Long> getLayoutIds() {
            return this.effectiveLayoutsMap.keySet();
        }

        public List<Long> getMultiPartitionIds() {
            return this.partitionBucketMap.values().stream().map(entry -> entry.keySet()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }

        public Long getBucketId(long cuboidId, Long partitionId) {
            Map<Long, Long> cuboidBucketMap = this.partitionBucketMap.get(cuboidId);
            if (cuboidBucketMap == null) {
                return null;
            }
            return cuboidBucketMap.get(partitionId);
        }

        public boolean isAlreadyBuilt(long layoutId) {
            if (Objects.nonNull(this.effectiveLayoutsMap) && this.effectiveLayoutsMap.containsKey(layoutId)) {
                return this.effectiveLayoutsMap.get(layoutId).isReady();
            }
            return false;
        }

        public NDataSegDetails getSegDetails() {
            return this.segDetails;
        }
    }
}

