/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegDetails;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NDataSegDetailsManager {
    private static final Serializer<NDataSegDetails> DATA_SEG_LAYOUT_INSTANCES_SERIALIZER = new JsonSerializer(NDataSegDetails.class);
    private static final Logger logger = LoggerFactory.getLogger(NDataSegDetailsManager.class);
    private KylinConfig kylinConfig;
    private String project;
    private ResourceStore resourceStore;

    public static NDataSegDetailsManager getInstance(KylinConfig config, String project) {
        return (NDataSegDetailsManager)config.getManager(project, NDataSegDetailsManager.class);
    }

    static NDataSegDetailsManager newInstance(KylinConfig config, String project) {
        return new NDataSegDetailsManager(config, project);
    }

    private NDataSegDetailsManager(KylinConfig config, String project) {
        if (!UnitOfWork.isAlreadyInTransaction()) {
            logger.info("Initializing NDataSegDetailsManager with KylinConfig Id: {} for project {}", (Object)System.identityHashCode(config), (Object)project);
        }
        this.kylinConfig = config;
        this.project = project;
        this.resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)this.kylinConfig);
    }

    public KylinConfig getConfig() {
        return this.kylinConfig;
    }

    private ResourceStore getStore() {
        return this.resourceStore;
    }

    private NDataSegDetails initEntity(NDataSegDetails dataSegDetails, String resourceName) {
        dataSegDetails.setProject(this.project);
        return dataSegDetails;
    }

    public NDataSegDetails copyForWrite(NDataSegDetails details) {
        return CachedCrudAssist.copyForWrite(details, DATA_SEG_LAYOUT_INSTANCES_SERIALIZER, this::initEntity, this.resourceStore);
    }

    NDataSegDetails getForSegment(NDataflow df, String segId) {
        NDataSegDetails instances = (NDataSegDetails)this.getStore().getResource(MetadataType.mergeKeyWithType((String)segId, (MetadataType)MetadataType.LAYOUT), DATA_SEG_LAYOUT_INSTANCES_SERIALIZER);
        if (instances != null) {
            instances.setConfig(df.getConfig());
            instances.setProject(this.project);
        }
        return instances;
    }

    NDataSegDetails getForSegment(NDataSegment segment) {
        return this.getForSegment(segment.getDataflow(), segment.getId());
    }

    void updateDataflow(NDataflow df, NDataflowUpdate update) {
        TreeSet allSegIds = new TreeSet();
        TreeMap toUpsert = new TreeMap();
        TreeMap toRemove = new TreeMap();
        if (update.getToAddOrUpdateLayouts() != null) {
            Arrays.stream(update.getToAddOrUpdateLayouts()).forEach(c -> {
                String segId = c.getSegDetails().getUuid();
                allSegIds.add(segId);
                List list = toUpsert.computeIfAbsent(segId, k -> new ArrayList());
                list.add(c);
            });
        }
        if (update.getToRemoveLayouts() != null) {
            Arrays.stream(update.getToRemoveLayouts()).forEach(c -> {
                String segId = c.getSegDetails().getUuid();
                allSegIds.add(segId);
                List list = toRemove.computeIfAbsent(segId, k -> new ArrayList());
                list.add(c);
            });
        }
        if (update.getToAddSegs() != null) {
            Arrays.stream(update.getToAddSegs()).map(RootPersistentEntity::getId).forEach(allSegIds::add);
        }
        for (String segId : allSegIds) {
            NDataSegDetails details = this.getForSegment(df, segId);
            if (details == null) {
                details = NDataSegDetails.newSegDetails(df, segId);
            }
            NDataSegDetails copy = this.copyForWrite(details);
            if (toUpsert.containsKey(segId)) {
                for (NDataLayout c2 : (List)toUpsert.get(segId)) {
                    c2.setSegDetails(copy);
                    copy.addLayout(c2);
                }
            }
            if (toRemove.containsKey(segId)) {
                for (NDataLayout c2 : (List)toRemove.get(segId)) {
                    copy.removeLayout(c2);
                }
            }
            this.upsertForSegmentQuietly(copy);
        }
        if (update.getToRemoveSegs() != null) {
            for (NDataSegment seg : update.getToRemoveSegs()) {
                this.removeForSegmentQuietly(df, seg.getId());
            }
        }
    }

    private NDataSegDetails upsertForSegmentQuietly(NDataSegDetails details) {
        try {
            return this.upsertForSegment(details);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Failed to insert/update NDataSegDetails for segment " + details.getDataflowId() + "." + details.getUuid(), e);
        }
        catch (Exception e) {
            logger.error("Failed to insert/update NDataSegDetails for segment {}", (Object)(details.getDataflowId() + "." + details.getUuid()), (Object)e);
            return null;
        }
    }

    private NDataSegDetails upsertForSegment(NDataSegDetails details) {
        Preconditions.checkNotNull((Object)details, (Object)"NDataSegDetails cannot be null.");
        this.getStore().checkAndPutResource(details.getResourcePath(), (RootPersistentEntity)details, DATA_SEG_LAYOUT_INSTANCES_SERIALIZER);
        return details;
    }

    public NDataSegDetails updateDetails(NDataSegment seg, NDataSegDetailsUpdater updater) {
        NDataSegDetails details = this.copyForWrite(this.getForSegment(seg));
        updater.modify(details);
        this.upsertForSegment(details);
        return this.getForSegment(seg);
    }

    private void removeForSegmentQuietly(NDataflow df, String segId) {
        try {
            this.removeForSegment(segId);
        }
        catch (Exception e) {
            logger.error("Failed to remove NDataSegDetails for segment {}", (Object)(df + "." + segId), (Object)e);
        }
    }

    void removeForSegment(String segId) {
        if (!this.getStore().exists(MetadataType.mergeKeyWithType((String)segId, (MetadataType)MetadataType.LAYOUT))) {
            return;
        }
        this.getStore().deleteResource(MetadataType.mergeKeyWithType((String)segId, (MetadataType)MetadataType.LAYOUT));
    }

    void removeDetails(NDataflow df) {
        List toBeRemoved = this.getStore().collectResourceRecursively(MetadataType.LAYOUT, RawResourceFilter.equalFilter((String)"dataflowId", (String)df.getUuid()));
        if (CollectionUtils.isNotEmpty((Collection)toBeRemoved)) {
            toBeRemoved.forEach(path -> this.getStore().deleteResource(path));
        }
    }

    static interface NDataSegDetailsUpdater {
        public void modify(NDataSegDetails var1);
    }
}

