/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.primitives.Longs;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.LayoutPartition;
import org.apache.kylin.metadata.cube.model.NDataSegDetails;
import org.apache.kylin.metadata.cube.model.NDataflow;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NDataLayout
implements Serializable {
    public static final long BUCKET_START_ID = 20000000L;
    @JsonBackReference
    private NDataSegDetails segDetails;
    @JsonProperty(value="layout_id")
    private long layoutId;
    @JsonProperty(value="build_job_id")
    private String buildJobId;
    @JsonProperty(value="rows")
    private long rows;
    @JsonProperty(value="byte_size")
    private long byteSize;
    @JsonProperty(value="file_count")
    private long fileCount;
    @JsonProperty(value="source_rows")
    private long sourceRows;
    @JsonProperty(value="source_byte_size")
    private long sourceByteSize;
    @JsonProperty(value="partition_num")
    private int partitionNum;
    @JsonProperty(value="partition_values")
    private List<String> partitionValues = new ArrayList<String>();
    @JsonProperty(value="is_ready")
    private boolean isReady = false;
    @JsonProperty(value="create_time")
    private long createTime;
    @JsonProperty(value="multi_partition")
    private List<LayoutPartition> multiPartition = new ArrayList<LayoutPartition>();
    @JsonProperty(value="abnormal_type")
    private AbnormalType abnormalType;

    public static NDataLayout newDataLayout(NDataflow df, String segId, long layoutId) {
        return NDataLayout.newDataLayout(NDataSegDetails.newSegDetails(df, segId), layoutId);
    }

    public static NDataLayout newDataLayout(NDataSegDetails segDetails, long layoutId) {
        NDataLayout r = new NDataLayout();
        r.setSegDetails(segDetails);
        r.setLayoutId(layoutId);
        return r;
    }

    public static boolean filterEffectiveLayout(NDataLayout layout) {
        if (layout == null) {
            return false;
        }
        return Objects.isNull((Object)layout.getAbnormalType());
    }

    public NDataLayout() {
        this.createTime = System.currentTimeMillis();
    }

    public KylinConfigExt getConfig() {
        return this.segDetails.getConfig();
    }

    public LayoutEntity getLayout() {
        return this.segDetails.getDataflow().getIndexPlan().getLayoutEntity(this.layoutId);
    }

    public LayoutEntity getLayoutByIndexPlan(IndexPlan indexPlan) {
        return indexPlan.getLayoutEntity(this.layoutId);
    }

    public NDataSegDetails getSegDetails() {
        return this.segDetails;
    }

    public void setSegDetails(NDataSegDetails segDetails) {
        this.checkIsNotCachedAndShared();
        this.segDetails = segDetails;
    }

    public long getLayoutId() {
        return this.layoutId;
    }

    public void setLayoutId(long layoutId) {
        this.checkIsNotCachedAndShared();
        this.layoutId = layoutId;
    }

    public String getBuildJobId() {
        return this.buildJobId;
    }

    public void setBuildJobId(String buildJobId) {
        this.checkIsNotCachedAndShared();
        this.buildJobId = buildJobId;
    }

    public long getRows() {
        if (CollectionUtils.isEmpty(this.multiPartition)) {
            return this.rows;
        }
        return this.multiPartition.stream().mapToLong(LayoutPartition::getRows).sum();
    }

    public void setRows(long rows) {
        this.checkIsNotCachedAndShared();
        this.rows = rows;
    }

    public long getByteSize() {
        if (CollectionUtils.isEmpty(this.multiPartition)) {
            return this.byteSize;
        }
        return this.multiPartition.stream().mapToLong(LayoutPartition::getByteSize).sum();
    }

    public void setByteSize(long byteSize) {
        this.checkIsNotCachedAndShared();
        this.byteSize = byteSize;
    }

    public long getSourceRows() {
        return this.sourceRows;
    }

    public void setSourceRows(long sourceRows) {
        this.checkIsNotCachedAndShared();
        this.sourceRows = sourceRows;
    }

    public long getSourceByteSize() {
        return this.sourceByteSize;
    }

    public void setSourceByteSize(long sourceByteSize) {
        this.checkIsNotCachedAndShared();
        this.sourceByteSize = sourceByteSize;
    }

    public boolean isEmpty() {
        return this.rows == 0L;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(long fileCount) {
        this.checkIsNotCachedAndShared();
        this.fileCount = fileCount;
    }

    public int getPartitionNum() {
        return this.partitionNum;
    }

    public void setPartitionNum(int partitionNum) {
        this.checkIsNotCachedAndShared();
        this.partitionNum = partitionNum;
    }

    public List<String> getPartitionValues() {
        return this.partitionValues;
    }

    public void setPartitionValues(List<String> partitionValues) {
        this.partitionValues = partitionValues;
    }

    public void replacePartitions(List<LayoutPartition> update) {
        HashMap partitionMap = Maps.newHashMap();
        this.multiPartition.forEach(partition -> partitionMap.put(partition.getPartitionId(), partition));
        update.forEach(partition -> {
            Preconditions.checkState((boolean)partitionMap.containsKey(partition.getPartitionId()));
            partitionMap.put(partition.getPartitionId(), partition);
        });
        this.multiPartition = new ArrayList(partitionMap.values());
    }

    public boolean removeMultiPartition(Set<Long> toBeDeletedPartIds) {
        Iterator<LayoutPartition> iterator = this.multiPartition.iterator();
        boolean contain = false;
        while (iterator.hasNext()) {
            LayoutPartition dataPartition = iterator.next();
            if (!toBeDeletedPartIds.contains(dataPartition.getPartitionId())) continue;
            iterator.remove();
            contain = true;
        }
        return contain;
    }

    public LayoutPartition getDataPartition(Long partitionId) {
        return this.multiPartition.stream().filter(p -> p.getPartitionId() == partitionId.longValue()).findAny().orElse(null);
    }

    public List<LayoutPartition> getPartitionsByIds(List<Long> partitionIds) {
        HashSet<Long> partitionSets = new HashSet<Long>(partitionIds);
        return this.multiPartition.stream().filter(partition -> partitionSets.contains(partition.getPartitionId())).collect(Collectors.toList());
    }

    public boolean isCachedAndShared() {
        if (this.segDetails == null || !this.segDetails.isCachedAndShared()) {
            return false;
        }
        for (NDataLayout cached : this.segDetails.getEffectiveLayouts()) {
            if (cached != this) continue;
            return true;
        }
        return false;
    }

    public void checkIsNotCachedAndShared() {
        if (this.isCachedAndShared()) {
            throw new IllegalStateException();
        }
    }

    public long getIndexId() {
        return this.getLayoutId() / 10000L * 10000L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Longs.hashCode((long)this.layoutId);
        result = 31 * result + (this.segDetails == null ? 0 : this.segDetails.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDataLayout other = (NDataLayout)obj;
        if (this.layoutId != other.layoutId) {
            return false;
        }
        return !(this.segDetails == null ? other.segDetails != null : !this.segDetails.equals(other.segDetails));
    }

    public String toString() {
        return "NDataLayout [ Model Name:" + this.segDetails.getDataflow().getModelAlias() + ", Segment Id:" + this.segDetails.getId() + ", Layout Id:" + this.layoutId + "]";
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public List<LayoutPartition> getMultiPartition() {
        return this.multiPartition;
    }

    @Generated
    public void setMultiPartition(List<LayoutPartition> multiPartition) {
        this.multiPartition = multiPartition;
    }

    @Generated
    public AbnormalType getAbnormalType() {
        return this.abnormalType;
    }

    @Generated
    public void setAbnormalType(AbnormalType abnormalType) {
        this.abnormalType = abnormalType;
    }

    public static enum AbnormalType {
        DATA_INCONSISTENT;

    }
}

