/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.BiMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;

public class NCubeJoinedFlatTableDesc
implements IJoinedFlatTableDesc,
Serializable {
    protected final String tableName;
    protected final IndexPlan indexPlan;
    protected final SegmentRange segmentRange;
    protected final boolean needJoin;
    private Map<String, Integer> columnIndexMap = Maps.newHashMap();
    private List<TblColRef> columns = Lists.newLinkedList();
    private Set<TblColRef> usedColumns = Sets.newLinkedHashSet();
    private List<Integer> indices = Lists.newArrayList();

    public NCubeJoinedFlatTableDesc(IndexPlan indexPlan) {
        this(indexPlan, null, true);
    }

    public NCubeJoinedFlatTableDesc(NDataSegment segment) {
        this(segment.getIndexPlan(), segment.getSegRange(), true);
    }

    public NCubeJoinedFlatTableDesc(IndexPlan indexPlan, @Nullable SegmentRange segmentRange, Boolean needJoinLookup) {
        this.indexPlan = indexPlan;
        this.segmentRange = segmentRange;
        this.tableName = this.makeTableName();
        this.needJoin = needJoinLookup;
        this.initParseIndexPlan();
        this.initIndices();
    }

    protected String makeTableName() {
        if (this.segmentRange == null) {
            return "kylin_intermediate_" + this.indexPlan.getUuid().toLowerCase(Locale.ROOT);
        }
        return "kylin_intermediate_" + this.indexPlan.getUuid().toLowerCase(Locale.ROOT) + "_" + this.segmentRange.toString();
    }

    protected final void initAddColumn(TblColRef col) {
        if (this.shouldNotAddColumn(col) || this.columnIndexMap.containsKey(col.getIdentity())) {
            return;
        }
        this.columnIndexMap.put(col.getIdentity(), this.columnIndexMap.size());
        this.columns.add(col);
    }

    private void initAddUsedColumn(TblColRef col) {
        if (this.shouldNotAddColumn(col)) {
            return;
        }
        this.usedColumns.add(col);
    }

    private boolean shouldNotAddColumn(TblColRef col) {
        NDataModel model = this.getDataModel();
        TableRef factTable = model.getRootFactTable();
        return !this.needJoin && !factTable.getTableName().equalsIgnoreCase(col.getTableRef().getTableName());
    }

    private void initParseIndexPlan() {
        BiMap<Integer, NDataModel.Measure> effectiveMeasures;
        boolean flatTableEnabled = KylinConfig.getInstanceFromEnv().isPersistFlatTableEnabled();
        BiMap<Integer, TblColRef> usedDimensions = this.indexPlan.getEffectiveDimCols();
        BiMap<Integer, TblColRef> effectiveDimensions = flatTableEnabled ? this.indexPlan.getModel().getEffectiveDimensions() : usedDimensions;
        BiMap<Integer, NDataModel.Measure> usedMeasures = this.indexPlan.getEffectiveMeasures();
        Object object = effectiveMeasures = flatTableEnabled ? this.indexPlan.getModel().getEffectiveMeasures() : usedMeasures;
        if (flatTableEnabled) {
            effectiveDimensions.forEach((k, v) -> this.initAddColumn((TblColRef)v));
            effectiveMeasures.forEach((k, v) -> {
                FunctionDesc func = v.getFunction();
                List<TblColRef> colRefs = func.getColRefs();
                colRefs.forEach(this::initAddColumn);
            });
            usedDimensions.forEach((k, v) -> this.initAddUsedColumn((TblColRef)v));
            usedMeasures.forEach((k, v) -> {
                FunctionDesc func = v.getFunction();
                List<TblColRef> colRefs = func.getColRefs();
                colRefs.forEach(this::initAddUsedColumn);
            });
        } else {
            usedDimensions.forEach((k, v) -> {
                this.initAddColumn((TblColRef)v);
                this.initAddUsedColumn((TblColRef)v);
            });
            usedMeasures.forEach((k, v) -> {
                FunctionDesc func = v.getFunction();
                List<TblColRef> colRefs = func.getColRefs();
                colRefs.forEach(colRef -> {
                    this.initAddColumn((TblColRef)colRef);
                    this.initAddUsedColumn((TblColRef)colRef);
                });
            });
        }
    }

    public List<Integer> getIndices() {
        return this.indices;
    }

    public void initIndices() {
        for (TblColRef tblColRef : this.columns) {
            int id = this.indexPlan.getModel().getColumnIdByColumnName(tblColRef.getIdentity());
            if (-1 == id) {
                throw new IllegalArgumentException("Column: " + tblColRef.getIdentity() + " is not in model: " + this.indexPlan.getModel().getUuid());
            }
            this.indices.add(id);
        }
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public List<TblColRef> getAllColumns() {
        return this.columns;
    }

    public Set<TblColRef> getUsedColumns() {
        return this.usedColumns;
    }

    @Override
    public NDataModel getDataModel() {
        return this.indexPlan.getModel();
    }

    @Override
    public int getColumnIndex(TblColRef colRef) {
        Integer index = this.columnIndexMap.get(colRef.getIdentity());
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public SegmentRange getSegRange() {
        return this.segmentRange;
    }

    @Override
    public TblColRef getDistributedBy() {
        return null;
    }

    @Override
    public ISegment getSegment() {
        return null;
    }

    @Override
    public TblColRef getClusterBy() {
        return null;
    }
}

