/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.cuboid.AdaptiveSpanningTree;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.LayoutPartition;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.job.JobBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionSpanningTree
extends AdaptiveSpanningTree {
    private static final long serialVersionUID = 6066477814307614441L;
    private static final Logger logger = LoggerFactory.getLogger(PartitionSpanningTree.class);
    private transient Map<Long, Map<Long, PartitionTreeNode>> cachedNodeMap;

    public PartitionSpanningTree(KylinConfig config, PartitionTreeBuilder builder) {
        super(config, builder);
    }

    @Override
    public List<IndexEntity> getLevel0thIndices() {
        return this.level0thNodes.stream().map(AdaptiveSpanningTree.TreeNode::getIndex).distinct().collect(Collectors.toList());
    }

    @Override
    public List<IndexEntity> getIndices() {
        return this.treeNodes.stream().map(AdaptiveSpanningTree.TreeNode::getIndex).distinct().collect(Collectors.toList());
    }

    public List<Long> getFlatTablePartitions() {
        return this.level0thNodes.stream().filter(AdaptiveSpanningTree.TreeNode::parentIsNull).map(PartitionTreeNode.class::cast).map(PartitionTreeNode::getPartition).distinct().sorted().collect(Collectors.toList());
    }

    @Override
    protected void buildMappings(List<AdaptiveSpanningTree.TreeNode> nodes) {
        HashMap mappings = Maps.newHashMap();
        nodes.stream().map(PartitionTreeNode.class::cast).forEach(node -> {
            Map partitionMap = (Map)mappings.get(node.getIndex().getId());
            if (Objects.isNull(partitionMap)) {
                partitionMap = Maps.newHashMap();
                mappings.put(node.getIndex().getId(), partitionMap);
            }
            partitionMap.put(node.getPartition(), node);
        });
        this.cachedNodeMap = Collections.unmodifiableMap(mappings);
    }

    @Override
    protected List<AdaptiveSpanningTree.TreeNode> adaptiveSpan(NDataSegment dataSegment) {
        Comparator<PartitionCandidate> comparator = Comparator.comparingInt(AdaptiveSpanningTree.Candidate::getParentLevel).thenComparingDouble(AdaptiveSpanningTree.Candidate::getParentUnfinishedFraction).thenComparingLong(PartitionCandidate::getParentRows).thenComparingLong(AdaptiveSpanningTree.Candidate::getIndexId).thenComparingLong(rec$ -> ((PartitionCandidate)rec$).getPartition());
        return this.treeNodes.stream().filter(AdaptiveSpanningTree.TreeNode::nonSpanned).map(PartitionTreeNode.class::cast).map(node -> {
            if (node.getDirectParents().isEmpty()) {
                PartitionCandidate candidate = new PartitionCandidate((PartitionTreeNode)node, null, null, null);
                candidate.setFraction(1.0);
                return candidate;
            }
            return this.getOptimalCandidate(this.getParentCandidates((PartitionTreeNode)node, dataSegment));
        }).filter(Objects::nonNull).sorted(comparator).limit(this.adaptiveBatchSize).map(this::markSpanned).collect(Collectors.toList());
    }

    @Override
    protected List<AdaptiveSpanningTree.TreeNode> layeredSpan(NDataSegment dataSegment) {
        Comparator<PartitionCandidate> comparator = Comparator.comparingLong(AdaptiveSpanningTree.Candidate::getIndexId).thenComparingLong(rec$ -> ((PartitionCandidate)rec$).getPartition());
        return this.treeNodes.stream().filter(AdaptiveSpanningTree.TreeNode::nonSpanned).map(PartitionTreeNode.class::cast).map(node -> {
            if (node.getDirectParents().isEmpty()) {
                PartitionCandidate candidate = new PartitionCandidate((PartitionTreeNode)node, null, null, null);
                candidate.setFraction(1.0);
                return candidate;
            }
            List<PartitionCandidate> parents = this.getParentCandidates((PartitionTreeNode)node, dataSegment);
            if (parents.size() < node.getDirectParents().size()) {
                return null;
            }
            return parents.stream().min(Comparator.comparingLong(PartitionCandidate::getParentRows)).orElse(null);
        }).filter(Objects::nonNull).sorted(comparator).map(this::markSpanned).collect(Collectors.toList());
    }

    private PartitionTreeNode getPartitionNode(IndexEntity index, Long partition) {
        Preconditions.checkNotNull((Object)index, (Object)"Index shouldn't be null.");
        Preconditions.checkNotNull((Object)partition, (Object)"Partition shouldn't be null.");
        Preconditions.checkNotNull(this.cachedNodeMap, (Object)"Node mappings' cache shouldn't be null.");
        Map<Long, PartitionTreeNode> partitionMap = this.cachedNodeMap.get(index.getId());
        if (Objects.isNull(partitionMap)) {
            return null;
        }
        return partitionMap.get(partition);
    }

    private List<PartitionCandidate> getParentCandidates(PartitionTreeNode node, NDataSegment dataSegment) {
        Long partition = node.partition;
        return node.getDirectParents().stream().map(index -> this.getPartitionNode((IndexEntity)index, partition)).filter(Objects::nonNull).map(parent -> parent.getLayouts().stream().map(layout -> PartitionSpanningTree.getLayoutPartition(layout, partition, dataSegment)).filter(Objects::nonNull).filter(pair -> this.checkLayoutPartitionNewBucketCompleted((PartitionTreeNode)parent, (Pair<NDataLayout, LayoutPartition>)pair)).findAny().map(pair -> new PartitionCandidate(node, (PartitionTreeNode)parent, (NDataLayout)pair.getFirst(), (LayoutPartition)pair.getSecond())).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean checkLayoutPartitionNewBucketCompleted(PartitionTreeNode node, Pair<NDataLayout, LayoutPartition> pair) {
        LayoutPartition lp = (LayoutPartition)pair.getSecond();
        return node.matchNewBucket(lp.getBucketId());
    }

    private static Pair<NDataLayout, LayoutPartition> getLayoutPartition(LayoutEntity layout, Long partition, NDataSegment dataSegment) {
        NDataLayout dataLayout = dataSegment.getLayout(layout.getId());
        if (Objects.isNull(dataLayout)) {
            return null;
        }
        LayoutPartition dataPartition = dataLayout.getDataPartition(partition);
        if (Objects.isNull(dataPartition)) {
            return null;
        }
        return new Pair((Object)dataLayout, (Object)dataPartition);
    }

    private static class PartitionCandidate
    extends AdaptiveSpanningTree.Candidate {
        private final LayoutPartition dataPartition;

        public PartitionCandidate(PartitionTreeNode node, PartitionTreeNode parent, NDataLayout dataLayout, LayoutPartition dataPartition) {
            super(node, parent, dataLayout);
            Preconditions.checkState((dataLayout == null == (dataPartition == null) ? 1 : 0) != 0, (Object)"Both dataLayout and dataPartition must be defined, or neither.");
            this.dataPartition = dataPartition;
        }

        private Long getPartition() {
            return ((PartitionTreeNode)this.getNode()).getPartition();
        }

        @Override
        protected Long getParentRows() {
            if (Objects.isNull(this.dataPartition)) {
                return -1L;
            }
            return this.dataPartition.getRows();
        }

        @Override
        protected String getReadableDesc() {
            return "partition " + this.getPartition() + ", " + super.getReadableDesc();
        }
    }

    public static class PartitionTreeNode
    extends AdaptiveSpanningTree.TreeNode {
        private final Long partition;
        private final Set<Long> newBucketIds;

        public PartitionTreeNode(IndexEntity index, List<LayoutEntity> layouts, Long partition) {
            this(index, layouts, partition, null);
        }

        public PartitionTreeNode(IndexEntity index, List<LayoutEntity> layouts, Long partition, Set<Long> newBucketIds) {
            super(index, layouts);
            Preconditions.checkNotNull((Object)partition, (Object)"Partition shouldn't be null.");
            this.partition = partition;
            this.newBucketIds = newBucketIds;
        }

        public Long getPartition() {
            return this.partition;
        }

        public boolean matchNewBucket(Long bucketId) {
            return this.newBucketIds != null && this.newBucketIds.contains(bucketId);
        }
    }

    public static class PartitionTreeBuilder
    extends AdaptiveSpanningTree.AdaptiveTreeBuilder {
        private final String jobId;
        private final List<Long> partitions;
        private final Set<JobBucket> newBuckets;

        public PartitionTreeBuilder(NDataSegment dataSegment, Collection<LayoutEntity> layouts, String jobId, List<Long> partitions, Set<JobBucket> newBuckets) {
            super(dataSegment, layouts);
            Preconditions.checkNotNull((Object)jobId, (Object)"Job id shouldn't be null.");
            Preconditions.checkNotNull(partitions, (Object)"Partitions shouldn't be null.");
            this.jobId = jobId;
            this.partitions = Collections.unmodifiableList(partitions);
            this.newBuckets = newBuckets;
        }

        @Override
        protected List<AdaptiveSpanningTree.TreeNode> buildTreeNodes() {
            HashMap ancestorNodeMap = Maps.newHashMap();
            return Collections.unmodifiableList(this.indexLayoutsMap.entrySet().stream().flatMap(indexLayouts -> {
                IndexEntity index = (IndexEntity)indexLayouts.getKey();
                List layouts = (List)indexLayouts.getValue();
                List<IndexEntity> directParents = this.getDirectParents(index);
                List<PartitionTreeNode> nodes = this.partitions.stream().map(partition -> {
                    Set layoutIds = layouts.stream().map(LayoutEntity::getId).collect(Collectors.toSet());
                    Set<Long> newBucketIds = this.newBuckets.stream().filter(nb -> layoutIds.contains(nb.getLayoutId())).map(JobBucket::getBucketId).collect(Collectors.toSet());
                    return new PartitionTreeNode(index, layouts, (Long)partition, newBucketIds);
                }).collect(Collectors.toList());
                if (directParents.isEmpty()) {
                    List candidates = this.indexPlanIndices.stream().filter(parent -> parent.fullyDerive(index)).filter(parent -> parent.getLayouts().stream().anyMatch(layout -> Objects.nonNull(this.dataSegment.getLayout(layout.getId())))).collect(Collectors.toList());
                    nodes.forEach(node -> {
                        node.level = 0;
                        Pair layoutPartition = candidates.stream().map(parent -> parent.getLayouts().stream().map(layout -> PartitionSpanningTree.getLayoutPartition(layout, ((PartitionTreeNode)node).partition, this.dataSegment)).filter(Objects::nonNull).findAny().orElse(null)).filter(Objects::nonNull).min(Comparator.comparingLong(pair -> ((LayoutPartition)pair.getSecond()).getRows())).orElse(null);
                        if (Objects.nonNull(layoutPartition)) {
                            PartitionTreeNode ancestor = this.getAncestorNode((PartitionTreeNode)node, ((NDataLayout)layoutPartition.getFirst()).getLayout(), ancestorNodeMap);
                            ancestor.subtrees.add(node);
                            node.parent = ancestor;
                            node.rootNode = ancestor;
                        }
                    });
                } else {
                    nodes.forEach(node -> {
                        node.directParents = directParents;
                    });
                }
                nodes.forEach(this::markSpannedIfResumed);
                return nodes.stream();
            }).collect(Collectors.toList()));
        }

        private PartitionTreeNode getAncestorNode(PartitionTreeNode node, LayoutEntity layout, Map<Long, Map<Long, PartitionTreeNode>> ancestorNodeMap) {
            PartitionTreeNode ancestor;
            HashMap partitionNodeMap = ancestorNodeMap.get(layout.getIndex().getId());
            if (Objects.isNull(partitionNodeMap)) {
                partitionNodeMap = Maps.newHashMap();
                ancestorNodeMap.put(layout.getIndex().getId(), partitionNodeMap);
            }
            if (Objects.isNull(ancestor = (PartitionTreeNode)partitionNodeMap.get(node.partition))) {
                ancestor = new PartitionTreeNode(layout.getIndex(), Lists.newArrayList((Object[])new LayoutEntity[]{layout}), node.partition);
                ancestor.layout = layout;
                ancestor.layoutNodes.forEach(AdaptiveSpanningTree.LayoutNode::setSpanned);
                partitionNodeMap.put(node.partition, ancestor);
            }
            return ancestor;
        }

        private void markSpannedIfResumed(PartitionTreeNode node) {
            node.layoutNodes.forEach(lnode -> {
                NDataLayout dataLayout = this.dataSegment.getLayout(lnode.getLayout().getId());
                if (Objects.isNull(dataLayout)) {
                    return;
                }
                LayoutPartition dataPartition = dataLayout.getDataPartition(node.getPartition());
                if (Objects.isNull(dataPartition)) {
                    return;
                }
                if (this.jobId.equals(dataPartition.getBuildJobId())) {
                    lnode.setSpanned();
                    logger.info("Segment {} skip build layout partition {} {}", new Object[]{this.dataSegment.getId(), lnode.getLayout().getId(), node.getPartition()});
                }
            });
        }
    }
}

