/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.CaseInsensitiveStringMap;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Joiner;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ColumnToConds
extends CaseInsensitiveStringMap<List<Cond>>
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ColumnToConds.class);
    private static final String COMMA = ",";

    public ColumnToConds() {
    }

    public ColumnToConds(Map<String, List<Cond>> columnToConds) {
        super.putAll(columnToConds);
    }

    public List<Cond> getCondsByColumn(String col) {
        ArrayList conds = (ArrayList)super.get((Object)col);
        if (conds == null) {
            conds = new ArrayList();
        }
        return ImmutableList.copyOf((Collection)conds);
    }

    public Set<String> keySet() {
        return ImmutableSet.copyOf((Collection)super.keySet());
    }

    public static Map<String, String> getColumnWithType(String project, String table) {
        ColumnDesc[] columns;
        HashMap<String, String> columnWithType = new HashMap<String, String>();
        for (ColumnDesc column : columns = NTableMetadataManager.getInstance(KylinConfig.getInstanceFromEnv(), project).getTableDesc(table).getColumns()) {
            columnWithType.put(column.getName(), column.getTypeName());
        }
        return columnWithType;
    }

    private static boolean isValidLikeColumnType(String type) {
        return type.startsWith("varchar") || type.equals("string") || type.startsWith("char");
    }

    public static String concatConds(ColumnToConds condsWithCol, ColumnToConds likeCondsWithCol, Map<String, String> columnWithType) {
        StringBuilder result = new StringBuilder();
        HashSet<String> conditionCols = new HashSet<String>();
        conditionCols.addAll(condsWithCol.keySet());
        conditionCols.addAll(likeCondsWithCol.keySet());
        if (conditionCols.size() > 1) {
            result.append("(");
        }
        for (String col : conditionCols) {
            String type = (String)Preconditions.checkNotNull((Object)columnWithType.get(col), (Object)("column:" + col + " type not found"));
            List<Cond> intervalConditions = condsWithCol.getCondsByColumn(col);
            List<Cond> likeConditions = likeCondsWithCol.getCondsByColumn(col);
            result.append("(");
            if (CollectionUtils.isNotEmpty(intervalConditions)) {
                if (intervalConditions.stream().allMatch(cond -> ((Cond)cond).type == IntervalType.CLOSED)) {
                    result.append(col).append(" in ").append("(").append(Joiner.on((String)COMMA).join((Iterable)intervalConditions.stream().map(cond -> Cond.trimWithoutCheck(((Cond)cond).leftExpr, type)).collect(Collectors.toList()))).append(")");
                } else {
                    result.append(Joiner.on((String)" or ").join((Iterable)intervalConditions.stream().map(cond -> cond.toString(col, type)).collect(Collectors.toList())));
                }
            }
            if (CollectionUtils.isNotEmpty(likeConditions)) {
                if (!ColumnToConds.isValidLikeColumnType(type)) {
                    log.error(MsgPicker.getMsg().getRowAclNotStringType());
                } else {
                    if (CollectionUtils.isNotEmpty(intervalConditions)) {
                        result.append(" or ");
                    }
                    result.append(Joiner.on((String)" or ").join((Iterable)likeConditions.stream().map(cond -> col + " like " + Cond.trimWithoutCheck(((Cond)cond).leftExpr, type)).collect(Collectors.toList())));
                }
            }
            result.append(")");
            result.append(" AND ");
        }
        if (!conditionCols.isEmpty()) {
            result.setLength(result.length() - 5);
        }
        if (conditionCols.size() > 1) {
            result.append(")");
        }
        return result.toString();
    }

    static class RowACLCondDeserializer
    extends JsonDeserializer<Cond> {
        RowACLCondDeserializer() {
        }

        public Cond deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object[] c = (Object[])p.readValueAs(Object[].class);
            Cond cond = new Cond();
            cond.type = IntervalType.values()[(Integer)c[0]];
            if (c.length == 2) {
                cond.leftExpr = (cond.rightExpr = (String)c[1]);
            } else {
                cond.leftExpr = (String)c[1];
                cond.rightExpr = (String)c[2];
            }
            return cond;
        }
    }

    static class RowACLCondSerializer
    extends JsonSerializer<Cond> {
        RowACLCondSerializer() {
        }

        public void serialize(Cond cond, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            Object[] c = cond.leftExpr.equals(cond.rightExpr) ? new Object[]{cond.type.ordinal(), cond.leftExpr} : new Object[]{cond.type.ordinal(), cond.leftExpr, cond.rightExpr};
            gen.writeObject((Object)c);
        }
    }

    @JsonSerialize(using=RowACLCondSerializer.class)
    @JsonDeserialize(using=RowACLCondDeserializer.class)
    public static class Cond
    implements Serializable {
        private IntervalType type;
        private String leftExpr;
        private String rightExpr;

        Cond() {
        }

        public Cond(IntervalType type, String leftExpr, String rightExpr) {
            this.type = type;
            this.leftExpr = leftExpr;
            this.rightExpr = rightExpr;
        }

        public Cond(String value, IntervalType type) {
            this.type = type;
            this.leftExpr = this.rightExpr = value;
        }

        public String toString(String column, String columnType) {
            Pair<String, String> op = Cond.getOp(this.type);
            String leftValue = Cond.trimWithoutCheck(this.leftExpr, columnType);
            String rightValue = Cond.trimWithoutCheck(this.rightExpr, columnType);
            if (leftValue == null && rightValue != null) {
                if (this.type == IntervalType.OPEN) {
                    return "(" + column + "<" + rightValue + ")";
                }
                if (this.type == IntervalType.RIGHT_INCLUSIVE) {
                    return "(" + column + "<=" + rightValue + ")";
                }
                throw new KylinException((ErrorCodeSupplier)CommonErrorCode.UNKNOWN_ERROR_CODE, "error expr");
            }
            if (rightValue == null && leftValue != null) {
                if (this.type == IntervalType.OPEN) {
                    return "(" + column + ">" + leftValue + ")";
                }
                if (this.type == IntervalType.LEFT_INCLUSIVE) {
                    return "(" + column + ">=" + leftValue + ")";
                }
                throw new KylinException((ErrorCodeSupplier)CommonErrorCode.UNKNOWN_ERROR_CODE, "error expr");
            }
            if (leftValue == null || leftValue.equals(rightValue)) {
                if (this.type == IntervalType.CLOSED) {
                    return "(" + column + "=" + leftValue + ")";
                }
                if (this.type == IntervalType.OPEN) {
                    return "(" + column + "<>" + leftValue + ")";
                }
            }
            return "(" + column + (String)op.getFirst() + leftValue + " AND " + column + (String)op.getSecond() + rightValue + ")";
        }

        public static String trim(String expr, String type) {
            SimpleDateFormat sdf;
            if (expr == null) {
                return null;
            }
            if (ColumnToConds.isValidLikeColumnType(type)) {
                expr = expr.replace("'", "''");
                expr = "'" + expr + "'";
            }
            if (type.equals("date")) {
                sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault(Locale.Category.FORMAT));
                sdf.setTimeZone(TimeZone.getDefault());
                expr = sdf.format(new Date(Long.parseLong(expr)));
                expr = "DATE '" + expr + "'";
            }
            if (type.equals("timestamp") || type.equals("datetime")) {
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault(Locale.Category.FORMAT));
                sdf.setTimeZone(TimeZone.getDefault());
                expr = sdf.format(new Date(Long.parseLong(expr)));
                expr = "TIMESTAMP '" + expr + "'";
            }
            if (type.equals("time")) {
                int TIME_START_POS = 11;
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault(Locale.Category.FORMAT));
                sdf2.setTimeZone(TimeZone.getDefault());
                expr = sdf2.format(new Date(Long.parseLong(expr)));
                expr = "TIME '" + expr.substring(11) + "'";
            }
            return expr;
        }

        static String trimWithoutCheck(String expr, String type) {
            if (expr == null) {
                return null;
            }
            if (type.startsWith("varchar") || type.equals("string") || type.equals("char")) {
                expr = expr.replace("'", "''");
                expr = "'" + expr + "'";
            }
            if (type.equals("date")) {
                expr = "DATE '" + expr + "'";
            }
            if (type.equals("timestamp") || type.equals("datetime")) {
                expr = "TIMESTAMP '" + expr + "'";
            }
            if (type.equals("time")) {
                int TIME_START_POS = 11;
                expr = "TIME '" + expr.substring(11) + "'";
            }
            return expr;
        }

        private static Pair<String, String> getOp(IntervalType type) {
            switch (type) {
                case OPEN: {
                    return Pair.newPair((Object)">", (Object)"<");
                }
                case CLOSED: {
                    return Pair.newPair((Object)">=", (Object)"<=");
                }
                case LEFT_INCLUSIVE: {
                    return Pair.newPair((Object)">=", (Object)"<");
                }
                case RIGHT_INCLUSIVE: {
                    return Pair.newPair((Object)">", (Object)"<=");
                }
            }
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.UNKNOWN_ERROR_CODE, "error, unknown type for condition");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cond cond = (Cond)o;
            if (this.type != cond.type) {
                return false;
            }
            if (!Objects.equals(this.leftExpr, cond.leftExpr)) {
                return false;
            }
            return Objects.equals(this.rightExpr, cond.rightExpr);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.leftExpr != null ? this.leftExpr.hashCode() : 0);
            result = 31 * result + (this.rightExpr != null ? this.rightExpr.hashCode() : 0);
            return result;
        }
    }

    public static enum IntervalType implements Serializable
    {
        OPEN,
        CLOSED,
        LEFT_INCLUSIVE,
        RIGHT_INCLUSIVE,
        LIKE;

    }
}

