/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.cuboid.ChooserContext;
import org.apache.kylin.metadata.cube.cuboid.ComparatorUtils;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.AntiFlatChecker;
import org.apache.kylin.metadata.model.ColExcludedChecker;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.recommendation.entity.DimensionRecItemV2;
import org.apache.kylin.metadata.recommendation.util.RawRecUtil;
import org.apache.kylin.query.exception.NotSupportedSQLException;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.apache.kylin.rec.exception.PendingException;
import org.apache.kylin.rec.model.ModelTree;
import org.apache.kylin.rec.util.CubeUtils;
import org.apache.kylin.rec.util.EntityBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSuggester {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexSuggester.class);
    public static final String COMPUTED_COLUMN_ON_ANTI_FLATTEN_LOOKUP = "Computed column depends on anti flatten lookup table, stop the process of generate index.";
    public static final String COMPUTED_COLUMN_OF_EXCLUDED_COLUMNS = "Computed columns depends on excluded columns, stop the process of generate index.";
    public static final String MEASURE_ON_ANTI_FLATTEN_LOOKUP = "Unsupported measure of anti flatten lookup table, stop the process of generate index. ";
    public static final String MEASURE_OF_EXCLUDED_COLUMNS = "Unsupported measure of excluded columns, stop the process of generate index. ";
    public static final String OTHER_UNSUPPORTED_MEASURE = "Unsupported measure may caused by turning on only reusing used defined computed column.";
    public static final String FK_ON_ANTI_FLATTEN_LOOKUP = "Unsupported foreign join key of anti flatten lookup table, stop the process of generate index. The foreign key is: ";
    public static final String FK_OF_EXCLUDED_COLUMNS = "Unsupported foreign join key of excluded columns, stop the process of generate index. The foreign key is: ";
    private static final String COLUMN_NOT_FOUND_PTN = "The model [%s] matches this query, but the dimension [%s] is missing. ";
    private static final String MEASURE_NOT_FOUND_PTN = "The model [%s] matches this query, but the measure [%s] is missing. ";
    private static final String JOIN_NOT_MATCHED = "The join of model [%s] has some difference with the joins of this query. ";
    private final AbstractContext proposeContext;
    private final AbstractContext.ModelContext modelContext;
    private final IndexPlan indexPlan;
    private final NDataModel model;
    private final Map<FunctionDesc, Integer> aggFuncIdMap;
    private final Map<IndexEntity.IndexIdentifier, IndexEntity> collector;
    private final SortedSet<Long> layoutIds = Sets.newTreeSet();
    private final Set<String> additionalNamedColumns = new HashSet<String>();

    IndexSuggester(AbstractContext.ModelContext modelContext, IndexPlan indexPlan, Map<IndexEntity.IndexIdentifier, IndexEntity> collector) {
        this.modelContext = modelContext;
        this.proposeContext = modelContext.getProposeContext();
        this.model = modelContext.getTargetModel();
        this.indexPlan = indexPlan;
        this.collector = collector;
        this.aggFuncIdMap = Maps.newHashMap();
        this.model.getEffectiveMeasures().forEach((measureId, measure) -> {
            FunctionDesc function = measure.getFunction();
            this.aggFuncIdMap.put(function, (Integer)measureId);
        });
        collector.forEach((indexIdentifier, indexEntity) -> indexEntity.getLayouts().forEach(layout -> this.layoutIds.add(layout.getId())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suggestIndexes(ModelTree modelTree) {
        KylinConfig kylinConfig = this.proposeContext.getKapConfig().getKylinConfig();
        boolean partialMatch = kylinConfig.isQueryMatchPartialInnerJoinModel();
        boolean nonEquiPartialMatch = kylinConfig.partialMatchNonEquiJoins();
        for (OlapContext ctx : modelTree.getOlapContexts()) {
            AccelerateInfo accelerateInfo = this.proposeContext.getAccelerateInfoMap().get(ctx.getSql());
            Preconditions.checkNotNull((Object)accelerateInfo);
            if (accelerateInfo.isNotSucceed()) continue;
            try {
                if (CollectionUtils.isNotEmpty((Collection)ctx.getContainedNotSupportedFunc())) {
                    throw new NotSupportedSQLException(StringUtils.join((Iterable)ctx.getContainedNotSupportedFunc(), (String)", ") + " function not supported");
                }
                Map aliasMap = ctx.matchJoins(this.model, partialMatch, nonEquiPartialMatch);
                if (MapUtils.isEmpty((Map)aliasMap)) {
                    throw new PendingException(String.format(Locale.ROOT, this.getMsgTemplateByModelMaintainType(JOIN_NOT_MATCHED, Type.TABLE), this.model.getAlias()));
                }
                ctx.fixModel(this.model, aliasMap);
                AccelerateInfo.QueryLayoutRelation queryLayoutRelation = this.ingest(ctx, this.model);
                accelerateInfo.getRelatedLayouts().add(queryLayoutRelation);
            }
            catch (Exception e) {
                log.error("Unable to suggest cuboid for IndexPlan", (Throwable)e);
                if (e instanceof PendingException) {
                    accelerateInfo.setPendingMsg(e.getMessage());
                } else {
                    accelerateInfo.setFailedCause(e);
                }
                accelerateInfo.getRelatedLayouts().clear();
            }
            finally {
                ctx.unfixModel();
            }
        }
    }

    private List<Integer> suggestShardBy(List<Integer> sortedDimIds) {
        ArrayList shardBy = Lists.newArrayList();
        if (CollectionUtils.isEmpty(sortedDimIds)) {
            return shardBy;
        }
        TblColRef colRef = (TblColRef)this.model.getEffectiveCols().get((Object)sortedDimIds.get(0));
        NTableMetadataManager tableMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.proposeContext.getProject());
        TableExtDesc.ColumnStats colStats = TableExtDesc.ColumnStats.getColumnStats((NTableMetadataManager)tableMgr, (TblColRef)colRef);
        if (colStats != null && colStats.getCardinality() > this.proposeContext.getSmartConfig().getRowkeyUHCCardinalityMin()) {
            shardBy.add(sortedDimIds.get(0));
        }
        return shardBy;
    }

    private AccelerateInfo.QueryLayoutRelation ingest(OlapContext ctx, NDataModel model) {
        IndexEntity indexEntity;
        SortedSet<Object> measureIds;
        List<Integer> dimIds;
        if (ctx.getSQLDigest().isRawQuery) {
            dimIds = this.suggestTableIndexDimensions(ctx);
            measureIds = Sets.newTreeSet();
            indexEntity = this.createIndexEntity(this.suggestDescId(true), dimIds, measureIds);
        } else {
            dimIds = this.suggestAggIndexDimensions(ctx);
            measureIds = this.suggestMeasures(dimIds, ctx);
            indexEntity = this.createIndexEntity(this.suggestDescId(false), dimIds, measureIds);
        }
        IndexEntity.IndexIdentifier cuboidIdentifier = indexEntity.createIndexIdentifier();
        if (this.collector.containsKey(cuboidIdentifier)) {
            indexEntity = this.collector.get(cuboidIdentifier);
        } else {
            this.collector.put(cuboidIdentifier, indexEntity);
        }
        if (model.getDataStorageType().isV3Storage() && model.isIncrementBuildOnExpertMode() && !dimIds.contains(model.getPartitionColumnId())) {
            dimIds.add(model.getPartitionColumnId(), 0);
        }
        LayoutEntity layout = new EntityBuilder.LayoutEntityBuilder(this.suggestLayoutId(indexEntity), indexEntity).colOrderIds(this.suggestColOrder(dimIds, measureIds, Lists.newArrayList())).isAuto(true).build();
        layout.setInProposing(true);
        if (!indexEntity.isTableIndex() && CollectionUtils.isNotEmpty((Collection)this.indexPlan.getAggShardByColumns()) && layout.getColOrder().containsAll((Collection)this.indexPlan.getAggShardByColumns())) {
            layout.setShardByColumns(this.indexPlan.getAggShardByColumns());
        } else if (this.isQualifiedSuggestShardBy(ctx)) {
            layout.setShardByColumns(this.suggestShardBy(dimIds));
        }
        String modelId = model.getUuid();
        int semanticVersion = model.getSemanticVersion();
        for (LayoutEntity l : indexEntity.getLayouts()) {
            List sortByColumns = layout.getSortByColumns();
            layout.setSortByColumns(l.getSortByColumns());
            if (l.equals((Object)layout)) {
                return new AccelerateInfo.QueryLayoutRelation(ctx.getSql(), modelId, l.getId(), semanticVersion);
            }
            layout.setSortByColumns(sortByColumns);
        }
        indexEntity.getLayouts().add(layout);
        this.layoutIds.add(layout.getId());
        this.modelContext.gatherLayoutRecItem(layout);
        return new AccelerateInfo.QueryLayoutRelation(ctx.getSql(), modelId, layout.getId(), semanticVersion);
    }

    private boolean isQualifiedSuggestShardBy(OlapContext context) {
        for (TblColRef colRef : context.getSQLDigest().getFilterColumns()) {
            if (TblColRef.FilterColEnum.EQUAL_FILTER != colRef.getFilterLevel()) continue;
            return true;
        }
        return false;
    }

    private List<Integer> suggestTableIndexDimensions(OlapContext context) {
        HashSet filterColumns = Sets.newHashSet((Iterable)context.getFilterColumns());
        HashSet<TblColRef> nonFilterColumnSet = new HashSet<TblColRef>(context.getAllColumns());
        nonFilterColumnSet.addAll(context.getSubqueryJoinParticipants());
        if (nonFilterColumnSet.isEmpty() && context.getFilterColumns().isEmpty()) {
            Preconditions.checkState((boolean)CollectionUtils.isNotEmpty((Collection)this.model.getAllNamedColumns()), (Object)"Cannot suggest any columns in table index.");
            Optional<NDataModel.NamedColumn> optional = this.model.getAllNamedColumns().stream().filter(column -> {
                TblColRef tblColRef = (TblColRef)this.model.getEffectiveCols().get((Object)column.getId());
                return tblColRef.getTable().equalsIgnoreCase(this.model.getRootFactTableName());
            }).findFirst();
            if (optional.isPresent()) {
                NDataModel.NamedColumn namedColumn = optional.get();
                nonFilterColumnSet.add((TblColRef)this.model.getEffectiveCols().get((Object)namedColumn.getId()));
                if (namedColumn.getStatus() != NDataModel.ColumnStatus.DIMENSION) {
                    this.addDimRecommendationForTableIndex(namedColumn);
                }
            }
        }
        nonFilterColumnSet.removeAll(context.getFilterColumns());
        this.replaceDimOfLookupTableWithFK(context, filterColumns, nonFilterColumnSet);
        List<TblColRef> sortedDims = this.sortDimensionColumns(filterColumns, nonFilterColumnSet);
        return this.generateDimensionIds(sortedDims, (ImmutableBiMap<TblColRef, Integer>)this.model.getEffectiveCols().inverse());
    }

    private void addDimRecommendationForTableIndex(NDataModel.NamedColumn column) {
        TblColRef tblColRef = (TblColRef)this.model.getEffectiveCols().get((Object)column.getId());
        if (this.additionalNamedColumns.contains(tblColRef.getIdentity())) {
            return;
        }
        column.setStatus(NDataModel.ColumnStatus.DIMENSION);
        Set newCcUuids = this.modelContext.getCcRecItemMap().values().stream().map(item -> item.getCc().getUuid()).collect(Collectors.toSet());
        String uniqueContent = RawRecUtil.dimensionUniqueContent((TblColRef)tblColRef, (Map)this.model.getCcMap(), newCcUuids);
        if (!this.modelContext.getUniqueContentToFlag().containsKey(uniqueContent)) {
            DimensionRecItemV2 item2 = new DimensionRecItemV2(column, tblColRef, uniqueContent);
            this.modelContext.getDimensionRecItemMap().putIfAbsent(item2.getUuid(), item2);
            this.additionalNamedColumns.add(tblColRef.getIdentity());
        }
    }

    private List<Integer> suggestAggIndexDimensions(OlapContext context) {
        HashSet filterColumns = Sets.newHashSet((Iterable)context.getFilterColumns());
        HashSet<TblColRef> nonFilterColumnSet = new HashSet<TblColRef>(context.getGroupByColumns());
        nonFilterColumnSet.addAll(context.getSubqueryJoinParticipants());
        nonFilterColumnSet.removeAll(context.getFilterColumns());
        this.replaceDimOfLookupTableWithFK(context, filterColumns, nonFilterColumnSet);
        List<TblColRef> sortedDims = this.sortDimensionColumns(filterColumns, nonFilterColumnSet);
        return this.generateDimensionIds(sortedDims, (ImmutableBiMap<TblColRef, Integer>)this.model.getEffectiveDimensions().inverse());
    }

    private void replaceDimOfLookupTableWithFK(OlapContext olapContext, Set<TblColRef> filterColumns, Set<TblColRef> nonFilterColumnSet) {
        AntiFlatChecker antiFlatChecker = this.modelContext.getAntiFlatChecker();
        Preconditions.checkNotNull((Object)antiFlatChecker, (Object)"Initialization of anti-flatten lookups is not ready.");
        boolean constraintFilterOfCC = this.removeAntiLookupCols(antiFlatChecker, filterColumns);
        boolean constraintNonFilterOfCC = this.removeAntiLookupCols(antiFlatChecker, nonFilterColumnSet);
        log.debug("Some computed-columns of anti-flatten lookup tables? {}", (Object)(constraintFilterOfCC || constraintNonFilterOfCC ? 1 : 0));
        if (constraintFilterOfCC || constraintNonFilterOfCC) {
            throw new PendingException(COMPUTED_COLUMN_ON_ANTI_FLATTEN_LOOKUP);
        }
        ColExcludedChecker excludedChecker = this.modelContext.getExcludedChecker();
        Preconditions.checkNotNull((Object)excludedChecker, (Object)"Initialization of excluded columns is not ready.");
        boolean excludedFilterOfCC = this.removeExcludedColumns(excludedChecker, filterColumns);
        boolean excludedNonFilterOfCC = this.removeExcludedColumns(excludedChecker, nonFilterColumnSet);
        log.debug("Some computed-columns depend on excluded column? {}", (Object)(excludedFilterOfCC || excludedNonFilterOfCC ? 1 : 0));
        if (excludedFilterOfCC || excludedNonFilterOfCC) {
            throw new PendingException(COMPUTED_COLUMN_OF_EXCLUDED_COLUMNS);
        }
        Map<String, TblColRef> fKAsDimensionMap = this.modelContext.collectFkDimensionMap(olapContext);
        fKAsDimensionMap.forEach((name, tblColRef) -> {
            if (!filterColumns.contains(tblColRef)) {
                nonFilterColumnSet.add((TblColRef)tblColRef);
            }
        });
    }

    private boolean removeExcludedColumns(ColExcludedChecker checker, Set<TblColRef> tblColRefs) {
        AtomicBoolean hasExcludedCC = new AtomicBoolean();
        tblColRefs.removeIf(tblColRef -> {
            ColumnDesc col;
            boolean isExcludedCol = checker.isExcludedCol(tblColRef);
            if (isExcludedCol) {
                log.debug("Remove column {} depends on excluded column.", tblColRef);
            }
            if ((col = tblColRef.getColumnDesc()).isComputedColumn() && isExcludedCol && !hasExcludedCC.get()) {
                hasExcludedCC.set(true);
            }
            return isExcludedCol;
        });
        return hasExcludedCC.get();
    }

    private boolean removeAntiLookupCols(AntiFlatChecker checker, Set<TblColRef> tblColRefs) {
        AtomicBoolean hasConstraintCC = new AtomicBoolean();
        tblColRefs.removeIf(tblColRef -> {
            boolean constrained = checker.isColOfAntiLookup(tblColRef);
            if (constrained) {
                log.debug("Removed column {} of anti-flatten lookup table.", tblColRef);
            }
            if (tblColRef.getColumnDesc().isComputedColumn() && constrained && !hasConstraintCC.get()) {
                hasConstraintCC.set(true);
            }
            return constrained;
        });
        return hasConstraintCC.get();
    }

    private List<TblColRef> sortDimensionColumns(Collection<TblColRef> filterColumnsCollection, Collection<TblColRef> nonFilterColumnsCollection) {
        ArrayList<TblColRef> filterColumns = new ArrayList<TblColRef>(filterColumnsCollection);
        ArrayList<TblColRef> nonFilterColumns = new ArrayList<TblColRef>(nonFilterColumnsCollection);
        ChooserContext chooserContext = new ChooserContext(this.model);
        Comparator filterColComparator = ComparatorUtils.filterColComparator((ChooserContext)chooserContext);
        filterColumns.sort(filterColComparator);
        nonFilterColumns.sort(ComparatorUtils.nonFilterColComparator());
        LinkedList<TblColRef> result = new LinkedList<TblColRef>(filterColumns);
        result.addAll(nonFilterColumns);
        return result;
    }

    private List<Integer> generateDimensionIds(List<TblColRef> dimCols, ImmutableBiMap<TblColRef, Integer> colIdMap) {
        return dimCols.stream().map(dimCol -> {
            if (colIdMap.get(dimCol) == null) {
                throw new PendingException(String.format(Locale.ROOT, this.getMsgTemplateByModelMaintainType(COLUMN_NOT_FOUND_PTN, Type.COLUMN), this.model.getAlias(), dimCol.getIdentity()));
            }
            return (Integer)colIdMap.get(dimCol);
        }).collect(Collectors.toList());
    }

    private SortedSet<Integer> suggestMeasures(List<Integer> dimIds, OlapContext ctx) {
        ImmutableBiMap colIdMap = this.model.getEffectiveDimensions().inverse();
        TreeSet measureIds = Sets.newTreeSet();
        measureIds.add(this.calcCountOneMeasureId());
        ctx.getAggregations().forEach(arg_0 -> this.lambda$suggestMeasures$9(measureIds, (Map)colIdMap, dimIds, arg_0));
        return measureIds;
    }

    private Integer calcCountOneMeasureId() {
        Integer countOne = this.aggFuncIdMap.get(FunctionDesc.newCountOne());
        return countOne == null ? 100000 : countOne;
    }

    private String getMsgTemplateByModelMaintainType(String messagePattern, Type type) {
        Preconditions.checkNotNull((Object)this.model);
        String suggestion = type == Type.COLUMN ? "Please add the above dimension before attempting to accelerate this query." : (type == Type.MEASURE ? "Please add the above measure before attempting to accelerate this query." : "Please adjust model's join to match the query.");
        return messagePattern + suggestion;
    }

    private IndexEntity createIndexEntity(long id, List<Integer> dimIds, SortedSet<Integer> measureIds) {
        EntityBuilder.checkDimensionsAndMeasures(dimIds, Lists.newArrayList(measureIds));
        IndexEntity indexEntity = new IndexEntity();
        indexEntity.setId(id);
        indexEntity.setDimensions(dimIds);
        indexEntity.setMeasures((List)Lists.newArrayList(measureIds));
        indexEntity.setIndexPlan(this.indexPlan);
        return indexEntity;
    }

    private List<Integer> suggestColOrder(List<Integer> orderedDimIds, Set<Integer> measureIds, List<Integer> shardBy) {
        ArrayList<Integer> copyDimension = new ArrayList<Integer>(orderedDimIds);
        copyDimension.removeAll(shardBy);
        ArrayList colOrder = Lists.newArrayList();
        colOrder.addAll(shardBy);
        colOrder.addAll(copyDimension);
        colOrder.addAll(measureIds);
        return colOrder;
    }

    private long suggestDescId(boolean isTableIndex) {
        return EntityBuilder.IndexEntityBuilder.findAvailableIndexEntityId(this.indexPlan, this.collector.values(), isTableIndex);
    }

    private long suggestLayoutId(IndexEntity indexEntity) {
        long s = indexEntity.getId() + indexEntity.getNextLayoutOffset();
        while (this.layoutIds.contains(s)) {
            ++s;
        }
        return s;
    }

    private /* synthetic */ void lambda$suggestMeasures$9(SortedSet measureIds, Map colIdMap, List dimIds, FunctionDesc aggFunc) {
        Integer measureId = this.aggFuncIdMap.get(aggFunc);
        if (this.modelContext.getAntiFlatChecker().isMeasureOfAntiLookup(aggFunc)) {
            throw new PendingException(MEASURE_ON_ANTI_FLATTEN_LOOKUP + aggFunc);
        }
        if (this.modelContext.getExcludedChecker().isExcludedMeasure(aggFunc)) {
            throw new PendingException(MEASURE_OF_EXCLUDED_COLUMNS + aggFunc);
        }
        if (measureId != null) {
            measureIds.add(measureId);
        } else if (CollectionUtils.isNotEmpty((Collection)aggFunc.getParameters())) {
            if (CubeUtils.isValidMeasure(aggFunc)) {
                String measure = String.format(Locale.ROOT, "%s(%s)", aggFunc.getExpression(), aggFunc.getParameters());
                for (TblColRef tblColRef : aggFunc.getColRefs()) {
                    if (colIdMap.get(tblColRef) != null) continue;
                    throw new PendingException(String.format(Locale.ROOT, this.getMsgTemplateByModelMaintainType(MEASURE_NOT_FOUND_PTN, Type.MEASURE), this.model.getAlias(), measure));
                }
            } else if (aggFunc.canAnsweredByDimensionAsMeasure()) {
                List<Integer> newDimIds = this.generateDimensionIds(Lists.newArrayList((Iterable)aggFunc.getSourceColRefs()), (ImmutableBiMap<TblColRef, Integer>)this.model.getEffectiveDimensions().inverse());
                newDimIds.removeIf(dimIds::contains);
                dimIds.addAll(newDimIds);
            }
        }
    }

    private static enum Type {
        TABLE,
        COLUMN,
        MEASURE;

    }
}

