/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Ordering;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.util.QueryModelPriorities;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractProposer;
import org.apache.kylin.rec.SmartContext;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.apache.kylin.rec.model.AbstractJoinRule;
import org.apache.kylin.rec.model.GreedyModelTreesBuilder;
import org.apache.kylin.rec.model.ModelTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelSelectProposer
extends AbstractProposer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelSelectProposer.class);
    public static final String NO_MODEL_MATCH_PENDING_MSG = "No model matches the SQL. Please add a model matches the SQL before attempting to accelerate this query.";
    public static final String CC_ACROSS_MODELS_PENDING_MSG = "No model matches the SQL. Please add a model that contains all the computed columns used in the query.";
    private final NDataModelManager dataModelManager;
    private final AbstractJoinRule joinSelectOptRule;

    public ModelSelectProposer(AbstractContext proposeContext) {
        super(proposeContext);
        this.dataModelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
        this.joinSelectOptRule = AbstractJoinRule.getInstance();
    }

    @Override
    public void execute() {
        List<AbstractContext.ModelContext> modelContexts = this.proposeContext.getModelContexts();
        if (CollectionUtils.isEmpty(modelContexts)) {
            log.warn("Something wrong happened in the preceding step of sql analysis. Cannot continue auto-modeling without modelTrees.");
            return;
        }
        ArrayList allSubModelContexts = Lists.newArrayList();
        HashMap selectedModel = Maps.newHashMap();
        this.selectModelForModelContext(modelContexts, allSubModelContexts, selectedModel);
        if (CollectionUtils.isNotEmpty((Collection)allSubModelContexts)) {
            this.selectModelForModelContext(allSubModelContexts, Lists.newArrayList(), selectedModel);
        }
        this.proposeContext.handleExceptionAfterModelSelect();
    }

    private void selectModelForModelContext(List<AbstractContext.ModelContext> modelContexts, List<AbstractContext.ModelContext> allSubModelContexts, Map<String, AbstractContext.ModelContext> selectedModel) {
        ListIterator<AbstractContext.ModelContext> modelContextIterator = modelContexts.listIterator();
        HashSet mergedModelContexts = Sets.newHashSet();
        while (modelContextIterator.hasNext()) {
            AbstractContext.ModelContext anotherModelContext;
            AbstractContext.ModelContext modelContext = modelContextIterator.next();
            ModelTree modelTree = modelContext.getModelTree();
            NDataModel model = this.selectExistedModel(modelTree, modelContext);
            if (model == null) {
                List<AbstractContext.ModelContext> subModelContexts;
                if (CollectionUtils.isEmpty(this.proposeContext.getOriginModels()) || (subModelContexts = this.splitModelContext(modelContext)).size() <= 1) continue;
                modelContextIterator.remove();
                subModelContexts.forEach(modelContextIterator::add);
                allSubModelContexts.addAll(subModelContexts);
                continue;
            }
            if (selectedModel.containsKey(model.getUuid()) && !modelContext.isSnapshotSelected() && !modelContext.getModelTree().isHasModelPropertiesHint() && !(anotherModelContext = selectedModel.get(model.getUuid())).getModelTree().isHasModelPropertiesHint()) {
                AbstractContext.ModelContext newModelContext = new GreedyModelTreesBuilder.TreeBuilder(model.getRootFactTable().getTableDesc(), NTableMetadataManager.getInstance((KylinConfig)this.dataModelManager.getConfig(), (String)this.project).getAllTablesMap(), this.proposeContext).mergeModelContext(this.proposeContext, modelContext, anotherModelContext);
                this.setModelContextModel(newModelContext, model);
                mergedModelContexts.add(modelContext);
                mergedModelContexts.add(anotherModelContext);
                modelContextIterator.add(newModelContext);
                selectedModel.put(model.getUuid(), newModelContext);
                continue;
            }
            this.setModelContextModel(modelContext, model);
            if (modelContext.isSnapshotSelected()) continue;
            selectedModel.put(model.getUuid(), modelContext);
        }
        modelContexts.removeAll(mergedModelContexts);
    }

    private void setModelContextModel(AbstractContext.ModelContext modelContext, NDataModel model) {
        modelContext.setOriginModel(model);
        NDataModel targetModel = this.dataModelManager.copyBySerialization(model);
        this.initModel(targetModel);
        targetModel.getComputedColumnDescs().forEach(cc -> modelContext.getUsedCC().put(cc.getExpression(), (ComputedColumnDesc)cc));
        modelContext.setTargetModel(targetModel);
    }

    private List<AbstractContext.ModelContext> splitModelContext(AbstractContext.ModelContext modelContext) {
        Map<String, List<OlapContext>> sqlOlapContextMap = modelContext.getModelTree().getOlapContexts().stream().collect(Collectors.groupingBy(OlapContext::getSql));
        if (sqlOlapContextMap.size() == 1) {
            return Lists.newArrayList((Object[])new AbstractContext.ModelContext[]{modelContext});
        }
        ArrayList subModelContexts = Lists.newArrayList();
        HashMap sqlModelContextMap = Maps.newHashMap();
        HashMap sqlSelectedModelMap = Maps.newHashMap();
        HashMap noneSelected = Maps.newHashMap();
        sqlOlapContextMap.forEach((key, value) -> {
            HashMap map = Maps.newHashMap();
            map.put(key, value);
            AbstractContext.ModelContext sqlModelContext = this.buildModelContext(map).get(0);
            NDataModel selectedModel = this.selectExistedModel(sqlModelContext.getModelTree(), sqlModelContext);
            if (selectedModel == null) {
                noneSelected.put(key, value);
            } else {
                sqlSelectedModelMap.putIfAbsent(selectedModel, Lists.newArrayList());
                ((List)sqlSelectedModelMap.get(selectedModel)).add(key);
                sqlModelContextMap.put(key, sqlModelContext);
            }
        });
        subModelContexts.addAll(this.buildModelContext(noneSelected));
        sqlSelectedModelMap.forEach((model, sqls) -> {
            HashMap map = Maps.newHashMap();
            if (sqls.size() == 1) {
                subModelContexts.add(sqlModelContextMap.get(sqls.get(0)));
            } else {
                for (String sql : sqls) {
                    map.putIfAbsent(sql, Lists.newArrayList());
                    ((Collection)map.get(sql)).addAll((Collection)sqlOlapContextMap.get(sql));
                }
                subModelContexts.addAll(this.buildModelContext(map));
            }
        });
        return subModelContexts;
    }

    private List<AbstractContext.ModelContext> buildModelContext(Map<String, Collection<OlapContext>> groupedOlapMap) {
        return new GreedyModelTreesBuilder(KylinConfig.getInstanceFromEnv(), this.project, this.proposeContext).build(groupedOlapMap, null).stream().filter(modelTree -> !modelTree.getOlapContexts().isEmpty()).map(this.proposeContext::createModelContext).collect(Collectors.toList());
    }

    private void initModel(NDataModel modelDesc) {
        modelDesc.init(KylinConfig.getInstanceFromEnv(), this.project, (List)Lists.newArrayList());
    }

    private Comparator<NDataModel> modelSorter(ModelTree modelTree) {
        HashMap modelPriorities = Maps.newHashMap();
        if (modelTree != null && modelTree.getOlapContexts() != null && !modelTree.getOlapContexts().isEmpty()) {
            String[] priorities = QueryModelPriorities.getModelPrioritiesFromComment((String)modelTree.getOlapContexts().iterator().next().getSql());
            for (int i = 0; i < priorities.length; ++i) {
                modelPriorities.put(priorities[i], i);
            }
        }
        Comparator<NDataModel> sqlHintSorter = Comparator.comparingInt(m -> modelPriorities.getOrDefault(m.getAlias().toUpperCase(Locale.ROOT), Integer.MAX_VALUE));
        Comparator joinSorter = (m1, m2) -> {
            List joinTables2 = m2.getJoinTables() == null ? Lists.newArrayList() : m2.getJoinTables();
            List joinTables1 = m1.getJoinTables() == null ? Lists.newArrayList() : m1.getJoinTables();
            List filteredJoinTables1 = joinTables1.stream().filter(joinTable -> joinTable.getJoin().isJoinWithFactTable(m1.getRootFactTableName())).collect(Collectors.toList());
            List filteredJoinTables2 = joinTables2.stream().filter(joinTable -> joinTable.getJoin().isJoinWithFactTable(m2.getRootFactTableName())).collect(Collectors.toList());
            return Integer.compare(filteredJoinTables2.size(), filteredJoinTables1.size());
        };
        Comparator<NDataModel> modifiedSorter = Comparator.comparing(RootPersistentEntity::getCreateTime).reversed();
        Comparator<NDataModel> aliasSorter = Comparator.comparing(NDataModel::getAlias).reversed();
        return Ordering.from(sqlHintSorter).compound(joinSorter).compound(modifiedSorter).compound(aliasSorter);
    }

    private NDataModel selectExistedModel(ModelTree modelTree, AbstractContext.ModelContext modelContext) {
        List<NDataModel> originModels = this.proposeContext.getOriginModels();
        originModels.sort(this.modelSorter(modelTree));
        for (NDataModel model : originModels) {
            boolean match;
            List<OlapContext> retainedOlapContexts = this.retainCapableOlapContexts(model, Lists.newArrayList(modelTree.getOlapContexts()));
            if (retainedOlapContexts.isEmpty()) continue;
            boolean bl = match = this.proposeContext instanceof SmartContext ? modelTree.hasSameSubGraph(model) : modelTree.isExactlyMatch(model, this.proposeContext.isPartialMatch(), this.proposeContext.isPartialMatchNonEqui());
            if (match) {
                List<OlapContext> disabledList = modelTree.getOlapContexts().stream().filter(context -> !retainedOlapContexts.contains(context)).collect(Collectors.toList());
                disabledList.forEach(context -> {
                    AccelerateInfo accelerateInfo = new AccelerateInfo();
                    accelerateInfo.setPendingMsg(CC_ACROSS_MODELS_PENDING_MSG);
                    this.proposeContext.getAccelerateInfoMap().put(context.getSql(), accelerateInfo);
                });
                modelTree.getOlapContexts().clear();
                modelTree.getOlapContexts().addAll(retainedOlapContexts);
                modelContext.setSnapshotSelected(false);
                return model;
            }
            if (this.proposeContext.isCanCreateNewModel() && this.joinSelectOptRule.isCompatible(model, modelTree)) {
                return model;
            }
            String project = modelContext.getProposeContext().getProject();
            KylinConfig config = modelContext.getProposeContext().getSmartConfig().getKylinConfig();
            if (this.proposeContext instanceof SmartContext || !ModelSelectProposer.matchSnapshot(config, project, modelTree)) continue;
            modelContext.setSnapshotSelected(true);
            return model;
        }
        return null;
    }

    private List<OlapContext> retainCapableOlapContexts(NDataModel model, List<OlapContext> olapContexts) {
        Set<ColumnDesc> ccColDesc = this.filterTblColRefOfCC((Set<TblColRef>)model.getEffectiveCols().values());
        Iterator<OlapContext> iterator = olapContexts.iterator();
        while (iterator.hasNext()) {
            OlapContext context = iterator.next();
            Set<ColumnDesc> ccColDescInCtx = this.filterTblColRefOfCC(context.getAllColumns());
            if (ccColDesc.containsAll(ccColDescInCtx)) continue;
            iterator.remove();
        }
        return olapContexts;
    }

    private Set<ColumnDesc> filterTblColRefOfCC(Set<TblColRef> tableColRefSet) {
        if (CollectionUtils.isEmpty(tableColRefSet)) {
            return Sets.newHashSet();
        }
        return tableColRefSet.stream().map(TblColRef::getColumnDesc).filter(ColumnDesc::isComputedColumn).collect(Collectors.toSet());
    }

    public static boolean matchSnapshot(KylinConfig config, String project, ModelTree modelTree) {
        if (!modelTree.getJoins().isEmpty() || modelTree.getRootFactTable().isIncrementLoading()) {
            return false;
        }
        String modelTreeRootTable = modelTree.getRootFactTable().getIdentity();
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)config, (String)project);
        return StringUtils.isNotEmpty((CharSequence)tableManager.getTableDesc(modelTreeRootTable).getLastSnapshotPath());
    }

    @Override
    public String getIdentifierName() {
        return "ModelSelectProposer";
    }
}

