/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.KapAddMonths$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.KapDateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(start_date, num_months) - Returns the date that is `num_months` after `start_date`.", extended="\n    Examples:\n      > SELECT _FUNC_('2016-08-31', 1);\n       2016-09-30\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001\u0002\u0010 \u00012B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005\u007f!A1\t\u0001BK\u0002\u0013\u0005a\b\u0003\u0005E\u0001\tE\t\u0015!\u0003@\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015Q\u0005\u0001\"\u0011?\u0011\u0015Y\u0005\u0001\"\u0011?\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015q\u0007\u0001\"\u0011p\u0011\u0015i\b\u0001\"\u0011\u007f\u0011\u001d\ty\u0001\u0001C)\u0003#A\u0011\"a\u0007\u0001\u0003\u0003%\t!!\b\t\u0013\u0005\r\u0002!%A\u0005\u0002\u0005\u0015\u0002\"CA\u001e\u0001E\u0005I\u0011AA\u0013\u0011%\ti\u0004AA\u0001\n\u0003\ny\u0004C\u0005\u0002P\u0001\t\t\u0011\"\u0001\u0002R!I\u0011\u0011\f\u0001\u0002\u0002\u0013\u0005\u00111\f\u0005\n\u0003C\u0002\u0011\u0011!C!\u0003GB\u0011\"!\u001d\u0001\u0003\u0003%\t!a\u001d\t\u0013\u0005u\u0004!!A\u0005B\u0005}t!CAL?\u0005\u0005\t\u0012AAM\r!qr$!A\t\u0002\u0005m\u0005BB#\u0019\t\u0003\tI\u000bC\u0005\u0002,b\t\t\u0011\"\u0012\u0002.\"I\u0011q\u0016\r\u0002\u0002\u0013\u0005\u0015\u0011\u0017\u0005\n\u0003oC\u0012\u0011!CA\u0003sC\u0011\"a3\u0019\u0003\u0003%I!!4\u0003\u0019-\u000b\u0007/\u00113e\u001b>tG\u000f[:\u000b\u0005\u0001\n\u0013aC3yaJ,7o]5p]NT!AI\u0012\u0002\u0011\r\fG/\u00197zgRT!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00172ii\u0002\"AL\u0018\u000e\u0003}I!\u0001M\u0010\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00183\u0013\t\u0019tD\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u001d\u0001&o\u001c3vGR\u0004\"!N\u001e\n\u0005q2$\u0001D*fe&\fG.\u001b>bE2,\u0017!C:uCJ$H)\u0019;f+\u0005y\u0004C\u0001\u0018A\u0013\t\tuD\u0001\u0006FqB\u0014Xm]:j_:\f!b\u001d;beR$\u0015\r^3!\u0003%qW/\\'p]RD7/\u0001\u0006ok6luN\u001c;ig\u0002\na\u0001P5oSRtDcA$I\u0013B\u0011a\u0006\u0001\u0005\u0006{\u0015\u0001\ra\u0010\u0005\u0006\u0007\u0016\u0001\raP\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u0014\t\u0004\u001f^SfB\u0001)V\u001d\t\tF+D\u0001S\u0015\t\u00196&\u0001\u0004=e>|GOP\u0005\u0002o%\u0011aKN\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0016LA\u0002TKFT!A\u0016\u001c\u0011\u0005msV\"\u0001/\u000b\u0005u\u001b\u0013!\u0002;za\u0016\u001c\u0018BA0]\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005\u0011\u0007CA.d\u0013\t!GLA\u0007US6,7\u000f^1naRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004O*d\u0007CA\u001bi\u0013\tIgGA\u0002B]fDQa\u001b\u0006A\u0002\u001d\fQa\u001d;beRDQ!\u001c\u0006A\u0002\u001d\fa!\\8oi\"\u001c\u0018!\u00033p\u000f\u0016t7i\u001c3f)\r\u0001ho\u001f\t\u0003cRl\u0011A\u001d\u0006\u0003g~\tqaY8eK\u001e,g.\u0003\u0002ve\nAQ\t\u001f9s\u0007>$W\rC\u0003x\u0017\u0001\u0007\u00010A\u0002dib\u0004\"!]=\n\u0005i\u0014(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006y.\u0001\r\u0001]\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\u0005y\b\u0003BA\u0001\u0003\u0013qA!a\u0001\u0002\u0006A\u0011\u0011KN\u0005\u0004\u0003\u000f1\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00055!AB*ue&twMC\u0002\u0002\bY\nqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000b}\n\u0019\"a\u0006\t\r\u0005UQ\u00021\u0001@\u0003\u001dqWm\u001e'fMRDa!!\u0007\u000e\u0001\u0004y\u0014\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0006\u000f\u0006}\u0011\u0011\u0005\u0005\b{9\u0001\n\u00111\u0001@\u0011\u001d\u0019e\u0002%AA\u0002}\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002()\u001aq(!\u000b,\u0005\u0005-\u0002\u0003BA\u0017\u0003oi!!a\f\u000b\t\u0005E\u00121G\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000e7\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\tyCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0003mC:<'BAA&\u0003\u0011Q\u0017M^1\n\t\u0005-\u0011QI\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003'\u00022!NA+\u0013\r\t9F\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004O\u0006u\u0003\"CA0'\u0005\u0005\t\u0019AA*\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\r\t\u0006\u0003O\nigZ\u0007\u0003\u0003SR1!a\u001b7\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\nIG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA;\u0003w\u00022!NA<\u0013\r\tIH\u000e\u0002\b\u0005>|G.Z1o\u0011!\ty&FA\u0001\u0002\u00049\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002v\u0005\u0005\u0005\u0002CA0-\u0005\u0005\t\u0019A4)\u0017\u0001\t))a#\u0002\u000e\u0006E\u00151\u0013\t\u0004]\u0005\u001d\u0015bAAE?\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAH\u0003i{f)\u0016(D?\"\u001aH/\u0019:u?\u0012\fG/\u001a\u0017!]Vlw,\\8oi\"\u001c\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t3bi\u0016\u0004C\u000f[1uA%\u001c\b\u0005\u00198v[~kwN\u001c;ig\u0002\u0004\u0013M\u001a;fe\u0002\u00027\u000f^1si~#\u0017\r^3a]\u0005AQ\r\u001f;f]\u0012,G-\t\u0002\u0002\u0016\u0006Y%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T\u0006\r\u001d.gE:C\u0006I\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u001c.aej3\u0007\r\u0006!A\u0005a1*\u00199BI\u0012luN\u001c;igB\u0011a\u0006G\n\u00051\u0005u%\bE\u0004\u0002 \u0006\u0015vhP$\u000e\u0005\u0005\u0005&bAARm\u00059!/\u001e8uS6,\u0017\u0002BAT\u0003C\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\tI*\u0001\u0005u_N#(/\u001b8h)\t\t\t%A\u0003baBd\u0017\u0010F\u0003H\u0003g\u000b)\fC\u0003>7\u0001\u0007q\bC\u0003D7\u0001\u0007q(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005m\u0016q\u0019\t\u0006k\u0005u\u0016\u0011Y\u0005\u0004\u0003\u007f3$AB(qi&|g\u000eE\u00036\u0003\u0007|t(C\u0002\u0002FZ\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAe9\u0005\u0005\t\u0019A$\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAh!\u0011\t\u0019%!5\n\t\u0005M\u0017Q\t\u0002\u0007\u001f\nTWm\u0019;")
public class KapAddMonths
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression startDate;
    private final Expression numMonths;

    public static Option<Tuple2<Expression, Expression>> unapply(KapAddMonths kapAddMonths) {
        return KapAddMonths$.MODULE$.unapply(kapAddMonths);
    }

    public static Function1<Tuple2<Expression, Expression>, KapAddMonths> tupled() {
        return KapAddMonths$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, KapAddMonths>> curried() {
        return KapAddMonths$.MODULE$.curried();
    }

    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$((ExpectsInputTypes)this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression numMonths() {
        return this.numMonths;
    }

    public Expression left() {
        return this.startDate();
    }

    public Expression right() {
        return this.numMonths();
    }

    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    public TimestampType dataType() {
        return TimestampType$.MODULE$;
    }

    public Object nullSafeEval(Object start, Object months) {
        long time = BoxesRunTime.unboxToLong((Object)start);
        int month = BoxesRunTime.unboxToInt((Object)months);
        return BoxesRunTime.boxToLong((long)KapDateTimeUtils$.MODULE$.addMonths(time, month));
    }

    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(KapDateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function2 & Serializable & scala.Serializable)(sd, m) -> new StringBuilder(14).append(dtu).append(".addMonths(").append((String)sd).append(", ").append((String)m).append(")").toString());
    }

    public String prettyName() {
        return "kap_add_months";
    }

    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        Seq newChildren = (Seq)new .colon.colon((Object)newLeft, (List)new .colon.colon((Object)newRight, (List)Nil$.MODULE$));
        return (Expression)super.legacyWithNewChildren(newChildren);
    }

    public KapAddMonths copy(Expression startDate, Expression numMonths) {
        return new KapAddMonths(startDate, numMonths);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.numMonths();
    }

    public String productPrefix() {
        return "KapAddMonths";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.startDate();
                break;
            }
            case 1: {
                expression = this.numMonths();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KapAddMonths;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KapAddMonths)) return false;
        boolean bl = true;
        if (!bl) return false;
        KapAddMonths kapAddMonths = (KapAddMonths)((Object)x$1);
        Expression expression = this.startDate();
        Expression expression2 = kapAddMonths.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.numMonths();
        Expression expression4 = kapAddMonths.numMonths();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!kapAddMonths.canEqual((Object)this)) return false;
        return true;
    }

    public KapAddMonths(Expression startDate, Expression numMonths) {
        this.startDate = startDate;
        this.numMonths = numMonths;
        ExpectsInputTypes.$init$((ExpectsInputTypes)this);
    }
}

