/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.v2;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.table.ATable;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.response.AccessEntryResponse;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.OpenAccessGroupResponse;
import org.apache.kylin.rest.response.OpenAccessUserResponse;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.AclTCRService;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.PagingUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/access"}, produces={"application/vnd.apache.kylin-v2+json"})
public class NAccessControllerV2
extends NBasicController {
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    @Qualifier(value="userService")
    protected UserService userService;
    @Autowired
    @Qualifier(value="userGroupService")
    private IUserGroupService userGroupService;
    @Autowired
    @Qualifier(value="aclTCRService")
    private AclTCRService aclTCRService;
    @Autowired
    private AclEvaluate aclEvaluate;
    private static final String PROJECT_NAME = "project_name";
    private static final String TABLE_NAME = "table_name";

    private ManagedUser checkAndGetUser(String userName) {
        if (!this.userService.userExists(userName)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_NOT_EXIST, String.format(Locale.ROOT, "User '%s' does not exists.", userName));
        }
        return (ManagedUser)this.userService.loadUserByUsername(userName);
    }

    @ApiOperation(value="getAllAccessEntitiesOfUser", tags={"MID"})
    @GetMapping(value={"/{userName:.+}"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse getAllAccessEntitiesOfUser(@PathVariable(value="userName") String username) throws IOException {
        this.checkAndGetUser(username);
        ArrayList dataList = new ArrayList();
        List projectList = this.accessService.getGrantedProjectsOfUser(username);
        for (String project : projectList) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(PROJECT_NAME, project);
            List tableList = this.aclTCRService.getAuthorizedTables(project, username).stream().map(ATable::getIdentity).collect(Collectors.toList());
            data.put(TABLE_NAME, tableList);
            dataList.add(data);
        }
        return new EnvelopeResponse("000", dataList, "");
    }

    @ApiOperation(value="getAccessEntities", tags={"MID"})
    @GetMapping(value={"/{type}/{project}"}, produces={"application/vnd.apache.kylin-v2+json"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<Map<String, Object>> getAccessEntities(@PathVariable(value="type") String type, @PathVariable(value="project") String project, @RequestParam(value="name", required=false) String nameSeg, @RequestParam(value="isCaseSensitive", required=false) boolean isCaseSensitive, @RequestParam(value="pageOffset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) throws IOException {
        List<AccessEntryResponse> accessList = this.getAccessList(type, project, nameSeg, isCaseSensitive);
        List sublist = PagingUtil.cutPage(accessList, (int)pageOffset, (int)pageSize);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sids", sublist);
        data.put("size", accessList.size());
        return new EnvelopeResponse("000", data, "");
    }

    @ApiOperation(value="getAllAccessUsers", tags={"MID"})
    @GetMapping(value={"/all/users"}, produces={"application/vnd.apache.kylin-v2+json"})
    @ResponseBody
    public EnvelopeResponse<OpenAccessUserResponse> getAllAccessUsers(@RequestParam(value="project", required=false) String project, @RequestParam(value="userName", required=false) String userName, @RequestParam(value="pageOffset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) throws IOException {
        HashSet users = StringUtils.isNotEmpty((CharSequence)userName) ? Sets.newHashSet((Object[])new ManagedUser[]{this.checkAndGetUser(userName)}) : this.getUsersOfProjects(this.getGrantedProjects(project));
        return new EnvelopeResponse("000", (Object)new OpenAccessUserResponse(PagingUtil.cutPage((List)Lists.newArrayList((Iterable)users), (int)pageOffset, (int)pageSize), users.size()), "");
    }

    @ApiOperation(value="getAllAccessGroups", tags={"MID"})
    @GetMapping(value={"/all/groups"}, produces={"application/vnd.apache.kylin-v2+json"})
    @ResponseBody
    public EnvelopeResponse<OpenAccessGroupResponse> getAllAccessGroups(@RequestParam(value="project", required=false) String project, @RequestParam(value="groupName", required=false) String groupName, @RequestParam(value="pageOffset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) throws IOException {
        ArrayList result = StringUtils.isNotEmpty((CharSequence)groupName) ? Lists.newArrayList((Object[])new Pair[]{Pair.newPair((Object)groupName, (Object)this.userGroupService.getGroupMembersByName(groupName).size())}) : this.getUserGroupsOfProjects(this.getGrantedProjects(project));
        return new EnvelopeResponse("000", (Object)new OpenAccessGroupResponse(PagingUtil.cutPage((List)Lists.newArrayList(result), (int)pageOffset, (int)pageSize), result.size()), "");
    }

    private List<AccessEntryResponse> getAccessList(String type, String projectName, String nameSeg, boolean isCaseSensitive) throws IOException {
        RootPersistentEntity aclEntity = this.accessService.getAclEntity(type, this.getProject(projectName).getUuid());
        return this.accessService.generateAceResponsesByFuzzMatching((AclEntity)aclEntity, nameSeg, isCaseSensitive);
    }

    private List<String> getGrantedProjects(String projectName) {
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        if (StringUtils.isBlank((CharSequence)projectName)) {
            return projectManager.listAllProjects().stream().map(ProjectInstance::getName).filter(name -> this.aclEvaluate.hasProjectAdminPermission(name)).collect(Collectors.toList());
        }
        if (this.aclEvaluate.hasProjectReadPermission(projectManager.getProject(projectName))) {
            return Lists.newArrayList((Object[])new String[]{projectName});
        }
        return Lists.newArrayList();
    }

    private Set<ManagedUser> getUsersOfProjects(List<String> projects) throws IOException {
        HashSet allUsers = Sets.newHashSet();
        for (String projectName : projects) {
            List<AccessEntryResponse> responses = this.getAccessList("ProjectInstance", projectName, null, false);
            allUsers.addAll(responses.stream().filter(response -> response.getSid() instanceof PrincipalSid).map(response -> (ManagedUser)this.userService.loadUserByUsername(((PrincipalSid)response.getSid()).getPrincipal())).collect(Collectors.toSet()));
        }
        return allUsers;
    }

    private List<Pair<String, Integer>> getUserGroupsOfProjects(List<String> projects) throws IOException {
        ArrayList allUserGroups = Lists.newArrayList();
        ArrayList grantedGroups = Lists.newArrayList();
        for (String projectName : projects) {
            List<AccessEntryResponse> responses = this.getAccessList("ProjectInstance", projectName, null, false);
            for (AccessEntryResponse response : responses) {
                String grantedAuthority;
                if (!(response.getSid() instanceof GrantedAuthoritySid) || grantedGroups.contains(grantedAuthority = ((GrantedAuthoritySid)response.getSid()).getGrantedAuthority())) continue;
                grantedGroups.add(grantedAuthority);
                allUserGroups.add(Pair.newPair((Object)grantedAuthority, (Object)this.userGroupService.getGroupMembersByName(grantedAuthority).size()));
            }
        }
        return allUserGroups;
    }
}

