/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.mergetree;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.substrait.proto.NamedStruct;
import io.substrait.proto.Type;
import java.io.Serializable;
import java.util.Map;
import org.apache.gluten.expression.ConverterUtils$;
import org.apache.gluten.substrait.type.TypeNode;
import org.apache.gluten.utils.SubstraitPlanPrinterUtil$;
import org.apache.spark.sql.execution.datasources.mergetree.PartSerializer;
import org.apache.spark.sql.execution.datasources.mergetree.StorageMeta$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public final class MetaSerializer$ {
    public static MetaSerializer$ MODULE$;

    static {
        new MetaSerializer$();
    }

    public String apply(String database, String tableName, String snapshotId, String relativePath, String absolutePath, String orderByKey, String lowCardKey, String minmaxIndexKey, String bfIndexKey, String setIndexKey, String primaryKey, PartSerializer partSerializer, StructType tableSchema, Map<String, String> clickhouseTableConfigs) {
        StringBuilder extensionTableStr = new StringBuilder(StorageMeta$.MODULE$.SERIALIZER_HEADER());
        String tableSchemaJson = this.convertNamedStructJson(tableSchema);
        extensionTableStr.append(database).append("\n").append(tableName).append("\n").append(snapshotId).append("\n").append(tableSchemaJson).append("\n").append(orderByKey).append("\n");
        Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(orderByKey)).nonEmpty());
        String string = orderByKey;
        String string2 = StorageMeta$.MODULE$.DEFAULT_ORDER_BY_KEY();
        StringBuilder stringBuilder = !(string != null ? !string.equals(string2) : string2 != null) ? extensionTableStr.append("").append("\n") : extensionTableStr.append(primaryKey).append("\n");
        extensionTableStr.append(lowCardKey).append("\n");
        extensionTableStr.append(minmaxIndexKey).append("\n");
        extensionTableStr.append(bfIndexKey).append("\n");
        extensionTableStr.append(setIndexKey).append("\n");
        extensionTableStr.append(StorageMeta$.MODULE$.normalizeRelativePath(relativePath)).append("\n");
        extensionTableStr.append(absolutePath).append("\n");
        this.appendConfigs(extensionTableStr, clickhouseTableConfigs);
        extensionTableStr.append(partSerializer.apply());
        return extensionTableStr.toString();
    }

    private void appendConfigs(StringBuilder extensionTableStr, Map<String, String> clickhouseTableConfigs) {
        if (clickhouseTableConfigs != null && !clickhouseTableConfigs.isEmpty()) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                String clickhouseTableConfigsJson = objectMapper.writeValueAsString(clickhouseTableConfigs).replaceAll("\n", "").replaceAll(" ", "");
                extensionTableStr.append(clickhouseTableConfigsJson).append("\n");
            }
            catch (Exception e) {
                extensionTableStr.append("\n");
            }
        } else {
            extensionTableStr.append("\n");
        }
    }

    private String convertNamedStructJson(StructType tableSchema) {
        Type.Struct.Builder structBuilder = Type.Struct.newBuilder();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields())).map((Function1 & Serializable & scala.Serializable)f -> ConverterUtils$.MODULE$.getTypeNode(f.dataType(), f.nullable()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeNode.class))))).foreach((Function1 & Serializable & scala.Serializable)t -> structBuilder.addTypes(t.toProtobuf()));
        NamedStruct.Builder nStructBuilder = NamedStruct.newBuilder();
        nStructBuilder.setStruct(structBuilder.build());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchema.fieldNames())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> nStructBuilder.addNames(x$1));
        return SubstraitPlanPrinterUtil$.MODULE$.substraitNamedStructToJson(nStructBuilder.build()).replaceAll("\n", "").replaceAll(" ", "");
    }

    private MetaSerializer$() {
        MODULE$ = this;
    }
}

