/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import io.netty.util.internal.PlatformDependent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.vectorized.ShuffleInputStream;
import org.apache.spark.network.util.LimitedInputStream;
import org.apache.spark.storage.CHShuffleReadStreamFactory;

public class LowCopyFileSegmentShuffleInputStream
implements ShuffleInputStream {
    private final InputStream in;
    private final FileChannel channel;
    private final boolean isCompressed;
    private long bytesRead = 0L;
    private long left;

    public LowCopyFileSegmentShuffleInputStream(InputStream in, LimitedInputStream limitedInputStream, boolean isCompressed) {
        FileInputStream fin;
        this.in = in;
        this.isCompressed = isCompressed;
        try {
            this.left = (Long)CHShuffleReadStreamFactory.FIELD_LimitedInputStream_left.get(limitedInputStream);
            fin = (FileInputStream)CHShuffleReadStreamFactory.FIELD_FilterInputStream_in.get(limitedInputStream);
        }
        catch (IllegalAccessException e) {
            throw new GlutenException((Throwable)e);
        }
        this.channel = fin.getChannel();
    }

    @Override
    public long read(long destAddress, long maxReadSize) {
        long bytesToRead = Math.min(this.left, maxReadSize);
        int bytesToRead32 = Math.toIntExact(bytesToRead);
        if (bytesToRead32 == 0) {
            return 0L;
        }
        ByteBuffer direct = PlatformDependent.directBuffer((long)destAddress, (int)bytesToRead32);
        try {
            int bytes = this.channel.read(direct);
            if (bytes == -1) {
                return 0L;
            }
            this.bytesRead += (long)bytes;
            this.left -= (long)bytes;
            return bytes;
        }
        catch (IOException e) {
            throw new GlutenException((Throwable)e);
        }
    }

    @Override
    public long pos() {
        return this.bytesRead;
    }

    @Override
    public boolean isCompressed() {
        return this.isCompressed;
    }

    @Override
    public void close() {
        try {
            this.channel.close();
            this.in.close();
        }
        catch (Exception e) {
            throw new GlutenException((Throwable)e);
        }
    }
}

