/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.utils;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.gluten.expression.ExpressionMappings$;
import org.apache.gluten.utils.CHExpressionUtil$;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class ExpressionDocUtil$ {
    public static ExpressionDocUtil$ MODULE$;
    private final String markdownFormat;
    private final Map<String, String> alreadySupported;
    private final java.util.Map<String, List<ExpressionInfo>> groupedExpressions;

    static {
        new ExpressionDocUtil$();
    }

    public String markdownFormat() {
        return this.markdownFormat;
    }

    public Map<String, String> alreadySupported() {
        return this.alreadySupported;
    }

    public java.util.Map<String, List<ExpressionInfo>> groupedExpressions() {
        return this.groupedExpressions;
    }

    public void main(String[] args) {
        ArrayList<String> groupOrdered = new ArrayList<String>(this.groupedExpressions().keySet());
        Collections.sort(groupOrdered);
        StringBuffer content = new StringBuffer();
        StringBuffer summary = new StringBuffer();
        content.append(new StringOps(Predef$.MODULE$.augmentString(this.markdownFormat())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Group", "Expression", "Spark Class Name", "CH Backend", "Examples"})));
        content.append(new StringOps(Predef$.MODULE$.augmentString(this.markdownFormat())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"----", "----", "----", "----", "----"})));
        IntRef total = IntRef.create((int)0);
        IntRef support = IntRef.create((int)0);
        groupOrdered.forEach(name -> {
            IntRef g_total_cnt = IntRef.create((int)0);
            IntRef g_support_cnt = IntRef.create((int)0);
            content.append(new StringOps(Predef$.MODULE$.augmentString(MODULE$.markdownFormat())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, "", "", "", ""})));
            ArrayList<ExpressionInfo> expression_sort = new ArrayList<ExpressionInfo>((Collection)MODULE$.groupedExpressions().get(name));
            expression_sort.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
            expression_sort.forEach(expr -> {
                String support_txt = MODULE$.isSupport((ExpressionInfo)expr);
                ++total$1.elem;
                ++g_total_cnt$1.elem;
                if ("True".equalsIgnoreCase(support_txt)) {
                    ++support$1.elem;
                    ++g_support_cnt$1.elem;
                }
                content.append(new StringOps(Predef$.MODULE$.augmentString(MODULE$.markdownFormat())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"", MODULE$.replaceEnter(expr.getName()), MODULE$.replaceEnter(expr.getClassName()), support_txt, MODULE$.replaceEnter(expr.getExamples())})));
            });
            summary.append(new StringOps(Predef$.MODULE$.augmentString("`%s` total expressions: %d, Supported expression:%d, Supported Rate: %.2f%%\n\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToInteger((int)g_total_cnt.elem), BoxesRunTime.boxToInteger((int)g_support_cnt.elem), BoxesRunTime.boxToDouble((double)((double)g_support_cnt.elem * 100.0 / (double)g_total_cnt.elem))})));
        });
        PrintWriter writer = new PrintWriter(new File("/home/admin123/Documents/work/code/Gluten-Dev/expressions.md"));
        writer.write(new StringOps(Predef$.MODULE$.augmentString("Total expressions: %d, Supported expression:%d, Supported Rate: %.2f%%\n\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)total.elem), BoxesRunTime.boxToInteger((int)support.elem), BoxesRunTime.boxToDouble((double)((double)support.elem * 100.0 / (double)total.elem))})));
        writer.write(summary.toString());
        writer.write("\n\n");
        writer.write(content.toString());
        writer.close();
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> supportExpression() {
        void var1_1;
        HashSet result = new HashSet();
        this.groupedExpressions().forEach((x$2, expressionInfos) -> expressionInfos.forEach(expressionInfo -> {
            block0: {
                if (!"True".equalsIgnoreCase(MODULE$.isSupport((ExpressionInfo)expressionInfo))) break block0;
                result.add(expressionInfo.getClassName());
            }
        }));
        return var1_1;
    }

    public String isSupport(ExpressionInfo expr) {
        String substraitName = (String)this.alreadySupported().getOrElse((Object)expr.getClassName(), (Function0 & Serializable & scala.Serializable)() -> "");
        if (substraitName.isEmpty()) {
            return "False";
        }
        if (expr.getClassName().startsWith("org.apache.spark.sql.catalyst.expressions.aggregate")) {
            if (CHExpressionUtil$.MODULE$.CH_AGGREGATE_FUNC_BLACKLIST().contains((Object)substraitName)) {
                return "False";
            }
        } else {
            Option option = CHExpressionUtil$.MODULE$.CH_BLACKLIST_SCALAR_FUNCTION().get((Object)substraitName);
            if (option instanceof Some) {
                return "False";
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return "True";
    }

    public String replaceEnter(String str) {
        return str.replace("\n", "<br />");
    }

    public static final /* synthetic */ boolean $anonfun$groupedExpressions$1(HashMap groups$1, Tuple2 expression) {
        ExpressionInfo expr;
        Tuple2 tuple2 = (Tuple2)expression._2();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ExpressionInfo expressionInfo = expr = (ExpressionInfo)tuple2._1();
        ExpressionInfo expr2 = expressionInfo;
        return ((List)groups$1.computeIfAbsent(expr2.getGroup(), x$1 -> new ArrayList())).add(expr2);
    }

    /*
     * WARNING - void declaration
     */
    private ExpressionDocUtil$() {
        void var1_1;
        MODULE$ = this;
        this.markdownFormat = "| %s | %s | %s | %s | %s |\n";
        this.alreadySupported = (Map)ExpressionMappings$.MODULE$.expressionsMap().map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)((Class)x._1()).getName(), x._2()), Map$.MODULE$.canBuildFrom());
        HashMap groups = new HashMap();
        FunctionRegistry$.MODULE$.expressions().foreach((Function1 & Serializable & scala.Serializable)expression -> BoxesRunTime.boxToBoolean((boolean)ExpressionDocUtil$.$anonfun$groupedExpressions$1(groups, expression)));
        this.groupedExpressions = var1_1;
    }
}

