/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.metrics;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.gluten.metrics.IMetrics;
import org.apache.gluten.metrics.MetricsData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeMetrics
implements IMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(NativeMetrics.class);
    public List<MetricsData> metricsDataList;
    public String metricsJson;

    public NativeMetrics(String metricsJson) {
        this.metricsJson = metricsJson;
        this.metricsDataList = NativeMetrics.deserializeMetricsJson(this.metricsJson);
    }

    public void setFinalOutputMetrics(long outputRowCount, long outputVectorCount) {
        if (CollectionUtils.isNotEmpty(this.metricsDataList)) {
            int listSize = this.metricsDataList.size();
            this.metricsDataList.get((int)(listSize - 1)).outputVectors = outputVectorCount;
            this.metricsDataList.get((int)(listSize - 1)).outputRows = outputRowCount;
            if (listSize > 2 && this.metricsDataList.get((int)(listSize - 1)).name.equals("kFetch") && this.metricsDataList.get((int)(listSize - 2)).name.equals("kSort")) {
                this.metricsDataList.get((int)(listSize - 3)).outputVectors = outputVectorCount;
                this.metricsDataList.get((int)(listSize - 3)).outputRows = outputRowCount;
            }
        }
    }

    public static List<MetricsData> deserializeMetricsJson(String metricsJson) {
        if (metricsJson != null && !metricsJson.isEmpty()) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                List metricsDataList = (List)mapper.readValue(metricsJson, (TypeReference)new TypeReference<List<MetricsData>>(){});
                Collections.reverse(metricsDataList);
                return metricsDataList;
            }
            catch (Exception e) {
                LOG.error("Deserialize metrics json string error:", (Throwable)e);
                return new ArrayList<MetricsData>();
            }
        }
        return new ArrayList<MetricsData>();
    }
}

