/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.JobErrorCode;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.base.Strings;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.eventbus.Subscribe;
import org.apache.kylin.job.exception.JobSubmissionException;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.manager.JobManager;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.SegmentPartition;
import org.apache.kylin.metadata.cube.optimization.event.BuildIndexEvent;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.ManagementType;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.SegmentStatusEnumToDisplay;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.util.MultiPartitionUtil;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.sourceusage.SourceUsageManager;
import org.apache.kylin.query.util.PushDownUtil;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.request.AddSegmentRequest;
import org.apache.kylin.rest.request.ModelRequest;
import org.apache.kylin.rest.request.PartitionsRefreshRequest;
import org.apache.kylin.rest.request.SegmentTimeRequest;
import org.apache.kylin.rest.response.BuildIndexResponse;
import org.apache.kylin.rest.response.JobInfoResponse;
import org.apache.kylin.rest.response.JobInfoResponseWithFailure;
import org.apache.kylin.rest.service.AbstractModelService;
import org.apache.kylin.rest.service.IndexPlanService;
import org.apache.kylin.rest.service.ModelBuildSupporter;
import org.apache.kylin.rest.service.ModelSemanticHelper;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.params.BasicSegmentParams;
import org.apache.kylin.rest.service.params.FullBuildSegmentParams;
import org.apache.kylin.rest.service.params.IncrementBuildSegmentParams;
import org.apache.kylin.rest.service.params.IndexBuildParams;
import org.apache.kylin.rest.service.params.MergeSegmentParams;
import org.apache.kylin.rest.service.params.RefreshSegmentParams;
import org.apache.kylin.source.SourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="modelBuildService")
public class ModelBuildService
extends AbstractModelService
implements ModelBuildSupporter {
    private static final Logger logger = LoggerFactory.getLogger(ModelBuildService.class);
    @Autowired
    private ModelService modelService;
    @Autowired
    private IndexPlanService indexPlanService;

    public JobInfoResponse buildSegmentsManually(String project, String modelId, String start, String end) throws Exception {
        return this.buildSegmentsManually(project, modelId, start, end, true, Sets.newHashSet(), null);
    }

    public JobInfoResponse buildSegmentsManually(String project, String modelId, String start, String end, boolean needBuild, Set<String> ignoredSnapshotTables, List<String[]> multiPartitionValues) throws Exception {
        return this.buildSegmentsManually(project, modelId, start, end, needBuild, ignoredSnapshotTables, multiPartitionValues, 3, false);
    }

    public JobInfoResponse buildSegmentsManually(String project, String modelId, String start, String end, boolean needBuild, Set<String> ignoredSnapshotTables, List<String[]> multiPartitionValues, int priority, boolean buildAllSubPartitions) throws Exception {
        return this.buildSegmentsManually(project, modelId, start, end, needBuild, ignoredSnapshotTables, multiPartitionValues, priority, buildAllSubPartitions, null, false, null, null);
    }

    public JobInfoResponse buildSegmentsManually(String project, String modelId, String start, String end, boolean needBuild, Set<String> ignoredSnapshotTables, List<String[]> multiPartitionValues, int priority, boolean buildAllSubPartitions, List<Long> batchIndexIds, boolean partialBuild, String yarnQueue, Object tag) throws Exception {
        NDataModel modelDesc = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        if (!modelDesc.isMultiPartitionModel() && !CollectionUtils.isEmpty(multiPartitionValues)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PARTITION_VALUE_NOT_SUPPORT, String.format(Locale.ROOT, MsgPicker.getMsg().getPartitionValueNotSupport(), modelDesc.getAlias()));
        }
        if (PartitionDesc.isEmptyPartitionDesc((PartitionDesc)modelDesc.getPartitionDesc())) {
            return this.fullBuildSegmentsManually(new FullBuildSegmentParams(project, modelId, needBuild).withIgnoredSnapshotTables(ignoredSnapshotTables).withPriority(priority).withPartialBuild(partialBuild).withBatchIndexIds(batchIndexIds).withYarnQueue(yarnQueue).withTag(tag));
        }
        return this.incrementBuildSegmentsManually(((IncrementBuildSegmentParams)((IncrementBuildSegmentParams)new IncrementBuildSegmentParams(project, modelId, start, end, modelDesc.getPartitionDesc(), modelDesc.getMultiPartitionDesc(), Lists.newArrayList(), needBuild, multiPartitionValues).withIgnoredSnapshotTables((Set)ignoredSnapshotTables)).withPriority(priority).withBuildAllSubPartitions(buildAllSubPartitions).withPartialBuild(partialBuild).withBatchIndexIds((List)batchIndexIds)).withYarnQueue(yarnQueue).withTag(tag));
    }

    public JobInfoResponse fullBuildSegmentsManually(FullBuildSegmentParams params) {
        this.aclEvaluate.checkProjectOperationPermission(params.getProject());
        this.checkModelPermission(params.getProject(), params.getModelId());
        this.modelService.checkModelAndIndexManually(params);
        String project = params.getProject();
        String modelId = params.getModelId();
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        if (model.getPartitionDesc() != null && !StringUtils.isEmpty((CharSequence)model.getPartitionDesc().getPartitionDateColumn())) {
            throw new IllegalArgumentException(MsgPicker.getMsg().getCanNotBuildSegment());
        }
        List jobIds = (List)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> this.constructFullBuild(params), (String)params.getProject());
        JobInfoResponse jobInfoResponse = new JobInfoResponse();
        jobInfoResponse.setJobs(jobIds);
        return jobInfoResponse;
    }

    private List<JobInfoResponse.JobInfo> constructFullBuild(FullBuildSegmentParams params) {
        NDataSegment newFullSegment = this.createFullSegment(params);
        String project = params.getProject();
        String modelId = params.getModelId();
        ArrayList res = Lists.newArrayList();
        if (!params.isNeedBuild()) {
            return res;
        }
        if (newFullSegment == null) {
            RefreshSegmentParams refreshSegmentParams = new RefreshSegmentParams(project, modelId, Lists.newArrayList((Object[])new String[]{((NDataSegment)((NDataflowManager)this.getManager(NDataflowManager.class, project)).getDataflow(modelId).getSegments().get(0)).getId()}).toArray(new String[0]), true).withIgnoredSnapshotTables(params.getIgnoredSnapshotTables()).withPriority(params.getPriority()).withPartialBuild(params.isPartialBuild()).withBatchIndexIds(params.getBatchIndexIds()).withYarnQueue(params.getYarnQueue()).withTag(params.getTag());
            res.addAll(this.refreshSegmentById(refreshSegmentParams));
        } else {
            JobParam jobParam = new JobParam(newFullSegment, modelId, ModelBuildService.getUsername()).withIgnoredSnapshotTables(params.getIgnoredSnapshotTables()).withPriority(params.getPriority()).withYarnQueue(params.getYarnQueue()).withTag(params.getTag()).withProject(project);
            this.addJobParamExtParams(jobParam, params);
            String jobId = (String)((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(project, () -> JobManager.getInstance((KylinConfig)this.getConfig(), (String)project).addSegmentJob(jobParam));
            res.add(new JobInfoResponse.JobInfo(JobTypeEnum.INC_BUILD.toString(), jobId));
        }
        return res;
    }

    private NDataSegment createFullSegment(FullBuildSegmentParams params) {
        String project = params.getProject();
        String modelId = params.getModelId();
        boolean needBuild = params.isNeedBuild();
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        NDataflow df = dataflowManager.getDataflow(modelId);
        NDataSegment seg = df.getFirstSegment();
        if (Objects.isNull(seg)) {
            NDataSegment newSegment = this.modelService.appendSegment(new AddSegmentRequest(project, modelId, (SegmentRange)SegmentRange.TimePartitionedSegmentRange.createInfinite(), needBuild ? SegmentStatusEnum.NEW : SegmentStatusEnum.READY, null));
            return newSegment;
        }
        return null;
    }

    private void addJobParamExtParams(JobParam jobParam, BasicSegmentParams params) {
        if (params.isPartialBuild()) {
            jobParam.addExtParams("partialBuild", String.valueOf(params.isPartialBuild()));
        }
        if (CollectionUtils.isNotEmpty(params.getBatchIndexIds())) {
            jobParam.setTargetLayouts((Set)Sets.newHashSet(params.getBatchIndexIds()));
        }
    }

    @Transaction(project=0)
    public List<JobInfoResponse.JobInfo> refreshSegmentById(RefreshSegmentParams params) {
        this.aclEvaluate.checkProjectOperationPermission(params.getProject());
        this.modelService.checkSegmentsExistById(params.getModelId(), params.getProject(), params.getSegmentIds());
        this.modelService.checkSegmentsStatus(params.getModelId(), params.getProject(), params.getSegmentIds(), SegmentStatusEnumToDisplay.LOADING, SegmentStatusEnumToDisplay.REFRESHING, SegmentStatusEnumToDisplay.MERGING, SegmentStatusEnumToDisplay.LOCKED);
        ArrayList<JobInfoResponse.JobInfo> jobIds = new ArrayList<JobInfoResponse.JobInfo>();
        NDataflowManager dfMgr = (NDataflowManager)this.getManager(NDataflowManager.class, params.getProject());
        IndexPlan indexPlan = this.getIndexPlan(params.getModelId(), params.getProject());
        NDataflow df = dfMgr.getDataflow(indexPlan.getUuid());
        ArrayList segments = Lists.newArrayList();
        for (String id : params.getSegmentIds()) {
            NDataSegment segment = df.getSegment(id);
            if (segment == null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, MsgPicker.getMsg().getSegNotFound(), id, df.getModelAlias()));
            }
            NDataSegment seg = this.modelService.refreshSegment(params.getProject(), indexPlan.getUuid(), id);
            seg.setDataflow(df);
            segments.add(seg);
        }
        for (NDataSegment segment : segments) {
            JobParam jobParam = new JobParam(segment, params.getModelId(), ModelBuildService.getUsername()).withIgnoredSnapshotTables(params.getIgnoredSnapshotTables()).withPriority(params.getPriority()).withYarnQueue(params.getYarnQueue()).withTag(params.getTag()).withProject(params.getProject());
            this.addJobParamExtParams(jobParam, params);
            String jobId = (String)((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(params.getProject(), () -> JobManager.getInstance((KylinConfig)this.getConfig(), (String)params.getProject()).refreshSegmentJob(jobParam, params.isRefreshAllLayouts()));
            jobIds.add(new JobInfoResponse.JobInfo(JobTypeEnum.INDEX_REFRESH.toString(), jobId));
        }
        return jobIds;
    }

    public JobInfoResponse incrementBuildSegmentsManually(String project, String modelId, String start, String end, PartitionDesc partitionDesc, List<SegmentTimeRequest> segmentHoles) throws Exception {
        return this.incrementBuildSegmentsManually(new IncrementBuildSegmentParams(project, modelId, start, end, partitionDesc, null, segmentHoles, true, null));
    }

    @Override
    public JobInfoResponse incrementBuildSegmentsManually(IncrementBuildSegmentParams params) throws Exception {
        String project = params.getProject();
        this.aclEvaluate.checkProjectOperationPermission(project);
        this.checkModelPermission(project, params.getModelId());
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        if (PartitionDesc.isEmptyPartitionDesc((PartitionDesc)params.getPartitionDesc())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARTITION_COLUMN, "Partition column is null.'");
        }
        String startFormat = DateFormat.getFormatTimeStamp((String)params.getStart(), (String)params.getPartitionDesc().getPartitionDateFormat()).toString();
        String endFormat = DateFormat.getFormatTimeStamp((String)params.getEnd(), (String)params.getPartitionDesc().getPartitionDateFormat()).toString();
        NDataModel copyModel = modelManager.copyForWrite(modelManager.getDataModelDesc(params.getModelId()));
        copyModel.setPartitionDesc(params.getPartitionDesc());
        if (params.getPartitionDesc() != null && !KylinConfig.getInstanceFromEnv().isUseBigIntAsTimestampForPartitionColumn()) {
            PartitionDesc partitionDesc = params.getPartitionDesc();
            partitionDesc.init(copyModel);
            if (!partitionDesc.checkIntTypeDateFormat()) {
                throw new KylinException((ErrorCodeSupplier)JobErrorCode.JOB_INT_DATE_FORMAT_NOT_MATCH_ERROR, "int/bigint data type only support yyyymm/yyyymmdd format");
            }
        }
        copyModel.init(modelManager.getConfig(), project, modelManager.getCCRelatedModels(copyModel));
        String format = this.modelService.probeDateFormatIfNotExist(project, copyModel);
        IncrementBuildSegmentParams buildSegmentParams = ((IncrementBuildSegmentParams)((IncrementBuildSegmentParams)new IncrementBuildSegmentParams(project, params.getModelId(), startFormat, endFormat, params.getPartitionDesc(), params.getMultiPartitionDesc(), format, params.getSegmentHoles(), params.isNeedBuild(), params.getMultiPartitionValues()).withIgnoredSnapshotTables((Set)params.getIgnoredSnapshotTables())).withPriority(params.getPriority()).withBuildAllSubPartitions(params.isBuildAllSubPartitions()).withPartialBuild(params.isPartialBuild()).withBatchIndexIds((List)params.getBatchIndexIds())).withYarnQueue(params.getYarnQueue()).withTag(params.getTag());
        List jobIds = (List)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            List<JobParam> paramList = this.createSegmentsAndJobParams(buildSegmentParams);
            return this.createJob(paramList);
        }, (String)project);
        JobInfoResponse jobInfoResponse = new JobInfoResponse();
        jobInfoResponse.setJobs(jobIds);
        return jobInfoResponse;
    }

    private List<JobInfoResponse.JobInfo> createJob(List<JobParam> jobParamList) {
        ArrayList res = Lists.newArrayList();
        for (JobParam params : jobParamList) {
            JobInfoResponse.JobInfo jobInfo = params == null ? null : new JobInfoResponse.JobInfo(JobTypeEnum.INC_BUILD.toString(), (String)((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(params.getProject(), () -> JobManager.getInstance((KylinConfig)this.getConfig(), (String)params.getProject()).addSegmentJob(params)));
            res.add(jobInfo);
        }
        return res;
    }

    public List<JobParam> createSegmentsAndJobParams(IncrementBuildSegmentParams params) throws IOException {
        NDataModel modelDesc;
        this.modelService.checkModelAndIndexManually(params);
        if (CollectionUtils.isEmpty(params.getSegmentHoles())) {
            params.setSegmentHoles(Lists.newArrayList());
        }
        if (PartitionDesc.isEmptyPartitionDesc((PartitionDesc)(modelDesc = ((NDataModelManager)this.getManager(NDataModelManager.class, params.getProject())).getDataModelDesc(params.getModelId())).getPartitionDesc()) || !modelDesc.getPartitionDesc().equals((Object)params.getPartitionDesc()) || !ModelSemanticHelper.isMultiPartitionDescSame(modelDesc.getMultiPartitionDesc(), params.getMultiPartitionDesc())) {
            this.aclEvaluate.checkProjectWritePermission(params.getProject());
            ModelRequest request = this.modelService.convertToRequest(modelDesc);
            request.setPartitionDesc(params.getPartitionDesc());
            request.setProject(params.getProject());
            request.setMultiPartitionDesc(params.getMultiPartitionDesc());
            this.modelService.updateDataModelSemantic(params.getProject(), request);
            params.getSegmentHoles().clear();
        }
        ArrayList res = Lists.newArrayListWithCapacity((int)(params.getSegmentHoles().size() + 2));
        List<String[]> allPartitions = null;
        if (modelDesc.isMultiPartitionModel()) {
            allPartitions = modelDesc.getMultiPartitionDesc().getPartitions().stream().map(MultiPartitionDesc.PartitionInfo::getValues).collect(Collectors.toList());
        }
        for (SegmentTimeRequest hole : params.getSegmentHoles()) {
            IncrementBuildSegmentParams relParams = ((IncrementBuildSegmentParams)((IncrementBuildSegmentParams)new IncrementBuildSegmentParams(params.getProject(), params.getModelId(), hole.getStart(), hole.getEnd(), params.getPartitionColFormat(), true, allPartitions).withIgnoredSnapshotTables((Set)params.getIgnoredSnapshotTables())).withPriority(params.getPriority()).withBuildAllSubPartitions(params.isBuildAllSubPartitions()).withPartialBuild(params.isPartialBuild()).withBatchIndexIds((List)params.getBatchIndexIds())).withYarnQueue(params.getYarnQueue()).withTag(params.getTag());
            NDataSegment segment = this.createSegment(relParams);
            res.add(this.createJobParam(relParams, segment));
        }
        IncrementBuildSegmentParams relParams = ((IncrementBuildSegmentParams)((IncrementBuildSegmentParams)new IncrementBuildSegmentParams(params.getProject(), params.getModelId(), params.getStart(), params.getEnd(), params.getPartitionColFormat(), params.isNeedBuild(), params.getMultiPartitionValues()).withIgnoredSnapshotTables((Set)params.getIgnoredSnapshotTables())).withPriority(params.getPriority()).withBuildAllSubPartitions(params.isBuildAllSubPartitions()).withPartialBuild(params.isPartialBuild()).withBatchIndexIds((List)params.getBatchIndexIds())).withYarnQueue(params.getYarnQueue()).withTag(params.getTag());
        NDataSegment segment = this.createSegment(relParams);
        res.add(this.createJobParam(relParams, segment));
        return res;
    }

    public JobParam createJobParam(IncrementBuildSegmentParams params, NDataSegment segment) {
        if (!params.isNeedBuild()) {
            return null;
        }
        String project = params.getProject();
        String modelId = params.getModelId();
        NDataModel dataModel = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        JobParam jobParam = new JobParam(segment, modelId, ModelBuildService.getUsername()).withIgnoredSnapshotTables(params.getIgnoredSnapshotTables()).withPriority(params.getPriority()).withYarnQueue(params.getYarnQueue()).withTag(params.getTag()).withProject(project);
        this.addJobParamExtParams(jobParam, params);
        if (dataModel.isMultiPartitionModel()) {
            NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
            jobParam.setTargetPartitions(model.getMultiPartitionDesc().getPartitionIdsByValues(params.getMultiPartitionValues()));
        }
        return jobParam;
    }

    @Override
    public NDataSegment createSegment(IncrementBuildSegmentParams params) throws IOException {
        String project = params.getProject();
        String modelId = params.getModelId();
        NDataModel modelDescInTransaction = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        TableDesc table = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getTableDesc(modelDescInTransaction.getRootFactTableName());
        if (modelDescInTransaction.getPartitionDesc() == null || StringUtils.isEmpty((CharSequence)modelDescInTransaction.getPartitionDesc().getPartitionDateColumn())) {
            throw new IllegalArgumentException("Can not add a new segment on full build model.");
        }
        Preconditions.checkArgument((!PushDownUtil.needPushdown((String)params.getStart(), (String)params.getEnd()) ? 1 : 0) != 0, (Object)"Load data must set start and end date");
        SegmentRange segmentRangeToBuild = SourceFactory.getSource((ISourceAware)table).getSegmentRange(params.getStart(), params.getEnd());
        List<NDataSegment> overlapSegments = this.modelService.checkSegmentToBuildOverlapsBuilt(project, modelDescInTransaction, (SegmentRange<Long>)segmentRangeToBuild, params.isNeedBuild(), params.getBatchIndexIds());
        this.buildSegmentOverlapExceptionInfo(overlapSegments);
        this.modelService.saveDateFormatIfNotExist(project, modelId, params.getPartitionColFormat());
        this.checkMultiPartitionBuildParam(modelDescInTransaction, params);
        return this.modelService.appendSegment(new AddSegmentRequest(project, modelId, segmentRangeToBuild, params.isNeedBuild() ? SegmentStatusEnum.NEW : SegmentStatusEnum.READY, params.getMultiPartitionValues()));
    }

    @Override
    public JobInfoResponse.JobInfo constructIncrementBuild(IncrementBuildSegmentParams params) {
        String project = params.getProject();
        String modelId = params.getModelId();
        NDataModel modelDescInTransaction = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        TableDesc table = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getTableDesc(modelDescInTransaction.getRootFactTableName());
        SegmentRange segmentRangeToBuild = params.getSpecifiedSegmentRange();
        if (segmentRangeToBuild == null) {
            if (modelDescInTransaction.getPartitionDesc() == null || StringUtils.isEmpty((CharSequence)modelDescInTransaction.getPartitionDesc().getPartitionDateColumn())) {
                throw new IllegalArgumentException("Can not add a new segment on full build model.");
            }
            Preconditions.checkArgument((!PushDownUtil.needPushdown((String)params.getStart(), (String)params.getEnd()) ? 1 : 0) != 0, (Object)"Load data must set start and end date");
            segmentRangeToBuild = SourceFactory.getSource((ISourceAware)table).getSegmentRange(params.getStart(), params.getEnd());
            if (segmentRangeToBuild instanceof SegmentRange.BasicSegmentRange) {
                List<NDataSegment> overlapSegments = this.modelService.checkSegmentToBuildOverlapsBuilt(project, modelDescInTransaction, (SegmentRange<Long>)((SegmentRange.BasicSegmentRange)segmentRangeToBuild), params.isNeedBuild(), params.getBatchIndexIds());
                this.buildSegmentOverlapExceptionInfo(overlapSegments);
            }
        }
        this.modelService.saveDateFormatIfNotExist(project, modelId, params.getPartitionColFormat());
        this.checkMultiPartitionBuildParam(modelDescInTransaction, params);
        NDataSegment newSegment = this.modelService.appendSegment(new AddSegmentRequest(project, modelId, segmentRangeToBuild, params.isNeedBuild() ? SegmentStatusEnum.NEW : SegmentStatusEnum.READY, params.getMultiPartitionValues()));
        if (!params.isNeedBuild()) {
            return null;
        }
        JobParam jobParam = new JobParam(newSegment, modelId, ModelBuildService.getUsername()).withIgnoredSnapshotTables(params.getIgnoredSnapshotTables()).withPriority(params.getPriority()).withYarnQueue(params.getYarnQueue()).withTag(params.getTag());
        this.addJobParamExtParams(jobParam, params);
        if (modelDescInTransaction.isMultiPartitionModel()) {
            NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
            jobParam.setTargetPartitions(model.getMultiPartitionDesc().getPartitionIdsByValues(params.getMultiPartitionValues()));
        }
        return new JobInfoResponse.JobInfo(JobTypeEnum.INC_BUILD.toString(), (String)((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(project, () -> JobManager.getInstance((KylinConfig)this.getConfig(), (String)project).addSegmentJob(jobParam)));
    }

    private void buildSegmentOverlapExceptionInfo(List<NDataSegment> overlapSegments) {
        if (CollectionUtils.isEmpty(overlapSegments)) {
            return;
        }
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        for (NDataSegment seg : overlapSegments) {
            joiner.add(seg.getName());
        }
        throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_BUILD_RANGE_OVERLAP, new Object[]{joiner.toString()});
    }

    public void checkMultiPartitionBuildParam(NDataModel model, IncrementBuildSegmentParams params) {
        if (!model.isMultiPartitionModel()) {
            return;
        }
        if (params.isNeedBuild() && CollectionUtils.isEmpty(params.getMultiPartitionValues())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_MULTI_PARTITION_EMPTY, new Object[0]);
        }
        if (!params.isNeedBuild() && !CollectionUtils.isEmpty(params.getMultiPartitionValues())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_MULTI_PARTITION_ABANDON, new Object[0]);
        }
        for (String[] values : params.getMultiPartitionValues()) {
            if (values.length == model.getMultiPartitionDesc().getColumns().size()) continue;
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_MULTI_PARTITION_ABANDON, new Object[0]);
        }
    }

    public BuildIndexResponse buildIndicesManually(String modelId, String project, int priority, String yarnQueue, Object tag) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        String username = ModelBuildService.getUsername();
        return this.buildIndicesInternal(modelId, project, priority, yarnQueue, tag, username);
    }

    public List<BuildIndexResponse> buildAllIndexPlannerIndicesInternal(String project, int priority, String yarnQueue, Object tag, String username) {
        ArrayList<BuildIndexResponse> jobs = new ArrayList<BuildIndexResponse>();
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)this.getConfig()).getProject(project);
        KylinConfigExt config = projectInstance.getConfig();
        if (config.isSemiAutoMode()) {
            List<NDataModel> indexPlannerModels = NDataModelManager.getInstance((KylinConfig)config, (String)project).listAllModels().stream().filter(model -> this.modelService.isAutoIndexPlanEnabled(project, model.getId())).collect(Collectors.toList());
            logger.info("Prepare to create fill index job on project {} for these {} models :{}", new Object[]{project, indexPlannerModels.size(), indexPlannerModels.stream().map(NDataModel::getAlias).collect(Collectors.joining(","))});
            indexPlannerModels.forEach(model -> {
                try {
                    BuildIndexResponse buildIndexResponse = this.buildIndexPlannerIndicesInternal(model.getId(), project, priority, yarnQueue, tag, username);
                    if (StringUtils.isNotEmpty((CharSequence)buildIndexResponse.getJobId())) {
                        logger.info("Success to create fill index job[{}] on project {} for to index-planner index in model {}", new Object[]{buildIndexResponse.getJobId(), project, model.getAlias()});
                        jobs.add(buildIndexResponse);
                    } else {
                        logger.warn("Due to {}, skip to create fill index job on project {} for to index-planner index in model {}", new Object[]{buildIndexResponse.getType(), project, model.getAlias()});
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to fill data to index-planner index for model {}", (Object)model.getId(), (Object)e);
                }
            });
        }
        return jobs;
    }

    public List<BuildIndexResponse> buildAllIndexPlannerIndicesManually(String project, int priority, String yarnQueue, Object tag) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        String username = ModelBuildService.getUsername();
        return this.buildAllIndexPlannerIndicesInternal(project, priority, yarnQueue, tag, username);
    }

    public BuildIndexResponse buildIndexPlannerIndicesManually(String modelId, String project, int priority, String yarnQueue, Object tag) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        String username = ModelBuildService.getUsername();
        return this.buildIndexPlannerIndicesInternal(modelId, project, priority, yarnQueue, tag, username);
    }

    public BuildIndexResponse buildIndexPlannerIndicesInternal(String modelId, String project, int priority, String yarnQueue, Object tag, String userName) {
        return this.buildIndicesInternal(modelId, project, priority, yarnQueue, tag, userName, true);
    }

    private BuildIndexResponse buildIndicesInternal(String modelId, String project, int priority, String yarnQueue, Object tag, String userName) {
        return this.buildIndicesInternal(modelId, project, priority, yarnQueue, tag, userName, false);
    }

    private BuildIndexResponse buildIndicesInternal(String modelId, String project, int priority, String yarnQueue, Object tag, String userName, boolean isIndexPlanner) {
        NDataModel modelDesc = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        if (ManagementType.MODEL_BASED != modelDesc.getManagementType()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, String.format(Locale.ROOT, MsgPicker.getMsg().getCanNotBuildIndicesManually(), modelDesc.getAlias()));
        }
        NDataflow df = ((NDataflowManager)this.getManager(NDataflowManager.class, project)).getDataflow(modelId);
        Segments segments = df.getSegments();
        if (segments.isEmpty()) {
            return new BuildIndexResponse(BuildIndexResponse.BuildIndexType.NO_SEGMENT);
        }
        JobParam jobParam = new JobParam(modelId, userName).withPriority(priority).withYarnQueue(yarnQueue).withTag(tag);
        if (isIndexPlanner) {
            boolean indexPlanEnabled = this.indexPlanService.checkAutoIndexPlanEnabled(project, modelId);
            jobParam.addExtParams("kylin.planner.autoApproveEnabled", String.valueOf(indexPlanEnabled));
        }
        jobParam.setProject(project);
        String jobId = (String)((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(project, () -> ((JobManager)this.getManager(JobManager.class, project)).addIndexJob(jobParam));
        return new BuildIndexResponse(StringUtils.isBlank((CharSequence)jobId) ? BuildIndexResponse.BuildIndexType.NO_LAYOUT : BuildIndexResponse.BuildIndexType.NORM_BUILD, jobId);
    }

    @Subscribe
    public void buildIndicesManually(BuildIndexEvent event) {
        String project = event.getProject();
        List dataflows = event.getDataflows();
        dataflows.forEach(dataflow -> {
            if (!dataflow.isOnline()) {
                return;
            }
            logger.info("build indexes for model: {} under project: {}", (Object)dataflow.getModelAlias(), (Object)project);
            this.buildIndicesInternal(dataflow.getId(), project, 3, null, null, "System");
        });
    }

    @Transaction(project=0)
    public JobInfoResponse buildSegmentPartitionByValue(String project, String modelId, String segmentId, List<String[]> partitionValues, boolean parallelBuild, boolean buildAllPartitions, int priority, String yarnQueue, Object tag) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        this.checkModelPermission(project, modelId);
        this.modelService.checkSegmentsExistById(modelId, project, new String[]{segmentId});
        this.modelService.checkModelIsMLP(modelId, project);
        List<Object> finalPartitionValues = partitionValues == null ? Lists.newArrayList() : partitionValues;
        NDataflowManager dfm = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        NDataflow df = dfm.getDataflow(modelId);
        NDataSegment segment = df.getSegment(segmentId);
        List duplicatePartitions = segment.findDuplicatePartitions((List)finalPartitionValues);
        if (!duplicatePartitions.isEmpty()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_MULTI_PARTITION_DUPLICATE, new Object[0]);
        }
        if (buildAllPartitions) {
            List oldPartitionIds = segment.getMultiPartitions().stream().map(SegmentPartition::getPartitionId).collect(Collectors.toList());
            NDataModel model = this.modelService.getModelById(modelId, project);
            List oldPartitions = model.getMultiPartitionDesc().getPartitionValuesById(oldPartitionIds);
            List allPartitions = model.getMultiPartitionDesc().getPartitions().stream().map(MultiPartitionDesc.PartitionInfo::getValues).collect(Collectors.toList());
            List diffPartitions = MultiPartitionUtil.findDiffValues(allPartitions, (List)oldPartitions);
            finalPartitionValues.addAll(diffPartitions);
        }
        this.modelService.appendPartitions(project, df.getId(), segment.getId(), (List<String[]>)finalPartitionValues);
        Set targetPartitions = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId).getMultiPartitionDesc().getPartitionIdsByValues((List)finalPartitionValues);
        return this.parallelBuildPartition(parallelBuild, project, modelId, segmentId, targetPartitions, priority, yarnQueue, tag);
    }

    private JobInfoResponse parallelBuildPartition(boolean parallelBuild, String project, String modelId, String segmentId, Set<Long> partitionIds, int priority, String yarnQueue, Object tag) {
        ArrayList jobIds = Lists.newArrayList();
        if (parallelBuild) {
            this.checkConcurrentSubmit(partitionIds.size(), project);
            partitionIds.forEach(partitionId -> {
                JobParam jobParam = new JobParam((Set)Sets.newHashSet((Object[])new String[]{segmentId}), null, modelId, ModelBuildService.getUsername(), (Set)Sets.newHashSet((Object[])new Long[]{partitionId}), null).withPriority(priority).withYarnQueue(yarnQueue).withTag(tag).withProject(project);
                String jobId = (String)((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(project, () -> ((JobManager)this.getManager(JobManager.class, project)).buildPartitionJob(jobParam));
                jobIds.add(jobId);
            });
        } else {
            JobParam jobParam = new JobParam((Set)Sets.newHashSet((Object[])new String[]{segmentId}), null, modelId, ModelBuildService.getUsername(), partitionIds, null).withPriority(priority).withYarnQueue(yarnQueue).withTag(tag).withProject(project);
            String jobId = (String)((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(project, () -> ((JobManager)this.getManager(JobManager.class, project)).buildPartitionJob(jobParam));
            jobIds.add(jobId);
        }
        return JobInfoResponse.of(jobIds, JobTypeEnum.SUB_PARTITION_BUILD.toString());
    }

    private void checkConcurrentSubmit(int partitionSize, String project) {
        int runningJobLimit = this.getMaxConcurrentJobLimitByProject(this.getConfig(), project);
        int submitJobLimit = runningJobLimit * 5;
        if (partitionSize > submitJobLimit) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CONCURRENT_SUBMIT_LIMIT, new Object[]{submitJobLimit});
        }
    }

    public int getMaxConcurrentJobLimitByProject(KylinConfig config, String project) {
        ProjectInstance prjInstance = NProjectManager.getInstance((KylinConfig)config).getProject(project);
        if (Strings.isNullOrEmpty((String)project) || prjInstance == null) {
            return config.getMaxConcurrentJobLimit();
        }
        return prjInstance.getConfig().getMaxConcurrentJobLimit();
    }

    public JobInfoResponse refreshSegmentPartition(PartitionsRefreshRequest param, String modelId) {
        String project = param.getProject();
        this.modelService.checkSegmentsExistById(modelId, project, new String[]{param.getSegmentId()});
        this.modelService.checkModelIsMLP(modelId, project);
        NDataflowManager dfm = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        NDataflow df = dfm.getDataflow(modelId);
        NDataSegment segment = df.getSegment(param.getSegmentId());
        Set partitions = param.getPartitionIds();
        this.aclEvaluate.checkProjectOperationPermission(project);
        this.checkModelPermission(project, modelId);
        if (CollectionUtils.isEmpty(param.getPartitionIds()) && ((partitions = this.modelService.getModelById(modelId, project).getMultiPartitionDesc().getPartitionIdsByValues(param.getSubPartitionValues())).isEmpty() || partitions.size() != param.getSubPartitionValues().size())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_MULTI_PARTITION_ABANDON, new Object[0]);
        }
        Set oldPartitions = segment.getMultiPartitions().stream().map(SegmentPartition::getPartitionId).collect(Collectors.toSet());
        if (!Sets.difference((Set)partitions, oldPartitions).isEmpty()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_MULTI_PARTITION_ABANDON, new Object[0]);
        }
        JobManager jobManager = (JobManager)this.getManager(JobManager.class, project);
        JobParam jobParam = new JobParam((Set)Sets.newHashSet((Object[])new String[]{segment.getId()}), null, modelId, ModelBuildService.getUsername(), partitions, null).withIgnoredSnapshotTables(param.getIgnoredSnapshotTables()).withPriority(param.getPriority()).withYarnQueue(param.getYarnQueue()).withTag(param.getTag()).withProject(project);
        String jobId = (String)((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(project, () -> jobManager.refreshSegmentJob(jobParam));
        return JobInfoResponse.of(Lists.newArrayList((Object[])new String[]{jobId}), JobTypeEnum.SUB_PARTITION_REFRESH.toString());
    }

    @Transaction(project=0)
    public JobInfoResponse.JobInfo mergeSegmentsManually(MergeSegmentParams params) {
        Pair<Long, Long> startAndEnd = this.modelService.checkMergeSegments(params);
        String project = params.getProject();
        String modelId = params.getModelId();
        NDataflowManager dfManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        JobManager jobManager = (JobManager)this.getManager(JobManager.class, project);
        IndexPlan indexPlan = this.getIndexPlan(modelId, project);
        NDataflow df = dfManager.getDataflow(indexPlan.getUuid());
        NDataSegment mergeSeg = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).mergeSegments(df, (SegmentRange)new SegmentRange.TimePartitionedSegmentRange((Long)startAndEnd.getFirst(), (Long)startAndEnd.getSecond()), true);
        JobParam jobParam = new JobParam(mergeSeg, modelId, ModelBuildService.getUsername()).withPriority(params.getPriority()).withYarnQueue(params.getYarnQueue()).withTag(params.getTag()).withProject(project);
        JobInfoResponse.JobInfo result = new JobInfoResponse.JobInfo();
        String jobId = (String)((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(project, () -> jobManager.mergeSegmentJob(jobParam));
        result.setJobName(JobTypeEnum.INDEX_MERGE.toString());
        result.setJobId(jobId);
        return result;
    }

    @Override
    public JobInfoResponseWithFailure addIndexesToSegments(IndexBuildParams params) {
        String project = params.getProject();
        String modelId = params.getModelId();
        List<String> segmentIds = params.getSegmentIds();
        List<Long> indexIds = params.getLayoutIds();
        boolean parallelBuildBySegment = params.isParallelBuildBySegment();
        int priority = params.getPriority();
        boolean partialBuild = params.isPartialBuild();
        String yarnQueue = params.getYarnQueue();
        Object tag = params.getTag();
        this.aclEvaluate.checkProjectOperationPermission(project);
        this.checkModelPermission(project, modelId);
        NDataflowManager dfManger = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        NDataflow dataflow = dfManger.getDataflow(modelId);
        this.modelService.checkSegmentsExistById(modelId, project, segmentIds.toArray(new String[0]));
        if (parallelBuildBySegment) {
            return this.addIndexesToSegmentsParallelly(project, modelId, segmentIds, indexIds, dataflow, priority, yarnQueue, tag);
        }
        JobInfoResponseWithFailure result = new JobInfoResponseWithFailure();
        LinkedList<JobInfoResponse.JobInfo> jobs = new LinkedList<JobInfoResponse.JobInfo>();
        try {
            HashSet targetLayouts = indexIds == null ? null : Sets.newHashSet(indexIds);
            JobParam jobParam = new JobParam((Set)Sets.newHashSet(segmentIds), (Set)targetLayouts, modelId, ModelBuildService.getUsername()).withPriority(priority).withYarnQueue(yarnQueue).withTag(tag).withProject(project);
            if (partialBuild) {
                jobParam.addExtParams("partialBuild", String.valueOf(true));
            }
            String jobId = (String)((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(project, () -> ((JobManager)this.getManager(JobManager.class, project)).addRelatedIndexJob(jobParam));
            jobs.add(new JobInfoResponse.JobInfo(JobTypeEnum.INDEX_BUILD.toString(), jobId));
        }
        catch (JobSubmissionException e) {
            result.addFailedSeg(dataflow, e);
        }
        result.setJobs(jobs);
        return result;
    }

    private JobInfoResponseWithFailure addIndexesToSegmentsParallelly(String project, String modelId, List<String> segmentIds, List<Long> indexIds, NDataflow dataflow, int priority, String yarnQueue, Object tag) {
        JobInfoResponseWithFailure result = new JobInfoResponseWithFailure();
        LinkedList<JobInfoResponse.JobInfo> jobs = new LinkedList<JobInfoResponse.JobInfo>();
        for (String segmentId : segmentIds) {
            try {
                JobParam jobParam = new JobParam((Set)Sets.newHashSet((Object[])new String[]{segmentId}), indexIds == null ? null : new HashSet<Long>(indexIds), modelId, ModelBuildService.getUsername()).withPriority(priority).withYarnQueue(yarnQueue).withTag(tag).withProject(project);
                JobInfoResponse.JobInfo jobInfo = new JobInfoResponse.JobInfo(JobTypeEnum.INDEX_BUILD.toString(), (String)((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(project, () -> ((JobManager)this.getManager(JobManager.class, project)).addRelatedIndexJob(jobParam)));
                jobs.add(jobInfo);
            }
            catch (JobSubmissionException e) {
                result.addFailedSeg(dataflow, e);
            }
        }
        result.setJobs(jobs);
        return result;
    }
}

