/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.OutOfMaxCombinationException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.engine.spark.smarter.IndexDependencyParser;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.common.SegmentUtil;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.manager.JobManager;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataLayoutDetailsManager;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.cube.optimization.FrequencyMap;
import org.apache.kylin.metadata.job.JobTokenItem;
import org.apache.kylin.metadata.job.JobTokenManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.util.ExpandableMeasureUtil;
import org.apache.kylin.metadata.sourceusage.SourceUsageManager;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.model.FuzzyKeySearcher;
import org.apache.kylin.rest.request.AggShardByColumnsRequest;
import org.apache.kylin.rest.request.CreateBaseIndexRequest;
import org.apache.kylin.rest.request.CreateTableIndexRequest;
import org.apache.kylin.rest.request.UpdateRuleBasedCuboidRequest;
import org.apache.kylin.rest.response.AggIndexCombResult;
import org.apache.kylin.rest.response.AggIndexResponse;
import org.apache.kylin.rest.response.AggShardByColumnsResponse;
import org.apache.kylin.rest.response.BuildBaseIndexResponse;
import org.apache.kylin.rest.response.BuildIndexResponse;
import org.apache.kylin.rest.response.DiffRuleBasedIndexResponse;
import org.apache.kylin.rest.response.IndexGraphResponse;
import org.apache.kylin.rest.response.IndexResponse;
import org.apache.kylin.rest.response.IndexStatResponse;
import org.apache.kylin.rest.response.NDataModelResponse;
import org.apache.kylin.rest.response.TableIndexResponse;
import org.apache.kylin.rest.service.BaseIndexUpdateHelper;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.ModelBuildService;
import org.apache.kylin.rest.service.ModelChangeSupporter;
import org.apache.kylin.rest.service.ModelSemanticHelper;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.ModelSmartServiceSupporter;
import org.apache.kylin.rest.service.TableIndexPlanSupporter;
import org.apache.kylin.rest.service.params.IndexPlanParams;
import org.apache.kylin.rest.service.params.PaginationParams;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service(value="indexPlanService")
public class IndexPlanService
extends BasicService
implements TableIndexPlanSupporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexPlanService.class);
    public static final String DATA_SIZE = "data_size";
    public static final Integer ROUTINE_REC = 0;
    private static final Logger logger = LoggerFactory.getLogger(IndexPlanService.class);
    @Autowired(required=false)
    private final List<ModelChangeSupporter> modelChangeSupporters = Lists.newArrayList();
    @Autowired
    private ModelSemanticHelper semanticUpater;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private ModelBuildService modelBuildService;
    @Autowired(required=false)
    private ModelSmartServiceSupporter modelSmartServiceSupporter;
    @Autowired
    private ModelService modelService;

    public void expandIndexPlanRequest(IndexPlan plan, NDataModel model) {
        ExpandableMeasureUtil.expandIndexPlanIndexes((IndexPlan)plan, (NDataModel)model);
    }

    private RuleBasedIndex convertRequestToRuleBasedIndex(UpdateRuleBasedCuboidRequest request) {
        NDataModel model = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)request.getProject()).getDataModelDesc(request.getModelId());
        RuleBasedIndex newRuleBasedCuboid = new RuleBasedIndex();
        BeanUtils.copyProperties((Object)request, (Object)newRuleBasedCuboid);
        ExpandableMeasureUtil.expandRuleBasedIndex((RuleBasedIndex)newRuleBasedCuboid, (NDataModel)model);
        newRuleBasedCuboid.setGlobalDimCap(request.getGlobalDimCap());
        return newRuleBasedCuboid;
    }

    @Transaction(project=0)
    public Pair<IndexPlan, BuildIndexResponse> updateRuleBasedCuboid(String project, UpdateRuleBasedCuboidRequest request) {
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        try {
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)kylinConfig, (String)request.getProject());
            IndexPlan originIndexPlan = this.getIndexPlan(request.getProject(), request.getModelId());
            NDataModel model = modelManager.getDataModelDesc(request.getModelId());
            Preconditions.checkNotNull((Object)model);
            NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
            IndexPlan indexPlan = indexPlanManager.updateIndexPlan(originIndexPlan.getUuid(), copyForWrite -> {
                RuleBasedIndex ruleBasedIndex = this.convertRequestToRuleBasedIndex(request);
                ruleBasedIndex.setLastModifiedTime(System.currentTimeMillis());
                copyForWrite.setRuleBasedIndex(ruleBasedIndex, (Set)Sets.newHashSet(), false, true, request.isRestoreDeletedIndex());
            });
            BuildIndexResponse response = new BuildIndexResponse();
            if (request.isLoadData()) {
                response = this.semanticUpater.handleIndexPlanUpdateRule(request.getProject(), model.getUuid(), originIndexPlan.getRuleBasedIndex(), indexPlan.getRuleBasedIndex(), false);
            }
            this.modelChangeSupporters.forEach(listener -> listener.onUpdate(project, request.getModelId()));
            return new Pair((Object)indexPlan, (Object)response);
        }
        catch (Exception e) {
            logger.error("Update agg index failed...", (Throwable)e);
            throw e;
        }
    }

    @Transaction(project=0)
    public BuildIndexResponse updateTableIndex(String project, CreateTableIndexRequest request) {
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        try {
            IndexPlan indexPlan = this.getIndexPlan(request.getProject(), request.getModelId());
            LayoutEntity layout = this.parseToLayout(project, request, indexPlan.getNextTableIndexId() + 1L);
            for (LayoutEntity cuboidLayout : indexPlan.getAllLayouts()) {
                if (!cuboidLayout.equals((Object)layout) || !cuboidLayout.isManual()) continue;
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_INDEX, MsgPicker.getMsg().getDuplicateLayout());
            }
            if (indexPlan.getLayoutEntity(request.getId()) != null && IndexEntity.isTableIndex((long)request.getId())) {
                this.deleteOrMarkTobeDelete(project, request.getModelId(), Sets.newHashSet((Object[])new Long[]{request.getId()}));
            }
            return this.createTableIndex(project, request);
        }
        catch (Exception e) {
            logger.error("Update table index failed...", (Throwable)e);
            throw e;
        }
    }

    private LayoutEntity parseToLayout(String project, CreateTableIndexRequest request, long layoutId) {
        IndexPlan indexPlan = this.getIndexPlan(request.getProject(), request.getModelId());
        NDataModel model = indexPlan.getModel();
        LayoutEntity newLayout = new LayoutEntity();
        newLayout.setId(layoutId);
        if (Objects.equals(newLayout.getId(), request.getId())) {
            newLayout.setId(newLayout.getId() + 10000L);
        }
        newLayout.setColOrder(this.convertColumn(request.getColOrder(), model));
        int storageType = request.getStorageType();
        if (model.getStorageType().isV3Storage() && request.getStorageType() == 20) {
            storageType = 20;
        }
        newLayout.setStorageType(storageType);
        newLayout.setShardByColumns(this.convertColumn(request.getShardByColumns(), model));
        newLayout.setUpdateTime(System.currentTimeMillis());
        newLayout.setOwner(BasicService.getUsername());
        newLayout.setManual(true);
        newLayout.setIndexRange(request.getIndexRange());
        if (!newLayout.getColOrder().containsAll((Collection)newLayout.getShardByColumns())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SHARD_BY_COLUMN_NOT_IN_INDEX, new Object[0]);
        }
        HashMap layoutOverride = Maps.newHashMap();
        if (request.getLayoutOverrideIndexes() != null) {
            for (Map.Entry<String, String> entry : request.getLayoutOverrideIndexes().entrySet()) {
                layoutOverride.put(model.getColumnIdByColumnName(entry.getKey()), entry.getValue());
            }
        }
        newLayout.setLayoutOverrideIndexes((Map)layoutOverride);
        return newLayout;
    }

    @Transaction(project=0)
    public BuildIndexResponse createTableIndex(String project, CreateTableIndexRequest request) {
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        IndexPlan indexPlan = this.getIndexPlan(request.getProject(), request.getModelId());
        return this.createTableIndex(project, request, indexPlan.getNextTableIndexId() + 1L);
    }

    @Transaction(project=0)
    public BuildIndexResponse createTableIndex(String project, CreateTableIndexRequest request, long layoutId) {
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        LayoutEntity newLayout = this.parseToLayout(project, request, layoutId);
        return this.createTableIndex(project, request.getModelId(), newLayout, request.isLoadData());
    }

    public BuildIndexResponse createTableIndex(String project, String modelId, LayoutEntity newLayout, boolean loadData) {
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(modelId);
        for (LayoutEntity cuboidLayout : indexPlan.getAllLayouts()) {
            if (!cuboidLayout.equals((Object)newLayout) || !cuboidLayout.isManual()) continue;
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.INDEX_DUPLICATE, new Object[0]);
        }
        int layoutIndex = indexPlan.getWhitelistLayouts().indexOf(newLayout);
        if (layoutIndex != -1) {
            indexPlanManager.updateIndexPlan(indexPlan.getUuid(), copyForWrite -> {
                LayoutEntity oldLayout = (LayoutEntity)copyForWrite.getWhitelistLayouts().get(layoutIndex);
                oldLayout.setManual(true);
                oldLayout.setOwner(BasicService.getUsername());
                oldLayout.setUpdateTime(System.currentTimeMillis());
            });
            this.modelChangeSupporters.forEach(listener -> listener.onUpdate(project, modelId));
            return new BuildIndexResponse(BuildIndexResponse.BuildIndexType.NO_LAYOUT);
        }
        indexPlanManager.updateIndexPlan(indexPlan.getUuid(), copyForWrite -> {
            IndexEntity newCuboid = new IndexEntity();
            newCuboid.setId(newLayout.getId() - 1L);
            newCuboid.setDimensions((List)Lists.newArrayList((Iterable)newLayout.getColOrder()));
            newCuboid.setLayouts(Arrays.asList(newLayout));
            newCuboid.setIndexPlan(copyForWrite);
            IndexEntity lookForIndex = (IndexEntity)copyForWrite.getWhiteListIndexesMap().get(newCuboid.createIndexIdentifier());
            if (lookForIndex == null) {
                copyForWrite.getIndexes().add(newCuboid);
            } else {
                IndexEntity realIndex = (IndexEntity)copyForWrite.getIndexes().get(copyForWrite.getIndexes().indexOf(lookForIndex));
                newLayout.setId(realIndex.getId() + realIndex.getNextLayoutOffset());
                realIndex.setNextLayoutOffset((realIndex.getNextLayoutOffset() + 1L) % 10000L);
                realIndex.getLayouts().add(newLayout);
            }
        });
        this.modelChangeSupporters.forEach(listener -> listener.onUpdate(project, modelId));
        if (loadData) {
            NDataflow df = ((NDataflowManager)this.getManager(NDataflowManager.class, project)).getDataflow(modelId);
            Segments readySegs = df.getSegments();
            if (readySegs.isEmpty()) {
                return new BuildIndexResponse(BuildIndexResponse.BuildIndexType.NO_SEGMENT);
            }
            ((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(project, () -> ((JobManager)this.getManager(JobManager.class, project)).addIndexJob(new JobParam(indexPlan.getUuid(), BasicService.getUsername())));
            return new BuildIndexResponse(BuildIndexResponse.BuildIndexType.NORM_BUILD);
        }
        return new BuildIndexResponse();
    }

    @Deprecated
    @Transaction(project=0)
    public void removeTableIndex(String project, String model, long id) {
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)kylinConfig, (String)project);
        IndexPlan indexPlan = this.getIndexPlan(project, model);
        Preconditions.checkState((indexPlan != null ? 1 : 0) != 0);
        if (id < 20000000000L) {
            throw new IllegalStateException("Table Index Id should large than 20000000000");
        }
        LayoutEntity layout = indexPlan.getLayoutEntity(Long.valueOf(id));
        Preconditions.checkNotNull((Object)layout);
        Preconditions.checkState((boolean)layout.isManual());
        indexPlanManager.updateIndexPlan(indexPlan.getUuid(), copyForWrite -> copyForWrite.removeLayouts((Set)Sets.newHashSet((Object[])new Long[]{id}), false, true));
    }

    @Transaction(project=0)
    public void removeIndex(String project, String model, long id) {
        this.removeIndexes(project, model, Collections.singleton(id));
    }

    @Transaction(project=0)
    public void removeIndexes(String project, String modelId, Set<Long> ids) {
        this.removeIndexes(project, modelId, ids, Sets.newHashSet(), Sets.newHashSet());
    }

    @Transaction(project=0)
    public void removeIndexes(String project, String modelId, Set<Long> ids, Set<Integer> invalidDimensions, Set<Integer> invalidMeasures) {
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        if (CollectionUtils.isEmpty(ids)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.LAYOUT_LIST_EMPTY, new Object[0]);
        }
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)kylinConfig, (String)project);
        IndexPlan indexPlan = this.getIndexPlan(project, modelId);
        Preconditions.checkNotNull((Object)indexPlan);
        String notExistsLayoutIds = ids.stream().filter(id -> Objects.isNull(indexPlan.getLayoutEntity(id))).sorted().map(String::valueOf).collect(Collectors.joining(","));
        if (StringUtils.isNotEmpty((CharSequence)notExistsLayoutIds)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.LAYOUT_NOT_EXISTS, new Object[]{notExistsLayoutIds});
        }
        indexPlanManager.updateIndexPlan(indexPlan.getUuid(), copyForWrite -> {
            List ruleLayoutIds = ids.stream().filter(id -> IndexEntity.isAggIndex((long)id) && indexPlan.getLayoutEntity(id).isManual()).collect(Collectors.toList());
            copyForWrite.addRuleBasedBlackList(ruleLayoutIds);
            copyForWrite.removeLayouts(ids, true, true);
            this.removeAggGroup(invalidDimensions, invalidMeasures, copyForWrite);
            copyForWrite.getPlannerWhiteList().removeAll(ids);
        });
        this.modelChangeSupporters.forEach(listener -> listener.onUpdate(project, modelId));
        if (indexPlan.getModel().getStorageType().isV3Storage()) {
            NDataLayoutDetailsManager.getInstance((KylinConfig)this.getConfig(), (String)project).removeDetails(modelId, ids);
        }
    }

    private void removeAggGroup(Set<Integer> invalidDimensions, Set<Integer> invalidMeasures, IndexPlan indexPlan) {
        RuleBasedIndex oldRuleBasedIndex = indexPlan.getRuleBasedIndex();
        if (invalidDimensions.isEmpty() && invalidMeasures.isEmpty() || oldRuleBasedIndex == null) {
            return;
        }
        List reservedAggGroups = oldRuleBasedIndex.getAggregationGroups().stream().filter(aggGroup -> {
            if (!Arrays.stream(aggGroup.getIncludes()).noneMatch(invalidDimensions::contains)) return false;
            if (!Arrays.stream(aggGroup.getMeasures()).noneMatch(invalidMeasures::contains)) return false;
            return true;
        }).collect(Collectors.toList());
        RuleBasedIndex newRuleBasedIndex = RuleBasedIndex.copyAndResetAggGroups((RuleBasedIndex)oldRuleBasedIndex, reservedAggGroups);
        indexPlan.setRuleBasedIndex(newRuleBasedIndex, (Set)Sets.newHashSet(), false, true, false);
    }

    private boolean addIndexToBeDeleted(String project, String modelId, Set<Long> layoutIds) {
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)kylinConfig, (String)project);
        IndexPlan indexPlan = this.getIndexPlan(project, modelId);
        Preconditions.checkNotNull((Object)indexPlan);
        for (Long id : layoutIds) {
            LayoutEntity layout = indexPlan.getLayoutEntity(id);
            Preconditions.checkNotNull((Object)layout);
        }
        indexPlanManager.updateIndexPlan(indexPlan.getUuid(), copyForWrite -> copyForWrite.markWhiteIndexToBeDelete(indexPlan.getUuid(), (Set)Sets.newHashSet((Iterable)layoutIds)));
        return true;
    }

    public DiffRuleBasedIndexResponse calculateDiffRuleBasedIndex(UpdateRuleBasedCuboidRequest request) {
        this.aclEvaluate.checkProjectOperationDesignPermission(request.getProject());
        IndexPlan.UpdateRuleImpact diff = this.getIndexPlan(request.getProject(), request.getModelId()).diffRuleBasedIndex(this.convertRequestToRuleBasedIndex(request));
        return DiffRuleBasedIndexResponse.from(request.getModelId(), diff);
    }

    public AggIndexResponse calculateAggIndexCount(UpdateRuleBasedCuboidRequest request) {
        AggIndexCombResult totalResult;
        this.aclEvaluate.checkProjectOperationDesignPermission(request.getProject());
        long maxCount = this.getConfig().getCubeAggrGroupMaxCombination();
        List<NAggregationGroup> aggregationGroups = request.getAggregationGroups();
        IndexPlan indexPlan = this.getIndexPlan(request.getProject(), request.getModelId()).copy();
        List<NAggregationGroup> aggregationGroupsCopy = aggregationGroups.stream().filter(aggGroup -> aggGroup.getIncludes() != null && aggGroup.getIncludes().length != 0).collect(Collectors.toList());
        request.setAggregationGroups(aggregationGroupsCopy);
        boolean invalid = false;
        try {
            List notExistCols;
            RuleBasedIndex ruleBasedIndex = this.convertRequestToRuleBasedIndex(request);
            NDataModel model = NDataModelManager.getInstance((KylinConfig)this.getConfig(), (String)request.getProject()).getDataModelDesc(indexPlan.getUuid());
            if (CollectionUtils.isNotEmpty((Collection)ruleBasedIndex.getDimensions()) && CollectionUtils.isNotEmpty(notExistCols = ruleBasedIndex.getDimensions().stream().filter(col -> null == model.getEffectiveDimensions() || null == model.getEffectiveDimensions().get(col)).collect(Collectors.toList()))) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EFFECTIVE_DIMENSION_NOT_FIND, String.format(Locale.ROOT, MsgPicker.getMsg().getEffectiveDimensionNotFind(), StringUtils.join(notExistCols.iterator(), (String)",")));
            }
            indexPlan.setRuleBasedIndex(ruleBasedIndex);
        }
        catch (OutOfMaxCombinationException oe) {
            invalid = true;
            log.error("The number of cuboid for the cube exceeds the limit, ", (Throwable)oe);
        }
        catch (IllegalStateException e) {
            log.error(e.getMessage());
        }
        ArrayList aggIndexCounts = Lists.newArrayList();
        for (NAggregationGroup group : aggregationGroups) {
            AggIndexCombResult aggIndexResult;
            if (group.getIncludes() != null && group.getIncludes().length == 0) {
                aggIndexResult = AggIndexCombResult.successResult(0L);
                aggIndexCounts.add(aggIndexResult);
                continue;
            }
            long count = group.calculateCuboidCombination();
            if (count > maxCount) {
                aggIndexResult = AggIndexCombResult.errorResult();
                invalid = true;
            } else {
                aggIndexResult = AggIndexCombResult.successResult(count);
            }
            aggIndexCounts.add(aggIndexResult);
        }
        if (invalid) {
            totalResult = AggIndexCombResult.errorResult();
        } else {
            try {
                long cuboidCount = indexPlan.getRuleBasedIndex().getCuboidScheduler().getCuboidCount();
                totalResult = AggIndexCombResult.successResult(cuboidCount);
            }
            catch (OutOfMaxCombinationException outOfMaxCombinationException) {
                totalResult = AggIndexCombResult.errorResult();
            }
        }
        return new AggIndexResponse(aggIndexCounts, totalResult, this.getConfig().getCubeAggrGroupMaxCombination());
    }

    public void checkIndexCountWithinLimit(UpdateRuleBasedCuboidRequest request) {
        long maxCount = this.getConfig().getCubeAggrGroupMaxCombination();
        List<NAggregationGroup> aggGroups = request.getAggregationGroups();
        IndexPlan indexPlan = this.getIndexPlan(request.getProject(), request.getModelId()).copy();
        List<NAggregationGroup> aggregationGroupsCopy = aggGroups.stream().filter(aggGroup -> aggGroup.getIncludes() != null && aggGroup.getIncludes().length != 0).collect(Collectors.toList());
        request.setAggregationGroups(aggregationGroupsCopy);
        try {
            indexPlan.setRuleBasedIndex(this.convertRequestToRuleBasedIndex(request));
        }
        catch (OutOfMaxCombinationException oe) {
            log.error("The number of cuboid for the cube exceeds the limit, ", (Throwable)oe);
        }
        catch (IllegalStateException e) {
            log.error(e.getMessage());
        }
        for (NAggregationGroup aggGroup2 : aggGroups) {
            long count = aggGroup2.calculateCuboidCombination();
            if (count <= maxCount) continue;
            throw new IllegalArgumentException("The aggregate amount exceeds its limit per aggregate group, please optimize the group setting or reduce dimension amount.");
        }
    }

    @Transaction(project=0)
    public void updateShardByColumns(String project, AggShardByColumnsRequest request) {
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        String modelId = request.getModelId();
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(modelId);
        NDataModel model = indexPlan.getModel();
        Map dimensions = model.getDimensionNameIdMap();
        for (String shardByColumn : request.getShardByColumns()) {
            if (dimensions.containsKey(shardByColumn)) continue;
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, String.format(Locale.ROOT, MsgPicker.getMsg().getColumuIsNotDimension(), shardByColumn));
        }
        indexPlanManager.updateIndexPlan(modelId, copyForWrite -> copyForWrite.setAggShardByColumns(request.getShardByColumns().stream().map(arg_0 -> ((NDataModel)model).getColumnIdByColumnName(arg_0)).collect(Collectors.toList())));
        if (request.isLoadData()) {
            JobManager jobManager = (JobManager)this.getManager(JobManager.class, project);
            ((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(project, () -> jobManager.addIndexJob(new JobParam(modelId, BasicService.getUsername())));
        }
    }

    public AggShardByColumnsResponse getShardByColumns(String project, String modelId) {
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(modelId);
        NDataModel model = indexPlan.getModel();
        AggShardByColumnsResponse result = new AggShardByColumnsResponse();
        result.setModelId(modelId);
        result.setProject(project);
        result.setShardByColumns(indexPlan.getAggShardByColumns().stream().map(arg_0 -> ((NDataModel)model).getColumnNameByColumnId(arg_0)).collect(Collectors.toList()));
        NDataflow df = ((NDataflowManager)this.getManager(NDataflowManager.class, project)).getDataflow(modelId);
        Segments segments = df.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.READY, SegmentStatusEnum.WARNING, SegmentStatusEnum.NEW});
        ExecutableManager executableManager = (ExecutableManager)this.getManager(ExecutableManager.class, project);
        long executablesCount = executableManager.countByModelAndStatus(modelId, ExecutableState::isProgressing, new JobTypeEnum[]{JobTypeEnum.INDEX_BUILD, JobTypeEnum.INC_BUILD, JobTypeEnum.INDEX_REFRESH, JobTypeEnum.INDEX_MERGE});
        if (segments.isEmpty() && executablesCount == 0L) {
            result.setShowLoadData(false);
        }
        return result;
    }

    public List<TableIndexResponse> getTableIndexs(String project, String model) {
        this.aclEvaluate.checkProjectReadPermission(project);
        IndexPlan indexPlan = this.getIndexPlan(project, model);
        Preconditions.checkState((indexPlan != null ? 1 : 0) != 0);
        ArrayList result = Lists.newArrayList();
        for (LayoutEntity cuboidLayout : indexPlan.getAllLayouts()) {
            if (!IndexEntity.isTableIndex((long)cuboidLayout.getId())) continue;
            result.add(this.convertToTableIndexResponse(cuboidLayout, indexPlan.getModel()));
        }
        return result;
    }

    public List<IndexResponse> getIndexesWithRelatedTables(String project, String modelId, String key, List<IndexEntity.Status> status, String orderBy, Boolean desc, List<IndexEntity.Source> sources, List<Long> ids) {
        List<IndexResponse> indexes = this.getIndexes(project, modelId, key, status, orderBy, desc, sources, ids);
        IndexPlan indexPlan = this.getIndexPlan(project, modelId);
        NDataModel model = indexPlan.getModel();
        IndexDependencyParser parser = new IndexDependencyParser(model);
        indexes.forEach(indexResponse -> {
            LayoutEntity layout = indexPlan.getLayoutEntity(indexResponse.getId());
            indexResponse.setRelatedTables(parser.getRelatedTables(layout));
        });
        return indexes;
    }

    public List<IndexResponse> getIndexes(String project, String modelId, String key, List<IndexEntity.Status> status, String orderBy, Boolean desc, List<IndexEntity.Source> sources, List<Long> ids) {
        List<IndexResponse> indexes = this.getIndexes(project, modelId, key, status, orderBy, desc, sources);
        if (CollectionUtils.isEmpty(ids)) {
            return indexes;
        }
        return indexes.stream().filter(index -> ids.contains(index.getId())).collect(Collectors.toList());
    }

    public List<IndexResponse> getIndexes(String project, String modelId, String key, List<IndexEntity.Status> status, String orderBy, Boolean desc, List<IndexEntity.Source> sources) {
        return this.getIndexes(new IndexPlanParams(project, modelId, null, null, sources, status, null), new PaginationParams(null, null, orderBy, desc), key);
    }

    public List<IndexResponse> getIndexes(IndexPlanParams indexPlanParams, PaginationParams paginationParams, String key) {
        String project = indexPlanParams.getProject();
        String modelId = indexPlanParams.getModelId();
        String segmentId = indexPlanParams.getSegmentId();
        List<IndexEntity.Source> sources = indexPlanParams.getSources();
        List<IndexEntity.Status> status = indexPlanParams.getStatus();
        String orderBy = paginationParams.getOrderBy();
        Boolean desc = paginationParams.getReverse();
        this.aclEvaluate.checkProjectReadPermission(project);
        HashSet statusSet = Sets.newHashSet(status);
        IndexPlan indexPlan = this.getIndexPlan(project, modelId);
        Preconditions.checkState((indexPlan != null ? 1 : 0) != 0);
        NDataModel model = indexPlan.getModel();
        List layouts = indexPlan.getAllLayouts();
        Map<String, Set<Long>> layoutsByRunningJobs = this.getLayoutsByRunningJobs(project, modelId);
        if (StringUtils.isBlank((CharSequence)key)) {
            return this.sortAndFilterLayouts(layouts.stream().map(layoutEntity -> this.convertToResponse((LayoutEntity)layoutEntity, indexPlan.getModel(), layoutsByRunningJobs, segmentId)).filter(indexResponse -> statusSet.isEmpty() || statusSet.contains(indexResponse.getStatus())), orderBy, desc, sources);
        }
        Set<String> ccFullNameSet = FuzzyKeySearcher.searchComputedColumns(model, key.trim());
        Set<Integer> matchDimensions = FuzzyKeySearcher.searchDimensions(model, ccFullNameSet, key.trim());
        Set<Integer> matchMeasures = FuzzyKeySearcher.searchMeasures(model, ccFullNameSet, key.trim());
        return this.sortAndFilterLayouts(layouts.stream().filter(index -> {
            HashSet colOrderSet = Sets.newHashSet((Iterable)index.getColOrder());
            return String.valueOf(index.getId()).equals(key.trim()) || !Sets.intersection((Set)matchDimensions, (Set)colOrderSet).isEmpty() || !Sets.intersection((Set)matchMeasures, (Set)colOrderSet).isEmpty();
        }).map(layoutEntity -> this.convertToResponse((LayoutEntity)layoutEntity, indexPlan.getModel(), layoutsByRunningJobs, segmentId)).filter(indexResponse -> statusSet.isEmpty() || statusSet.contains(indexResponse.getStatus())), orderBy, desc, sources);
    }

    public IndexGraphResponse getIndexGraph(String project, String modelId, int maxSize) {
        this.aclEvaluate.checkProjectReadPermission(project);
        IndexPlan indexPlan = this.getIndexPlan(project, modelId);
        Preconditions.checkNotNull((Object)indexPlan);
        List indexes = indexPlan.getAllLayouts();
        List<IndexResponse> indexResponses = this.sortAndFilterLayouts(indexes.stream().map(layoutEntity -> this.convertToResponse((LayoutEntity)layoutEntity, indexPlan.getModel())), DATA_SIZE, true, Lists.newArrayList());
        IndexGraphResponse indexGraphResponse = new IndexGraphResponse();
        indexGraphResponse.setProject(project);
        indexGraphResponse.setModel(modelId);
        indexGraphResponse.setTotalIndexes(indexResponses.size());
        indexGraphResponse.setEmptyIndexes(indexResponses.stream().filter(r -> IndexEntity.Status.NO_BUILD == r.getStatus()).count());
        Function<IndexResponse, IndexGraphResponse.Index> responseConverter = res -> {
            IndexGraphResponse.Index index = new IndexGraphResponse.Index();
            BeanUtils.copyProperties((Object)res, (Object)index);
            return index;
        };
        indexGraphResponse.setAutoAggIndexes(this.convertToIndexList(indexResponses.stream().limit(maxSize).filter(r -> IndexEntity.Source.RECOMMENDED_AGG_INDEX == r.getSource()).map(responseConverter)));
        indexGraphResponse.setManualAggIndexes(this.convertToIndexList(indexResponses.stream().limit(maxSize).filter(r -> IndexEntity.Source.CUSTOM_AGG_INDEX == r.getSource()).map(responseConverter)));
        indexGraphResponse.setAutoTableIndexes(this.convertToIndexList(indexResponses.stream().limit(maxSize).filter(r -> IndexEntity.Source.RECOMMENDED_TABLE_INDEX == r.getSource()).map(responseConverter)));
        indexGraphResponse.setManualTableIndexes(this.convertToIndexList(indexResponses.stream().limit(maxSize).filter(r -> IndexEntity.Source.CUSTOM_TABLE_INDEX == r.getSource()).map(responseConverter)));
        NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)indexPlan.getConfig(), (String)indexPlan.getProject()).getDataflow(indexPlan.getId());
        Segments readySegments = SegmentUtil.getSegmentsExcludeRefreshingAndMerging((Segments)dataflow.getSegments()).stream().collect(Collectors.toCollection(Segments::new));
        long startTime = 0L;
        long endTime = 0L;
        if (!readySegments.isEmpty()) {
            startTime = Long.MAX_VALUE;
            for (NDataSegment seg : readySegments) {
                long start = Long.parseLong(seg.getSegRange().getStart().toString());
                long end = Long.parseLong(seg.getSegRange().getEnd().toString());
                startTime = Math.min(startTime, start);
                endTime = Math.max(endTime, end);
            }
        }
        indexGraphResponse.setStartTime(startTime);
        indexGraphResponse.setEndTime(endTime);
        long segmentToComplementCount = 0L;
        long allIndexCountWithoutTobeDel = indexPlan.getAllLayoutsSize(false);
        for (NDataSegment seg : readySegments) {
            long lockedIndexCountInSeg = seg.getLayoutsMap().values().stream().filter(nDataLayout -> nDataLayout.getLayoutByIndexPlan(indexPlan).isToBeDeleted()).count();
            if ((long)seg.getSegDetails().getAllLayouts().size() - lockedIndexCountInSeg == allIndexCountWithoutTobeDel) continue;
            ++segmentToComplementCount;
        }
        indexGraphResponse.setSegmentToComplementCount(segmentToComplementCount);
        return indexGraphResponse;
    }

    private List<IndexResponse> sortAndFilterLayouts(Stream<IndexResponse> layouts, String orderBy, boolean reverse, List<IndexEntity.Source> sources) {
        if (CollectionUtils.isNotEmpty(sources)) {
            layouts = layouts.filter(r -> sources.contains(r.getSource()));
        }
        Comparator<IndexResponse> comparator = StringUtils.isEmpty((CharSequence)orderBy) ? Comparator.comparingInt(res -> res.getStatus().ordinal()).thenComparing(BasicService.propertyComparator((String)DATA_SIZE, (boolean)true)) : BasicService.propertyComparator((String)orderBy, (!reverse ? 1 : 0) != 0);
        return layouts.sorted(comparator).collect(Collectors.toList());
    }

    private IndexGraphResponse.IndexList convertToIndexList(Stream<IndexGraphResponse.Index> stream) {
        IndexGraphResponse.IndexList indexList = new IndexGraphResponse.IndexList();
        indexList.setIndexes(stream.collect(Collectors.toList()));
        indexList.setTotalSize(indexList.getIndexes().stream().mapToLong(IndexGraphResponse.Index::getDataSize).sum());
        return indexList;
    }

    public RuleBasedIndex getRule(String project, String model) {
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        IndexPlan indexPlan = this.getIndexPlan(project, model);
        Preconditions.checkState((indexPlan != null ? 1 : 0) != 0);
        RuleBasedIndex index = indexPlan.getRuleBasedIndex();
        if (index == null) {
            return null;
        }
        RuleBasedIndex newRuleBasedIndex = new RuleBasedIndex();
        newRuleBasedIndex.setIndexUpdateEnabled(index.getIndexUpdateEnabled());
        newRuleBasedIndex.setAggregationGroups(new LinkedList());
        newRuleBasedIndex.setGlobalDimCap(Integer.valueOf(index.getGlobalDimCap()));
        newRuleBasedIndex.setLastModifiedTime(index.getLastModifiedTime());
        for (NAggregationGroup aggGrp : index.getAggregationGroups()) {
            NAggregationGroup aggGrpCopy = new NAggregationGroup();
            aggGrpCopy.setIncludes(aggGrp.getIncludes());
            aggGrpCopy.setSelectRule(aggGrp.getSelectRule());
            aggGrpCopy.setIndexRange(aggGrp.getIndexRange());
            ArrayList filteredMeasure = Lists.newArrayList((Object[])aggGrp.getMeasures());
            filteredMeasure.removeIf(indexPlan.getModel().getEffectiveInternalMeasureIds()::contains);
            aggGrpCopy.setMeasures(filteredMeasure.toArray(new Integer[0]));
            newRuleBasedIndex.getAggregationGroups().add(aggGrpCopy);
        }
        return newRuleBasedIndex;
    }

    private TableIndexResponse convertToTableIndexResponse(LayoutEntity cuboidLayout, NDataModel model) {
        TableIndexResponse response = new TableIndexResponse();
        BeanUtils.copyProperties((Object)cuboidLayout, (Object)response);
        response.setColOrder(this.convertColumnIdName((List<Integer>)cuboidLayout.getColOrder(), model));
        response.setShardByColumns(this.convertColumnIdName(cuboidLayout.getShardByColumns(), model));
        response.setSortByColumns(this.convertColumnIdName(cuboidLayout.getSortByColumns(), model));
        response.setProject(model.getProject());
        response.setModel(model.getUuid());
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject());
        NDataflow dataflow = dfMgr.getDataflow(cuboidLayout.getIndex().getIndexPlan().getUuid());
        TableIndexResponse.Status status = TableIndexResponse.Status.AVAILABLE;
        int readyCount = 0;
        for (NDataSegment segment : dataflow.getSegments()) {
            NDataLayout dataCuboid = segment.getLayout(cuboidLayout.getId());
            if (dataCuboid == null) continue;
            ++readyCount;
        }
        if (readyCount != dataflow.getSegments().size() || CollectionUtils.isEmpty((Collection)dataflow.getSegments())) {
            status = TableIndexResponse.Status.EMPTY;
        }
        response.setStatus(status);
        response.setUpdateTime(cuboidLayout.getUpdateTime());
        return response;
    }

    public Map<String, Set<Long>> getLayoutsByRunningJobs(String project, String modelId) {
        List runningJobList = ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getPartialExecutablesByStatusList((Set)Sets.newHashSet((Object[])new ExecutableState[]{ExecutableState.READY, ExecutableState.PENDING, ExecutableState.RUNNING, ExecutableState.PAUSED, ExecutableState.ERROR}), modelId);
        HashMap<String, Set<Long>> underConstructionLayoutsMap = new HashMap<String, Set<Long>>();
        runningJobList.stream().filter(ae -> Objects.equals(modelId, ae.getTargetSubject())).forEach(ae -> {
            Set layoutIds = ae.getLayoutIds();
            for (String segmentId : ae.getSegmentIds()) {
                Set segmentLayoutIds = (Set)underConstructionLayoutsMap.get(segmentId);
                if (segmentLayoutIds == null) {
                    underConstructionLayoutsMap.put(segmentId, Sets.newHashSet((Iterable)layoutIds));
                    continue;
                }
                segmentLayoutIds.addAll(layoutIds);
            }
        });
        return underConstructionLayoutsMap;
    }

    private IndexResponse convertToResponse(LayoutEntity layoutEntity, NDataModel model) {
        return this.convertToResponse(layoutEntity, model, Maps.newHashMap(), null);
    }

    private IndexResponse convertToResponse(LayoutEntity layoutEntity, NDataModel model, Map<String, Set<Long>> layoutIdsOfRunningJobs, String segmentId) {
        IndexEntity.Status status;
        ArrayList colOrders = Lists.newArrayList((Iterable)layoutEntity.getColOrder());
        colOrders.removeIf(model.getEffectiveInternalMeasureIds()::contains);
        IndexResponse response = new IndexResponse();
        BeanUtils.copyProperties((Object)layoutEntity, (Object)response);
        response.setColOrder(this.convertColumnOrMeasureIdName(colOrders, model));
        response.setShardByColumns(this.convertColumnIdName(layoutEntity.getShardByColumns(), model));
        response.setSortByColumns(this.convertColumnIdName(layoutEntity.getSortByColumns(), model));
        response.setProject(model.getProject());
        response.setModel(model.getUuid());
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject());
        NDataflow dataflow = dfMgr.getDataflow(layoutEntity.getIndex().getIndexPlan().getUuid());
        long dataSize = 0L;
        int readyCount = 0;
        boolean hasDataInconsistent = false;
        Segments segments = StringUtils.isBlank((CharSequence)segmentId) ? dataflow.getSegments() : dataflow.getSegments().stream().filter(seg -> seg.getId().equals(segmentId)).collect(Collectors.toList());
        HashSet layoutIdsOnLoading = Sets.newHashSet();
        for (NDataSegment segment : segments) {
            NDataLayout layout;
            Set<Long> segmentLayoutIdsOnLoading = layoutIdsOfRunningJobs.get(segment.getId());
            if (CollectionUtils.isNotEmpty(segmentLayoutIdsOnLoading)) {
                layoutIdsOnLoading.addAll(segmentLayoutIdsOnLoading);
            }
            if ((layout = segment.getLayout(layoutEntity.getId(), true)) == null) continue;
            if (layout.getAbnormalType() == NDataLayout.AbnormalType.DATA_INCONSISTENT) {
                hasDataInconsistent = true;
                continue;
            }
            ++readyCount;
            dataSize += layout.getByteSize();
        }
        if (readyCount <= 0) {
            if (layoutIdsOnLoading.contains(layoutEntity.getId())) {
                status = IndexEntity.Status.BUILDING;
            } else {
                status = IndexEntity.Status.NO_BUILD;
                if (hasDataInconsistent) {
                    response.setAbnormalType(NDataLayout.AbnormalType.DATA_INCONSISTENT);
                }
            }
        } else {
            status = IndexEntity.Status.ONLINE;
        }
        if (layoutEntity.isToBeDeleted()) {
            status = IndexEntity.Status.LOCKED;
        }
        response.setNeedUpdate(this.needUpdateLayout(model, layoutEntity));
        response.setStatus(status);
        response.setDataSize(dataSize);
        response.setLastModified(layoutEntity.getUpdateTime());
        if (dataflow.getLayoutHitCount().get(layoutEntity.getId()) != null) {
            response.setUsage(((FrequencyMap)dataflow.getLayoutHitCount().get(layoutEntity.getId())).getDateFrequency().values().stream().mapToInt(Integer::intValue).sum());
        }
        response.setStorageType(layoutEntity.getStorageType());
        return response;
    }

    private boolean needUpdateLayout(NDataModel model, LayoutEntity layoutEntity) {
        IndexPlan indexPlan = this.getIndexPlan(model.getProject(), model.getId());
        if (layoutEntity.isBase()) {
            if (IndexEntity.isAggIndex((long)layoutEntity.getId())) {
                return indexPlan.needUpdateBaseAggLayout(indexPlan.createBaseAggIndex(model), true);
            }
            return indexPlan.needUpdateBaseTableLayout(indexPlan.createBaseTableIndex(model), true);
        }
        return false;
    }

    private IndexPlan getIndexPlan(String project, String model) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)kylinConfig, (String)project);
        return indexPlanManager.getIndexPlan(model);
    }

    private List<String> convertColumnIdName(List<Integer> ids, NDataModel model) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        for (Integer columnId : ids) {
            String name = columnId < 100000 ? model.getColumnNameByColumnId(columnId.intValue()) : model.getMeasureNameByMeasureId(columnId.intValue());
            result.add(name);
        }
        return result;
    }

    private List<IndexResponse.ColOrderPair> convertColumnOrMeasureIdName(List<Integer> ids, NDataModel model) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        NTableMetadataManager tableMetadata = NTableMetadataManager.getInstance((KylinConfig)this.getConfig(), (String)model.getProject());
        ArrayList result = Lists.newArrayList();
        for (Integer id : ids) {
            if (id < 100000) {
                String columnName = model.getColumnNameByColumnId(id.intValue());
                if (columnName == null) {
                    result.add(new IndexResponse.ColOrderPair(id + "", "column", null));
                    continue;
                }
                TblColRef colRef = model.findColumnByAlias(columnName);
                TableExtDesc tableExt = tableMetadata.getTableExtIfExists(colRef.getTableRef().getTableDesc());
                TableExtDesc.ColumnStats columnStats = Objects.isNull(tableExt) ? null : tableExt.getColumnStatsByName(colRef.getName());
                result.add(new IndexResponse.ColOrderPair(columnName, "column", Objects.isNull(columnStats) ? null : Long.valueOf(columnStats.getCardinality())));
                continue;
            }
            result.add(new IndexResponse.ColOrderPair(model.getMeasureNameByMeasureId(id.intValue()), "measure"));
        }
        return result;
    }

    private List<Integer> convertColumn(List<String> columns, NDataModel model) {
        if (CollectionUtils.isEmpty(columns)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        for (String column : columns) {
            int id = model.getColumnIdByColumnName(column);
            result.add(id);
        }
        return result;
    }

    public void reloadLayouts(String project, String modelId, Set<Long> changedLayouts) {
        ((NIndexPlanManager)this.getManager(NIndexPlanManager.class, project)).updateIndexPlan(modelId, copy -> {
            Set indexes = changedLayouts.stream().map(layout -> layout / 10000L * 10000L).collect(Collectors.toSet());
            RuleBasedIndex originAgg = (RuleBasedIndex)JsonUtil.deepCopyQuietly((Object)copy.getRuleBasedIndex(), RuleBasedIndex.class);
            Set reloadLayouts = copy.getRuleBaseLayouts().stream().filter(l -> changedLayouts.contains(l.getId())).collect(Collectors.toSet());
            copy.addRuleBasedBlackList((Collection)reloadLayouts.stream().map(LayoutEntity::getId).collect(Collectors.toList()));
            List changedIndexes = copy.getIndexes().stream().filter(i -> indexes.contains(i.getId())).collect(Collectors.toList());
            copy.setIndexes(copy.getIndexes().stream().filter(i -> !indexes.contains(i.getId())).collect(Collectors.toList()));
            long nextAggIndexId = copy.getNextAggregationIndexId();
            long nextTableIndexId = copy.getNextTableIndexId();
            for (IndexEntity indexEntity : changedIndexes) {
                long nextLayoutOffset = 1L;
                long nextIndexId = indexEntity.isTableIndex() ? nextTableIndexId : nextAggIndexId;
                indexEntity.setId(nextIndexId);
                if (indexEntity.isTableIndex()) {
                    nextTableIndexId = nextIndexId + 10000L;
                } else {
                    nextAggIndexId = nextIndexId + 10000L;
                }
                for (LayoutEntity layoutEntity : indexEntity.getLayouts()) {
                    layoutEntity.setId(indexEntity.getId() + nextLayoutOffset++);
                }
                indexEntity.setNextLayoutOffset(nextLayoutOffset);
            }
            List indexList = copy.getIndexes();
            indexList.addAll(changedIndexes);
            copy.setIndexes(indexList);
            if (originAgg != null) {
                RuleBasedIndex updatedAgg = new RuleBasedIndex();
                updatedAgg.setAggregationGroups(originAgg.getAggregationGroups());
                updatedAgg.setGlobalDimCap(Integer.valueOf(originAgg.getGlobalDimCap()));
                updatedAgg.setDimensions(originAgg.getDimensions());
                updatedAgg.setLastModifiedTime(System.currentTimeMillis());
                copy.setRuleBasedIndex(updatedAgg, reloadLayouts, false, false, false);
            }
            copy.removeLayouts(changedLayouts, true, true);
        });
    }

    public void updateForMeasureChange(String project, String modelId, Set<Integer> invalidMeasures, Map<Integer, Integer> replacedMeasure) {
        if (((NIndexPlanManager)this.getManager(NIndexPlanManager.class, project)).getIndexPlan(modelId).getRuleBasedIndex() == null) {
            return;
        }
        ((NIndexPlanManager)this.getManager(NIndexPlanManager.class, project)).updateIndexPlan(modelId, copy -> {
            RuleBasedIndex copyRuleBaseIndex = (RuleBasedIndex)JsonUtil.deepCopyQuietly((Object)copy.getRuleBasedIndex(), RuleBasedIndex.class);
            ListIterator measureItr = copyRuleBaseIndex.getMeasures().listIterator();
            while (measureItr.hasNext()) {
                Integer measureId = (Integer)measureItr.next();
                if (invalidMeasures.contains(measureId)) {
                    measureItr.remove();
                    continue;
                }
                if (replacedMeasure.get(measureId) == null) continue;
                measureItr.set(replacedMeasure.get(measureId));
            }
            ListIterator aggGroupItr = copyRuleBaseIndex.getAggregationGroups().listIterator();
            while (aggGroupItr.hasNext()) {
                NAggregationGroup aggGroup = (NAggregationGroup)aggGroupItr.next();
                Integer[] aggGroupMeasures = aggGroup.getMeasures();
                for (int i = 0; i < aggGroupMeasures.length; ++i) {
                    if (replacedMeasure.get(aggGroupMeasures[i]) != null) {
                        aggGroupMeasures[i] = (Integer)replacedMeasure.get(aggGroupMeasures[i]);
                        continue;
                    }
                    if (!invalidMeasures.contains(aggGroupMeasures[i])) continue;
                    aggGroupItr.remove();
                }
            }
            if (invalidMeasures.size() > 0 && copyRuleBaseIndex.getAggregationGroups().size() == 0) {
                copyRuleBaseIndex.setDimensions(new ArrayList());
            }
            copy.setRuleBasedIndex(copyRuleBaseIndex);
        });
    }

    @Transaction(project=0)
    public void clearShardColIfNotDim(String project, String modelId) {
        this.aclEvaluate.checkProjectWritePermission(project);
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(modelId);
        ImmutableBiMap dimensions = indexPlan.getModel().getEffectiveDimensions();
        List oldShardCols = indexPlan.getAggShardByColumns();
        List effectiveShardCol = oldShardCols.stream().filter(arg_0 -> ((ImmutableBiMap)dimensions).containsKey(arg_0)).collect(Collectors.toList());
        if (effectiveShardCol.size() < oldShardCols.size()) {
            indexPlanManager.updateIndexPlan(modelId, copyForWrite -> copyForWrite.setAggShardByColumns(effectiveShardCol));
        }
    }

    @Transaction(project=0)
    public BuildBaseIndexResponse updateBaseIndex(String project, CreateBaseIndexRequest request, boolean createIfNotExist) {
        return this.updateBaseIndex(project, request, createIfNotExist, createIfNotExist, false);
    }

    @Transaction(project=0)
    public BuildBaseIndexResponse updateBaseIndex(String project, CreateBaseIndexRequest request, boolean createIfNotExistTableLayout, boolean createIfNotExistAggLayout, boolean isAuto) {
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        return this.updateBaseIndexInternal(project, request, createIfNotExistTableLayout, createIfNotExistAggLayout, isAuto);
    }

    @Transaction(project=0)
    public BuildBaseIndexResponse updateBaseIndexInternal(String project, CreateBaseIndexRequest request, boolean createIfNotExistTableLayout, boolean createIfNotExistAggLayout, boolean isAuto) {
        Set<Long> needDelete = this.checkNeedUpdateBaseIndex(project, request, isAuto);
        List<LayoutEntity> needRetainAggLayout = this.getNeedRetainAggLayout(project, request, needDelete);
        this.deleteOrMarkTobeDelete(project, request.getModelId(), needDelete);
        this.removeFromBlackList(project, request, needDelete, needRetainAggLayout);
        if (createIfNotExistAggLayout) {
            request.getSourceTypes().add(IndexEntity.Source.BASE_AGG_INDEX);
        }
        if (createIfNotExistTableLayout) {
            request.getSourceTypes().add(IndexEntity.Source.BASE_TABLE_INDEX);
        }
        if (request.getSourceTypes().isEmpty()) {
            return BuildBaseIndexResponse.EMPTY;
        }
        BuildBaseIndexResponse response = this.createBaseIndexInternal(project, request);
        response.setIndexUpdateType(needDelete);
        return response;
    }

    private List<LayoutEntity> getNeedRetainAggLayout(String project, CreateBaseIndexRequest request, Set<Long> needDelete) {
        if (CollectionUtils.isEmpty(needDelete)) {
            return Collections.emptyList();
        }
        String modelId = request.getModelId();
        IndexPlan indexPlan = this.getIndexPlan(project, modelId);
        LayoutEntity baseAggLayout = indexPlan.getBaseAggLayout();
        if (baseAggLayout != null) {
            long baseLaoutId = baseAggLayout.getId();
            if (indexPlan.getRuleBaseLayouts().contains(indexPlan.getBaseAggLayout()) && needDelete.contains(baseLaoutId)) {
                return indexPlan.getRuleBaseLayouts().stream().filter(r -> r.getId() == baseLaoutId).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    @Transaction(project=0)
    private void removeFromBlackList(String project, CreateBaseIndexRequest request, Set<Long> needDelete, List<LayoutEntity> needRetainAggLayout) {
        if (CollectionUtils.isEmpty(needRetainAggLayout)) {
            return;
        }
        String modelId = request.getModelId();
        IndexPlan indexPlan = this.getIndexPlan(project, modelId);
        HashSet layoutIdMapping = new HashSet(indexPlan.getRuleBasedIndex().getLayoutIdMapping());
        List retainLayout = needRetainAggLayout.stream().filter(l -> layoutIdMapping.contains(l.getId()) && needDelete.contains(l.getId())).collect(Collectors.toList());
        Set retainLayoutIds = retainLayout.stream().map(LayoutEntity::getId).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(retainLayout)) {
            NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
            indexPlanManager.updateIndexPlan(indexPlan.getUuid(), copyForWrite -> {
                copyForWrite.getRuleBasedIndex().getLayoutBlackList().removeAll(retainLayoutIds);
                copyForWrite.getRuleBaseLayouts().addAll(retainLayout);
            });
        }
    }

    private Set<Long> checkNeedUpdateBaseIndex(String project, CreateBaseIndexRequest request, boolean isAuto) {
        LayoutEntity baseTablelayout;
        String modelId = request.getModelId();
        IndexPlan indexPlan = this.getIndexPlan(project, modelId);
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(request.getModelId());
        HashSet needDelete = Sets.newHashSet();
        HashSet updateTypes = Sets.newHashSet();
        LayoutEntity baseAggLayout = indexPlan.createBaseAggIndex(model);
        this.overrideLayout(baseAggLayout, request.getBaseAggIndexProperty(), model);
        if (request.needHandleBaseAggIndex() && indexPlan.needUpdateBaseAggLayout(baseAggLayout, isAuto)) {
            needDelete.add(indexPlan.getBaseAggLayoutId());
            updateTypes.add(IndexEntity.Source.BASE_AGG_INDEX);
        }
        if ((baseTablelayout = indexPlan.createBaseTableIndex(model)) != null) {
            this.overrideLayout(baseTablelayout, request.getBaseTableIndexProperty(), model);
            if (request.needHandleBaseTableIndex() && indexPlan.needUpdateBaseTableLayout(baseTablelayout, isAuto)) {
                needDelete.add(indexPlan.getBaseTableLayoutId());
                updateTypes.add(IndexEntity.Source.BASE_TABLE_INDEX);
            }
        } else if (indexPlan.containBaseTableLayout()) {
            needDelete.add(indexPlan.getBaseTableLayoutId());
        }
        request.setSourceTypes(updateTypes);
        return needDelete;
    }

    private void deleteOrMarkTobeDelete(String project, String modelId, Set<Long> needDelete) {
        if (CollectionUtils.isEmpty(needDelete)) {
            return;
        }
        NDataflow df = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getDataflow(modelId);
        Segments readySegs = df.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.READY, SegmentStatusEnum.WARNING});
        if (readySegs.isEmpty()) {
            this.removeIndexes(project, modelId, needDelete);
        } else {
            Set effectiveLayouts = readySegs.stream().flatMap(seg -> seg.getLayoutIds().stream()).collect(Collectors.toSet());
            for (long layoutId : needDelete) {
                if (!effectiveLayouts.contains(layoutId)) {
                    this.removeIndex(project, modelId, layoutId);
                    continue;
                }
                this.addIndexToBeDeleted(project, modelId, Sets.newHashSet((Object[])new Long[]{layoutId}));
            }
        }
    }

    @Transaction(project=0)
    public BuildBaseIndexResponse createBaseIndex(String project, CreateBaseIndexRequest request) {
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        return this.createBaseIndexInternal(project, request);
    }

    public BuildBaseIndexResponse createBaseIndexInternal(String project, CreateBaseIndexRequest request) {
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(request.getModelId());
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(request.getModelId());
        List<LayoutEntity> needCreateBaseLayouts = this.getNotCreateBaseLayout(model, indexPlan, request);
        indexPlanManager.updateIndexPlan(indexPlan.getUuid(), copyForWrite -> copyForWrite.createAndAddBaseIndex(needCreateBaseLayouts));
        BuildBaseIndexResponse response = new BuildBaseIndexResponse();
        for (LayoutEntity layoutEntity : needCreateBaseLayouts) {
            response.addLayout(layoutEntity);
        }
        this.modelChangeSupporters.forEach(listener -> listener.onUpdate(project, request.getModelId()));
        return response;
    }

    private List<LayoutEntity> getNotCreateBaseLayout(NDataModel model, IndexPlan indexPlan, CreateBaseIndexRequest request) {
        LayoutEntity baseTableLayout;
        ArrayList needCreateBaseLayouts = Lists.newArrayList();
        if (request.needHandleBaseAggIndex() && !indexPlan.containBaseAggLayout()) {
            LayoutEntity baseAggLayout = indexPlan.createBaseAggIndex(model);
            this.overrideLayout(baseAggLayout, request.getBaseAggIndexProperty(), model);
            needCreateBaseLayouts.add(baseAggLayout);
        }
        if (request.needHandleBaseTableIndex() && !indexPlan.containBaseTableLayout() && (baseTableLayout = indexPlan.createBaseTableIndex(model)) != null) {
            this.overrideLayout(baseTableLayout, request.getBaseTableIndexProperty(), model);
            needCreateBaseLayouts.add(baseTableLayout);
        }
        return needCreateBaseLayouts;
    }

    private void overrideLayout(LayoutEntity layout, CreateBaseIndexRequest.LayoutProperty layoutProperty, NDataModel model) {
        layout.setOwner(SecurityContextHolder.getContext() == null ? "System" : IndexPlanService.getUsername());
        if (layoutProperty == null) {
            return;
        }
        if (!layoutProperty.getColOrder().isEmpty()) {
            List<Integer> overrideColOrder = this.convertColumn(layoutProperty.getColOrder(), model);
            ImmutableList dimsIds = layout.getDimsIds();
            if (this.checkColsMatch((List<Integer>)dimsIds, overrideColOrder)) {
                layout.setColOrder((List)ImmutableList.builder().addAll(overrideColOrder).addAll((Iterable)layout.getMeasureIds()).build());
            } else {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "col order %s doesn't match current base layout %s ", layoutProperty.getColOrder(), layout.getColOrder()));
            }
        }
        if (!CollectionUtils.isEmpty(layoutProperty.getShardByColumns())) {
            layout.setShardByColumns(this.convertColumn(layoutProperty.getShardByColumns(), model));
        }
    }

    private boolean checkColsMatch(List<Integer> colOrder, List<Integer> overrideColOrder) {
        if (colOrder.size() == overrideColOrder.size()) {
            ArrayList colOrder1 = Lists.newArrayList(colOrder);
            ArrayList colOrder2 = Lists.newArrayList(overrideColOrder);
            colOrder1.sort(Integer::compareTo);
            colOrder2.sort(Integer::compareTo);
            return colOrder1.equals(colOrder2);
        }
        return false;
    }

    public IndexStatResponse getStat(String project, String modelId) {
        List<IndexResponse> results = this.getIndexes(project, modelId, "", Lists.newArrayList(), null, false, Lists.newArrayList(), Lists.newArrayList());
        IndexPlan indexPlan = this.getIndexPlan(project, modelId);
        IndexStatResponse response = IndexStatResponse.from(results);
        if (!indexPlan.containBaseAggLayout()) {
            response.setNeedCreateBaseAggIndex(true);
        }
        if (!indexPlan.containBaseTableLayout() && indexPlan.createBaseTableIndex() != null) {
            response.setNeedCreateBaseTableIndex(true);
        }
        return response;
    }

    public void checkPartitionDimensionForV3Storage(String project, String modelId, KylinConfig config) {
        NDataModel model = NDataModelManager.getInstance((KylinConfig)config, (String)project).getDataModelDesc(modelId);
        if (model.getStorageType().isV3Storage() && model.isIncrementBuildOnExpertMode()) {
            NIndexPlanManager.getInstance((KylinConfig)this.getConfig(), (String)project).updateIndexPlan(modelId, indexPlan -> {
                Integer partitionColumnId = model.getPartitionColumnId();
                RuleBasedIndex ruleBasedIndex = indexPlan.getRuleBasedIndex();
                if (ruleBasedIndex != null) {
                    this.updateAggregationGroups(ruleBasedIndex, partitionColumnId);
                    indexPlan.getRuleBasedIndex().setLayoutIdMapping((List)Lists.newArrayList());
                }
                indexPlan.setRuleBasedIndex(ruleBasedIndex);
                this.updateIndexPlan(indexPlan, partitionColumnId);
            });
        }
    }

    private void updateAggregationGroups(RuleBasedIndex ruleBasedIndex, Integer partitionColumnId) {
        ruleBasedIndex.getAggregationGroups().forEach(nAggregationGroup -> {
            if (!Lists.newArrayList((Object[])nAggregationGroup.getIncludes()).contains(partitionColumnId)) {
                this.updateIncludes((NAggregationGroup)nAggregationGroup, partitionColumnId);
                this.updateMandatoryDims((NAggregationGroup)nAggregationGroup, partitionColumnId);
            }
        });
    }

    private void updateIncludes(NAggregationGroup nAggregationGroup, Integer partitionColumnId) {
        Integer[] newIncludes = new Integer[nAggregationGroup.getIncludes().length + 1];
        newIncludes[0] = partitionColumnId;
        System.arraycopy(nAggregationGroup.getIncludes(), 0, newIncludes, 1, nAggregationGroup.getIncludes().length);
        nAggregationGroup.setIncludes(newIncludes);
    }

    private void updateMandatoryDims(NAggregationGroup nAggregationGroup, Integer partitionColumnId) {
        Integer[] mandatoryDims = new Integer[nAggregationGroup.getSelectRule().mandatoryDims.length + 1];
        mandatoryDims[0] = partitionColumnId;
        System.arraycopy(nAggregationGroup.getSelectRule().mandatoryDims, 0, mandatoryDims, 1, nAggregationGroup.getSelectRule().mandatoryDims.length);
        nAggregationGroup.getSelectRule().setMandatoryDims(mandatoryDims);
    }

    private void updateIndexPlan(IndexPlan indexPlan, Integer partitionColumnId) {
        List indexBitSet = indexPlan.getAllIndexes().stream().map(index -> index.getDimensionBitset().or(index.getMeasureBitset())).collect(Collectors.toList());
        List indexEntities = indexPlan.getIndexes().stream().map(index -> {
            if (!index.getDimensions().contains(partitionColumnId)) {
                if (indexBitSet.contains(index.getDimensionBitset().or(index.getMeasureBitset()))) {
                    return null;
                }
                this.updateIndex((IndexEntity)index, partitionColumnId);
            }
            return index;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        indexPlan.setIndexes(indexEntities);
    }

    private void updateIndex(IndexEntity index, Integer partitionColumnId) {
        index.getDimensions().add(0, partitionColumnId);
        index.getLayouts().stream().forEach(layoutEntity -> {
            ArrayList newColOrder = Lists.newArrayList((Object[])new Integer[]{partitionColumnId});
            newColOrder.addAll(layoutEntity.getColOrder());
            layoutEntity.setColOrder((List)newColOrder);
        });
    }

    public void onReloadLayouts(String project, String modelId, Set<Long> changedLayouts) {
        this.reloadLayouts(project, modelId, changedLayouts);
    }

    public void onUpdateBaseIndex(Object indexUpdateHelper) {
        BaseIndexUpdateHelper baseIndexUpdater = (BaseIndexUpdateHelper)indexUpdateHelper;
        baseIndexUpdater.update(this);
    }

    public Object getIndexUpdateHelper(NDataModel model, boolean createIfNotExist) {
        return new BaseIndexUpdateHelper(model, false);
    }

    public List<String> optIndexPlan(String modelId, Integer instantInitIndexNum, String project, int priority, String yarnQueue, Object tag, Long start, Long end) {
        this.aclEvaluate.checkProjectWritePermission(project);
        if (!this.checkAutoIndexPlanEnabled(project, modelId)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.AUTO_INDEX_PLAN_NOT_ENABLED, MsgPicker.getMsg().getAutoIndexPlanNotEnabled());
        }
        ArrayList jobIds = Lists.newArrayList();
        if (Objects.isNull(start) || Objects.isNull(end)) {
            start = 0L;
            end = 0x7FFFFFFFFFFFFFFEL;
        }
        JobParam jobParam = new JobParam(modelId, IndexPlanService.getUsername()).withProject(project).withYarnQueue(yarnQueue).withPriority(priority).withJobTypeEnum(JobTypeEnum.INDEX_PLAN_OPT).withTag(tag).addExtParams("dataflowId", String.valueOf(modelId)).addExtParams("kylin.planner.dataRangeStart", String.valueOf(start)).addExtParams("kylin.planner.dataRangeEnd", String.valueOf(end));
        this.setIndexPlannerRelatedParams(jobParam, instantInitIndexNum);
        jobIds.add(((JobManager)this.getManager(JobManager.class, project)).addJob(jobParam));
        return jobIds;
    }

    public List<String> optIndexPlan(String dataflowId, Integer instantInitIndexNum, String project, int priority, String yarnQueue, Object tag) {
        return this.optIndexPlan(dataflowId, instantInitIndexNum, project, priority, yarnQueue, tag, null, null);
    }

    private void setIndexPlannerRelatedParams(JobParam jobParam, Integer initializeCuboidCount) {
        String project = jobParam.getProject();
        if (!this.checkAutoIndexPlanEnabled(jobParam.getProject(), jobParam.getModel())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.AUTO_INDEX_PLAN_NOT_ENABLED, MsgPicker.getMsg().getAutoIndexPlanNotEnabled());
        }
        Map autoIndexPlanRule = this.modelSmartServiceSupporter.getAutoIndexPlanRule(jobParam.getModel(), jobParam.getProject());
        NDataModel modelDesc = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(jobParam.getModel());
        IndexPlan indexPlan = ((NIndexPlanManager)this.getManager(NIndexPlanManager.class, project)).getIndexPlan(jobParam.getModel());
        NDataModelResponse dataModelResponse = this.modelService.getCube(modelDesc.getAlias(), project);
        boolean shouldLaunchRoutineRec = ModelUtils.isModelHasAnyData(dataModelResponse, indexPlan);
        if (initializeCuboidCount == null) {
            initializeCuboidCount = shouldLaunchRoutineRec ? ROUTINE_REC : Integer.parseInt(String.valueOf(autoIndexPlanRule.get("index_planner_max_change_count")));
        } else if (initializeCuboidCount > 0 && shouldLaunchRoutineRec) {
            initializeCuboidCount = ROUTINE_REC;
        }
        logger.info("prepare launch {} rec job", (Object)(initializeCuboidCount == 0 ? "routine" : "cold start"));
        String token = RandomUtil.randomUUIDStr();
        JobTokenManager tokenManager = JobTokenManager.getInstance((KylinConfig)this.getConfig());
        JobTokenItem item = new JobTokenItem(jobParam.getJobId(), tokenManager.encrypt(token), System.currentTimeMillis());
        tokenManager.save(item);
        jobParam.addExtParams("kylin.planner.initializeCuboidCount", String.valueOf(initializeCuboidCount));
        jobParam.addExtParams("kylin.planner.maxCuboidCount", String.valueOf(autoIndexPlanRule.get("index_planner_max_index_count")));
        jobParam.addExtParams("kylin.planner.maxCuboidChangeCount", String.valueOf(autoIndexPlanRule.get("index_planner_max_change_count")));
        jobParam.addExtParams("kylin.planner.autoApproveEnabled", String.valueOf(true));
        jobParam.addExtParams("kylin.planner.operationToken", token);
    }

    public boolean checkAutoIndexPlanEnabled(String project, String modelId) {
        return this.modelService.isAutoIndexPlanEnabled(project, modelId);
    }

    @Generated
    public void setSemanticUpater(ModelSemanticHelper semanticUpater) {
        this.semanticUpater = semanticUpater;
    }
}

