/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.render;

import java.util.Objects;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;

public class RenderedCriterion {
    private final String connector;
    private final FragmentAndParameters fragmentAndParameters;

    private RenderedCriterion(Builder builder) {
        this.connector = builder.connector;
        this.fragmentAndParameters = Objects.requireNonNull(builder.fragmentAndParameters);
    }

    public FragmentAndParameters fragmentAndParameters() {
        return this.fragmentAndParameters;
    }

    public FragmentAndParameters fragmentAndParametersWithConnector() {
        if (this.connector == null) {
            return this.fragmentAndParameters;
        }
        return this.prependFragment(this.fragmentAndParameters, this.connector);
    }

    public RenderedCriterion withConnector(String connector) {
        return new Builder().withFragmentAndParameters(this.fragmentAndParameters).withConnector(connector).build();
    }

    private FragmentAndParameters prependFragment(FragmentAndParameters fragmentAndParameters, String connector) {
        return FragmentAndParameters.withFragment(connector + " " + fragmentAndParameters.fragment()).withParameters(fragmentAndParameters.parameters()).build();
    }

    public static class Builder {
        private String connector;
        private FragmentAndParameters fragmentAndParameters;

        public Builder withConnector(String connector) {
            this.connector = connector;
            return this;
        }

        public Builder withFragmentAndParameters(FragmentAndParameters fragmentAndParameters) {
            this.fragmentAndParameters = fragmentAndParameters;
            return this;
        }

        public RenderedCriterion build() {
            return new RenderedCriterion(this);
        }
    }
}

