/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.Serializable;
import java.util.LinkedList;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.ThreadSafeRpcEndpoint;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.InboxMessage;
import org.apache.celeborn.common.rpc.netty.NettyRpcCallContext;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.OnStart$;
import org.apache.celeborn.common.rpc.netty.OnStop$;
import org.apache.celeborn.common.rpc.netty.OneWayMessage;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnected;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnectionError;
import org.apache.celeborn.common.rpc.netty.RemoteProcessDisconnected;
import org.apache.celeborn.common.rpc.netty.RpcMessage;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb!B\f\u0019\u0001y!\u0003\u0002C\u0019\u0001\u0005\u000b\u0007I\u0011A\u001a\t\u0011a\u0002!\u0011!Q\u0001\nQB\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005w!)\u0001\t\u0001C\u0001\u0003\"9Q\t\u0001b\u0001\n#1\u0005B\u0002*\u0001A\u0003%q\tC\u0004b\u0001\u0001\u0007I\u0011\u00022\t\u000f\u0019\u0004\u0001\u0019!C\u0005O\"1Q\u000e\u0001Q!\n\rDqa\u001c\u0001A\u0002\u0013%!\rC\u0004q\u0001\u0001\u0007I\u0011B9\t\rM\u0004\u0001\u0015)\u0003d\u0011\u001d)\b\u00011A\u0005\nYDqA\u001f\u0001A\u0002\u0013%1\u0010\u0003\u0004~\u0001\u0001\u0006Ka\u001e\u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001BBA\r\u0001\u0011\u0005!\rC\u0004\u0002\u001c\u0001!\t\"!\b\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$\t)\u0011J\u001c2pq*\u0011\u0011DG\u0001\u0006]\u0016$H/\u001f\u0006\u00037q\t1A\u001d9d\u0015\tib$\u0001\u0004d_6lwN\u001c\u0006\u0003?\u0001\n\u0001bY3mK\n|'O\u001c\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xmE\u0002\u0001K-\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u001d\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0019.\u0005\u001daunZ4j]\u001e\f1\"\u001a8ea>Lg\u000e\u001e*fM\u000e\u0001Q#\u0001\u001b\u0011\u0005U2T\"\u0001\r\n\u0005]B\"a\u0005(fiRL(\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0017\u0001D3oIB|\u0017N\u001c;SK\u001a\u0004\u0013\u0001C3oIB|\u0017N\u001c;\u0016\u0003m\u0002\"\u0001P\u001f\u000e\u0003iI!A\u0010\u000e\u0003\u0017I\u00038-\u00128ea>Lg\u000e^\u0001\nK:$\u0007o\\5oi\u0002\na\u0001P5oSRtDc\u0001\"D\tB\u0011Q\u0007\u0001\u0005\u0006c\u0015\u0001\r\u0001\u000e\u0005\u0006s\u0015\u0001\raO\u0001\t[\u0016\u001c8/Y4fgV\tq\tE\u0002I\u001b>k\u0011!\u0013\u0006\u0003\u0015.\u000bA!\u001e;jY*\tA*\u0001\u0003kCZ\f\u0017B\u0001(J\u0005)a\u0015N\\6fI2K7\u000f\u001e\t\u0003kAK!!\u0015\r\u0003\u0019%s'm\u001c=NKN\u001c\u0018mZ3\u0002\u00135,7o]1hKN\u0004\u0003\u0006B\u0004U=~\u0003\"!\u0016/\u000e\u0003YS!a\u0016-\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002Z5\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0003m\u000bQA[1wCbL!!\u0018,\u0003\u0013\u001d+\u0018M\u001d3fI\nK\u0018!\u0002<bYV,\u0017%\u00011\u0002\tQD\u0017n]\u0001\bgR|\u0007\u000f]3e+\u0005\u0019\u0007C\u0001\u0014e\u0013\t)wEA\u0004C_>dW-\u00198\u0002\u0017M$x\u000e\u001d9fI~#S-\u001d\u000b\u0003Q.\u0004\"AJ5\n\u0005)<#\u0001B+oSRDq\u0001\\\u0005\u0002\u0002\u0003\u00071-A\u0002yIE\n\u0001b\u001d;paB,G\r\t\u0015\u0005\u0015Qsv,\u0001\tf]\u0006\u0014G.Z\"p]\u000e,(O]3oi\u0006!RM\\1cY\u0016\u001cuN\\2veJ,g\u000e^0%KF$\"\u0001\u001b:\t\u000f1d\u0011\u0011!a\u0001G\u0006\tRM\\1cY\u0016\u001cuN\\2veJ,g\u000e\u001e\u0011)\t5!flX\u0001\u0011]Vl\u0017i\u0019;jm\u0016$\u0006N]3bIN,\u0012a\u001e\t\u0003MaL!!_\u0014\u0003\u0007%sG/\u0001\u000bok6\f5\r^5wKRC'/Z1eg~#S-\u001d\u000b\u0003QrDq\u0001\\\b\u0002\u0002\u0003\u0007q/A\tok6\f5\r^5wKRC'/Z1eg\u0002BC\u0001\u0005+_?\u00069\u0001O]8dKN\u001cHc\u00015\u0002\u0004!9\u0011QA\tA\u0002\u0005\u001d\u0011A\u00033jgB\fGo\u00195feB\u0019Q'!\u0003\n\u0007\u0005-\u0001D\u0001\u0006ESN\u0004\u0018\r^2iKJ\fA\u0001]8tiR\u0019\u0001.!\u0005\t\r\u0005M!\u00031\u0001P\u0003\u001diWm]:bO\u0016\fAa\u001d;paR\t\u0001.A\u0004jg\u0016k\u0007\u000f^=\u0002\r=tGI]8q)\rA\u0017q\u0004\u0005\u0007\u0003')\u0002\u0019A(\u0002\u0015M\fg-\u001a7z\u0007\u0006dG\u000e\u0006\u0003\u0002&\u0005EBc\u00015\u0002(!A\u0011\u0011\u0006\f\u0005\u0002\u0004\tY#\u0001\u0004bGRLwN\u001c\t\u0005M\u00055\u0002.C\u0002\u00020\u001d\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\u0006sY\u0001\ra\u000f")
public class Inbox
implements Logging {
    private final NettyRpcEndpointRef endpointRef;
    private final RpcEndpoint endpoint;
    @GuardedBy(value="this")
    private final LinkedList<InboxMessage> messages;
    @GuardedBy(value="this")
    private boolean stopped;
    @GuardedBy(value="this")
    private boolean enableConcurrent;
    @GuardedBy(value="this")
    private int numActiveThreads;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        Inbox inbox = this;
        synchronized (inbox) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public NettyRpcEndpointRef endpointRef() {
        return this.endpointRef;
    }

    public RpcEndpoint endpoint() {
        return this.endpoint;
    }

    public LinkedList<InboxMessage> messages() {
        return this.messages;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private boolean enableConcurrent() {
        return this.enableConcurrent;
    }

    private void enableConcurrent_$eq(boolean x$1) {
        this.enableConcurrent = x$1;
    }

    private int numActiveThreads() {
        return this.numActiveThreads;
    }

    private void numActiveThreads_$eq(int x$1) {
        this.numActiveThreads = x$1;
    }

    public void process(Dispatcher dispatcher) {
        ObjectRef message;
        block10: {
            message = ObjectRef.create(null);
            Inbox inbox = this;
            synchronized (inbox) {
                block9: {
                    if (!this.enableConcurrent() && this.numActiveThreads() != 0) break block9;
                    message.elem = this.messages().poll();
                    if ((InboxMessage)message.elem == null) break block9;
                    this.numActiveThreads_$eq(this.numActiveThreads() + 1);
                    break block10;
                }
                return;
            }
        }
        while (true) {
            this.safelyCall(this.endpoint(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                InboxMessage inboxMessage = (InboxMessage)message$1.elem;
                if (inboxMessage instanceof RpcMessage) {
                    RpcMessage rpcMessage = (RpcMessage)inboxMessage;
                    RpcAddress _sender = rpcMessage.senderAddress();
                    Object content = rpcMessage.content();
                    NettyRpcCallContext context = rpcMessage.context();
                    try {
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)this.endpoint().receiveAndReply(context).applyOrElse(content, (Function1 & Serializable & scala.Serializable)msg -> {
                            throw new CelebornException(new StringBuilder(26).append("Unsupported message ").append((InboxMessage)message$1.elem).append(" from ").append(_sender).toString());
                        });
                    }
                    catch (Throwable e) {
                        context.sendFailure(e);
                        throw e;
                    }
                    return;
                }
                if (inboxMessage instanceof OneWayMessage) {
                    OneWayMessage oneWayMessage = (OneWayMessage)inboxMessage;
                    RpcAddress _sender = oneWayMessage.senderAddress();
                    Object content = oneWayMessage.content();
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)this.endpoint().receive().applyOrElse(content, (Function1 & Serializable & scala.Serializable)msg -> {
                        throw new CelebornException(new StringBuilder(26).append("Unsupported message ").append((InboxMessage)message$1.elem).append(" from ").append(_sender).toString());
                    });
                    return;
                }
                if (OnStart$.MODULE$.equals(inboxMessage)) {
                    this.endpoint().onStart();
                    if (!(this.endpoint() instanceof ThreadSafeRpcEndpoint)) {
                        Inbox inbox = this;
                        synchronized (inbox) {
                            if (!this.stopped()) {
                                this.enableConcurrent_$eq(true);
                            }
                        }
                        return;
                    }
                    return;
                }
                if (OnStop$.MODULE$.equals(inboxMessage)) {
                    int n;
                    Inbox inbox = this;
                    synchronized (inbox) {
                        n = this.numActiveThreads();
                    }
                    int activeThreads = n;
                    Predef$.MODULE$.assert(activeThreads == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("There should be only a single active thread but found ").append(activeThreads).append(" threads.").toString());
                    dispatcher.removeRpcEndpointRef(this.endpoint());
                    this.endpoint().onStop();
                    Predef$.MODULE$.assert(this.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "OnStop should be the last message");
                    return;
                }
                if (inboxMessage instanceof RemoteProcessConnected) {
                    RemoteProcessConnected remoteProcessConnected = (RemoteProcessConnected)inboxMessage;
                    RpcAddress remoteAddress = remoteProcessConnected.remoteAddress();
                    this.endpoint().onConnected(remoteAddress);
                    return;
                }
                if (inboxMessage instanceof RemoteProcessDisconnected) {
                    RemoteProcessDisconnected remoteProcessDisconnected = (RemoteProcessDisconnected)inboxMessage;
                    RpcAddress remoteAddress = remoteProcessDisconnected.remoteAddress();
                    this.endpoint().onDisconnected(remoteAddress);
                    return;
                }
                if (inboxMessage instanceof RemoteProcessConnectionError) {
                    RemoteProcessConnectionError remoteProcessConnectionError = (RemoteProcessConnectionError)inboxMessage;
                    Throwable cause = remoteProcessConnectionError.cause();
                    RpcAddress remoteAddress = remoteProcessConnectionError.remoteAddress();
                    this.endpoint().onNetworkError(cause, remoteAddress);
                    return;
                }
                throw new MatchError((Object)inboxMessage);
            });
            Inbox inbox = this;
            synchronized (inbox) {
                if (!this.enableConcurrent() && this.numActiveThreads() != 1) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
                message.elem = this.messages().poll();
                if ((InboxMessage)message.elem == null) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
            }
        }
    }

    public void post(InboxMessage message) {
        Inbox inbox = this;
        synchronized (inbox) {
            Object object;
            if (this.stopped()) {
                this.onDrop(message);
                object = BoxedUnit.UNIT;
            } else {
                this.messages().add(message);
                object = BoxesRunTime.boxToBoolean((boolean)false);
            }
        }
    }

    public void stop() {
        Inbox inbox = this;
        synchronized (inbox) {
            Object object;
            if (!this.stopped()) {
                this.enableConcurrent_$eq(false);
                this.stopped_$eq(true);
                object = BoxesRunTime.boxToBoolean((boolean)this.messages().add(OnStop$.MODULE$));
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.messages().isEmpty();
    }

    public void onDrop(InboxMessage message) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Drop ").append(message).append(" because ").append(this.endpointRef()).append(" is stopped").toString());
    }

    private void safelyCall(RpcEndpoint endpoint, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                try {
                    endpoint.onError(e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                    if (!option2.isEmpty()) {
                        Throwable ee = (Throwable)option2.get();
                        if (this.stopped()) {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring error", ee);
                        } else {
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring error", ee);
                        }
                    } else {
                        throw throwable3;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            throw throwable;
        }
    }

    public Inbox(NettyRpcEndpointRef endpointRef, RpcEndpoint endpoint) {
        this.endpointRef = endpointRef;
        this.endpoint = endpoint;
        Logging.$init$(this);
        this.messages = new LinkedList();
        this.stopped = false;
        this.enableConcurrent = false;
        this.numActiveThreads = 0;
        Inbox inbox = this;
        synchronized (inbox) {
            this.messages().add(OnStart$.MODULE$);
        }
    }
}

