/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service.task;

import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.rest.service.task.SpringSessionCleanExpiredJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"spring.session.store-type"}, havingValue="JDBC")
public class SpringSessionCleanScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringSessionCleanScheduler.class);

    @PostConstruct
    public void init() {
        JobFactory.register((String)"SPRING_SESSION_CLEAN_EXPIRED_JOB_FACTORY", (JobFactory)new SpringSessionCleanExpiredJob.Factory());
    }

    @Scheduled(cron="${spring.session.jdbc.cleanup-cron-task:0 */30 * * * *}")
    public void submitJob() {
        ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)"_global").checkAndSubmitCronJob("SPRING_SESSION_CLEAN_EXPIRED_JOB_FACTORY", JobTypeEnum.SPRING_SESSION_CLEAN_EXPIRED);
        log.debug("submit job to clean spring session");
    }
}

